#ifndef HASHMM_H_
#define HASHMM_H_

#include "hash.h"
#include <stdlib.h>

template <class T>
class HashMM {
	public:
		HashMM() {
			my_hash = hash_alloc(1);
			return;
		}

		HashMM(unsigned int initialsize) {
			my_hash = hash_alloc(initialsize);
			return;
		}

		~HashMM() {
			hash_free(my_hash, NULL);
			my_hash = NULL;

			return;
		}

		void add(int key, T *datum) {
			my_hash = hash_add(my_hash, h_entry_alloc(key, datum));

			return;
		}


		void addFirstFree(int key, T *datum) {
			my_hash = hash_add_first_free(my_hash,
						h_entry_alloc(key, datum));

			return;
		}

		const T *get(int key) {
			h_entry *he = hash_get(my_hash, key);

			if(he == NULL) {
				return NULL;
			}

			return (const T *) he->data;
		}

		void remove(int key) {
			my_hash = hash_remove(my_hash, key);

			return;
		}


		void free(int key) {
			my_hash = hash_delete(my_hash, key, NULL);

			return;
		}

	protected:
		void resize(unsigned int newsize) {
			my_hash = hash_resize(my_hash, newsize);

			return;
		}

		hash *my_hash;
};

#endif /* HASHMM_H_ */
