/*=============================================================================
	Cluster.cpp: Cluster audio package.
	Copyright 1999 Epic Games, Inc. All Rights Reserved.
	Copyright 2015 Sebastian Kaufel. All Rights Reserved.
=============================================================================*/

#include "Cluster.h"

/*-----------------------------------------------------------------------------
	Globals.
-----------------------------------------------------------------------------*/

FString ALErrorString( ALenum ErrorCode )
{
	return appFromAnsi( alGetString(ErrorCode) );
}
FString ALCErrorString( ALCdevice* Device, ALCenum ErrorCode )
{
	return appFromAnsi( alcGetString(Device,ErrorCode) );
}

FString ALCurrentErrorString()
{
	return appFromAnsi( alGetString(alGetError()) );
}
FString ALCCurrentErrorString( ALCdevice* Device )
{
	return appFromAnsi( alcGetString(Device,alcGetError(Device)) );
}

/*-----------------------------------------------------------------------------
	Package implementation.
-----------------------------------------------------------------------------*/

IMPLEMENT_PACKAGE(Cluster);

/*-----------------------------------------------------------------------------
	The end.
-----------------------------------------------------------------------------*/
