#include <stdio.h>

#include <mikmod.h>

#include <Cluster.h>
#include <MikModInterface.h>

/*
 * These are used in conjuntion with the MREADER structure to simulate
 * access to the MOD.
 */
static long mOffset;
static long mEnd;
static MODULE *mod = NULL;
static UMusic *mus = NULL;

MREADER mReader = {
	mSeek,
	mTell,
	mRead,
	mGet,
	mEof
};

long mTell(struct MREADER *foo) {
	return mOffset;
}

BOOL mRead(struct MREADER *foo, void *buf, size_t datum) {
	size_t bytesToRead = datum;

	if(mOffset > mEnd) {
		/* passed end of file already. */
		return 0;
	}

	if(mOffset + bytesToRead > mEnd) {
		/* truncate bytes to read. */
		bytesToRead = mEnd - mOffset;
	}

	memcpy(buf, &mus->Data(mOffset), bytesToRead);

	mOffset += bytesToRead;

	return bytesToRead;
}

int mGet(struct MREADER *foo) {
	return (int) mus->Data(mOffset++);
}

BOOL mEof(struct MREADER *foo) {
	if(mOffset >= mEnd) {
		return 1;
	}

	return 0;
}

BOOL mSeek(struct MREADER *foo, long offset, int whence) {
	switch(whence) {
		case SEEK_SET:
			if(offset > mEnd) {
				return -1;
			}

			mOffset = offset;
			break;
		case SEEK_CUR:
			if(mEnd < mOffset + offset) {
				return -1;
			}

			mOffset += offset;
			break;
		case SEEK_END:
			if(offset > mEnd) {
				return -1;
			}
			mOffset = mEnd - offset;
			break;
	}

	return 0;
}

int playMusic(UMusic *um) {
	mOffset = 0;
	mEnd    = um->Data.Num();
	mus     = um;
	mod     = Player_LoadGeneric(&mReader, 64, 0);

	if(mod == NULL) {
		return 0;
	}


	Player_Start(mod);

	return 1;
}

int stopMusic(UMusic *um) {
	Player_Stop();

	Player_Free(mod);

	mod = NULL;

	return 0;
}


