#pragma once

class Shader;

#include <d3d10.h>
#include <d3dx10.h>
#include "d3d10drv.h"
#include "geometrybuffer.h"

class Shader
{
protected:	
	GeometryBuffer* geometryBuffer;
	ID3D10RenderTargetView* renderTargetView;
	ID3D10DepthStencilView* depthStencilView;
	ID3D10InputLayout* vertexLayout;
	ID3D10ShaderResourceView* shaderResourceView;
	ID3D10Blob* blob;
	ID3D10Device *device;
	ID3D10Effect* effect;
	D3D10_PRIMITIVE_TOPOLOGY topology;
	HRESULT hr;

	bool checkCompileResult(HRESULT hr) const;
	bool createRenderTargetViews(DXGI_FORMAT format, DXGI_FORMAT depthFormat,float scaleX, float scaleY, int samples, const DXGI_SWAP_CHAIN_DESC &swapChainDesc);


public:
	Shader(ID3D10Device *device);
	virtual bool compile(const D3D10_SHADER_MACRO *macros, DWORD shaderFlags)=0;
	virtual bool createRenderTargetViews(ID3D10RenderTargetView *backbuffer, const DXGI_SWAP_CHAIN_DESC &swapChainDesc, int multiSampleCount)=0;
	virtual void releaseRenderTargetViews();
	virtual ~Shader();
	virtual void bind();
	virtual void apply();
	GeometryBuffer *getGeometryBuffer() const;
	ID3D10ShaderResourceView *getResourceView() const;
};