class MVMutator extends Mutator config(Mutators);

enum ECycleType
{
CT_Static,
CT_Random,
CT_Cycle
};

var config string ExcludeList[32];
var config ECycleType CycleType;
var config bool bUseMapListOnly, bFilterSPMaps;

var string Maps[250];
var int MapCount;
var byte VoteTotals[arraycount(Maps)];

var DXL DXLList;
var string sNextMap;
var float CWTime;
var int LoadingTime, iDefMap, iNextMap, iListSize;
var bool bInit, bVoteDone;


function PostBeginPlay()
{
local string CM;
local int I;

if (bInit)
 return;

bInit = true;
MapCount = 0;

if (bUseMapListOnly)
 GetMapList();
else
 GetMapFiles();

CM = Left(Self, InStr(Self, "."));

if (MapCount <= 0)
 {
 MapCount = 1;
 Maps[0] = CM;
 iListSize += Len(CM);
 }

log(MapCount @ "Maps," @ iListSize @ "Bytes", 'MVMutator');

if (CycleType == CT_Random)
 iDefMap = Rand(MapCount);
else
 {
 iDefMap = -1;
 for (I = 0; I < MapCount; I++)
  if (Maps[I] ~= CM)
   {
   iDefMap = I;
   break;
   }
 if (iDefMap >= 0)
  {
  if ((CycleType == CT_Cycle) && (++iDefMap >= MapCount))
   iDefMap = 0;
  }
 else
  iDefMap = Rand(MapCount);
 }

ChooseWinner();
DXLList = Spawn(class'DXL', Self);
SetTimer(1, true);
SaveConfig();
}


// 'mutate mapvote' shows the menu.
// 'mutate voteresult' shows current leading map.
function Mutate(string S, PlayerPawn P)
{
if (DXLList != None)
 {
 if (S ~= "MapVote")
  {
  if (!bVoteDone)
   GetDXL(P, true).OpenMVMenu();
  }
 else if (S ~= "VoteResult")
  GetDXL(P, true).ShowWinner();
 }

Super.Mutate(S, P);
}


function ModifyPlayer(Pawn P)
{
if (!bVoteDone && (DeusExPlayer(P) != None) && (GetDXL(P) == None))
 AddDXL(P);

Super.ModifyPlayer(P);
}


function Tick(float Delta)
{
if (bVoteDone)
 return;

CWTime += Delta / Level.TimeDilation;
if (CWTime < 1)
 return;

CWTime = 0;
ChooseWinner();
UpdateVoteData();
}


// Check if its end of match, if so, travel to our new map.
function Timer()
{
if ((DeusExMPGame(Level.Game) != None) && DeusExMPGame(Level.Game).bNewMap)
 {
 Level.Game.SetTimer(0, false);
 if (!bVoteDone)
  {
  ChooseWinner(true);
  UpdateVoteData(true);
  LoadingTime = 0;
  bVoteDone = true;
  }

 if (LoadingTime++ == 11)
  Level.ServerTravel(sNextMap, false);
 }
}


final function UpdateVoteData(optional bool bFinal)
{
local DXL D;
local int I;

if (DXLList != None)
 for (D = DXLList.Next; D != None; D = D.Next)
  {
  D.iNextMap = iNextMap;
  for (I = 0; I < MapCount; I++)
   D.VoteTotals[I] = VoteTotals[I];
  if (bFinal)
   D.CloseMVMenu(sNextMap);
  }
}


final function AddDXL(Actor A)
{
local DXL D;
local int I;

if ((A != None) && !A.bDeleteMe && (DXLList != None))
 {
 D = A.Spawn(class'DXL', A);
 D.Prev = DXLList;
 D.Next = DXLList.Next;
 if (DXLList.Next != None)
  DXLList.Next.Prev = D;
 DXLList.Next = D;
 D.MapCount = MapCount;
 for (I = 0; I < MapCount; I++)
  D.Maps[I] = Maps[I];
 }
}


final function DXL GetDXL(Actor A, optional bool bSafe)
{
local DXL D;

if ((A != None) && (DXLList != None))
 for (D = DXLList.Next; D != None; D = D.Next)
  if (D.Owner == A)
   return D;

if (bSafe)
 return DXLList;

return None;
}


final function ChooseWinner(optional bool bFinal)
{
local DXL D;
local int I;
local byte BestScore;

if (bVoteDone)
 return;

for (I = 0; I < MapCount; I++)
 VoteTotals[I] = 0;

I = 0;
if (DXLList != None)
 for (D = DXLList.Next; D != None; D = D.Next)
  if ((D.iCurrentVote >= 0) && (D.iCurrentVote < MapCount))
   {
   VoteTotals[D.iCurrentVote]++;
   I = 1;
   }

iNextMap = iDefMap;
if (I != 0)
 for (I = 0; I < MapCount; I++)
  {
  if (VoteTotals[I] > BestScore)
   {
   BestScore = VoteTotals[I];
   iNextMap = I;
   }
  else if (bFinal && (BestScore > 0) && (VoteTotals[I] == BestScore) && (FRand() < 0.5))
   iNextMap = I;
  }

sNextMap = Maps[iNextMap];
}


final function AddMap(string M)
{
local string S;
local int I;

if ((M != "") && (MapCount < arraycount(Maps)))
 {
 if (bFilterSPMaps)
  {
  S = Left(M, 3);
  if ((S ~= "00_") || ((int(S) != 0) && (Right(S, 1) ~= "_")))
   return;
  }

 if ((M ~= "AutoPlay") || (M ~= "DX") || (M ~= "DXOnly") || (M ~= "Entry") || (M ~= "Index"))
  return;

 for (I = 0; I < arraycount(ExcludeList); I++)
  if (ExcludeList[I] ~= M)
   return;

 Maps[MapCount++] = M;
 iListSize += Len(M);
 }
}


final function GetMapList()
{
local string S;
local int I, C;

for (I = 0; I < arraycount(class'DXMapList'.Default.Maps); I++)
 {
 S = class'DXMapList'.Default.Maps[I];
 if (S != "")
  {
  C = InStr(S, ".");
  if (C >= 0)
   S = Left(S, C);
  if (S != "")
   {
   for (C = 0; C < MapCount; C++)
    if (Maps[C] ~= S)
     {
     S = "";
     break;
     }
   AddMap(S);    
   }
  }
 }
}


final function GetMapFiles()
{
local string First, Next, Last;

First = GetMapName("", "", 0);
Next = First;

while (!(Last ~= First) && (Next != "") && (MapCount < arraycount(Maps)))
 {
 if (Right(Next, 3) ~= ".dx")
  AddMap(Left(Next, Len(Next) - 3));

 Next = GetMapName("", Next, 1);
 Last = Next;
 }
}


defaultproperties
{
CycleType=CT_Cycle
bUseMapListOnly=False
bFilterSPMaps=True
}
