//=============================================================================
// HUDKeypadWindow
//=============================================================================

class HUDCreditReaderWindow extends DeusExBaseWindow;

var bool bFirstFrameDone;

var HUDCreditReaderButton buybutton;
var TextWindow winText;

var bool bBought;

var bool bWait;
var CreditReader reader;

var Texture texBackground;
var Texture texBorder;

// Border and Background Translucency
var bool bBorderTranslucent;
var bool bBackgroundTranslucent;
var bool bDrawBorder;

// Default Colors
var Color colBackground;
var Color colBorder;
var Color colHeaderText;

var() localized string costtext;
var() localized string cantaffordmessage;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	SetWindowAlignments(HALIGN_Center, VALIGN_Center);
	SetSize(103, 162);
	SetMouseFocusMode(MFocus_EnterLeave);

	// Create the buttons
	CreateKeypadButtons();
	CreateInputTextWindow();

	bTickEnabled = True;

	StyleChanged();
}

// ----------------------------------------------------------------------
// DestroyWindow()
//
// Destroys the Window
// ----------------------------------------------------------------------

event DestroyWindow()
{
	Super.DestroyWindow();

	reader.readerwindow = None;
}

// ----------------------------------------------------------------------
// InitData()
// 
// Do the post-InitWindow stuff
// ----------------------------------------------------------------------

function InitData()
{
	winText.SetTextColor(colHeaderText);
	winText.SetText(costtext @ reader.cost);
}

// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

function Tick(float deltaTime)
{
	if (!bFirstFrameDone)
	{
		SetCursorPos(width, height);
		bFirstFrameDone = True;
	}
}

// ----------------------------------------------------------------------
// DrawWindow()
// 
// DrawWindow event (called every frame)
// ----------------------------------------------------------------------

event DrawWindow(GC gc)
{
	// First draw the background then the border
	DrawBackground(gc);
	DrawBorder(gc);

	Super.DrawWindow(gc);
}

// ----------------------------------------------------------------------
// DrawBackground()
// ----------------------------------------------------------------------

function DrawBackground(GC gc)
{
	if (bBackgroundTranslucent)
		gc.SetStyle(DSTY_Translucent);
	else
		gc.SetStyle(DSTY_Masked);
	
	gc.SetTileColor(colBackground);

	gc.DrawTexture(0, 0, width, height, 0, 0, texBackground);
}

// ----------------------------------------------------------------------
// DrawBorder()
// ----------------------------------------------------------------------

function DrawBorder(GC gc)
{
	if (bDrawBorder)
	{
		if (bBorderTranslucent)
			gc.SetStyle(DSTY_Translucent);
		else
			gc.SetStyle(DSTY_Masked);
		
		gc.SetTileColor(colBorder);

		gc.DrawTexture(0, 0, width, height, 0, 0, texBorder);
	}
}

// ----------------------------------------------------------------------
// CreateKeypadButtons()
// ----------------------------------------------------------------------

function CreateKeypadButtons()
{
	buybutton = HUDCreditReaderButton(NewChild(Class'HUDCreditReaderButton'));
	buybutton.SetPos(16, 35);
}

// ----------------------------------------------------------------------
// CreateInputTextWindow()
// ----------------------------------------------------------------------

function CreateInputTextWindow()
{
	winText = TextWindow(NewChild(Class'TextWindow'));
	winText.SetPos(17, 21);
	winText.SetSize(75, 11);
	winText.SetTextMargins(0, 0);
	winText.SetTextAlignments(HALIGN_Center, VALIGN_Center);
	winText.SetFont(Font'FontMenuSmall');
	winText.SetTextColor(colHeaderText);
	winText.SetText(String(reader.cost));
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local int i;

	bHandled = False;

	if ( buttonPressed == buybutton )
	{
		if (player.credits >= reader.cost)
		{
			player.credits -= reader.cost;
			reader.Bought();
		}
		else
		{
			player.ClientMessage(cantaffordmessage);
		}
		root.PopWindow();
		bHandled = true;
	}

	if (!bHandled)
		bHandled = Super.ButtonActivated(buttonPressed);

	return bHandled;
}

//		default:	str = String(num+1); break;

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme theme;

	theme = player.ThemeManager.GetCurrentHUDColorTheme();

	colBackground = theme.GetColorFromName('HUDColor_Background');
	colBorder     = theme.GetColorFromName('HUDColor_Borders');
	colHeaderText = theme.GetColorFromName('HUDColor_HeaderText');

	bBorderTranslucent     = player.GetHUDBorderTranslucency();
	bBackgroundTranslucent = player.GetHUDBackgroundTranslucency();
	bDrawBorder            = player.GetHUDBordersVisible();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
    texBackground=Texture'DeusExUI.UserInterface.HUDKeypadBackground'
    texBorder=Texture'DeusExUI.UserInterface.HUDKeypadBorder'
    costtext="Cost: "
    cantaffordmessage="You cannot afford this item."
}
