//=============================================================================
// NoteAddTrigger.
//=============================================================================
class NoteAddTrigger expands Trigger;

// Set bCollideActors to False to make it triggered

var() name NoteTag;
var() string Textpackage;
var deusexplayer player;
var string vaultstring;
var bool bFirstParagraph;

function Trigger(Actor Other, Pawn Instigator)
{
	Super.Trigger(Other, Instigator);

	player = DeusExPlayer(Instigator);

	if (player != None)
	{
		givenote();
	}
}

function Touch(Actor Other)
{
	Super.Touch(Other);

	if (IsRelevant(Other))
	{
		player = DeusExPlayer(Other);

		if (player != None)
		{
			givenote();
		}
	}
}

function givenote()
{
	local DeusExTextParser parser;
	local DeusExNote note;

	// First check to see if we have a name
	if ( notetag != '' )
	{
		// Create the text parser
		parser = new(None) Class'DeusExTextParser';
								    
		// Attempt to find the text object
		if ((player != None) && (parser.OpenText(noteTag,TextPackage)))
		{
			parser.SetPlayerName(player.TruePlayerName);

			vaultString = "";
			bFirstParagraph = True;

			while(parser.ProcessText())
				ProcessTag(parser);

			parser.CloseText();

			// Check to see if we need to save this string in the 
			// DataVault
				note = player.GetNote(NoteTag);

				if (note == None)
				{
					note = player.AddNote(vaultString,, True);
					note.SetTextTag(NoteTag);
				}
				vaultString = "";
		}
		CriticalDelete(parser);
	}
}

// ----------------------------------------------------------------------
// ProcessTag()
// ----------------------------------------------------------------------

function ProcessTag(DeusExTextParser parser)
{
	local String text;
//	local EDeusExTextTags tag;
	local byte tag;
	local Name fontName;
	local String textPart;

	tag  = parser.GetTag();

	switch(tag)
	{
		case 0:				// TT_Text:
		case 9:				// TT_PlayerName:
		case 10:			// TT_PlayerFirstName:
			text = parser.GetText();

			vaultString = vaultString $ text;
			break;

		// Create a new text window
		case 18:			// TT_NewParagraph:

			// Only add a return if this is not the *first*
			// paragraph.
			if (!bFirstParagraph)
				vaultString = vaultString $ CHR(10) $ CHR(13); //can't use CR()easily

			bFirstParagraph = False;
			break;

	}
}

defaultproperties
{
    TextPackage="tnm"
    bTriggerOnceOnly=True
}
