//=============================================================================
// POPaper.
//=============================================================================
class POPaper extends TNMInformationDevices;

#exec mesh IMPORT MESH=POPaper ANIVFILE=MODELS\POPaper_a.3d DATAFILE=MODELS\POPaper_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=POPaper X=0 Y=0 Z=400 YAW=64

#exec MESH SEQUENCE MESH=POPaper SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=POPaper SEQ=paper STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JPOPaper1 FILE=Textures/PPaperTex1.PCX GROUP=Skins // MATERIAL #14

#exec MESHMAP NEW   MESHMAP=POPaper MESH=POPaper
#exec MESHMAP SCALE MESHMAP=POPaper X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=POPaper NUM=1 TEXTURE=JPOPaper1

function Frob(Actor Frobber, Inventory frobWith)
{
	super.Frob(Frobber,frobWith);
	Destroy(); //no paper clutter
}

singular function SupportActor(Actor standingActor)
{
	super.SupportActor(standingActor);
	if(standingActor.IsA('POPaper'))
	{
		standingActor.SetPhysics(PHYS_None);
		standingActor.SetLocation(Location+vect(0,0,1)*CollisionHeight*1.5);
	}
}

defaultproperties
{
    bAddToVault=True
    bInvincible=True
    bCanBeBase=True
    ItemArticle="a piece of"
    ItemName="Paper"
    Mesh=LodMesh'POPaper'
    DrawScale=2.00
    PrePivot=(X=0.00,Y=0.00,Z=1.65),
    CollisionRadius=10.00
    CollisionHeight=0.10
    Mass=5.00
}
