//=============================================================================
// Printer.
//=============================================================================
class Printer extends ElectronicDevices;

#exec OBJ LOAD FILE=Ambient

var int numUses;
var localized String msgEmpty;
var bool bUsing;
var name printingTag;
var name queue[8];
var int queue_pos, queue_size;

var float PaperLoopLength;
var int PaperLoopID;
var float PrintLoopLength;
var int PrintLoopID;
var bool bLoopPaper;
var bool bLoopPrint;

var TNMInformationDevices product;

function Timer()
{
//	local DeusExPlayer player;

    bUsing = False;
//	PlayAnim('Still');
	AmbientSound = None;

	product.bHidden=false;
	product=None;

	PlaysoundPrintEnd();
	PlaySoundPaperOutEnd();

	PlayAnim('Still',0,0);

	if(queue_pos>0)
	{
		Print(queue[queue_pos - queue_size--]);
		if(queue_size==0)
			queue_pos=0;
	}
}

function Start()
{
	local Vector loc;

	PlayAnim('Spool');

	if (bUsing)
	return;

	loc = Vector(Rotation) * (CollisionRadius * 0.8 + 11);
	loc.Z -= CollisionHeight/2 - class'POPaper'.default.CollisionHeight - 8;
	loc += Location;

//	if(product!=None)
//		product.Destroy();
	product = Spawn(class'POPaper', None,, loc);
	product.AmbientGlow=32;
	product.bHidden=true;
	product.Velocity=vect(0,0,-10);
	product.textTag[0] = printingTag;
	product.notetag = printingTag;
	numUses--;

	SetTimer(3.2, False);

    	bUsing = True;

    //playanim('still');
}

function Print(name inFile)
{
	if(bUsing)
	{
		if(queue_size<8)
		{
			queue[queue_pos++]=inFile;
			queue_size++;
		}
		return;
	}
	printingTag = inFile;
	Start();
	PlaySoundPrint();
}

#exec AUDIO IMPORT FILE="Sounds\Printer\PaperLoop.wav"				NAME="PaperLoop"		GROUP="Printer"
#exec AUDIO IMPORT FILE="Sounds\Printer\PaperLoopStart.wav"			NAME="PaperLoopStart"		GROUP="Printer"
#exec AUDIO IMPORT FILE="Sounds\Printer\PaperLoopEnd.wav"			NAME="PaperLoopEnd"		GROUP="Printer"
#exec AUDIO IMPORT FILE="Sounds\Printer\PrintLoop.wav"				NAME="PrintLoop"		GROUP="Printer"
#exec AUDIO IMPORT FILE="Sounds\Printer\PrintLoopEnd.wav"			NAME="PrintLoopEnd"		GROUP="Printer"

function PlaySoundPrint()
{
	PrintLoopLength = default.PrintLoopLength;
	PrintLoopID = PlaySound(sound'PrintLoop');
	bLoopPrint = true;
}

function PlaysoundPrintEnd() //also stops Print sound
{
	StopSound(PaperLoopID);
	bLoopPrint = false;
	PlaySound(sound'PrintLoopEnd');
}

function PlaySoundPaperOut() //play start then loop
{
	PlaySound(sound'PaperLoopStart');
	PaperLoopLength = 0.293741;
	bLoopPaper = true;
}

function PlaySoundPaperOutEnd() //also stops Paper out sound
{
	StopSound(PaperLoopID);
	bLoopPaper = false;
	PlaySound(sound'PaperLoopEnd');
}

function tick(float deltatime)
{
	super.tick(deltatime);
	if (bLoopPaper)
	{
		PaperLoopLength -= deltatime;
		if (PaperLoopLength <= 0)
		{
			PaperLoopLength = default.PaperLoopLength;
			PaperLoopID = PlaySound(sound'PaperLoop');
		}
	}
	if (bLoopPrint)
	{
		PrintLoopLength -= deltatime;
		if (PrintLoopLength <= 0)
		{
			PrintLoopLength = default.PrintLoopLength;
			PrintLoopID = PlaySound(sound'PrintLoop');
		}
	}
}

#exec mesh IMPORT MESH=Printer ANIVFILE=MODELS\Printer_a.3d DATAFILE=MODELS\Printer_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=Printer X=0 Y=0 Z=0 YAW=64

#exec mesh SEQUENCE MESH=Printer SEQ=All     STARTFRAME=0 NUMFRAMES=11
#exec mesh SEQUENCE MESH=Printer SEQ=Still   STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=Printer SEQ=Spool   STARTFRAME=0 NUMFRAMES=11  Rate=4
#exec mesh SEQUENCE MESH=Printer SEQ=NoPaper STARTFRAME=11 NUMFRAMES=1  Rate=4

#exec texture IMPORT NAME=JPrinter1 FILE=Textures\PrinterTex1.PCX GROUP=Skins // MATERIAL #0
#exec texture IMPORT NAME=JPrinter2 FILE=Textures\PPaperTex1.PCX GROUP=Skins // MATERIAL #14

#exec MESHMAP NEW   MESHMAP=Printer MESH=Printer
#exec MESHMAP SCALE MESHMAP=Printer X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Printer NUM=1 TEXTURE=JPrinter1
#exec MESHMAP SETTEXTURE MESHMAP=Printer NUM=2 TEXTURE=JPrinter2

#exec mesh NOTIFY MESH=Printer SEQ=Spool	TIME=0.03	FUNCTION=PlaySoundPrint

defaultproperties
{
    numUses=1
    msgEmpty="There is no paper."
    PaperLoopLength=1.77
    PrintLoopLength=0.64
    bCanBeBase=True
    ItemName="Printer"
    Mesh=LodMesh'Printer'
    DrawScale=2.00
    SoundRadius=8
    SoundVolume=96
    AmbientSound=Sound'Ambient.Ambient.HumLow3'
    CollisionRadius=10.00
    CollisionHeight=14.00
    Mass=150.00
    Buoyancy=100.00
}
