//=============================================================================
// DeusExHUD.
//=============================================================================
class RadishHud expands Window;

var HUDRadishDisplay radishes[3];

function SetLives( int lives )
{
   switch ( lives )
   {
      case 3:
         radishes[2].Show();
      case 2:
         radishes[1].Show();
      case 1:
         radishes[0].Show();
      case 0:
   }

   switch ( lives )
   {
      case 0:
         radishes[2].Hide();
      case 1:
         radishes[1].Hide();
      case 2:
         radishes[0].Hide();
      case 3:
   }
   
}

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	local DeusExRootWindow root;
	local DeusExPlayer player;

	Super.InitWindow();

	// Get a pointer to the root window
	root = DeusExRootWindow(GetRootWindow());

	// Get a pointer to the player
	player = DeusExPlayer(root.parentPawn);

	SetFont(Font'TechMedium');
	SetSensitivity(false);

	radishes[0] = HUDRadishDisplay(NewChild(Class'HUDRadishDisplay', true));
	radishes[1] = HUDRadishDisplay(NewChild(Class'HUDRadishDisplay', true));
	radishes[2] = HUDRadishDisplay(NewChild(Class'HUDRadishDisplay', true));
	radishes[0].Show();
}

// ----------------------------------------------------------------------
// DescendantRemoved()
// ----------------------------------------------------------------------

event DescendantRemoved(Window descendant)
{
	if      (descendant == radishes[0])
		radishes[0] = None;
	else if (descendant == radishes[1])
		radishes[1] = None;
	else if (descendant == radishes[2])
		radishes[2] = None;
}

// ----------------------------------------------------------------------
// ConfigurationChanged()
// ----------------------------------------------------------------------

function ConfigurationChanged()
{
	local float w1, h1, w2, h2, w3, h3;

	if (radishes[0] != None)
	{
		if (radishes[0].IsVisible())
		{
			radishes[0].QueryPreferredSize(w1, h1);
			radishes[0].ConfigureChild(0, 0, w1, h1);
		}
	}

	if (radishes[1] != None)
	{
		if (radishes[1].IsVisible())
		{
			radishes[1].QueryPreferredSize(w2, h2);
			radishes[1].ConfigureChild(0, h1, w2, h2);
		}
	}

	if (radishes[2] != None)
	{
		if (radishes[2].IsVisible())
		{
			radishes[2].QueryPreferredSize(w3, h3);
			radishes[2].ConfigureChild(0, h1 + h2, w3, h3);
		}
	}
}

// ----------------------------------------------------------------------
// ChildRequestedReconfiguration()
// ----------------------------------------------------------------------

function bool ChildRequestedReconfiguration(window child)
{
	ConfigurationChanged();

	return TRUE;
}

// ----------------------------------------------------------------------
// ChildRequestedVisibilityChange()
// ----------------------------------------------------------------------

function ChildRequestedVisibilityChange(window child, bool bNewVisibility)
{
	child.SetChildVisibility(bNewVisibility);

	ConfigurationChanged();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
