//=============================================================================
// TNMFire.
// Smoke39 - spawned when something is set on fire, handles all visual effects
//=============================================================================
class TNMFire extends Effects;

simulated function Tick(float deltaTime)
{
	Super.Tick(deltaTime);

	// if our owner or base is destroyed, destroy us
	if (Owner == None)
		Destroy();
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	Mesh = Owner.Mesh;
	DrawScale = Owner.DrawScale;
	// the flame image isn't centered on the base of the flame, so move it all up
	PrePivot += vect(0,0,20);

	bTrailerSameRotation = true;
	bAnimByOwner = true;

	SetBase(Owner);

	SetTimer( 0.05, true );
}

// spawn fancy burny stuff!
simulated function Timer()
{
	local vector v;
	local SmokeTrail p;  // "p" is for "puff!" :O

	Spawn(class'Flame', Owner);
	Spawn(class'Flame', Owner);

	// I don't think this actually works in Deus Ex :\
	if ( Level.bDropDetail )
		return;

	Spawn(class'Flame', Owner);
	Spawn(class'Flame', Owner);


	v = FRand()*Owner.CollisionRadius * vector( FRand()*rot(0,65536,0) );
	v.Z += (FRand()-FRand()) * Owner.CollisionHeight;
	v += Owner.Location;

	p = Spawn( class'SmokeTrail',,, v );
	if ( p != None )
	{
		p.Velocity.Z = 45 + FRand()*35;
		p.OrigVel = p.Velocity;
		p.DrawScale = 0.5 + FRand()/2;
		p.OrigScale = p.DrawScale;
		p.LifeSpan = 1.0 + FRand();
		p.OrigLifeSpan = p.LifeSpan;
	}
}

defaultproperties
{
    bTravel=True
    Physics=11
    DrawType=2
    Style=3
    Texture=FireTexture'Effects.Fire.OneFlame_J'
    bUnlit=True
    bParticles=True
    bOwnerNoSee=True
    SoundVolume=192
    AmbientSound=Sound'Ambient.Ambient.FireSmall1'
    LightType=1
    LightBrightness=255
    LightHue=16
    LightSaturation=64
    LightRadius=4
}
