//=============================================================================
// Fireball Smoke.
// Smoke39 - attached to TNMFireball an' then go ploof...
//=============================================================================
class TNMFireballSmoke expands Effects;

// necessary for this smoke puff, but not for the texture in Flame? \=|
#exec OBJ LOAD FILE=Effects

var bool bRelinquished;
var float origLifeSpan;

simulated function Tick( float dt )
{
	Super.Tick(dt);

	if ( !bRelinquished )
		return;

	Velocity *= 1-dt;
	Velocity.Z += 200*dt;
	DrawScale += 2*dt;
	ScaleGlow = LifeSpan / origLifeSpan;
}

defaultproperties
{
    Physics=6
    LifeSpan=1.00
    DrawType=1
    Style=3
    Texture=FireTexture'Effects.Smoke.SmokePuff1'
    DrawScale=0.10
    bCollideWorld=True
}
