//=============================================================================
// TrestkonCarcass.
// auth: aUnt beTty
//=============================================================================
class TrestkonCarcass extends DeusExCarcass;

var bool bBloodHead;

// ----------------------------------------------------------------------
// PostPostBeginPlay()
// ----------------------------------------------------------------------

function PostPostBeginPlay()
{
	local trestkon player;

	Super.PostPostBeginPlay();

	foreach AllActors(class'trestkon', player)
		break;

	bBloodHead=player.bInsaneDeath;

	SetSkin(player);
}

// ----------------------------------------------------------------------
// SetSkin()
// ----------------------------------------------------------------------

function SetSkin(DeusExPlayer player)
{
	local int i;
	if (player != None)
	{
		if (player.playerSkin >= 12)
		{
		     Mesh2=LodMesh'DeusExCharacters.GM_Trench_CarcassB';
		     Mesh3=LodMesh'DeusExCharacters.GM_Trench_CarcassC';
		     Mesh=LodMesh'DeusExCharacters.GM_Trench_Carcass';
		}

		for (i=0;i<8;i++)
			MultiSkins[i] = player.Multiskins[i];
	}
}

//just to move the blood splat up to his head
auto state Dead
{
	function HandleLanding()
	{
		local Vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
		local Actor hit;
		local BloodPool pool;

		if (!bNotDead)
		{
			// trace down about 20 feet if we're not in water
			if (!Region.Zone.bWaterZone)
			{
				StartTrace = Location;

				if(bBloodHead)
				{
					GetAxes(Rotation,X,Y,Z);
					StartTrace += X * CollisionRadius;
				}
				
				EndTrace = StartTrace - vect(0,0,320);
				hit = Trace(HitLocation, HitNormal, EndTrace, StartTrace, False);
				pool = spawn(class'BloodPool',,, HitLocation+HitNormal, Rotator(HitNormal));
				if (pool != None)
				{
					if(bBloodHead)
						pool.maxDrawScale = CollisionRadius / 40.0 * 0.25;
					else
						pool.maxDrawScale = CollisionRadius / 40.0;
				}
			}

			// alert NPCs that I'm food
			AIStartEvent('Food', EAITYPE_Visual);
		}

		// by default, the collision radius is small so there won't be as
		// many problems spawning carcii
		// expand the collision radius back to where it's supposed to be
		// don't change animal carcass collisions
		if (!bAnimalCarcass)
			SetCollisionSize(40.0, Default.CollisionHeight);

		// alert NPCs that I'm really disgusting
		if (bEmitCarcass)
			AIStartEvent('Carcass', EAITYPE_Visual);
	}
}

defaultproperties
{
    Mesh2=LodMesh'DeusExCharacters.GM_Jumpsuit_CarcassB'
    Mesh3=LodMesh'DeusExCharacters.GM_Jumpsuit_CarcassC'
    Texture=Texture'DeusExItems.Skins.PinkMaskTex'
    Mesh=LodMesh'DeusExCharacters.GM_Jumpsuit_Carcass'
    MultiSkins(0)=Texture'Skins.TrestkonTex0'
    MultiSkins(1)=Texture'Skins.TrestkonTex2'
    MultiSkins(2)=Texture'Skins.TrestkonTex1'
    MultiSkins(3)=Texture'Skins.TrestkonTex0'
    MultiSkins(4)=Texture'DeusExItems.Skins.PinkMaskTex'
    MultiSkins(5)=Texture'DeusExItems.Skins.PinkMaskTex'
    MultiSkins(6)=Texture'DeusExItems.Skins.PinkMaskTex'
    MultiSkins(7)=Texture'DeusExItems.Skins.PinkMaskTex'
    CollisionRadius=44.00
    CollisionHeight=7.70
}
