//=============================================================================
// WeaponFireStaff.
//=============================================================================
class WeaponFireStaff extends TNMWeapon;

#exec OBJ LOAD FILE=Effects

var int BurnTime, BurnDamage;

var int		mpBurnTime;
var int		mpBurnDamage;

// Muzzle Flash Stuff
// called from the mesh NOTIFY Copied from DeusexWeapons.uc and modified...
simulated function SwapMuzzleFlashTexture()
{
     if (!bHasMuzzleFlash)
     return;
     if (FRand() < 0.5)
         MultiSkins[4] = Texture'Effects.liquid.Virus_SFX';
     else
         MultiSkins[4] = Texture'Effects.liquid.Virus_SFX';

     MuzzleFlashLight();
     SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture1()
{
     MultiSkins[4] = None;
}

simulated function Timer()
{
     EraseMuzzleFlashTexture1();
}

simulated function MuzzleFlashLight()
{
     local Vector offset, X, Y, Z;
     local Effects flash;

      if (!bHasMuzzleFlash)
          return;

     if ((flash != None) && !flash.bDeleteMe)
          flash.LifeSpan = flash.Default.LifeSpan;
     else
     {
          GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
          offset = Owner.Location;
          offset += X * Owner.CollisionRadius * 2;
          flash = spawn(class'Muzzleflash',,, offset);
          if (flash != None)
               flash.SetBase(Owner);
     }
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
      HitDamage = mpHitDamage;
      BaseAccuracy=mpBaseAccuracy;
      ReloadTime = mpReloadTime;
      AccurateRange = mpAccurateRange;
      MaxRange = mpMaxRange;
      ReloadCount = mpReloadCount;
      BurnTime = mpBurnTime;
      BurnDamage = mpBurnDamage;
      PickupAmmoCount = mpReloadCount;
	}
}


//
// When the Staff is Reloading
//
state Reload
{
      function BeginState()
      {
           Super.BeginState();
//         playsound(sound'Soundfile'); //You'll have to #exec import the sound if you want one, I thought it would be good if
                                        //if the player mutters some magical words when it reloads, but it's up to you
           LightType = LT_Flicker;
           LightEffect = LE_NonIncidence;
       }
}


//
// When the Staff is Idle
//
state Idle
{
     function BeginState()
     {
          Super.BeginState();
          LightType = LT_Steady;
     }
}


//
// When the Staff is down
//
state DownWeapon
{
     function BeginState()
     {
          Super.BeginState();
          LightType = LT_None;
     }
}


//
// When the Staff is picked up
//
auto state Pickup
{
     function EndState()
     {
          Super.EndState();
          LightType = LT_None;
     }
}

//
// Belt and Inventory Icons
//
#exec texture IMPORT NAME=LargeIconStaff FILE=Textures\LargeIconStaff.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconStaff FILE=Textures\BeltIconStaff.pcx GROUP=Skins MIPS=off


//
// First Person Version
//
#exec mesh IMPORT MESH=DeusStaff ANIVFILE=MODELS\DeusStaff_a.3d DATAFILE=MODELS\DeusStaff_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DeusStaff X=0 Y=0 Z=0 YAW=64

#exec MESH SEQUENCE MESH=DeusStaff SEQ=All         STARTFRAME=0 NUMFRAMES=76
#exec MESH SEQUENCE MESH=DeusStaff SEQ=Still       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=DeusStaff SEQ=Select      STARTFRAME=1 NUMFRAMES=9    RATE=8 GROUP=Select
#exec MESH SEQUENCE MESH=DeusStaff SEQ=Shoot       STARTFRAME=9 NUMFRAMES=7    RATE=24
#exec mesh SEQUENCE MESH=DeusStaff SEQ=Down        STARTFRAME=15 NUMFRAMES=4   RATE=24
#exec mesh SEQUENCE MESH=DeusStaff SEQ=ReloadBegin STARTFRAME=19 NUMFRAMES=7   RATE=24
#exec mesh SEQUENCE MESH=DeusStaff SEQ=Reload      STARTFRAME=25 NUMFRAMES=6   RATE=8
#exec mesh SEQUENCE MESH=DeusStaff SEQ=ReloadEnd   STARTFRAME=30 NUMFRAMES=6   RATE=8
#exec mesh SEQUENCE MESH=DeusStaff SEQ=Idle1       STARTFRAME=35 NUMFRAMES=11  RATE=4
#exec mesh SEQUENCE MESH=DeusStaff SEQ=Idle2       STARTFRAME=45 NUMFRAMES=11  RATE=4
#exec mesh SEQUENCE MESH=DeusStaff SEQ=Idle3       STARTFRAME=55 NUMFRAMES=11  RATE=4
#exec mesh SEQUENCE mesh=DeusStaff SEQ=Attack      STARTFRAME=65 NUMFRAMES=11  RATE=14

#exec mesh NOTIFY MESH=DeusStaff SEQ=Shoot	TIME=0.01	FUNCTION=SwapMuzzleFlashTexture
#exec mesh NOTIFY MESH=DeusStaff SEQ=Reload	TIME=0.01	FUNCTION=SwapMuzzleFlashTexture
#exec mesh NOTIFY MESH=DeusStaff SEQ=Attack TIME=0.04	FUNCTION=HandToHandAttack

#exec texture IMPORT NAME=DeusStaff1 FILE=Textures\DeusStaffTex1.PCX GROUP=Skins // Staffwood
#exec texture IMPORT NAME=Orb1 FILE=Textures\ReflectionRed.PCX GROUP=Skins // ENVMAPPED
#exec TEXTURE IMPORT NAME=Hands FILE=Textures\WeaponHandsTex.pcx GROUP=Skins // TWOSIDEDNORM
#exec TEXTURE IMPORT NAME=FireStaffMuzzle FILE=Textures\FireStaffMuzzle.pcx GROUP=Skins

#exec MESHMAP NEW   MESHMAP=DeusStaff MESH=DeusStaff
#exec MESHMAP SCALE MESHMAP=DeusStaff X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=DeusStaff NUM=1 TEXTURE=DeusStaff1
#exec MESHMAP SETTEXTURE MESHMAP=DeusStaff NUM=2 TEXTURE=Effects.Electricity.WEPN_Prod_FX
#exec MESHMAP SETTEXTURE MESHMAP=DeusStaff NUM=3 TEXTURE=Effects.electricity.Nano_SFX_A
#exec MESHMAP SETTEXTURE MESHMAP=DeusStaff NUM=4 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=DeusStaff NUM=5 TEXTURE=Hands

//
// Pickup Version
//
#exec MESH IMPORT MESH=DeusStaffPickup ANIVFILE=MODELS\DeusStaffPickup_a.3d DATAFILE=MODELS\DeusStaffPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DeusStaffPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=DeusStaffPickup SEQ=All             STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=DeusStaffPickup SEQ=Still           STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=DeusStaffPickup MESH=DeusStaffPickup
#exec MESHMAP SCALE MESHMAP=DeusStaffPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=DeusStaffPickup NUM=1 TEXTURE=DeusStaff1
#exec MESHMAP SETTEXTURE MESHMAP=DeusStaffPickup NUM=2 TEXTURE=Effects.Electricity.WEPN_Prod_FX
#exec MESHMAP SETTEXTURE MESHMAP=DeusStaffPickup NUM=3 TEXTURE=Effects.electricity.Nano_SFX_A
#exec MESHMAP SETTEXTURE MESHMAP=DeusStaffPickup NUM=4 TEXTURE=PinkMaskTex //Effects.electricity.Nano_SFX_A



//
// 3rd Person Version
//
#exec MESH IMPORT MESH=DeusStaff3rd ANIVFILE=MODELS\DeusStaff3rd_a.3d DATAFILE=MODELS\DeusStaff3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DeusStaff3rd X=1000 Y=0 Z=1000 ROLL=-3 PITCH=25

#exec MESH SEQUENCE MESH=DeusStaff3rd SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=DeusStaff3rd SEQ=Still        STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=DeusStaff3rd MESH=DeusStaff3rd
#exec MESHMAP SCALE MESHMAP=DeusStaff3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=DeusStaff3rd NUM=1 TEXTURE=DeusStaff1
#exec MESHMAP SETTEXTURE MESHMAP=DeusStaff3rd NUM=2 TEXTURE=Effects.Electricity.WEPN_Prod_FX
#exec MESHMAP SETTEXTURE MESHMAP=DeusStaff3rd NUM=3 TEXTURE=Effects.electricity.Nano_SFX_A
#exec MESHMAP SETTEXTURE MESHMAP=DeusStaff3rd NUM=4 TEXTURE=PinkMaskTex

//Sounds
#exec AUDIO IMPORT FILE="Sounds\FIRESTAFF\Fire.wav" 			NAME="FireStaffFire" 		GROUP="Weapons"
#exec AUDIO IMPORT FILE="Sounds\FIRESTAFF\Reload.wav" 			NAME="FireStaffReload" 		GROUP="Weapons"

defaultproperties
{
    burnTime=30
    BurnDamage=5
    mpBurnTime=15
    mpBurnDamage=2
    bNoMetal=True
    LowAmmoWaterMark=50
    GoverningSkill=Class'DeusEx.SkillWeaponRifle'
    NoiseLevel=0.05
    EnemyEffective=1
    EnviroEffective=1
    Concealability=1
    bAutomatic=True
    ShotTime=0.10
    reloadTime=5.00
    HitDamage=0
    maxRange=4800
    AccurateRange=320
    BaseAccuracy=0.90
    ScopeFOV=25
    mpReloadTime=3.00
    mpHitDamage=20
    mpBaseAccuracy=0.20
    mpAccurateRange=1200
    mpMaxRange=1200
    mpReloadCount=2
    AmmoName=Class'AmmoManaPotion'
    ReloadCount=100
    PickupAmmoCount=100
    FireOffset=(X=0.00,Y=10.00,Z=10.00),
    ProjectileClass=Class'DeusEx.Fireball'
    shakemag=20.00
    FireSound=Sound'Weapons.FireStaffFire'
    CockingSound=Sound'Weapons.FireStaffReload'
    SelectSound=Sound'DeusExSounds.Weapons.CrowbarSelect'
    InventoryGroup=28
    bAmbientGlow=True
    ItemName="Firestaff"
    ItemArticle="the"
    PlayerViewOffset=(X=18.00,Y=-10.00,Z=-14.50),
    PlayerViewMesh=LodMesh'DeusStaff'
    PickupViewMesh=LodMesh'DeusStaffPickup'
    PickupViewScale=1.30
    ThirdPersonMesh=LodMesh'DeusStaff3rd'
    ThirdPersonScale=0.90
    Icon=Texture'Skins.BeltIconStaff'
    largeIcon=Texture'Skins.LargeIconStaff'
    largeIconWidth=205
    largeIconHeight=36
    invSlotsX=4
    Description="UNIQUE WEAPON:|nThis is the legendary Firestaff, which you retrieved from its protected container in the ancient moderator control room in the ruins of Deus Ex Incarnate, where it was actually enjoying itself quite a bit. What the heck were you thinking? Did you care to just ask the staff if it wanted to be removed? NO! Heartless bastard."
    beltDescription="FIRESTAFF"
    Mesh=LodMesh'DeusStaffPickup'
    AmbientGlow=255
    CollisionRadius=9.00
    CollisionHeight=4.00
    LightType=1
    LightEffect=3
    LightBrightness=255
    LightHue=176
    LightSaturation=20
    LightRadius=4
}
