//=============================================================================
// WeaponFists.
//=============================================================================
class WeaponFists extends TNMWeapon;

var travel bool bhasspiked;
var travel bool bhasshock;
var travel bool bhasstun;
var bool bkaratechop;

enum EFistType {
  FT_normal,
  FT_spiked,
  FT_shock,
  FT_stun };

var travel Efisttype fisttype;

function byte getfistType()
{
	return fisttype;
}

simulated function PlaySelectiveFiring()
{
	if(bKarateChop)
	{
		PlayAnim('KarateChop',,0.1);
		return;
	}

	super.PlaySelectiveFiring();
}

simulated function Tick(float deltaTime)
{
	local ScriptedPawn pawn;
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z, offset;
	local actor Other;
	local float dist;
	local bool bHead;
	local float offsetZ,offsetY;

	super.Tick(deltaTime);

	//make sure proper fist mesh is selected post travel
	if(PlayerViewMesh==None)
		SetFistType(fisttype);

	if(pawn(owner)==None)
		return;

	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = ComputeProjectileStart(X, Y, Z);
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);

	EndTrace = StartTrace + (FMax(1024.0, MaxRange) * vector(AdjustedAim));
      
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	dist = Abs(VSize(HitLocation - Owner.Location));
	if (dist <= AccurateRange)
	{
		X=vector(adjustedaim);
		pawn=ScriptedPawn(Other);
		
		if(pawn!=None)
		{
			offset = (hitLocation - pawn.Location) << pawn.Rotation;
			offsetZ = pawn.CollisionHeight * 0.7;
			offsetY = pawn.CollisionRadius * 0.3;

			if(offset.z>offsetZ)
				if((Abs(offset.x) < offsetY) || (Abs(offset.y) < offsetY))
					if(offset.x<0)
						bHead=true;
		}

		if(!bHead && bKarateChop)
		{
			bKarateChop=false;
			TweenAnim('Still',0.3);
		}
		else if (bHead && !bKarateChop)
		{
			bKarateChop=true;
			PlayAnim('KarateRaised',,0.2);
		}	
	}
}

function setfisttype(byte ft)
{
//why aren't enums interchangable with integers?
//--
//if anyone's interested (yay fan looking through the code) it's because they're byte values
//you can still explicitly cast them to int eg int(ft) -shax
switch(ft)
{
 case 0 : fisttype = FT_normal;
	playerviewmesh = LodMesh'WeaponFists';
	mesh = LodMesh'WeaponFists';
	break;
 case 1 : fisttype = FT_spiked;
	playerviewmesh = LodMesh'WeaponFistsspike';
	mesh = LodMesh'WeaponFistsspike';;
	break;
 case 2 : fisttype = FT_shock;
	playerviewmesh = LodMesh'WeaponFistsshock';
	mesh = LodMesh'WeaponFistsshock';
	break;
 case 3 : fisttype = FT_stun;
	playerviewmesh = LodMesh'WeaponFistsstun';
	mesh = LodMesh'WeaponFistsstun';
	break;
}
}

function givefisttype(byte ft)
{
switch(ft)
{
 case 1 : bhasspiked = true;
	break;
 case 2 : bhasshock = true;
	break;
 case 3 : bhasstun = true;
	break;
}
}

simulated function SpawnEffectSounds( Vector HitLocation, Vector HitNormal, Actor Other, float Damage )
{
	if (bHandToHand)
	{
		// if we are hand to hand, play an appropriate sound
		if (Other.IsA('Pawn')|| Other.IsA('carcass')) //added to make carci make a squelching sound instead of a metalic sound.
			Owner.PlayOwnedSound(Misc1Sound, SLOT_None,,, 1024);
		else if (Other.IsA('DeusExDecoration'))
			Owner.PlayOwnedSound(Misc3Sound, SLOT_None,,, 1024);
		else if (Other.IsA('BreakableGlass'))
			Owner.PlayOwnedSound(sound'GlassHit1', SLOT_None,,, 1024);
		else if (GetWallMaterial(HitLocation, HitNormal) == 'Glass')
			Owner.PlayOwnedSound(sound'BulletProofHit', SLOT_None,,, 1024);
		else
			Owner.PlayOwnedSound(Misc2Sound, SLOT_None,,, 1024);
	}
}


simulated function OwnerHandToHandAttack()
{
	local bool bOwnerIsPlayerPawn;

	if (!bOwnerWillNotify)
		return;

	// The controlling animator should be the one to do the tracefire and projfire
	if ( Level.NetMode != NM_Standalone )
	{
		bOwnerIsPlayerPawn = (DeusExPlayer(Owner) == DeusExPlayer(GetPlayerPawn()));

		if (( Role < ROLE_Authority ) && bOwnerIsPlayerPawn )
			ServerHandleNotify( bInstantHit, ProjectileClass, ProjectileSpeed, bWarnTarget );
		else if ( !bOwnerIsPlayerPawn )
			return;
	}

	if (ScriptedPawn(Owner) != None)
		ScriptedPawn(Owner).SetAttackAngle();

	switch(fisttype)
	{
	 case FT_normal: 
		HitDamage = default.HitDamage;
		break;
	 case FT_spiked: 
		hitdamage = default.hitdamage * 1.5;
		break;
	 case FT_shock: 
		hitdamage = default.hitdamage;
		break;
	 case FT_stun : 
		hitdamage = default.hitdamage / 2;
		break;
	}
		TraceFire(0.0);

}

function name WeaponDamageType()
{
	if(Trestkon(GetPlayerPawn()).bInstagibFists)
		return 'Gibbed';

	StunDuration = 0;

	switch(fisttype)
	{
	case FT_normal:
		return 'KnockedOut';
	case FT_spiked:
		return 'Shot';
	case FT_shock:
		return 'FistEMP';
	case FT_stun:
		StunDuration=4.0;
		return 'Stunned';
	}
}

//all
	//
	// Sounds
	//
	#exec AUDIO IMPORT FILE="Sounds\hitflesh.wav" NAME="HitFlesh" GROUP="Weapons"
	#exec AUDIO IMPORT FILE="Sounds\swingmiss.wav" NAME="FistsFire" GROUP="Weapons"
	#exec AUDIO IMPORT FILE="Sounds\hitmetal.wav" NAME="HitMetal" GROUP="Weapons"
	#exec AUDIO IMPORT FILE="Sounds\hitwood.wav" NAME="HitWood" GROUP="Weapons"


	//BeltIcon the fist should not take up any inventory space so no large icon is needed
	#exec texture IMPORT NAME=BeltIconFist FILE=Textures\BeltIconFist.pcx GROUP=Skins MIPS=off
	#exec texture IMPORT NAME=LargeIconFist FILE=Textures\LargeIconFist.pcx GROUP=Skins MIPS=off

	#exec TEXTURE IMPORT NAME=JWeaponFists1 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // TWOSIDED
	#exec TEXTURE IMPORT NAME=shockFists1 FILE=Textures\FistsTex_Electric.pcx GROUP=Skins // TWOSIDED
	#exec TEXTURE IMPORT NAME=spikeFists1 FILE=Textures\FistsTex_Lethal.pcx GROUP=Skins // TWOSIDED
	#exec TEXTURE IMPORT NAME=stunFists1 FILE=Textures\FistsTex_Stun.pcx GROUP=Skins // TWOSIDED

//plain
	#exec MESH IMPORT MESH=WeaponFists ANIVFILE=MODELS\WeaponFists_a.3d DATAFILE=MODELS\WeaponFists_d.3d X=0 Y=0 Z=0 UNMIRROR=1
	#exec MESH ORIGIN MESH=WeaponFists X=-3000 Y=-5000 Z=3000 Yaw=128  //x=5000 Y=2000 Z=3000

	#exec mesh SEQUENCE MESH=WeaponFists SEQ=All               STARTFRAME=0  NUMFRAMES=80
	#exec mesh SEQUENCE MESH=WeaponFists SEQ=Still             STARTFRAME=0  NUMFRAMES=1
	#exec mesh SEQUENCE MESH=WeaponFists SEQ=Select            STARTFRAME=1  NUMFRAMES=5    RATE=7     GROUP=Select
	#exec mesh SEQUENCE MESH=WeaponFists SEQ=Attack            STARTFRAME=5  NUMFRAMES=8    RATE=18   //RightHook
	#exec mesh SEQUENCE MESH=WeaponFists SEQ=Attack2           STARTFRAME=12 NUMFRAMES=12   RATE=30   //2 Combo Jab
	#exec mesh SEQUENCE MESH=WeaponFists SEQ=Attack3           STARTFRAME=23 NUMFRAMES=10   RATE=24   //Uppercut
	#exec mesh SEQUENCE MESH=WeaponFists SEQ=Prod              STARTFRAME=32 NUMFRAMES=8
	#exec mesh SEQUENCE MESH=WeaponFists SEQ=KarateRaised      STARTFRAME=40 NUMFRAMES=6
	#exec mesh SEQUENCE MESH=WeaponFists SEQ=KarateChop        STARTFRAME=45 NUMFRAMES=10
	#exec mesh SEQUENCE MESH=WeaponFists SEQ=Down              STARTFRAME=54 NUMFRAMES=5   RATE=10
	#exec mesh SEQUENCE MESH=WeaponFists SEQ=Idle1             STARTFRAME=59 NUMFRAMES=8   RATE=2
	#exec mesh SEQUENCE MESH=WeaponFists SEQ=Idle2             STARTFRAME=66 NUMFRAMES=8   RATE=2
	#exec mesh SEQUENCE MESH=WeaponFists SEQ=Idle3             STARTFRAME=73 NUMFRAMES=7   RATE=2

	//
	// Attack Information
	//
	#exec MESH NOTIFY MESH=WeaponFists SEQ=Attack           TIME=0.2     FUNCTION=HandToHandAttack
	#exec MESH NOTIFY MESH=WeaponFists SEQ=Attack2          TIME=0.3     FUNCTION=HandToHandAttack
	#exec MESH NOTIFY MESH=WeaponFists SEQ=Attack3          TIME=0.3     FUNCTION=HandToHandAttack
	#exec MESH NOTIFY MESH=WeaponFists SEQ=KarateChop       TIME=0.3     FUNCTION=HandToHandAttack

	#exec MESHMAP NEW   MESHMAP=WeaponFists MESH=WeaponFists
	#exec MESHMAP SCALE MESHMAP=WeaponFists X=0.00390625 Y=0.00390625 Z=0.00390625

	#exec MESHMAP SETTEXTURE MESHMAP=WeaponFists NUM=1 TEXTURE=JWeaponFists1

//stun
	#exec MESH IMPORT MESH=WeaponFistsStun ANIVFILE=MODELS\WeaponFists_a.3d DATAFILE=MODELS\WeaponFists_d.3d X=0 Y=0 Z=0 UNMIRROR=1
	#exec mesh ORIGIN MESH=WeaponFistsStun X=-3000 Y=-5000 Z=3000 Yaw=128  //x=5000 Y=2000 Z=3000

	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=All               STARTFRAME=0  NUMFRAMES=80
	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=Still             STARTFRAME=0  NUMFRAMES=1
	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=Select            STARTFRAME=1  NUMFRAMES=5    RATE=7     GROUP=Select
	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=Attack            STARTFRAME=5  NUMFRAMES=8    RATE=18   //RightHook
	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=Attack2           STARTFRAME=12 NUMFRAMES=12   RATE=30   //2 Combo Jab
	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=Attack3           STARTFRAME=23 NUMFRAMES=10   RATE=24   //Uppercut
	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=Prod              STARTFRAME=32 NUMFRAMES=8
	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=KarateRaised      STARTFRAME=40 NUMFRAMES=6
	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=KarateChop        STARTFRAME=45 NUMFRAMES=10
	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=Down              STARTFRAME=54 NUMFRAMES=5   RATE=10
	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=Idle1             STARTFRAME=59 NUMFRAMES=8   RATE=2
	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=Idle2             STARTFRAME=66 NUMFRAMES=8   RATE=2
	#exec mesh SEQUENCE MESH=WeaponFistsStun SEQ=Idle3             STARTFRAME=73 NUMFRAMES=7   RATE=2

	//
	// Attack Information
	//
	#exec MESH NOTIFY MESH=WeaponFistsStun SEQ=Attack          TIME=0.2     FUNCTION=HandToHandAttack
	#exec MESH NOTIFY MESH=WeaponFistsStun SEQ=Attack2          TIME=0.3     FUNCTION=HandToHandAttack
	#exec MESH NOTIFY MESH=WeaponFistsStun SEQ=Attack3          TIME=0.3     FUNCTION=HandToHandAttack
	#exec MESH NOTIFY MESH=WeaponFistsStun SEQ=KarateChop       TIME=0.3     FUNCTION=HandToHandAttack

	#exec MESHMAP NEW   MESHMAP=WeaponFistsStun MESH=WeaponFistsStun
	#exec MESHMAP SCALE MESHMAP=WeaponFistsStun X=0.00390625 Y=0.00390625 Z=0.00390625

	#exec MESHMAP SETTEXTURE MESHMAP=WeaponFistsStun NUM=1 TEXTURE=stunFists1
//shock
	#exec mesh IMPORT MESH=WeaponFistsShock ANIVFILE=MODELS\WeaponFists_a.3d DATAFILE=MODELS\WeaponFists_d.3d X=0 Y=0 Z=0 UNMIRROR=1
	#exec MESH ORIGIN MESH=WeaponFistsShock X=-3000 Y=-5000 Z=3000 Yaw=128  //x=5000 Y=2000 Z=3000

	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=All               STARTFRAME=0  NUMFRAMES=80
	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=Still             STARTFRAME=0  NUMFRAMES=1
	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=Select            STARTFRAME=1  NUMFRAMES=5    RATE=7     GROUP=Select
	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=Attack            STARTFRAME=5  NUMFRAMES=8    RATE=18   //RightHook
	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=Attack2           STARTFRAME=12 NUMFRAMES=12   RATE=30   //2 Combo Jab
	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=Attack3           STARTFRAME=23 NUMFRAMES=10   RATE=24   //Uppercut
	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=Prod              STARTFRAME=32 NUMFRAMES=8
	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=KarateRaised      STARTFRAME=40 NUMFRAMES=6
	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=KarateChop        STARTFRAME=45 NUMFRAMES=10
	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=Down              STARTFRAME=54 NUMFRAMES=5   RATE=10
	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=Idle1             STARTFRAME=59 NUMFRAMES=8   RATE=2
	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=Idle2             STARTFRAME=66 NUMFRAMES=8   RATE=2
	#exec mesh SEQUENCE MESH=WeaponFistsShock SEQ=Idle3             STARTFRAME=73 NUMFRAMES=7   RATE=2

	//
	// Attack Information
	//
	#exec MESH NOTIFY MESH=WeaponFistsShock SEQ=Attack          TIME=0.2     FUNCTION=HandToHandAttack
	#exec MESH NOTIFY MESH=WeaponFistsShock SEQ=Attack2          TIME=0.3     FUNCTION=HandToHandAttack
	#exec MESH NOTIFY MESH=WeaponFistsShock SEQ=Attack3          TIME=0.3     FUNCTION=HandToHandAttack
	#exec MESH NOTIFY MESH=WeaponFistsShock SEQ=KarateChop       TIME=0.3     FUNCTION=HandToHandAttack

	#exec MESHMAP NEW   MESHMAP=WeaponFistsShock MESH=WeaponFistsShock
	#exec MESHMAP SCALE MESHMAP=WeaponFistsShock X=0.00390625 Y=0.00390625 Z=0.00390625

	#exec MESHMAP SETTEXTURE MESHMAP=WeaponFistsShock NUM=1 TEXTURE=shockFists1
//spike
	#exec mesh IMPORT MESH=WeaponFistsSpike ANIVFILE=MODELS\WeaponFists_a.3d DATAFILE=MODELS\WeaponFists_d.3d X=0 Y=0 Z=0 UNMIRROR=1
	#exec MESH ORIGIN MESH=WeaponFistsSpike X=-3000 Y=-5000 Z=3000 Yaw=128  //x=5000 Y=2000 Z=3000

	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=All               STARTFRAME=0  NUMFRAMES=80
	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=Still             STARTFRAME=0  NUMFRAMES=1
	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=Select            STARTFRAME=1  NUMFRAMES=5    RATE=7     GROUP=Select
	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=Attack            STARTFRAME=5  NUMFRAMES=8    RATE=18   //RightHook
	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=Attack2           STARTFRAME=12 NUMFRAMES=12   RATE=30   //2 Combo Jab
	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=Attack3           STARTFRAME=23 NUMFRAMES=10   RATE=24   //Uppercut
	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=Prod              STARTFRAME=32 NUMFRAMES=8
	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=KarateRaised      STARTFRAME=40 NUMFRAMES=6
	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=KarateChop        STARTFRAME=45 NUMFRAMES=10
	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=Down              STARTFRAME=54 NUMFRAMES=5   RATE=10
	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=Idle1             STARTFRAME=59 NUMFRAMES=8   RATE=2
	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=Idle2             STARTFRAME=66 NUMFRAMES=8   RATE=2
	#exec mesh SEQUENCE MESH=WeaponFistsSpike SEQ=Idle3             STARTFRAME=73 NUMFRAMES=7   RATE=2

	//
	// Attack Information
	//
	#exec MESH NOTIFY MESH=WeaponFistsSpike SEQ=Attack          TIME=0.2     FUNCTION=HandToHandAttack
	#exec MESH NOTIFY MESH=WeaponFistsSpike SEQ=Attack2          TIME=0.3     FUNCTION=HandToHandAttack
	#exec MESH NOTIFY MESH=WeaponFistsSpike SEQ=Attack3          TIME=0.3     FUNCTION=HandToHandAttack
	#exec MESH NOTIFY MESH=WeaponFistsSpike SEQ=KarateChop       TIME=0.3     FUNCTION=HandToHandAttack

	#exec MESHMAP NEW   MESHMAP=WeaponFistsSpike MESH=WeaponFistsSpike
	#exec MESHMAP scale MESHMAP=WeaponFistsSpike X=0.00390625 Y=0.00390625 Z=0.00390625

	#exec MESHMAP SETTEXTURE MESHMAP=WeaponFistsSpike NUM=1 TEXTURE=spikeFists1

defaultproperties
{
    LowAmmoWaterMark=0
    GoverningSkill=Class'SkillWeaponFists'
    NoiseLevel=0.02
    EnemyEffective=1
    Concealability=3
    reloadTime=0.00
    HitDamage=5
    maxRange=80
    AccurateRange=80
    BaseAccuracy=1.00
    StunDuration=5.00
    bHasMuzzleFlash=False
    bHandToHand=True
    bEmitWeaponDrawn=False
    bUseAsDrawnWeapon=False
    mpHitDamage=20
    mpBaseAccuracy=0.20
    mpAccurateRange=1200
    mpMaxRange=80
    AmmoName=Class'DeusEx.AmmoNone'
    ReloadCount=0
    bInstantHit=True
    FireOffset=(X=22.00,Y=-10.00,Z=14.00),
    shakemag=20.00
    FireSound=Sound'Weapons.FistsFire'
    SelectSound=Sound'DeusExSounds.Weapons.CrowbarSelect'
    Misc1Sound=Sound'Weapons.HitFlesh'
    Misc2Sound=Sound'Weapons.HitMetal'
    Misc3Sound=Sound'Weapons.HitWood'
    InventoryGroup=31
    bDisplayableInv=False
    ItemName="Stun-Gloves(TM)"
    PlayerViewOffset=(X=28.00,Y=-10.00,Z=-11.50),
    PlayerViewScale=0.70
    Icon=Texture'Skins.BeltIconFist'
    largeIcon=Texture'Skins.LargeIconFist'
    largeIconWidth=36
    largeIconHeight=36
    Description="UNIQUE WEAPON:|nThe ACME(R) Techno-Steel Stun-Gloves(TM) are especially crafted to fit anybody perfectly. They are made of a very light composite steel-variety which allows maximum impact power while ensuring minimum encumbrance. Their unique shape allows you to stun anyone you punch while wearing these gloves for a short period of time.|n|nNB. Now available with special synth-fur padding! Order now, and get a free candy bar for free, with no extra cost!"
    beltDescription="GLOVES"
    CollisionRadius=9.00
    CollisionHeight=4.00
}
