class incinerator extends Cloud;

function DoZoneCheck()
{
	local tnmzoneinfo z;
	if(Region.Zone.bWaterZone)
		Destroy();
	z=tnmzoneinfo(region.zone);
	if(z==none)
		return;
	if(z.bNoOxygen)
		Destroy();
}

event ZoneChange( ZoneInfo NewZone )
{
	DoZoneCheck();
}

function Tick(float dt)
{
	DoZoneCheck();
	super.Tick(dt);
}

function TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
{
	if(DamageType=='HalonGas')
		Destroy();
}

defaultproperties
{
    DamageType=Flamed
    maxDrawScale=2.00
    Physics=2
    Texture=FireTexture'Effects.Fire.OnFire_J'
    SoundVolume=192
    AmbientSound=Sound'Ambient.Ambient.FireSmall1'
    LightType=1
    LightEffect=2
    LightBrightness=255
    LightHue=16
    LightSaturation=64
    LightRadius=4
}
