//=============================================================================
// BloodPool.
//=============================================================================
class tnmBloodPool extends tnmDecal;

var float spreadTime;
var float maxDrawScale;
var float time;

var bool bStopExpanding;

function BeginPlay()
{
	// Gore check
	if (Level.Game.bLowGore || Level.Game.bVeryLowGore)
	{
		Destroy();
		return;
	}
	Super.BeginPlay();
}

function Tick(float deltaTime)
{
	if (bStopExpanding)
		return;
	time += deltaTime;
	if (time <= spreadTime)
	{
		DrawScale = maxDrawScale * time / spreadTime;
		ReattachDecal(vect(0.1,0.1,0));
	}
}

defaultproperties
{
    spreadTime=5.00
    maxDrawScale=1.00
    Texture=Texture'DeusExItems.Skins.FlatFXTex1'
}
