//=============================================================================
// CameraPoint.
//=============================================================================
class tnmCameraPoint extends KeyPoint;

enum ECameraCommand
{
	CAMCMD_MOVE,						// cut (or smoothly move if timeSmooth > 0) to XYZPYR
	CAMCMD_PUSH,						// move forward along view axis
	CAMCMD_FOV,						// change FOV
	CAMCMD_TILT,						// change Pitch
	CAMCMD_PAN,						// change Yaw
	CAMCMD_ROLL,						// change Roll
//	CAMCMD_WAIT,						// wait time or for a specific event
	CAMCMD_TRIGGER,						// trigger an event
	CAMCMD_END,		//added				// End of Cinematic
	CAMCMD_MOVETOPLAYER,	//added				// Move back to the Eye level of th player
	CAMCMD_FADEIN,		//added				// Fade the camera out. move here. fade back in.
	CAMCMD_FADEOUT,		//added				// Fade the camera out. move to player. fade back in.
	CAMCMD_INTERPOLATE	//added				// Interpolate along interpolation path
};

var() bool bLetterBox;
var() bool bConversationAllowed;

var() bool				bChangeState;
var() bool 				bPlayerVisible;
var() ECameraCommand			cmd;			// what command to execute
var() float				value;			// parameter for command
var() name				eventName;		// used by CAMCMD_WAIT_EVENT
var() float				timeSmooth;		// execute command smoothly over time (0 = instant)
var() float				timeWaitPost;		// delay after executing command
//var() bool				bParallel;		// execute the next command simultaneously
var() bool				bRandom;		// the next point is chosen at random from other bRandoms
var() int				randomCount;		// number of times to choose randomly
var() int				postRandomNum;		// sequence to start at after random sequence
var() name				InterpolationTarget;
var() bool 				bFollowPlayer;
var() bool				bFadeWhite;		// fade to/from white instead of black

var() name TargetName;

// internal vars not editable by the user
var() const int				sequenceNum;		// assigned in editor automatically
var tnmCameraPoint			nextPoint;		// next point to be executed - points linked at runtime
var tnmCameraPoint			prevPoint;		// point that was just executed - used by bParallel
var float				curTime;		// timer used by movement routines
var vector				startLoc;		// init location at beginning of command
var rotator				startRot;		// init rotation at beginning of command
var float				startFOV;		// init FOV at beginning of command
var vector				endLoc;			// dest location
var rotator				endRot;			// dest rotation
var float				endFOV;			// dest FOV
var trestkon 				Player;			// which player is being controlled
var bool				bTickReady;		// can we tick now?
var bool				bFirstRandom;		// are we the first random point in this sequence?
var int					randomRemain;		// how many random choices are left?
var tnmCameraPoint			continuePoint;		// where we continue after a random sequence
var bool				bShaking;		// shake the camera?
var int					ShakeMagnitude;		// angle to shake the camera at if bShaking

var Window letterbox_win;

var bool bFading; //added

var() bool bmovefade;
var() float fadetime1;
var() float fadetime2;
var bool fade1;
var bool fade2;

var trestkonCam TCam;
var() name InteruptCam;

function InitAllPoints()
{
	local tnmCameraPoint cur, next;
	local int num;
	local rotator rot;

	cur = Self;
	num = 0;
	while (num != 999999)
	{
		num = 999999;
		foreach AllActors(class'tnmCameraPoint', next, Tag)
		{
			// clamp the rotation
			rot.Pitch = Rotation.Pitch % 65536;
			rot.Yaw = Rotation.Yaw % 65536;
			rot.Roll = Rotation.Roll % 65536;
			SetRotation(rot);

			// find the next highest number in the sequence
			if ((next.sequenceNum < num) && (next.sequenceNum > cur.sequenceNum))
			{
				num = next.sequenceNum;
				cur.nextPoint = next;
			}
		}

		if (num != 999999)
		{
			cur = cur.nextPoint;
		}
	}
}

function StartCinematic()
{
	player = trestkon(getplayerpawn()); //something dodgy here. player somehow gets set to none. will proably have to fix that.
	player.startcinematic(true, bPlayerVisible, bChangeState);
	if(bLetterBox)
	{
		letterbox_win=DeusExRootWindow(player.rootWindow).NewChild(class'CinematicWindow');
		player.bLetterBox=true;
	}
	TCam = Player.TCam;
	GotoState('Running');
}

function Prep()
{
	player = trestkon(getplayerpawn()); //something dodgy here. player somehow gets set to none. will proably have to fix that.
	TCam = Player.TCam;
	player.CurrentCam = self;
	GotoState('Running');
}

function Interupt()
{
	local tnmcamerapoint tcp;

	if ( InteruptCam != '')
	{
		Foreach allactors( class'tnmcamerapoint', tcp, InteruptCam)
		{
			tcp.trigger(none, none);
		}

		if ( tcp != none )
		{
			if(letterbox_win!=None)
				letterbox_win.hide();
			//GoToSleep(); - done in the player class when a new cinematic is started
		}
	}
}


function EndCinematic()
{
	player.startcinematic(false, true, bChangeState);
	if(letterbox_win!=None)
		letterbox_win.hide();
	GotoState('Idle');
}

//
// state control code
//
auto state Idle
{
	// wait to be triggered
	function Trigger(Actor Other, Pawn Instigator)
	{
		Super.Trigger(Other, Instigator);
		if (SequenceNum == 0)
		{
			StartCinematic();
		}
	}

Begin:
	// find the player in this level
	// if there's not a player, destroy ourself
	Player = trestkon(GetPlayerPawn());
	if (player == none)
	{
		log("** WARNING - tnmCameraPoint.Idle.Begin() - "$sequenceNum$" - can't find the player!");
		Destroy();
		Stop;
	}

	// if we are the first one, link up the points and begin execution
	if (sequenceNum == 0)
		InitAllPoints();
Wait:
	// do nothing until somebody wakes us up
	Stop;
}

state Running
{
	function Fade()
	{
		if (cmd==CAMCMD_FADEIN)
			player.FadeFromBlack(timeSmooth,bFadeWhite);
		else if (cmd==CAMCMD_FADEOUT)
			player.FadeToBlack(timeSmooth,bFadeWhite);
		
		bFading = false;
	}

	// used for smooth moves/rotations
	function Tick(float deltaTime)
	{
		local float alpha, beta;
		local vector loc;
		local rotator rot, diffrot;
		local float fov;

		if (TCAM == none)
		{
			Log("Warning: TCAM not found");
			return;
		}

		if (!bTickReady)
			return;

		Super.Tick(deltaTime);

		// update the timer and see if we're done
		curTime += deltaTime;

		if (curTime >= timeSmooth)
		{
			if (cmd != CAMCMD_INTERPOLATE)
			{
				TCam.ViewRotation = endRot;
				TCam.SetLocation(endLoc);
				TCam.SetFOVAngle(endFOV);
				TCam.DesiredFOV = endFOV;
			}
			//fix fade?
			Next();
		}
		else
		{
			if (bFading)
				Fade();
			else
			{
				if ( bmovefade )
				{
					if ( fade1 && curTime >= fadetime1)
					{
						fade1 = false;
						player.FadeFromBlack(fadetime2 - fadetime1,bFadeWhite);
					}
					if ( fade2 && curTime >= fadetime2)
					{
						fade2 = false;
						player.FadeToBlack(timesmooth - fadetime2,bFadeWhite);
					}
				}
				
				if (cmd != CAMCMD_INTERPOLATE)
				{
					if (!bFollowPlayer)
					{
						alpha = curTime / timeSmooth;
	
						// make sure we rotate the shortest direction
						diffrot = endRot - startRot;
		
						if (diffrot.Pitch >= 32768)
							diffrot.Pitch = diffrot.Pitch - 65536;
						else if (diffrot.Pitch <= -32768)
							diffrot.Pitch = diffrot.Pitch + 65536;
	
						if (diffrot.Yaw >= 32768)
							diffrot.Yaw = diffrot.Yaw - 65536;
						else if (diffrot.Yaw <= -32768)
							diffrot.Yaw = diffrot.Yaw + 65536;

						if (diffrot.Roll >= 32768)
							diffrot.Roll = diffrot.Roll - 65536;
						else if (diffrot.Roll <= -32768)
							diffrot.Roll = diffrot.Roll + 65536;

						// calculate our smoothing coefficient
							beta = 3.0*alpha*alpha - 2.0*alpha*alpha*alpha;
	
						// smooth the camera rotation, movement, and FOV
						rot = startRot + beta * diffrot;
						loc = startLoc + beta * (endLoc - startLoc);
						fov = startFOV + beta * (endFOV - startFOV);
	
					}
					else
					{
						rot = player.ViewRotation;
						Loc = Player.Location + player.baseEyeHeight * vect(0,0,1);
						fov = TCam.FOVAngle;
					}

					TCam.SetLocation(loc);
					TCam.ViewRotation = rot;
					if(bShaking)
					{
						TCam.ViewRotation.Pitch+=rand(ShakeMagnitude)-ShakeMagnitude/2;
						TCam.ViewRotation.Yaw+=rand(ShakeMagnitude)-ShakeMagnitude/2;
					}
					TCam.SetFOVAngle(fov);
					TCam.DesiredFOV = fov;
				}
			}
		}
	}

Begin:
//	log("** starting "$sequenceNum);
	// save the starting location/rotation
	startLoc = TCam.Location;
	startRot = TCam.ViewRotation;
	startFOV = TCam.FOVAngle;

	//tell the TCAM if we can be interupted
	TCam.Interuptable = InteruptCam != '';

        TCam.ConversationAllowed = bConversationAllowed;
	TCam.LetterBox = bLetterBox;

	//Find the viewtarget if there is one
	TCam.viewtarget = none;
	if ( TargetName != '')
	{
		TCAM.viewtarget = none;
		foreach Allactors(class'actor', TCam.viewtarget, TargetName)
		{
			break;
		}
		if ( TCAM.viewtarget == none)
			Log("Failed to locate camerapoint view target for camera " $ name);
	}

	// init the destination
	endLoc = startLoc;
	endRot = startRot;
	endFOV = startFOV;
	bFading = false;

	// evaluate the command
	EvaluateCommand();
	bTickReady = True;
	tick(0);

	// should we execute the next command in parallel?
/*	if (bParallel)
	{
		nextPoint.prevPoint = Self;
		Next();
	}*/

	Stop;

Next:
//	if (!bParallel)
		bTickReady = False;

	// if there's a postdelay, wait for it
	if (timeWaitPost > 0.0)
		Sleep(timeWaitPost);

	if (bRandom /*&& !bParallel*/)
	{
		bTickReady = False;

		// if this is the first random encounter, set some values
		if (randomRemain == -1)
		{
			bFirstRandom = True;
			randomRemain = randomCount;
			SetContinuePoint();
		}

		// if we're done being random, continue where we left off
		if (randomRemain == 0)
			continuePoint.WakeUp();
		else
			WakeUpRandomPoint();
	}
	else if (nextPoint != None)
		nextPoint.WakeUp();

Wait:
	GoToSleep();
}



//
// state control functions
//

// called to find another random camerapoint
function WakeUpRandomPoint()
{
	local tnmCameraPoint point;
	local int count, rnd;

	// count how many there are
	count = 0;
	foreach AllActors(class'tnmCameraPoint', point)
		if (point.bRandom)
			count++;

	// pick one at random
	rnd = Rand(count);
	count = 0;
	foreach AllActors(class'tnmCameraPoint', point)
		if (point.bRandom && (count++ == rnd))
		{
			point.randomRemain = randomRemain - 1;
			point.continuePoint = continuePoint;
			point.WakeUp();
			break;
		}
}

// called to set the point to continue at after the random sequence
function SetContinuePoint()
{
	local tnmCameraPoint point;
	
	foreach AllActors(class'tnmCameraPoint', point)
		if (point.sequenceNum == postRandomNum)
		{
			continuePoint = point;
			break;
		}
}

// called when command is complete to move on to next command
function Next()
{
	GotoState('Running', 'Next');
}

// called to wake this camerapoint up
function WakeUp()
{
	Prep();
	GotoState('Running', 'Begin');
}

// called to put this camerapoint into it's idle state
function GoToSleep()
{
	if (IsInState('Running'))
		GotoState('Idle', 'Wait');
	else
		log("** WARNING - tnmCameraPoint.GoToSleep() - "$sequenceNum$" - already sleeping!",tag);
}

// wait for the timer to expire
function Timer()
{
	Next();
}


// evaluate the current command
function bool EvaluateCommand()
{
	local vector loc;
	local Actor A;

	loc = vect(0,0,0);

	// init the movement timer
	curTime = 0.0;

	switch (cmd)
	{
		case CAMCMD_MOVE:		InterpolateCamera(false);
						endLoc = Location;
						endRot = Rotation;
						if ( bmovefade )
						{
							fade1=fadetime1>0;
							fade2=fadetime2>0;
						}
						break;

		case CAMCMD_PUSH:		InterpolateCamera(false);
						loc.X = value;
						endLoc += (loc >> TCam.ViewRotation);
								break;

		case CAMCMD_FOV:		InterpolateCamera(false);
						endFOV += value;
						break;

		case CAMCMD_TILT:		InterpolateCamera(false);
						endRot.Pitch += value;
						break;

		case CAMCMD_PAN:		InterpolateCamera(false);
						endRot.Yaw += value;
						break;

		case CAMCMD_ROLL:		InterpolateCamera(false);
						endRot.Roll += value;
						break;

/*		case CAMCMD_WAIT:		if (eventName != '')
						{
							Tag = eventName;
							GoToSleep();
						}
						else
							SetTimer(timeSmooth, False);
						break;*/

		case CAMCMD_TRIGGER:		if (eventName != '')
						{
							foreach AllActors(class'Actor', A, eventName)
							A.Trigger(None, player);
						}
						break;

		case CAMCMD_END:		EndCinematic(); 
						break;

		case CAMCMD_MOVETOPLAYER:	InterpolateCamera(false);
						endLoc = Player.Location + player.baseEyeHeight * vect(0,0,1);
						endRot = Player.ViewRotation;
						break;

		case CAMCMD_FADEIN:		bFading = true;
						break;

		case CAMCMD_FADEOUT:		bFading = true;
						break;

		case CAMCMD_INTERPOLATE:	InterpolateCamera(true);
						break;
	}

	// if we are running in parallel with the previous point,
	// add its parameters to ours
	if (prevPoint != None)
	{
		endLoc += prevPoint.endLoc - prevPoint.startLoc;
		endRot += prevPoint.endRot - prevPoint.startRot;
		endFOV += prevPoint.endFOV - prevPoint.startFOV;
	}
}

function InterpolateCamera(bool bDoIt)
{
	local InterpolationPoint I;

	if (bDoIt)
	{
		foreach AllActors (class'InterpolationPoint', I, InterpolationTarget)
		{
			if (I.Position == 1)		// start at 1 instead of 0 - put 0 at the object's initial position
			{
				TCAM.SetCollision(false, false, false);
				TCAM.bCollideWorld = False;
				TCAM.Target = I;
				TCAM.SetPhysics(PHYS_Interpolating);
				TCAM.PhysRate = 1.0;
				TCAM.PhysAlpha = 0.0;
				TCAM.bInterpolating = True;
				TCAM.bStasis = False;
				//TCAM.GotoState('Interpolating');
				break;
			}
		}
	}
	else
	{
		TCAM.GotoState('');
		TCAM.bInterpolating = False;
		TCAM.SetPhysics(PHYS_None);
	}
}

defaultproperties
{
    bPlayerVisible=True
    randomRemain=-1
    shakeMagnitude=512
    bStatic=False
    bDirectional=True
    Texture=Texture'Engine.S_Camera'
}
