//=============================================================================
// Crosshair.
//=============================================================================
class tnmCrosshair extends Crosshair;

var bool bScoping;
var bool benabled;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	local Color col;

	Super.InitWindow();

	SetBackgroundStyle(DSTY_Masked);
	SetBackground(Texture'CrossSquare');
	col.R = 255;
	col.G = 255;
	col.B = 255;
	SetCrosshairColor(col);
}

function UpdateCrosshair()
{
	Show(bEnabled && !bScoping);
}

function SetCrosshair( bool bShow )
{
	bEnabled = bShow;
	UpdateCrosshair();
}

function SetScoping(bool bScope)
{
	bScoping = bScope;
	UpdateCrosshair();	
}

// ----------------------------------------------------------------------
// SetCrosshairColor()
// ----------------------------------------------------------------------

function SetCrosshairColor(color newColor)
{
	local tnmscopeview scope;
	local DeusExrootwindow root;
	root = deusexrootwindow(winParent.winparent);
	if (root != none)
		scope = tnmScopeView( root.scopeView );	
	if (scope != none)
		scope.IFFColor = newColor;
	SetTileColor(newColor);
}

defaultproperties
{
}
