class tnmHUDCompassDisplay expands HUDCompassDisplay;

//North is now a function of location so we need to cache position as well.
var vector lastplayerpos;

event Tick(float deltaSeconds)
{
	// Only continue if we moved
	if (lastPlayerYaw != player.Rotation.Yaw || lastPlayerPos != player.Location)
	{
		lastPlayerYaw = player.Rotation.Yaw;
		lastPlayerPos = player.Location;

		// Based on the player's rotation and the map's True North, calculate
		// where to draw the tick marks and letters
		drawPos = clipWidthHalf - (((lastPlayerYaw - trestkon(player).MapTrueNorth()) & 65535) / UnitsPerPixel);

		// We have two tickmark windows to compensate what happens with
		// the wrap condition.

		if ((drawPos > 0) && (drawPos < clipWidth))
			wrapPos = drawPos - tickWidth;
		else if (drawPos - tickWidth < (clipWidthHalf))
			wrapPos = drawPos + tickWidth;
		else
			wrapPos = 100;

		winCompass1.SetPos(drawPos, 0);
		winCompass2.SetPos(wrapPos, 0);
	}
}

defaultproperties
{
}
