//=============================================================================
// InformationDevices.
//=============================================================================
class tnmInformationDevices extends DeusExDecoration
	abstract;

var() name			textTag[20];
var() string			TextPackage;
var() class<DataVaultImage>	imageClass;

var bool			bAltTags;

var transient HUDInformationDisplay infoWindow;		// Window to display the information in
var transient TextWindow winText;				// Last text window we added
var Bool bSetText;
var() Bool bAddToVault;					// True if we need to add this text to the DataVault
var() name notetag;
var String vaultString;
var deusexplayer aReader;				// who is reading this?
var localized String msgNoText;
var Bool bFirstParagraph;
var localized String ImageLabel;
var localized String AddedToDatavaultLabel;

//added for bolding
var bool bbold;
var font boldfont;

var() int numberofpages;
var int currentpage;
var TextWindow nextpage;
var TextWindow prevpage;
var localized string nextpagetext;
var localized string prevpagetext;

var() bool binworld;
var vector worldposition;
var bool bWorldCollideActors;
var bool bWorldBlockActors;
var bool bWorldBlockPlayers;

function postbeginplay()
{
super.postbeginplay();
if (!binworld)
	putinworld(false);
}

function EnterWorld()
{
	PutInWorld(true);
}

function LeaveWorld()
{
	PutInWorld(false);
}

function PutInWorld(bool bEnter)
{
	if (!bEnter)
	{
		bHidden             = true;
		bDetectable         = false;
		WorldPosition       = Location;
		bWorldCollideActors = bCollideActors;
		bWorldBlockActors   = bBlockActors;
		bWorldBlockPlayers  = bBlockPlayers;
		SetCollision(false, false, false);
		bCollideWorld       = false;
		SetPhysics(PHYS_None);
		SetLocation(Location+vect(0,0,20000));  // move it out of the way
	}
	else
	{
		bHidden     = Default.bHidden;
		bDetectable = Default.bDetectable;
		SetLocation(WorldPosition);
		SetCollision(bWorldCollideActors, bWorldBlockActors, bWorldBlockPlayers);
		bCollideWorld = Default.bCollideWorld;
		SetPhysics(PHYS_Falling);
	}
}


function gotonextpage(Actor Frobber, Inventory frobWith)
{
destroywindow(true);
frob(Frobber, frobWith);
}

function gotoprevpage(Actor Frobber, Inventory frobWith)
{
if (currentpage > 0)
{
destroywindow(true);
currentpage --;
currentpage --;
frob(Frobber, frobWith);
}
}

// ----------------------------------------------------------------------
// Destroyed()
//
// If the item is destroyed, make sure we also destroy the window
// if it happens to be visible!
// ----------------------------------------------------------------------

function Destroyed()
{	DestroyWindow(false);

	Super.Destroyed();
}

// ----------------------------------------------------------------------
// DestroyWindow()
// ----------------------------------------------------------------------

function DestroyWindow(bool bkeepsource)
{
	local tnmhudinformationdisplay tnmhid;

	// restore the crosshairs and the other hud elements
	if (nextpage != none)
	{
		nextpage.destroy();
		nextpage = none;
	}

	if (prevpage != none)
	{
		prevpage.destroy();
		prevpage = none;
	}

	if (aReader != None)
	{
		DeusExRootWindow(aReader.rootWindow).hud.cross.SetCrosshair(aReader.bCrosshairVisible);
		DeusExRootWindow(aReader.rootWindow).hud.frobDisplay.Show();
		if (!bkeepSource)
		{
			tnmhid = tnmhudinformationdisplay(DeusExRootWindow(aReader.rootWindow).hud.info);
			if (tnmhid != none)
				tnmhid.source = none;
		}
	}

	if (infoWindow != None)
	{
		infoWindow.ClearTextWindows();
		infoWindow.Hide();
		tnmhudinformationdisplay(infowindow).pagenumber = 1;
	}

	infoWindow = None;
	winText = None;
	aReader = None;

}

// ----------------------------------------------------------------------
// Tick()
//
// Only display the window while the player is in front of the object
// ----------------------------------------------------------------------

function Tick(float deltaTime)
{
	// if the reader strays too far from the object, kill the text window
	if ((aReader != None) && (infoWindow != None))
		if (aReader.FrobTarget != Self)
			DestroyWindow(false);
}

// ----------------------------------------------------------------------
// Frob()
// ----------------------------------------------------------------------

function Frob(Actor Frobber, Inventory frobWith)
{
	local color c;
	local deusexplayer player;
	local tnmhudinformationdisplay tnmhid;

	Super.Frob(Frobber, frobWith);

	player = deusexplayer(Frobber);

	if (player != None)
	{
		if (infoWindow == None)
		{
			aReader = player;
			currentpage ++;

			if (currentpage == numberofpages)
				currentpage = 0;


			if (trestkon(player) != none)
			{
				tnmhudinformationdisplay(DeusExRootWindow(player.rootWindow).hud.info).source = self;
			}
			CreateInfoWindow();

			// hide the crosshairs if there's text to read, otherwise display a message
			if (infoWindow != None)
			{
				DeusExRootWindow(player.rootWindow).hud.cross.SetCrosshair(False);
				DeusExRootWindow(player.rootWindow).hud.frobDisplay.Hide();

				c.r =255;
				c.g =255;
				c.b =255;
				tnmhid = tnmhudinformationdisplay(DeusExRootWindow(player.rootWindow).hud.info);

				if (currentpage < numberofpages-1)
				{
					if (nextpage != none)
						nextpage.destroy();
					nextpage = TextWindow(deusexrootwindow(player.rootwindow).hud.NewChild(Class'TextWindow'));
					nextpage.SetText(NextPagetext);
					nextpage.SetPos(tnmhid.x + tnmhid.width - 50,tnmhid.y + tnmhid.height +10);
					nextpage.SetTextColor(c);
				}

				if (currentpage > 0)
				{
					if (prevpage != none)
						prevpage.destroy();
					prevpage = TextWindow(deusexrootwindow(player.rootwindow).hud.NewChild(Class'TextWindow'));
					prevpage.SetText(prevPagetext);
					prevpage.SetPos(tnmhid.x,tnmhid.y + tnmhid.height +10);
					prevpage.SetTextColor(c);
				}
			}
			else
				player.ClientMessage(msgNoText);
		}
		else
		{

			DestroyWindow(false);
		}


	}
}

// ----------------------------------------------------------------------
// CreateInfoWindow()
// ----------------------------------------------------------------------

function name GetAltTag(int index);

function CreateInfoWindow()
{
	local DeusExTextParser parser;
	local DeusExRootWindow rootWindow;
	local DeusExNote note;
	local DataVaultImage image;
	local bool bImageAdded;
	local name tag;

	rootWindow = DeusExRootWindow(aReader.rootWindow);

	if(bAltTags)
		tag=GetAltTag(currentpage);
	else
		tag=textTag[currentpage];

	// First check to see if we have a name
	if ( tag != '')
	{
		// Create the text parser
		parser = new(None) Class'DeusExTextParser';
								    
		// Attempt to find the text object
		if ((aReader != None) && (parser.OpenText(tag,TextPackage)))
		{
			parser.SetPlayerName(aReader.TruePlayerName);

			infoWindow = rootWindow.hud.ShowInfoWindow();
			infoWindow.ClearTextWindows();

			vaultString = "";
			bFirstParagraph = True;
	
			while(parser.ProcessText())
				{
					ProcessTag(parser);
				}
			parser.CloseText();

			// Check to see if we need to save this string in the 
			// DataVault
			if (bAddToVault)
			{
				note = aReader.GetNote(noteTag);

				if (note == None)
				{
					parser.OpenText(notetag,TextPackage);
					while(parser.ProcessText())
					{
					ProcessnoteTag(parser);
					}
					note = aReader.AddNote(vaultString,, True);
					note.SetTextTag(notetag);
				}

				vaultString = "";
			}
		}
		CriticalDelete(parser);
	}

	// do we have any image data to give the player?
	if ((imageClass != None) && (aReader != None))
	{
		image = Spawn(imageClass, aReader);
		if (image != None)  
		{
			image.GiveTo(aReader);
			image.SetBase(aReader);
			bImageAdded = aReader.AddImage(image);

			// Display a note to the effect that there's an image here, 
			// but only if nothing else was displayed
			if (infoWindow == None)
			{
				infoWindow = rootWindow.hud.ShowInfoWindow();
				winText = infoWindow.AddTextWindow();
				winText.SetText(Sprintf(ImageLabel, image.imageDescription));
			}

			// Log the fact that the user just got an image.
			if (bImageAdded)
			{
				aReader.ClientMessage(Sprintf(AddedToDatavaultLabel, image.imageDescription));
			}
		}
	}
}

function string replace(string str, string bef, string aft)
{
	local int i;
	i=InStr(str,bef);
	while(i!=-1)
	{
		str=left(str,i)$aft$right(str,len(str)-i-len(bef));
		i=InStr(str,bef);
	}
	return str;
}

// ----------------------------------------------------------------------
// ProcessnoteTag()
// ----------------------------------------------------------------------

function ProcessnoteTag(DeusExTextParser parser)
{
	local String text;
	local byte tag;
	local Name fontName;
	local String textPart;

	tag  = parser.GetTag();

	bsettext=false;

	switch(tag)
	{
		case 0:				// TT_Text:
		case 9:				// TT_PlayerName:
		case 10:			// TT_PlayerFirstName:
			text = parser.GetText();
			text = replace(replace(text,"%LT%","<"),"%GT%",">");
			bSetText = False;
			vaultString = vaultString $ text;
			break;
		case 18:			// TT_NewParagraph:
			if (!bFirstParagraph)
				vaultString = vaultString $ infowindow.CR();
			bFirstParagraph = False;
			bSetText = True;
			break;

	}
}

// ----------------------------------------------------------------------
// ProcessTag()
// ----------------------------------------------------------------------

function ProcessTag(DeusExTextParser parser)
{
	local String text;
	local byte tag;
	local Name fontName;
	local String textPart;

	tag  = parser.GetTag();

	// Make sure we have a text window to operate on.
	if (winText == None)
				
	{
		winText = infoWindow.AddTextWindow();
		bSetText = True;
	}

	switch(tag)
	{
		// If a winText window doesn't yet exist, create one.
		// Then add the text
		case 0:				// TT_Text:
		case 9:				// TT_PlayerName:
		case 10:			// TT_PlayerFirstName:
			text = parser.GetText();
			text = replace(replace(text,"%LT%","<"),"%GT%",">");

			// Add the text
			if (bSetText)
				winText.SetText(text);
			else
				winText.AppendText(text);

			if (bbold)
				wintext.setfont(boldfont);
			bbold=false;

			bSetText = False;

	
			break;

		// Create a new text window
		case 18:			// TT_NewParagraph:

			// Create a new text window
			winText = infoWindow.AddTextWindow();

			bFirstParagraph = False;

			bSetText = True;
			break;

		case 13:				// TT_LeftJustify:
			winText.SetTextAlignments(HALIGN_Left, VALIGN_Center);
			break;

		case 14:			// TT_RightJustify:
			winText.SetTextAlignments(HALIGN_Right, VALIGN_Center);
			break;

		case 12:				// TT_CenterText:
			winText.SetTextAlignments(HALIGN_Center, VALIGN_Center);
			break;

		case 26:			// TT_Font:
//			fontName = parser.GetName();
//			winText.SetFont(fontName);
			break;

		case 15:			// TT_DefaultColor:
		case 16:			// TT_TextColor:
		case 17:			// TT_RevertColor:
			winText.SetTextColor(parser.GetColor());
			break;
		case 19:	// bold
			bBold = True;
			break;
	}
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
    TextPackage="tnmText"
    msgNoText="There's nothing interesting to read"
    ImageLabel="[Image: %s]"
    AddedToDatavaultLabel="Image %s added to DataVault"
    boldFont=Font'DeusExUI.FontMenuHeaders'
    numberofpages=1
    currentpage=-1
    nextpagetext="more..."
    prevpagetext="...more"
    bInWorld=True
    FragType=Class'DeusEx.PaperFragment'
    bPushable=False
}
