class tnmMission22 expands tnmMission20and22;

function SlumHologramDisappear()
{
	local tnmpawn p;

	foreach allactors(class'tnmpawn',p,)
		if ((p.tag == 'KylieHolocom')||
		    (p.tag == 'ZeroHolocom')||
		    (p.tag == 'PhasmatisHolocom')||
		    (p.tag == 'SlicerHolocom'))
		{
			p.LeaveWorld();
		}
}

function TortureKnockConvo()
{
	local actor a;

	if (!flags.GetBool('AJ_ComeIn_Played') && flags.GetBool('QR_MAIN_KidnapKevo') && !flags.GetBool('Kevo_Dead'))
	{
		if ( player.inhand != none && player.inhand.isA( 'tnmpovcorpse' ) && tnmpovcorpse(player.inhand).givenbindname == "Kevo" )
		{
			foreach allactors(class'actor', a, 'TortureKnock_Body')
				a.trigger(none,player);
		}
		else
		{
			foreach allactors(class'actor', a, 'TortureKnock_NoBody')
				a.trigger(none,player);
		}
	}	
}

function AJChangeClothes()
{
	local tnmpawn p;
	local tnmpovcorpse povc;
	local tnmcarcass carc;
	local actor a;

	foreach allactors(class'tnmpawn',p,'AJ')
	{
		p.Multiskins[0] = Texture(DynamicLoadObject("TNMCharacters.Skins.AJTex0_2", class'Texture'));
		p.Multiskins[2] = Texture(DynamicLoadObject("TNMCharacters.Skins.AJTex1", class'Texture'));
		p.Multiskins[3] = Texture(DynamicLoadObject("TNMCharacters.Skins.AJTex0_2", class'Texture'));
		p.Multiskins[4] = Texture(DynamicLoadObject("TNMCharacters.Skins.AJTex0_2", class'Texture'));
	}

	povc = tnmpovcorpse(player.inHand);
	if ( povc != none )
	{
		player.PutInHand(none);
		povc.Destroy();
	}

	foreach allactors(class'tnmcarcass', carc, 'KevoCarcass')
	{
		carc.EnterWorld();
		carc.ItemName = "Dead Body (Kevo)";
	}
}

function OpenTortureRoom()
{
	local KnockableMover K;
	foreach AllActors(class'KnockableMover', K, 'TortureRoomDoors')
		OpenDoor(K);
}

function EvacuateTemplae()
{
	local tnmpawn p;

	if (flags.GetBool('QR_SUB_LureThePriest'))
	{
		foreach allactors(class'tnmpawn',p,)
		{
			if (p.Tag == 'OiNutter' || p.Tag == 'FleeingGoatFemale' || p.Tag == 'OiBodyguard1' || p.Tag == 'OiBodyguard2')
				p.EnterWorld();
		}
	}
}

function ShootOiNutter()
{
	local tnmpawn p;

	if (!flags.GetBool('Zero_Dead') && !flags.GetBool('Zero_Unconscious'))
	{
		foreach allactors(class'tnmpawn',p,'OiNutter')
		{
			p.HealthHead = 0;
			p.Health = 0;
			p.bStunned = false;
			p.TakeDamage(1, p, p.Location, vect(-10,0,25), 'shot'); // Headshot = collision height(35.625000) * 0,7
		}

		// Give the player some skillpoints
		SkillAward(200, "Accomplice Award");

		// Send a PM from ZeroPresence when it's done
		SendPM("PM_Zero_ShotOi");
	}
}

function LandedChopperAppear()
{
	local BlackHelicopter B;
	foreach allactors(class'BlackHelicopter',B,'BlackChopper02')
		B.EnterWorld();
}

function CarCrash()
{
	// The pox upon the fact that both HovercarCrash.uc and TNMVehicles.uc are in TNMDeco!!
	local Vehicles V;
	local tnmpawn p;
	local tnmrobot r;
	local CaroneElevator CE;
	local TNMDecoration D;
	local securitycamera cam;

	// Make the wreck appear
	foreach allactors(class'Vehicles',V,'HovercarCrash')
		V.EnterWorld();

	flags.SetBool('MS_MoveLobbyGuards', true, , 23);

	// If the player has picked up an ID card, void the sucker
	if (flags.GetBool('HAS_ATCIDCard') && !flags.GetBool('MS_ATCVoidID'))
	{
		// Make all the guards hostile again if the player fucks up
		foreach AllActors(class'tnmpawn',p,)
			if (p.Tag == 'ATCGuard' || p.Tag == 'ATCGuardAlert1' || p.Tag == 'ATCGuardAlert2' || p.Tag == 'ATCGuardAlert3' || p.Tag == 'ATCGuardAlert4' || p.Tag == 'ShackGuard')
				p.ChangeAlly('Player',-1.000000,true);
		foreach allactors(class'tnmrobot',r,'ATCBot')
			r.ChangeAlly('Player',-1.000000,true);
		foreach allactors(class'securitycamera', cam, )
			cam.memoryTime=cam.default.memoryTime;

		flags.SetBool('MS_ATCVoidID',true,,23);
	}
}

function DTDropItems()
{
	local navigationpoint n;
	local actor a;
	foreach allactors(class'navigationpoint',n,'DTDropItemPoint')
		break;
	a=spawn(class'WeaponModAccuracy',,,n.location);
	if(!flags.GetBool('DT_NoRoom_Accuracy'))
		spawn(class'WeaponModSilencer',,,a.location+vect(2.0,0,0)*a.collisionradius);
	if(!flags.GetBool('DT_NoRoom_Silencer') && !flags.GetBool('DT_NoRoom_Accuracy'))
		spawn(class'AugmentationUpgradeCannister',,,a.location+vect(-2.0,0,0)*a.collisionradius);
}

function DTHologramAppear()
{
	local tnmpawn p;
	foreach allactors(class'tnmpawn', p, 'DTHologram')
		p.EnterWorld();		
}

function DTHologramDisappear()
{
	local tnmpawn p;
	foreach allactors(class'tnmpawn', p, 'DTHologram')
		p.LeaveWorld();		
}

function MelkShutOff()
{
	local particlegenerator melksource;
	//shut off the flow
	foreach AllActors(class'particlegenerator',melksource,'MelkSource')
		melksource.Destroy();

	//Possible bark from athena

	flags.SetBool('MS_MelkShutOff',true,,23);
}

function RespawnAthena(class<tnmpawn> athenaclass, vector deathlocation)
{
	local tnmcarcass c;
	local FleshFragment f;
	local NavigationPoint n;
	local vector spawnlocation;
	local rotator spawnrotation;
	local particlegenerator melksource;
	local int i;
	local rotator rot;
	local athenarespawninfo spawner;

	if (!flags.GetBool('MS_MelkShutOff'))
	{
		spawner=Spawn(Class'AthenaRespawnInfo'); //handle her respawning
		spawner.athena_spawn_class=athenaclass;

		foreach allactors(class'NavigationPoint', n, 'MelkPool')
		{
			spawnlocation = n.location;
			spawnrotation = n.rotation;
			break;
		}

		foreach AllActors(class'particlegenerator',melksource,'MelkSource')
			melksource.Destroy();

		rot.pitch = 1000;
		for (i = 0; i < 10; i++)
		{
			rot.yaw = 65535 * i / 10;
			melksource = spawn(class'particlegenerator', ,'MelkSource', spawnlocation + vect(1,0,0) >> rot, rot);
			melksource.particleTexture = texture'snowflaketex';
			melksource.particleLifeSpan = 10;
			melksource.bGravity = true;
			melksource.LifeSpan=4.5;
		}
	}
}

function SetEnvironment()
{
	local tnminformationdevices inf;
	local tnmpawn p;
	// Determine which bulletins to spawn
	if (flags.GetBool('Killer_PDX') || flags.GetBool('Killer_FC'))
	{
		foreach allactors(class'tnminformationdevices',inf,'KillerBulletin')
			inf.EnterWorld();
		// Remove some of the random citizens if the player is a killer
		foreach allactors(class'tnmpawn',p,'GenericPawn')
			p.LeaveWorld(); //todo: use correct tag
	}
	else if (flags.GetBool('ALLIED_WC'))
	{
		foreach allactors (class'tnminformationdevices',inf, 'WCBulletin')
			inf.EnterWorld();
	}
	else
	{
		foreach allactors (class'tnminformationdevices',inf, 'PDXBulletin')
			inf.EnterWorld();
	}
}

// ----------------------------------------------------------------------
// FirstFrame()
// 
// Stuff to check at first frame
// ----------------------------------------------------------------------

function FirstFrame()
{
	local inventory inv;
	local tnmpawn p;
	local tnmrobot r;
	local tnmcarcass c;
	local Containers cont;
	local tnminformationdevices inf;
	local int kills;
	local deusexmover M;
	local triggerlight l;
	local ParticleGenerator S; // S for Smoke because p is already taken >_<
	local WarpZoneInfo W;
	local AmbientSoundTriggered A;
	local securitycamera cam;
	local int i,check;
	local Actor tmp;
	local CouchLeather CL;
	local BlackHelicopter H;
	local keypad kp;
	local TNMDecoration deco;

	Super.FirstFrame();

	if (localURL == "22_FCDOWNTOWN")
	{
		SetEnvironment();
		SetupPortal('FC_Current_Booth','FC_Current_Booth_Sound');

		if (flags.GetBool('ALLIED_WC'))
		{
			// Remove the whole Sol's Bar thing
			foreach AllActors(Class'Actor',tmp,'SolsWitness')
				tmp.Destroy();
			foreach AllActors(Class'Actor',tmp,'SolsFireWall')
				tmp.Destroy();
			foreach AllActors(Class'Actor',tmp,'AlphaOperator')
				tmp.Destroy();
			foreach AllActors(Class'Actor',tmp,'SolsPlot')
				tmp.Destroy();
			foreach AllActors(Class'Actor',tmp,'SolBomber')
				tmp.Destroy();
			foreach AllActors(Class'Actor',tmp,'BomberVan')
				tmp.Destroy();

			SealDoor('SolsDoor');
			SealDoor('SolsBackDoor');

			// And make all the firewalls hostile
			foreach AllActors(class'TNMPawn',p,'Firewall')
				p.ChangeAlly('Player', -1.000000, true);

			// ...and the PDX bots
			foreach AllActors(class'TNMRobot',r,'MilitaryBotPDX')
				r.ChangeAlly('Player', -1.000000, true);
		}

		// Spawn Pimp-Jojo if the player did the DXO side-mission (unless PJ is knocked out or dead)
		if (flags.GetBool('QC_SUB_Bugging') && !flags.GetBool('PJ_Dead') && !flags.GetBool('PJ_Unconscious'))
		{
			foreach allactors(class'tnmpawn', p, 'PimpJojo')
				p.EnterWorld();

			// Also send a PM with directions from PJ
			SendPM("PM_PJ_Directions");
		}

		// Award skillpoints for escaping the slums and complete the objective
		if (!flags.GetBool('MS_EscapeSlums_AwardGiven'))
		{
			AddGoal('EscapeSlums', "You have escaped the Slum district alive, now it's time to report back to base.", true, true);
			SkillAward(1000, "Surviving the Slums Award");
			flags.SetBool('MS_EscapeSlums_AwardGiven',true,,23);
		}

		// Handle the awards for the goat templae mission
		if ((LastMap() == "22_GoatCity") && flags.GetBool('QC_CULT_KillAthena') && !flags.GetBool('KillCount_GoatCityDone'))
		{
			kills = flags.GetInt('KillCount_GoatCity') + flags.GetInt('KillCount_GoatTemplae1') + flags.GetInt('KillCount_GoatTemplae2');
	
//			// Award Massacre Award 
//			//if (kills >= GoatCityLiving22 + GoatTemplae1Living22 + GoatTemplae2Living22)
//			//	SkillAward(200, "Massacre Award");

			// todo - readd me :(
			// Identify the player as a killer
			//if (kills >= (GoatCityLiving22 + GoatTemplae1Living22 + GoatTemplae2Living22) / 5) //5 is a placeholder
			//	flags.SetBool('Killer_Goats', TRUE, , 23);

//			// Award Pacifist Award
//			if (kills <= 1) //Athena
//				SkillAward(200, "Pacifist Award");

			flags.SetBool('KillCount_GoatCityDone' , TRUE, ,23);
		}

		// Handle the awards for the llama temple mission
		if ((LastMap() == "22_LlamaTemple") && flags.GetBool('QC_CULT_KillBeefman') && !flags.GetBool('KillCount_LlamaTempleDone'))
		{
			kills = flags.GetInt('KillCount_LlamaTemple');

//			// Award Massacre Award 
//			//if (kills >= LlamaTempleLiving22)
//			//	SkillAward(200, "Massacre Award");

			// todo - readd me :(
			// Identify the player as a killer
			//if (kills >= LlamaTempleLiving22 / 5) //5 is a placeholder
			//	flags.SetBool('Killer_Llamas', TRUE, , 23);

//			// Award Pacifist Award
//			if (kills <= 1) // Beefman
//				SkillAward(200, "Pacifist Award");

			flags.SetBool('KillCount_LlamaTempleDone' , TRUE, ,23);
		}

		if(flags.GetBool('NVShackerPet_Abom') && !flags.GetBool('MS_NVShackerPetEntered'))
		{
			foreach AllActors(class'tnmrobot',r,'NVShackerPet')
				r.EnterWorld();

			flags.SetBool('MS_NVShackerPetEntered',true,,23);
		}
	}
	else if (localURL == "22_FCCORPORATE")
	{
		SetEnvironment();
		SetupPortal('FC_Current_Booth','FC_Current_Booth_Sound');

		if (flags.GetBool('ALLIED_PDX'))
		{
			// Make all the WC people hostile
			foreach AllActors(class'TNMPawn',p,)
			{
				if ((p.Tag == 'WCSecurity')||
				    (p.Tag == 'WCCommando')||
				    (p.Tag == 'WCThug')||
				    (p.Tag == 'PDXHQAttackGroup')||
				    (p.Tag == 'OldHQAttackGroup')||
				    (p.Tag == 'Checkpoint1AttackGroup')||
				    (p.Tag == 'Checkpoint2AttackGroup'))
					p.ChangeAlly('Player', -1.000000, true);
			}

			// Make all the WC bots hostile
			foreach AllActors(class'tnmrobot',r,)
			{
				if ((r.Tag == 'SecurityBot2WC')||
				    (r.Tag == 'MilitaryBotWC')||
				    (r.Tag == 'PDXHQAttackGroup'))
					r.ChangeAlly('Player', -1.000000, true);
			}
		}
		else if (flags.GetBool('ALLIED_WC'))
		{
			// Make all the firewalls hostile
			foreach AllActors(class'TNMPawn',p,)
			{
				if ((p.Tag == 'Firewall')||
				    (p.Tag == 'FireWall2'))
					p.ChangeAlly('Player', -1.000000, true);
			}

			// Make all the PDX bots hostile
			foreach AllActors(class'tnmrobot',r,)
			{
				if ((r.Tag == 'SecurityBot2PDX')||
				    (r.Tag == 'MilitaryBotPDX'))
					r.ChangeAlly('Player', -1.000000, true);
			}

			// Lock the PDX HQ securely
			SealDoor('PDXHQDoors');
			SealDoor('PDXSideDoor1');
			SealDoor('PDXSideDoor2');
		}

		// Spawn Raving's thugs if the player has stolen from him (but only if either Raving or Andreus is still alive) 
		if (flags.GetBool('StoleFromWeaponShop') && (!flags.GetBool('Raving_Dead') || !flags.GetBool('Andreus_Dead')))
			foreach allactors(class'tnmpawn',p,'RavingThug')
				p.EnterWorld();

		// Award skillpoints for escaping the slums and complete the objective
		if (!flags.GetBool('MS_EscapeSlums_AwardGiven'))
		{
			AddGoal('EscapeSlums', "You have escaped the Slum district alive, now it's time to report back to base.", true, true);
			SkillAward(1000, "Surviving the Slums Award");
			flags.SetBool('MS_EscapeSlums_AwardGiven',true,,23);
		}

//		if (!flags.GetBool('MS_ZPGoatPortalZoneEntTriggered'));
//		foreach allactors( class'warpzoneinfo', w, 'ZPGoatPortalZoneEnt')
//		{
//			w.Trigger(none, none);
//			flags.SetBool('MS_ZPGoatPortalZoneEntTriggered', true, ,23);
//		}

		// Send an invite from Wolfy
		SendPM("PM_WolfySummons");

		// After you've received your first mission
		if (flags.GetBool('QR_MAIN_FreeKevo') || flags.GetBool('QR_MAIN_KidnapKevo'))
		{
			if (flags.GetBool('ALLIED_CULT_GOAT') && !flags.GetBool('QR_CULT_KillBeefman'))
				SendPM("PM_DT_QuestSummon");
			else if (flags.GetBool('ALLIED_CULT_LLAMA') && !flags.GetBool('QR_CULT_KillAthena'))
				SendPM("PM_Abom_QuestSummon");
		}
	}
	else if (localURL == "22_FCCORPSEWERS")
	{
		if (flags.GetBool('ALLIED_WC'))
		{
			// Lock the PDX HQ securely
			SealDoor('PDXDoor');
		}
	}
	else if (localURL == "22_FCSLUMS")
	{
		SetEnvironment();
		SetupPortal('FC_Current_Booth','FC_Current_Booth_Sound');

		/*
		   NB! These EnterWorld and LeaveWorld functions are set up so if you're WC-aligned, 
		   the firewalls and the milbot at the checkpoint will not be removed when you return 
		   to capture Kevo-Sama. This is on purpose!
		*/

		// Spawn WC Thugs or Firewalls and a holocom depending on player alliance
		if (!flags.GetBool('MS_SlumEnemiesSpawned'))
		{
			if (flags.GetBool('ALLIED_PDX'))
			{
				// Generic enemies
				foreach allactors(class'tnmcarcass',c,'WCCarcass')
					c.EnterWorld();

				foreach allactors(class'tnmpawn',p,)
					if ((p.tag == 'WCThug')||
					    (p.tag == 'WCCommando')||
					    (p.tag == 'WCKeyHolder'))
					{
						p.EnterWorld();
					}

				foreach allactors(class'tnmrobot',r,)
					if ((r.tag == 'SecurityBot2WC') || (r.tag == 'MilitaryBotWC'))
						r.EnterWorld();

				// Holocom: Spawn Kylie if ZP is dead except if he was killed before DXI or Kylie is also dead
				if (flags.GetBool('Zero_Dead') && !flags.GetBool('Zero_Dead_M20') && !flags.GetBool('Kylie_Dead'))
				{
					foreach allactors(class'tnmpawn',p,'KylieHolocom')
						p.EnterWorld();
				}
				else if (!flags.GetBool('Zero_Dead')) // otherwise, spawn ZP
				{
					foreach allactors(class'tnmpawn',p,'ZeroHolocom')
						p.EnterWorld();
				}

				// Make sure the game remembers if ZP was killed in DXI (for denouement)
				if (flags.GetBool('Zero_Dead') && !flags.GetBool('Zero_Dead_M20'))
					flags.SetBool('Zero_Dead_DXI',true,,0);
			}
			if (flags.GetBool('ALLIED_WC'))
			{
				// Generic enemies
				foreach allactors(class'tnmcarcass',c,'FireWallCarcass')
					c.EnterWorld();

				foreach allactors(class'tnmpawn',p,)
					if ((p.tag == 'Firewall')||
					    (p.tag == 'CheckpointFirewall')||
					    (p.tag == 'CSISniper')||
					    (p.tag == 'PDXKeyHolder'))
					{
						p.EnterWorld();
					}

				foreach allactors(class'tnmrobot',r,)
					if ((r.tag == 'SecurityBot2PDX') || (r.tag == 'MilitaryBotPDX'))
						r.EnterWorld();

				// Holocom: Spawn Phas if Slicer is dead except if he was killed before DXI
				if (flags.GetBool('Slicer_Dead') && !flags.GetBool('Slicer_Dead_M20'))
				{
					foreach allactors(class'tnmpawn',p,'PhasmatisHolocom')
						p.EnterWorld();
				}
				else if (!flags.GetBool('Slicer_Dead') && !flags.GetBool('Slicer_Dead_M20')) // otherwise, spawn 
				{
					foreach allactors(class'tnmpawn',p,'SlicerHolocom')
						p.EnterWorld();
				}
			}
			flags.SetBool('MS_SlumEnemiesSpawned', True,, 23);
		}

		// Re-add the Bugging quest (secondary goals are auto-deleted between missions)
		if (flags.GetBool('QC_SUB_Bugging') && !flags.GetBool('MS_BuggingUpdated'))
		{
			AddGoal('Bugging', "Having placed the spyware device on the old DXI servers, all you need to do now is return to Pimp Jojo to receive your reward.", FALSE, FALSE);
			SendPM("PM_PJ_Reward");
			flags.SetBool('MS_BuggingUpdated',true,,23);
		}

		// Remove the holocom and the WC Thugs or Firewalls when the player is back for Kevo or Vavrek
		if (!flags.GetBool('MS_SlumEnemiesRemoved') && (flags.GetBool('QR_MAIN_FreeKevo') || flags.GetBool('QR_MAIN_KidnapKevo')))
		{
			if (!flags.GetBool('Yardbomb_AdvisedToSell'))
			{
				foreach allactors(class'deusexmover',m, 'VoodooShopDoor')
					m.bLocked = false;
			}

			foreach allactors(class'tnmpawn',p,)
				if ((p.tag == 'KylieHolocom')||
				    (p.tag == 'ZeroHolocom')||
				    (p.tag == 'PhasmatisHolocom')||
				    (p.tag == 'SlicerHolocom'))
				{
					p.LeaveWorld();
				}

			foreach allactors(class'tnmpawn',p,'AlleyBums')
				p.EnterWorld();

			if (flags.GetBool('ALLIED_PDX'))
			{
				foreach allactors(class'tnmcarcass',c,'WCCarcass')
					c.LeaveWorld();

				foreach allactors(class'tnmpawn',p,)
					if ((p.tag == 'WCThug')||
					    (p.tag == 'WCCommando')||
					    (p.tag == 'WCKeyHolder'))
					{
						p.LeaveWorld();
					}

				foreach allactors(class'tnmrobot',r,)
					if ((r.tag == 'SecurityBot2WC') || (r.tag == 'MilitaryBotWC'))
						r.LeaveWorld();
			}
			if (flags.GetBool('ALLIED_WC'))
			{
				foreach allactors(class'tnmcarcass',c,'FireWallCarcass')
					c.LeaveWorld();

				foreach allactors(class'tnmpawn',p,)
					if ((p.tag == 'Firewall')||
					    (p.tag == 'CSISniper')||
					    (p.tag == 'PDXKeyHolder'))
					{
						p.LeaveWorld();
					}

				foreach allactors(class'tnmrobot',r,'SecurityBot2PDX')
					r.LeaveWorld();
			}

			foreach allactors(class'Containers',cont,)
			{
				if ((cont.tag == 'SubwayExplosives1')||(cont.tag == 'SubwayExplosives2'))
					cont.Destroy();
			}

			flags.SetBool('MS_SlumEnemiesRemoved', True,, 23);
		}

		// Put a big ol' WC logo over the Voodoo Shop sign if the player advised Yardie to sell 
		if (flags.GetBool('Yardbomb_AdvisedToSell'))
		{
			foreach AllActors(class'DeusExMover', M, 'VoodooShopDoor')
				M.bLocked = true;

			foreach AllActors(class'DeusExMover', M, 'VoodooShopWCSign')
				OpenDoor(M);

			foreach AllActors(class'TriggerLight', l, 'VoodooShopSignLight')
				l.Destroy();
		}

		// When it is time to kidnap Kevo...
		if (flags.GetBool('QR_MAIN_KidnapKevo'))
		{
			// ...unlock the garage doors to the torture chamber
			foreach AllActors(class'DeusExMover', M, 'TortureRoomDoors')
			{
				M.bFrobbable = true;
				M.bHighlight = true;
			}

			// ...and spawn Kevo himself
			foreach allactors(class'tnmpawn',p,'Kevo')
			{
				p.EnterWorld();
				p.bEmitCarcass=false;
			}
		}

		// Change the chopper bindname and disable the keypad when you return after freeing Kevo
		if (flags.GetBool('Kevo_Free') && !flags.GetBool('Kevo_Dead') && !flags.GetBool('Kevo_Unconscious'))
		{
			foreach allactors(Class'BlackHelicopter', H, 'ROFLCopter')
			{
				H.FamiliarName = "Kevo-sama";
				H.UnfamiliarName = "Kevo-sama";
				H.ConBindEvents();
			}

			foreach allactors(Class'Keypad', kp, 'HelipadKeypad')
				kp.hackStrength=0;
		}

		// If you return after killing Kevo
		if (flags.GetBool('ALLIED_PDX') && (flags.GetBool('Kevo_Dead') || flags.GetBool('Kevo_Unconscious')) && !flags.GetBool('MS_DoneKevoDeath'))
		{
			// Unlock the keypad
			foreach allactors(Class'Keypad', kp, 'HelipadKeypad')
				kp.hackStrength=0;

			// Make sure the player gets the right convo from the chopper
			foreach allactors(class'BlackHelicopter',H,'ROFLCopter')
			{
				H.Bindname = "ROFLCopter";
				H.FamiliarName = "ROFLCopter";
				H.ConBindEvents();
			}

			flags.SetBool('MS_DoneKevoDeath',true,,23);
		}

		// Spawn Vavrek when you need to rescue Kevo from DXO
		if (flags.GetBool('QR_MAIN_FreeKevo'))
		{
			foreach allactors(class'tnmpawn',p,'Vavrek')
				p.EnterWorld();
		}

		// If the player returns to the slums after completing all of the ATC, remove the chopper and Midashand
		if (flags.GetBool('MS_MidasIncoming') || flags.GetBool('MS_MidasTimerStarted'))
		{
			foreach allactors(Class'BlackHelicopter',H,'ROFLCopter')
				H.LeaveWorld();

			foreach allactors(class'tnmpawn', p)
			{
				if ((p.Tag == 'Midashand') || (p.Tag == 'Midashand_Subway'))
					p.LeaveWorld();
			}
		}
	}
	else if (localURL == "22_WCFLOOR1")
	{
		// Make Kylie appear when the player is looking for ZP
		if (flags.GetBool('QR_SUB_FindZP'))
			foreach allactors(Class'tnmpawn',p,'Kylie')
				p.EnterWorld();

		// If the player's PDX-aligned, make Scara's secret elevator door vanish
		if (flags.GetBool('ALLIED_PDX'))
		{
			foreach allactors(Class'deusexmover',M,'ScaraElevatorSecretDoor')
			{
				M.bFrobbable = false;
				M.bHighlight = false;
			}
		}
	}
	else if (localURL == "22_WCFLOOR4")
	{
		// If the player's PDX-aligned, make Scara's office unenterable
		if (flags.GetBool('ALLIED_PDX'))
		{
			foreach allactors(Class'deusexmover',M,'Scara_Office_Door')
				M.bLocked = true;

			foreach allactors(Class'keypad',kp,'Scara_Office_Keypad')
			{
				kp.hackstrength=1.0;
				kp.bHackable = false;
			}
		}
		else
		{
			if(!flags.GetBool('MS_ScaraSecretDoorOpened'))
			{
				foreach allactors(class'deusexmover',m,'ScaraSecretDoor')
					m.trigger(none,none);
				flags.setbool('MS_ScaraSecretDoorOpened',true,,23);
			}
		}
	}
	else if (localURL == "22_WCSUBLEVEL")
	{
		// Check if NVShacker should be there
		if (flags.GetBool('NVShacker_WC') && !flags.GetBool('MS_NVS_Placed'))
		{
			foreach AllActors(class'tnmcarcass',c,'NVShackerCarcass')
				c.EnterWorld();

			foreach AllActors(class'tnminformationdevices',inf)
			{
				if(inf.tag=='PrisonRegistry01')
					inf.LeaveWorld();
				else if(inf.tag=='PrisonRegistry02')
					inf.EnterWorld();
			}

			foreach AllActors(class'inventory',inv,'NVSGun')
				inv.bHidden=false;

			foreach AllActors(class'DeusExMover',m,'SublevelPrisonCellDoor02')
				OpenDoor(m);

			if(flags.GetBool('NVShackerPet_NVS'))
			{
				foreach AllActors(class'tnmcarcass',c,'NVShackerPetVictim')
					c.EnterWorld();

				foreach AllActors(class'tnmrobot',r,'NVShackerPet')
					r.EnterWorld();
			}

			flags.SetBool('MS_NVS_Placed',true,,23);
		}

		// Check if the player made it past the exploding wall in M20
		if (flags.GetBool('MS_SublevelDestroyedWall'))
		{
			// Remove the dead scientist...
			foreach AllActors(class'tnmcarcass', c, 'WallExplosionCarcass')
				c.LeaveWorld();

			// ...and his notepad
			foreach allactors(class'tnmInformationDevices',inf,'WallExplosionNoteBook')
				inf.LeaveWorld();

			// Re-destroy the wall
			foreach AllActors(class'deusexmover', M)
			{
				if (M.Tag == 'BreakableWall')
					M.BlowItUp(none);
			}

			// Remove the explosives
			foreach AllActors(class'Containers', cont)
			{
				if (cont.Tag == 'CrateExplosiveMed')
					cont.Destroy();
			}

			foreach AllActors(class'tnmcarcass', c)
			{
				if (c.Tag == 'ThomasBarnes')
					c.LeaveWorld();

				else if (c.Tag == 'ThomasBarnes_Lab')
					c.EnterWorld();
			}

			// Replace the previous datacube at Thomas' cell with his file
			foreach allactors(class'tnmInformationDevices',inf,)
			{
				if (inf.Tag == 'Datacube12')
					inf.LeaveWorld();
				else if (inf.Tag == 'Datacube03')
					inf.EnterWorld();
			}
		}

		// If the player is PDX-aligned, remove ZP's datacube
		if (flags.GetBool('ALLIED_PDX'))
		{
			foreach allactors(class'tnmInformationDevices',inf,'ZPDataCube')
				inf.LeaveWorld();
		}

		// Enable the Black ICE virus upload button if the mission wasn't handled in M20
		if (flags.GetBool('QR_SUB_BlackICE') && !flags.GetBool('QC_SUB_BlackICE'))
			flags.SetBool('BlackICEVirusUploadable',true,,23);
	}
	else if (localURL == "22_GOATCITY")
	{
		// Spawn ZeroPresence when the player has received the mission to find him 
		if (flags.GetBool('QR_SUB_FindZP') && !flags.GetBool('QC_SUB_FindZP'))
			foreach allactors(class'tnmpawn',p,'ZeroPresence')
				p.EnterWorld();

		// Disable the melk fountains if the player sabotaged them in M20
		if (flags.GetBool('QC_CULT_DrainTheMelk') && !flags.GetBool('MS_GoatFountainsOff'))
		{
			foreach allactors(class'tnmdecoration', deco, )
			{
				// Destroy the valves
				if ( deco.Tag == 'MelkValve1' || deco.Tag == 'MelkValve2' )
				{
					deco.Destroy();
				}
				// Turn off the fountains
				if ( deco.Tag == 'MelkFountain1' || deco.Tag == 'MelkFountain2' )
				{
					deco.Trigger(none, none);
				}
			}

			foreach allactors(class'AmbientSoundTriggered', A, )
			{
				// Replace the rushing water sound with a water pool sound
				if ( A.Tag == 'MelkFountain1' || A.Tag == 'MelkFountain2' )
				{
					A.Trigger(none, none);
				}
			}

			flags.SetBool('MS_GoatFountainsOff',true,,23);
		}

		// If the player killed Athena in the fight room, set her normal death flag too
		if (flags.GetBool('Athena_Fight_Dead'))
			flags.SetBool('Athena_Dead',true,,0);
	}
	else if (localURL == "22_GOATTEMPLAE")
	{
		// If the player did the last quest...
		if (flags.GetBool('QC_CULT_DestroyTheTablets'))
		{
			foreach allactors(class'tnmpawn',p,)
			{
				// Spawn DT and friendly Athena in the templae
				if ((p.Tag == 'DarkTemplar') || (p.Tag == 'Athena'))
					p.EnterWorld();

				// Remove hostile Athena
				if (p.Tag == 'Athena_Fight')
					p.LeaveWorld();

				// Make the guards friendly
				if (p.Tag == 'InnerTemplaeGuards')
					p.ChangeAlly('Player', 1.0, true);

				if (p.Tag == 'TemplaeSecurityRoomGuard')
					p.ChangeAlly('Player', 1.0, true);
			}

			// Deactivate the security cameras in the inner Templae
			foreach allactors(class'securitycamera', cam, )
			{
				if ((cam.tag == 'TemplaeSecRoomCam') ||
				    (cam.tag == 'TemplaeStairsCam2') ||
				    (cam.tag == 'TemplaeStairsCam1'))
				cam.bNoAlarm = true;
			}
		}

		// If the player didn't do the last quest, spawn DT in the courtyard
		if (!flags.GetBool('QC_CULT_DestroyTheTablets'))
			foreach allactors(class'tnmpawn',p,'DarkTemplar_Courtyard')
				p.EnterWorld();
	}
	else if (localURL == "22_LLAMATEMPLE")
	{
		// Make Hobbes hostile if he was knocked out in M20
		if (flags.GetBool('Hobbes_Unconscious'))
		{
			foreach allactors(class'tnmpawn',p,'Hobbes')
				P.ChangeAlly('Player', -1.0, true);
		}
	}
	else if (localURL == "22_WEAPONSHOP")
	{
		// Handle unlocking the fireblade
		if (trestkon(player) != none)
		{
			if (trestkon(player).bunlockedSword)
			{
				flags.SetBool('UNLOCKED_FlameBlade', True,, 23);

				if (!flags.GetBool('MS_GivenFireBlade'))
				{
					foreach allactors(class'tnmpawn', p, 'Raving')
					{
						GiveItemTo("tnmitems.weaponfireblade",p);
					}
					flags.SetBool('MS_GivenFireBlade', True,, 23);
				}
			}
		}

		if (flags.GetBool('StoleFromWeaponShop'))
		{
			// Make Andreus run up to the player if you've stolen from the shop
			foreach allactors(class'tnmpawn',p,'Andreus')
				P.SetOrders('WaitingFor','');

			// Make Raving mad if you show your face after stealing from his shop
			foreach allactors(class'tnmpawn',p,'RavingNutter')
				P.ChangeAlly('Player', -1.0, true);
		}
	}
	else if (localURL == "22_VOODOOSHOP")
	{
		SetupPortal('VoodooShop1','FC_Current_Booth_Sound');
		SetupPortal('VoodooShop2','FC_Current_Booth_Sound');
		SetupPortal('VoodooShop3','FC_Current_Booth_Sound');

		// Change the lock if Yardbomb was advised to sell the shop
		if (flags.GetBool('Yardbomb_AdvisedToSell'))
		{
			foreach allactors(class'deusexmover',m, 'PortalDoor')
				m.KeyIDNeeded = 'betchadonthavethiskey';
		}

		// Make Yardbomb hostile if the player knocked him out in M20
		if (flags.GetBool('Yardbomb_Unconscious'))
		{
			foreach allactors(class'tnmpawn', p, 'Yardbomb')
				p.ChangeAlly('Player', -1.000000, true);
		}
	}
	else if (localURL == "22_ATC")
	{
		// Send a PM with a sattelite picture
		SendPM("PM_TG_EnterATC");

		// Make the car smoke inactive to begin with (WHY THE HELL DOESN'T bInActive DO ANYTHING!?)
		// Disabled because bInActive seems to have decided to work again
		// I also realized the desk was being broken by the office guy, so I made it a door :P
		/*if (!flags.GetBool('MS_DisabledCarSmoke'))
		{
			foreach AllActors(class'ParticleGenerator', S, 'BustedCar_Smoke')
				S.Trigger(Self, Player);

			// Okay this isn't exactly smoke, but I have to stop that desk from breaking on its own!!
			foreach AllActors(class'deusexmover', M, 'CarCrashDesk')
				M.bBreakable = true;

			flags.SetBool('MS_DisabledCarSmoke', True,, 23);
		}*/

		// Make the barricade couch go away for the moment
		foreach AllActors(class'CouchLeather', CL, 'Couch_LobbyBarricade2')
		{
			CL.bHidden = true;
			CL.SetCollision(false,false,false);
		}
	}
	else if (localURL == "22_PDXHQ01")
	{
		// Check if NVShacker should be there
		if (flags.GetBool('NVShacker_PDX') && !flags.GetBool('MS_NVS_Placed'))
		{
			foreach AllActors(class'tnmpawn',p,'NVShackerLobby')
				p.EnterWorld();

			if(flags.GetBool('NVShackerPet_NVS'))
				foreach AllActors(class'tnmrobot',r,'NVShackerPet')
					r.EnterWorld();

			flags.SetBool('MS_NVS_Placed',true,,23);
		}

		// Replace the old newspaper with Slicer's new article if Slicer was saved
		if (flags.GetBool('Slicer_SetFree'))
		{
			foreach AllActors(class'tnminformationdevices',inf)
			{
				if(inf.tag=='SlicerNewspaper_Old')
					inf.LeaveWorld();
				else if(inf.tag=='SlicerNewspaper_New')
					inf.EnterWorld();
			}
		}

		if (!Flags.GetBool('Evil_Done')&&!Flags.GetBool('MS_Evil_Done_Done'))
		{
			foreach allactors( class'tnmpawn' ,p , 'Evil')
			{
				GiveItemTo("deusex.augmentationupgradecannister", p);
				GiveItemTo("deusex.biocell", p);
				GiveItemTo("deusex.biocell", p);
				GiveItemTo("deusex.biocell", p);
			}
			Flags.SetBool('MS_Evil_Done_Done', true, , 23);
		}

		if (!flags.GetBool('MS_PDXMovePostBriefing1_Done') && flags.GetBool('QR_MAIN_FreeKevo') && (LastMap() != "22_PDXHQ02"))
		{
			foreach allactors( class'tnmpawn' ,p , )
			{
				if (p.Tag == 'Evil' || p.Tag == 'Phasmatis')
					p.EnterWorld();
				if (flags.GetBool('NVShacker_PDX'))
				{
					if (p.Tag=='NVShacker')
						p.EnterWorld();
					else if (p.Tag=='NVShackerLobby')
						p.LeaveWorld();
				}
			}

			SpawnItemAt("TNM.WeaponFireStaff" , 'FirestaffSpawnPoint');

			Flags.SetBool('MS_PDXMovePostBriefing1_Done', true, , 23);
		}
	}
	else if (localURL == "22_PDXHQ02")
	{
		if (flags.GetBool('MS_PDXMovePostBriefing1_Done') && !flags.GetBool('MS_PDXMovePostBriefing2_Done'))
		{
			foreach allactors( class'tnmpawn' ,p , )
			{
				if (p.Tag == 'Evil' || p.Tag == 'Phasmatis')
					p.LeaveWorld();
			}
			Flags.SetBool('MS_PDXMovePostBriefing2_Done', true, , 23);
		}
	}

	//handle the elevator hatch and keypad persistance
	if (left(localURL,5) == "22_WC")
	{
		if(flags.CheckFlag('WC_ElevatorHatch_Strength',flags.EFlagType.FLAG_Float))
		{
			foreach AllActors(Class'DeusExMover',m,'SublevelKeypadHatch')
			{
				m.lockstrength=flags.GetFloat('WC_ElevatorHatch_Strength');
				if(m.lockstrength==0.0)
					m.bLocked=false;

				if(flags.GetBool('WC_ElevatorHatch_Open'))
				{
					if(m.keynum==0)
					{
						//the delay lets it interpolate first then
						//properly 'move' later to do collision
						m.InterpolateTo(1,0);
						m.DelayTime=0.1;
						m.GotoState('TriggerToggle','Open');

					}
				}
				else
				{
					if(m.keynum==1)
					{
						m.InterpolateTo(0,0);
						m.DelayTime=0.1;
						m.GotoState('TriggerToggle','Close');
					}
				}
			}

			foreach AllActors(Class'Keypad',kp,'SublevelKeypad')
			{
				kp.hackstrength=flags.GetFloat('WC_ElevatorKeypad');
			}
		}
	}
}

// ----------------------------------------------------------------------
// PreTravel()
// 
// Set flags upon exit of a certain map
// ----------------------------------------------------------------------

function PreTravel()
{
	local tnmpawn p;	
	local int count;
	local deusexmover m;
	local keypad kp;

	if (localURL == "22_DXO")
	{
		// Remove Kevo when he's released 
		if (flags.GetBool('Kevo_Free'))
			foreach allactors(class'tnmpawn',p,'Kevo')
				p.LeaveWorld();
	}
	else if (localURL == "22_GOATCITY")
	{
		// Remove ZeroPresence when his mission is done 
		if (flags.GetBool('QC_SUB_LureThePriest'))
			foreach allactors(class'tnmpawn',p,'ZeroPresence')
				p.LeaveWorld();
	}

	//handle the elevator hatch and keypad persistance
	if (left(localURL,5) == "22_WC")
	{
		foreach AllActors(Class'DeusExMover',m,'SublevelKeypadHatch')
		{
			flags.SetFloat('WC_ElevatorHatch_Strength',m.lockstrength,,23);
			flags.SetBool('WC_ElevatorHatch_Open',m.keynum==1,,23);
		}

		foreach AllActors(Class'Keypad',kp,'SublevelKeypad')
			flags.SetFloat('WC_ElevatorKeypad',kp.hackstrength,,23);
	}


	Super.PreTravel();
}

// ----------------------------------------------------------------------
// Timer()
//
// Main state machine for the mission
// ----------------------------------------------------------------------

function Timer()
{
	local int count;
	local pawn pawn;
	local tnmpawn p;
	local tnmrobot r;
	local tnmcarcass c;
	local deusexmover M;
	local BlackHelicopter B;
	local Vehicles V;
	local Dispatcher D;
	local bool bDoTorture;
	local AmbientSoundTriggered S;
	local Containers Con;
	local actor a;
	local datavaultimage image;
	local securitycamera cam;

	Super.timer();

	if (localURL == "22_FCDOWNTOWN")
	{
		// Handle the completion of the Sol quest 
		if(!flags.GetBool('QC_SUB_KillBombers') && !flags.GetBool('ALLIED_WC'))
		{
			count = 0;
			foreach allactors(class'tnmpawn',p,'SolBomber')
				count++;

			if (count == 0)
			{
				flags.SetBool('QC_SUB_KillBombers', TRUE, ,0);  

				// Update the goal
				if(flags.GetBool('QR_SUB_KillBombers') && !flags.GetBool('AlphaOperator_Dead') && !flags.GetBool('AlphaOperator_Unconscious'))
				{
					AddGoal('SolBombing', "You have disposed of the men who bombed Sol's Bar. Alpha will appreciate this news.", false, false);
					SkillAward(500, "FOR GREAT JUSTICE! Award");
				}
				else if(flags.GetBool('SolBombers_Played') && !flags.GetBool('AlphaOperator_Dead') && !flags.GetBool('AlphaOperator_Unconscious'))
				{
					AddGoal('SolBombing', "You have disposed of some thugs, maybe you should check with Alpha to see what they were talking about.", false, false);
					SkillAward(500, "FOR GREAT JUSTICE! Award");
				}
				else if(!flags.GetBool('ALLIED_WC') && !flags.GetBool('AlphaOperator_Dead') && !flags.GetBool('AlphaOperator_Unconscious'))
				{
					AddGoal('SolBombing', "You have disposed of some thugs, maybe you should check around to see if anyone is offering a reward for this endeavor.", false, false);
					SkillAward(500, "FOR GREAT JUSTICE! Award");
				}
			}
		}

		// Close PJ's goals if you take him out
		if((flags.GetBool('PJ_Dead') || flags.GetBool('PJ_Unconscious')) && !flags.GetBool('PJ_GaveReward'))
		{
			AddGoal('Bugging', "Pimp-Jojo is no longer in any state to complain if you help yourself to some of his items.", false, true);
			flags.SetBool('PJ_GaveReward', TRUE, ,23);
		}
		
		//Close the Sol quest again if you knock down or kill AO
		if ((flags.GetBool('AlphaOperator_Dead') || flags.GetBool('AlphaOperator_Unconscious')) && flags.GetBool('ALLIED_PDX') && (flags.GetBool('QC_SUB_KillBombers') || flags.GetBool('QR_SUB_KillBombers')) && !flags.GetBool('MS_AlphaGoalClose'))
		{
			if (flags.GetBool('QR_SUB_KillBombers') && flags.GetBool('QC_SUB_KillBombers'))
			{
				if (flags.GetBool('AlphaOperator_Dead'))
				{
					AddGoal('SolBombing', "After going through the effort of killing the bombers of Sol's Bar, you killed Alpha Operator. What did you do that for?", false, true);
					flags.SetBool('MS_AlphaGoalClose', TRUE, ,23);
				}
				else
				{
					AddGoal('SolBombing', "After helping Alpha with finding and killing the bombers, you helped give him a headache too.", false, true);
					flags.SetBool('MS_AlphaGoalClose', TRUE, ,23);
				}
			}
			else if (flags.GetBool('QR_SUB_KillBombers') && !flags.GetBool('QC_SUB_KillBombers'))
			{
				if (flags.GetBool('AlphaOperator_Dead'))
				{
					AddGoal('SolBombing', "You decided it was much easier to kill Alpha Operator than finding and killing the bombers.", false, true);
					flags.SetBool('MS_AlphaGoalClose', TRUE, ,23);
				}
				else
				{
					AddGoal('SolBombing', "You decided not to search for the bombers of Sol's bar, and let Alpha know in the rudest way possible. He probably won't be pleased when he wakes up.", false, true);
					flags.SetBool('MS_AlphaGoalClose', TRUE, ,23);
				}
			}
			else
			{
				if (flags.GetBool('AlphaOperator_Dead'))
				{
					AddGoal('SolBombing', "You'll never find out exactly what the bombers did now that you killed Alpha Operator.", false, true);
					flags.SetBool('MS_AlphaGoalClose', TRUE, ,23);
				}
				else
				{
					AddGoal('SolBombing', "It will be unlikely that you discover the true purpose of the bombing with Alpha knocked out.", false, true);
					flags.SetBool('MS_AlphaGoalClose', TRUE, ,23);
				}
			}
		}
	}
	else if (localURL == "22_SOLSBAR")
	{
		//Close Winqumans interview goal if you take him down before completing it.
		if ((flags.GetBool('Winquman_Dead') || flags.GetBool('Winquman_Unconscious')) && flags.GetBool('Winquman2_Played') && !flags.GetBool('Winquman3_Played') && !flags.GetBool('MS_WinqumanGoalClose'))
		{
			if (flags.GetBool('Winquman_Dead'))
			{
				AddGoal('QuestionWitnesses', "Apparently questioning witnesses was beneath you, so you killed Winquman.", false, true);
				flags.SetBool('MS_WinqumanGoalClose', TRUE, ,23);
			}
			else
			{
				AddGoal('QuestionWitnesses', "It will be difficult to tell Winquman the results of your investigation, what with him being unconscious and all.", false, true);
				flags.SetBool('MS_WinqumanGoalClose', TRUE, ,23);
			}
		}
	}
	else if (localURL == "22_FCCORPORATE")
	{
		// Close Wolfy's side mission if you kill or knock him out
		if (!flags.GetBool('Wolfy_GaveReward') && !flags.GetBool('Wolfy_KilledGuard') && (flags.GetBool('Wolfy_Dead') || flags.GetBool('Wolfy_Unconscious')) && !flags.GetBool('MS_ClosedWolfyMission'))
		{
			if(flags.GetBool('QR_SUB_DXEditing'))
			{
				AddGoal('DXEditing', "You should probably kiss those 2000 credits from Wolfy goodbye.", false, true);
				flags.SetBool('MS_ClosedWolfyMission', TRUE, ,23);
			}
			else
			{
				AddGoal('DXEditing', "Now you will never find out what mission Wolfy wanted to give you.", false, true);
				flags.SetBool('MS_ClosedWolfyMission', TRUE, ,23);
			}
		}
	}
	else if (localURL == "22_FCSLUMS")
	{
		// Remove Midashand if he's about to take off
		if (flags.GetBool('Midas_TakingOff'))
		{
			foreach allactors(class'tnmpawn',p,'Midashand')
				p.LeaveWorld();
		}

		// If the player frags Madmax and Fender
		if ((flags.GetBool('Fender2k1_Dead') || flags.GetBool('Fender2k1_Unconscious')) &&
		    (flags.GetBool('Madmax_Dead') || flags.GetBool('Madmax_Unconscious')))
		{
			SendPM("PM_KillDXO");
		}

		// Set some flags if the player gets any hostages killed
		count = 0;
		foreach allactors(class'tnmpawn',p,)
			if (p.Tag == 'Hostage1' || p.Tag == 'Hostage2' || p.Tag == 'Hostage3')
				count++;

		if (count == 0)
			flags.SetBool('Slums_AllHostagesDead', TRUE, ,23);
		else if (count < 3)
			flags.SetBool('Slums_SomeHostagesDead', TRUE, ,23);

		// When the player restores power to the subway...
		if (flags.GetBool('QC_SUB_SubwayPower') && !flags.GetBool('MS_SubwayCleared'))
		{
			// Delete some of the subway explosives unless both Fender and Madmax are dead or unconscious
			if (!(flags.GetBool('Fender2k1_Dead') || flags.GetBool('Fender2k1_Unconscious')) ||
			    !(flags.GetBool('Madmax_Dead') || flags.GetBool('Madmax_Unconscious')))
			{
				foreach allactors(class'Containers',Con,'SubwayExplosives1')
					Con.Destroy();
			}

			foreach allactors(class'tnmpawn',p,)
			{
				// ...remove Fender2k1 and Madmax
				if (p.Tag == 'Fender2k1' || p.Tag == 'Madmax')
					p.LeaveWorld();

				// ...and move the hostages up into the streets
				// Removed for apparently causing crashes
//				if (p.Tag == 'Hostage1')
//				{
//					p.OrderTag='Hostage1Point';
//					TeleportPawn(p, 'Hostage1Point', 'Patrolling',false,true);
//				}
//				else if (p.Tag == 'Hostage2')
//				{
//					p.OrderTag='Hostage2Point';
//					TeleportPawn(p, 'Hostage2Point', 'Patrolling',false,true);
//				}
//				else if (p.Tag == 'Hostage3')
//				{
//					p.OrderTag='Hostage3Point';
//					TeleportPawn(p, 'Hostage3Point', 'Patrolling',false,true);
//				}
			}

			flags.SetBool('MS_SubwayCleared',true,,23);
			SendPM("PM_SubwayPowerRestored");
		}

		if (flags.GetBool('Kevo_PlacedOnSlab') && !flags.GetBool('MS_KevoInvincible'))
		{
			foreach AllActors( Class<tnmcarcass>(DynamicLoadObject("TNMCharacters.KevoCarcass", Class'Class')), a)
			{
				tnmcarcass(a).bInvincible = true;
			}

			flags.SetBool('MS_KevoInvincible', TRUE, ,23);
		}

		if (flags.GetBool('AJ_Ready'))
		{
			bDoTorture=true;
			foreach AllActors(class'Pawn', pawn)
			{
				// Run the torture sequence when AJ is the only remaining pawn in the room
				if(pawn.Tag != 'AJ' && pawn.Region.Zone.Tag=='TortureRoom')
				{
					bDoTorture=false;
					break;
				}
			}
			if(bDoTorture)
			{
				// Close the doors
				SealDoor('TortureRoomDoors');

				// Initiate torture sequence by means of a dispatcher
				foreach AllActors(class'Dispatcher', D, 'TortureSequenceDispatcher')
					D.Trigger(Self, Player);

				// Make sure this only happens once
				flags.SetBool('AJ_Ready', false);
			}
		}

		// Send directions when the player knocks out Kevo
		if (flags.GetBool('QR_MAIN_KidnapKevo') && flags.GetBool('Kevo_Unconscious'))
			SendPM("PM_TG_KnockedOutKevo");

		// Award some skillpoints for getting the necessary information out of Kevo
		if (flags.GetBool('QC_MAIN_KidnapKevo') && !flags.GetBool('MS_KidnapKevo_AwardGiven'))
		{
			SkillAward(250, "Marathon Man Award");
			flags.SetBool('MS_KidnapKevo_AwardGiven',true,,23);
		}

		// Handle "Plan B" when the player foolishly kills Kevo-sama or AJ
		if (flags.GetBool('QR_MAIN_KidnapKevo') && !flags.GetBool('MS_PreparedDemolition'))
		{
			if (flags.GetBool('Kevo_Dead') && !flags.GetBool('AJ_TortureDone'))
			{
				// Close the doors to the torture chamber again
				// TODO: Make sure the player isn't actually in there...
				SealDoor('TortureRoomDoors');

				// Send the player a PM to tell him the demo crew is inbound
				SendPM("PM_TG_KilledKevo");

				// Spawn the demo guys (their orders make them move)
				foreach allactors(class'tnmpawn',p,'DemolitionMan')
					p.EnterWorld();
				foreach allactors(class'tnmpawn',p,'DemolitionSquad')
					p.EnterWorld();

				// Make the gate destructible
				foreach AllActors(class'DeusExMover', M, 'HelipadGate')
					M.bBreakable = true;

				flags.SetBool('MS_PreparedDemolition',true,,23);
			}
			else if ((flags.GetBool('AJ_Dead') || flags.GetBool('AJ_Unconscious')) && flags.GetBool('AJ_TortureDone'))
			{
				// Send the player a PM to tell him he's a prick
				SendPM("PM_TG_KilledAJPostTorture");
			}
			else if (flags.GetBool('AJ_Dead') || flags.GetBool('AJ_Unconscious'))
			{
				// Send the player a PM to tell him the demo crew is inbound
				SendPM("PM_TG_KilledAJ");

				// Spawn the demo guys (their orders make them move)
				foreach allactors(class'tnmpawn',p,'DemolitionMan')
					p.EnterWorld();
				foreach allactors(class'tnmpawn',p,'DemolitionSquad')
					p.EnterWorld();

				// Make the gate destructible
				foreach AllActors(class'DeusExMover', M, 'HelipadGate')
					M.bBreakable = true;

				flags.SetBool('MS_PreparedDemolition',true,,23);
			}
		}

		// Spawn the attacking Firewalls when the gate has been blown up
		if (flags.GetBool('MS_PreparedDemolition') && !flags.GetBool('MS_SpawnedDemoInterceptors'))
		{
			// We're checking if it's gone so all this'll happen if the player blows it too
			foreach allactors(class'DeusExMover',M,'HelipadGate')
				if (M.bDestroyed)
				{
					foreach allactors(class'tnmpawn',p,'DemolitionInterceptors')
						p.EnterWorld();

					AddGoal('KidnapKevo', "The helipad gate is blown, now you just have to fend off the firewalls until Midashand gets here.", true, false);

					flags.SetBool('MS_SpawnedDemoInterceptors',true,,23);
				}
		}

		// Spawn Midashand in the subway once the attacking firewalls are gone
		if (flags.GetBool('MS_SpawnedDemoInterceptors') && !(flags.GetBool('MS_MidasIncoming') || flags.GetBool('MS_MidasTimerStarted')))
		{
			count = 0;
			foreach allactors(class'tnmpawn',p,'DemolitionInterceptors')
				count++;

			if (count == 0)
			{
				foreach allactors(class'tnmpawn',p,'Midashand_Subway')
					p.EnterWorld();

				SendPM("PM_TG_InterceptorsGone");
			}
		}

		// Spawn Midashand when the player gets the info out of Kevo
		if (flags.GetBool('QC_MAIN_KidnapKevo') && !(flags.GetBool('MS_MidasIncoming') || flags.GetBool('MS_MidasTimerStarted')))
			foreach allactors(class'tnmpawn',p,'Midashand')
				p.EnterWorld();

		// Scold the player if he kills the demolition man and tell the fucker he can do it himself then
		if (flags.GetBool('DemolitionMan_Dead') && !flags.GetBool('MS_SpawnedDemoInterceptors'))
		{
			SendPM("PM_TG_KilledDemoMan");
			// Spawn a LAM so the player will always have something to blow up the gate with
			SpawnItemAt("DeusEx.WeaponLAM" , 'LAMSpawnPoint');
		}

		if (flags.GetBool('Midashand_Dead') && !flags.GetBool('MS_DoneMidasDeath'))
		{
			// Tell the player to fly his own damn helicopter if he kills Midas
			SendPM("PM_TG_KilledMidas");

			// Then make sure he gets the right convo if he triggers it
			foreach allactors(class'BlackHelicopter',B,'ROFLCopter')
			{
				B.Bindname = "ROFLCopter";
				B.FamiliarName = "ROFLCopter";
				B.ConBindEvents();
			}

			flags.SetBool('MS_DoneMidasDeath',true,,23);
		}

		// Update the player's goal if Vavrek dies
		if (flags.GetBool('Vavrek_Dead') && !flags.GetBool('Vavrek_TOLD_Kidnapping') && !flags.GetBool('MS_VavrekDeadGoalUpdated'))
		{
			AddGoal('FreeThePilot', "Vavrek has tragically passed away. Perhaps you should search his body for clues.", false, false);
			flags.SetBool('MS_VavrekDeadGoalUpdated',true,,23);
		}

		// Update the player's goal further when the player finds Vavrek's note
		if ( !flags.GetBool('Vavrek_TOLD_Kidnapping') )
		{
			image = player.FirstImage;
			while(image != None)
			{
				if (image.imageDescription == "Note From Vavrek")
				{
					flags.SetBool('Vavrek_TOLD_Kidnapping',true,,23);
					AddGoal( 'FreeThePilot', "A note you found on Vavrek says Kevo-sama was kidnapped by DXO. Apparently their HQ is somewhere near Sol's. The note suggested Jackie may have a lead." , false, false);
				}
				image = image.NextImage;
			}
			
		}
	}
	else if (localURL == "22_WCFLOOR1")
	{
		// Send an angry PM from Scara if the player kills Kylie
		if (flags.getbool('ALLIED_WC') && flags.getbool('Kylie_Dead') && !flags.getbool('Kylie_Dead_M20') && !flags.getbool('Scara_TOLD_KylieKill'))
			SendPM("PM_Scara_KilledKylie");
	}
	else if (localURL == "22_ATC")
	{
		LobbyGuards();

		// Check if all the guards who would investigate the car crash are still alive
		count = 0;
		foreach allactors(class'tnmpawn',p,)
			if (p.Tag == 'ATCGuardAlert1' || p.Tag == 'ATCGuardAlert2' || p.Tag == 'ATCGuardAlert3' || p.Tag == 'ATCGuardAlert4')
				count++;

		if (count == 0)
		{
			// If they're all dead, prevent That Guy from warning the player after the crash
			flags.SetBool('ATC_AlertGuardsDead',true,,23);
		}

		// Make all the guards neutral if the player picks up the ID card 
		if (flags.GetBool('HAS_ATCIDCard') && !flags.GetBool('MS_DoneID'))
		{
			SendPM("PM_TG_GotID");

			foreach allactors(class'tnmpawn',p,)
				if (p.Tag == 'ATCGuard' || p.Tag == 'ATCGuardAlert1' || p.Tag == 'ATCGuardAlert2' || p.Tag == 'ATCGuardAlert3' || p.Tag == 'ATCGuardAlert4' || p.Tag == 'ShackGuard')
					p.ChangeAlly('Player',0.000000,false);
			foreach allactors(class'tnmrobot',r,'ATCBot')
				r.ChangeAlly('Player',0.000000,false);
			foreach allactors(class'securitycamera', cam, )
				cam.memoryTime=0.0;

			flags.SetBool('MS_DoneID',true,,23);
		}

		// Check how many guards are left alive
		count = 0;
		foreach allactors(class'tnmpawn',p,)
			if (p.Tag == 'ATCGuard' || p.Tag == 'ATCGuardAlert1' || p.Tag == 'ATCGuardAlert2' || p.Tag == 'ATCGuardAlert3' || p.Tag == 'ATCGuardAlert4' || p.Tag == 'ShackGuard')
				count++;

		// Only count robots who aren't disabled
		foreach allactors(class'tnmrobot',r,'ATCBot')
			if (!r.IsInState('Disabled'))
				count++;

		// Only do the following is Midashand is NOT dead!
		if (!flags.GetBool('Midashand_Dead'))
		{
			// Complete the Clear LZ goal if the player neutralizes everybody before lifting the lockdown
			if ((count == 0) && !flags.GetBool('MS_ChopperLockdownOff'))
				SendPM("PM_Midas_ClearedLZ");

			// Once the lockdown is off, call upon Midas depending on whether any enemies remain
			if (flags.GetBool('MS_ChopperLockdownOff') && !flags.GetBool('MS_MidasWaiting') && !flags.GetBool('MS_MidasIncoming') && !flags.GetBool('MS_MidasTimerStarted'))
			{
				if (count == 0)
				{
					// Award some skillpoints for completing the mission
					SkillAward(750, "Do-It-Yourself Air Control Award");

					SendPM("PM_Midas_LockOff_LZClear");

					// 30 second delay for added realism
					AddTimer('TimerStarted_SpawnMidasChopper','Timer_SpawnMidasChopper', 30);

					flags.SetBool('MS_MidasTimerStarted',true,,23);
				}
				else
				{
					SendPM("PM_Midas_LockOff_LZHot");
					flags.SetBool('MS_MidasWaiting',true,,23);
				}
			}

			// If the lockdown is off, call Midas in when the player neutralizes the last guard
			if (flags.GetBool('MS_ChopperLockdownOff') && flags.GetBool('MS_MidasWaiting') && !flags.GetBool('MS_MidasIncoming'))
			{
				if (count == 0)
				{
					// Award some skillpoints for completing the mission
					SkillAward(750, "Do-It-Yourself Air Control Award");

					SendPM("PM_Midas_TouchingDown");

					// Make the chopper appear
					foreach allactors(class'Vehicles',V,'BlackHelicopter01')
						V.EnterWorld();

					// Begin the interpolation
					foreach AllActors(class'Dispatcher', D, 'LandingDispatcher')
						D.Trigger(Self, Player);

					flags.SetBool('MS_MidasIncoming',true,,23);
				}
			}
		}
		else // If Midashand IS dead, do this instead:
		{
			// Inform the player what a giant murderous psychopath he is (since we were counting anyway)
			if (count == 0)
				SendPM("PM_TG_ATCKilledEveryone");

			// Once the lockdown is off, tell the player to go back to the chopper
			if (flags.GetBool('MS_ChopperLockdownOff') && flags.GetBool('Midashand_Dead'))
				SendPM("PM_TG_LockOff");
		}
	}
	else if (localURL == "22_DXEDITING")
	{
		// Award some skillpoints when the player picks up the sheep poster
		if (PlayerHasItem('PosterTube') && !flags.GetBool('MS_SheepPoster_AwardGiven') &&
		    !flags.GetBool('Wolfy_KilledGuard') && !flags.GetBool('Wolfy_Dead') && !flags.GetBool('Wolfy_Unconscious'))
		{
			SkillAward(250, "Poster Boy Award");
			flags.SetBool('MS_SheepPoster_AwardGiven',true,,23);
		}

		// Abort the mission if the player kills somebody 
		if (Killed() > 0)
			SendPM("PM_Wolfy_KilledGuard");
	}
	else if (localURL == "22_GOATCITY")
	{
		// Close the relevant goals if the player kills ZP
		if (flags.GetBool('Zero_Dead') && !flags.GetBool('MS_FindZP_Closed') && !flags.GetBool('ALLIED_PDX'))
		{
			if (flags.GetBool('MS_FindZP_AwardGiven'))
			{
				AddGoal('FindZP', "You killed ZP, but not before you got Scara's reward. Good thinking.", FALSE, TRUE);
			}
			else
			{
				AddGoal('FindZP', "You killed ZP. You probably shouldn't tell Scara.", FALSE, TRUE);
			}

			flags.SetBool('MS_FindZP_Closed',true,,23);
		}

		// Close the relevant goals if the player knocks out ZP
		if (flags.GetBool('Zero_Unconscious') && !flags.GetBool('MS_FindZP_Closed') && !flags.GetBool('ALLIED_PDX'))
		{
			if (flags.GetBool('MS_FindZP_AwardGiven'))
			{
				AddGoal('FindZP', "You knocked out ZP, but - wisely - not before you got Scara's reward.", FALSE, TRUE);
			}
			else
			{
				AddGoal('FindZP', "ZP will soon wake up with quite the headache, but you probably shouldn't count on that reward from Scara.", FALSE, TRUE);
			}

			flags.SetBool('MS_FindZP_Closed',true,,23);
		}

		// Award skillpoints if ZP agrees to report back to Scara
		if (flags.GetBool('QC_SUB_LureThePriest') && !flags.GetBool('MS_FindZP_AwardGiven'))
		{
			SkillAward(300, "Don't Shoot the Messenger Award");
			flags.SetBool('MS_FindZP_AwardGiven',true,,23);
		}

		// Send a debriefing PM from Scara when ZP has agreed to return
		if (flags.GetBool('QC_SUB_FindZP'))
			SendPM("PM_Scara_FoundZP");
	}
	else if (localURL == "22_GOATTEMPLAE")
	{
		// Award skillpoints if Athena is killed as part of the mission
		if (flags.GetBool('Athena_Fight_Dead') && flags.GetBool('QR_CULT_KillAthena') && flags.GetBool('MS_MelkShutOff') && !flags.GetBool('QC_CULT_KillAthena'))
		{
			SkillAward(750, "Assassination Award");
			AddGoal('KillAthena', "You have assassinated Athena. Return to the Llamas to claim your reward.", FALSE, FALSE);
			flags.SetBool('QC_CULT_KillAthena',true,,0);
		}
		//Close the Kill Beefman goal when killing Dark Templar.
		if ((flags.GetBool('DarkTemplar_Dead') || flags.GetBool('DarkTemplar_Unconscious')) && flags.GetBool('ALLIED_CULT_GOAT') && !flags.GetBool('QC_CULT_KillBeefman') && !flags.GetBool('MS_BeefmanGoalClose'))
		{
			if (flags.GetBool('QR_CULT_KillBeefman'))
			{
				if (flags.GetBool('DarkTemplar_Dead'))
				{
					AddGoal('KillBeefman', "You decided to kill the wrong cult leader. You probably had a reason for it.", false, true);
					flags.SetBool('MS_BeefmanGoalClose', TRUE, ,23);
				}
				else
				{
					AddGoal('KillBeefman', "Not interested in killing Beefman, you knocked Dark Templar down instead.", false, true);
					flags.SetBool('MS_BeefmanGoalClose', TRUE, ,23);
				}
			}
			else
			{
				if (flags.GetBool('DarkTemplar_Dead'))
				{
					AddGoal('KillBeefman', "Did something happen down in DXI? Instead of listening to Dark Templar's proposal, you simply killed him.", false, true);
					flags.SetBool('MS_BeefmanGoalClose', TRUE, ,23);
				}
				else
				{
					AddGoal('KillBeefman', "You will never know what Dark Templar wanted you to do because you decided to knock him out. You probably had your reasons.", false, true);
					flags.SetBool('MS_BeefmanGoalClose', TRUE, ,23);
				}
			}
		}
	}
	else if (localURL == "22_LLAMATEMPLE")
	{
		// Award skillpoints if Beefman is killed as part of the mission
		if (flags.GetBool('Beefman_Dead') && flags.GetBool('QR_CULT_KillBeefman') && !flags.GetBool('QC_CULT_KillBeefman'))
		{
			SkillAward(750, "Assassination Award");
			AddGoal('KillBeefman', "You have assassinated Beefman. Return to the Goats to claim your reward.", FALSE, FALSE);
			flags.SetBool('QC_CULT_KillBeefman',true,,0);
		}
		//Close the Kill Athena goal when killing Beefman.
		if ((flags.GetBool('Beefman_Dead') || flags.GetBool('Beefman_Unconscious')) && flags.GetBool('ALLIED_CULT_LLAMA') && !flags.GetBool('QC_CULT_KillAthena') && !flags.GetBool('MS_AthenaGoalClose'))
		{
			if (flags.GetBool('QR_CULT_KillAthena'))
			{
				if (flags.GetBool('Beefman_Dead'))
				{
					AddGoal('KillAthena', "You decided to kill the wrong cult leader. You probably had a reason for it.", false, true);
					flags.SetBool('MS_AthenaGoalClose', TRUE, ,23);
				}
				else
				{
					AddGoal('KillAthena', "Unsure about the dangers waiting for you in the Goat Templae, you decided to knock down Beefman and call it a day.", false, true);
					flags.SetBool('MS_AthenaGoalClose', TRUE, ,23);
				}
			}
			else
			{
				if (flags.GetBool('Beefman_Dead'))
				{
					AddGoal('KillAthena', "You decided you'd much rather shoot Beefman than talk to him again.", false, true);
					flags.SetBool('MS_AthenaGoalClose', TRUE, ,23);
				}
				else
				{
					AddGoal('KillAthena', "Unwilling to listen to Beefman a second longer, you decided to give him a strong headache instead.", false, true);
					flags.SetBool('MS_AthenaGoalClose', TRUE, ,23);
				}
			}
		}
	}
	else if (localURL == "22_DXO")
	{
		// If anybody dies, make everybody hostile (it's sort of cheating, but so be it)
		if (flags.GetBool('TRM_Dead')||flags.GetBool('Compudoc_Dead')||flags.GetBool('Illuminati_Dead')||flags.GetBool('Mole_Dead'))
		{
			foreach AllActors(class'TNMPawn',p,)
			{
				if((p.Tag == 'TRM')||(p.Tag == 'Compudoc')||(p.Tag == 'Illuminati')||(p.Tag == 'Mole'))
					p.ChangeAlly('Player', -1.000000, true);
			}
		}

		// Update the goal if the player kills TRM
		if (flags.GetBool('TRM_Dead') && !flags.GetBool('Kevo_Free') && !flags.GetBool('MS_TRMDeathGoalUpdated'))
		{
			AddGoal('FreeThePilot', "You've killed TRM. Now it's time to free Kevo-sama.", false, false);
			flags.SetBool('MS_TRMDeathGoalUpdated',true,,23);
		}

		// Award skillpoints for freeing Kevo
		if (flags.GetBool('Kevo_Free') && !flags.GetBool('MS_FreeThePilot_AwardGiven'))
		{
			SkillAward(1000, "Search and Rescue Award");
			flags.SetBool('MS_FreeThePilot_AwardGiven',true,,23);
		}

		// Send a PM if the player stupidly kills or knocks out Kevo-sama
		if (flags.GetBool('Kevo_Dead') || flags.GetBool('Kevo_Unconscious'))
			SendPM("PM_Evil_KillKevo");

		// Send a new PM when the player picks up the autopilot codes
		if ( !flags.GetBool('MS_AutopilotCodes_Done') )
		{
			image = player.FirstImage;
			while(image != None)
			{
				if (image.imageDescription == "Kevo's Autopilot Codes")
				{
					flags.SetBool('MS_AutopilotCodes_Done',true,,23);
					flags.SetBool('TrestkonFlying',true,,24);
					SendPM("PM_Evil_GotAutoPilotCodes");
				}
				image = image.NextImage;
			}
			
		}
	}
}

function PlayerDetected()
{
	// *Ahem* Let's try that again, defining the proper vars this time! Thanks Smoke - Jonas
	local tnmpawn p;
	local tnmrobot r;
	local securitycamera cam;

	if ((localURL == "22_GOATCITY")||
	   (localURL == "22_GOATTEMPLAE"))
	{
		//killing Athena:
		if (flags.GetBool('QR_CULT_KillAthena') && !flags.GetBool('Beefman_LastQuestDone'))
		{
			flags.SetBool('NS_KillAthena',true,,23);
		}
	}
	else if (localURL == "22_LLAMATEMPLAE")
	{
		//killing Beefman:
		if (flags.GetBool('QR_CULT_KillBeefman') && !flags.GetBool('DT_LastQuestDone'))
		{
			flags.SetBool('NS_KillBeefman',true,,23);
		}
	}
	else if (localURL == "22_DXO")
	{
		// Activate the security cameras if you cause trouble
		foreach allactors(class'securitycamera', cam, )
		{
			if ((cam.tag == 'HubRoomCam') ||
			    (cam.tag == 'ArmouryCam') ||
			    (cam.tag == 'BarrackCam'))
			cam.bNoAlarm = false;
		}
	}
	else if (localURL == "22_ATC")
	{
		// W00T, I found a use for this function other than bonuses!
		if (flags.GetBool('HAS_ATCIDCard') && !flags.GetBool('MS_ATCVoidID'))
		{
			SendPM("PM_TG_VoidID");

			// Make all the guards hostile again if the player fucks up
			foreach allactors(class'tnmpawn',p,)
				if (p.Tag == 'ATCGuard' || p.Tag == 'ATCGuardAlert1' || p.Tag == 'ATCGuardAlert2' || p.Tag == 'ATCGuardAlert3' || p.Tag == 'ATCGuardAlert4' || p.Tag == 'ShackGuard')
					p.ChangeAlly('Player',-1.000000,true);
			foreach allactors(class'tnmrobot',r,'ATCBot')
				r.ChangeAlly('Player',-1.000000,true);
			foreach allactors(class'securitycamera', cam, )
				cam.memoryTime=cam.default.memoryTime;

			flags.SetBool('MS_ATCVoidID',true,,23);
		}
	}
	else if (LocalURL == "22_WCSUBLEVEL")
	{
		//destroying Black ICE:
		if (flags.GetBool('QR_SUB_BlackICE') && !flags.GetBool('Evil_Done'))
		{
			flags.SetBool('NS_BlackICE',true,,23);
		}
	}
}

function LobbyGuards()
{
	local tnmpawn p;
	local CouchLeather C;

	// Make some guards barricade the lobby unless they're all dead
	if (flags.GetBool('MS_MoveLobbyGuards') && !flags.GetBool('ATC_AlertGuardsDead') && !flags.GetBool('MS_MovedLobbyGuards'))
	{
		foreach allactors(class'tnmpawn',p,)
		{
			if (p.Tag == 'ATCGuardAlert1')
			{
				p.OrderTag='LobbyPoint01';
				TeleportPawn(p, 'LobbyPoint01', 'Patrolling',false,true);
			}
			else if (p.Tag == 'ATCGuardAlert2')
			{
				p.OrderTag='LobbyPoint02';
				TeleportPawn(p, 'LobbyPoint02', 'Patrolling',false,true);
			}
			else if (p.Tag == 'ATCGuardAlert3')
			{
				p.OrderTag='LobbyPoint03';
				TeleportPawn(p, 'LobbyPoint03', 'Patrolling',false,true);
			}
			else if (p.Tag == 'ATCGuardAlert4')
			{
				p.OrderTag='LobbyPoint04';
				TeleportPawn(p, 'LobbyPoint04', 'Patrolling',false,true);
			}
		}

		// Move the couch to form a crude barricade
		foreach AllActors(class'CouchLeather', C,)
		{
			if (C.Tag == 'Couch_LobbyBarricade1')
			{
				C.bHidden = true;
				C.SetCollision(false,false,false);
			}
			else if (C.Tag == 'Couch_LobbyBarricade2')
			{
				C.bHidden = false;
				C.SetCollision(true,true,true);
			}
		}

		flags.SetBool('MS_MovedLobbyGuards', true, , 23);
	}
}

function SpawnMidasChopper()
{
	local vehicles v;
	local dispatcher d;

	// Make the chopper appear
	foreach allactors(class'Vehicles',V,'BlackHelicopter01')
		V.EnterWorld();

	// Begin the interpolation
	foreach AllActors(class'Dispatcher', D, 'LandingDispatcher')
		D.Trigger(Self, Player);

	flags.SetBool('MS_MidasIncoming',true,,23);
}

function HandleGameEvent(name scriptFunction)
{
	switch (scriptfunction)
	{
		case 'SlumHologramDisappear'	: SlumHologramDisappear(); break;
		case 'AJChangeClothes'		: AJChangeClothes(); break;
		case 'OpenTortureRoom'		: OpenTortureRoom(); break;
		case 'EvacuateTemplae'		: EvacuateTemplae(); break;
		case 'ShootOiNutter'		: ShootOiNutter(); break;
		case 'LandedChopperAppear'	: LandedChopperAppear(); break;
		case 'CarCrash'			: CarCrash(); break;
		case 'DTHologramAppear'		: DTHologramAppear(); break;
		case 'DTHologramDisappear'	: DTHologramDisappear(); break;
		case 'TortureKnockConvo'	: TortureKnockConvo(); break;
		case 'DTDropItems'		: DTDropItems(); break;
		default: super.HandleGameEvent(scriptFunction);
	}
}

function DecrementTimers()
{
	DecrementTimer('TimerStarted_SpawnMidasChopper','Timer_SpawnMidasChopper');
}

function HandleTimers()
{
	if ( IsTimerDone('TimerStarted_SpawnMidasChopper','Timer_SpawnMidasChopper') )
	{
		if (!flags.GetBool('MS_MidasIncoming'))
			SpawnMidasChopper();
	}
}

function SetupExclusions()
{
   CountExclusions[0]='Dazza'; // Make the DXE mission not fail when Dazza leaves if you trigger the alarm
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
}
