class tnmPassiveIRCLink extends UBrowserBufferedTCPLink;

var IpAddr			ServerIpAddr;

var string			ServerAddress;
var int				ServerPort;

var string			NickName;
var string			UserIdent;
var string			FullName;
var string			DefaultChannel;

var localized string InvalidAddressText;
var localized string ErrorBindingText;
var localized string ResolveFailedText;
var localized string ConnectedText;
var localized string ConnectingToText;
var localized string TimeOutError;
var localized string InviteString;

var string DisconnectReason;
var string VersionString;

var string server;

var Trestkon player;

function PostBeginPlay()
{
	Super.PostBeginPlay();
	Disable('Tick');
}

function Connect(string nick, string server, string channel)
{
	local int i;
	player=Trestkon(GetPlayerPawn());
	NickName=nick;
	FullName = "tnm user";
	UserIdent = "TNM";
	DefaultChannel = channel;

	i = InStr(server, ":");
	if(i == -1)
	{
		ServerAddress = server;
		ServerPort = 6667;
	}
	else
	{
		ServerAddress = Left(server, i);
		ServerPort = Int(Mid(server, i+1));
	}

	ResetBuffer();
	ServerIpAddr.Port = ServerPort;
	SetTimer(20, False);
	Resolve( ServerAddress );
}
/*
function Connect(tnmIRCInterface _interface)
{
	local int i;

	interface=_interface;
	NickName = interface.nick;
	FullName = "tnm user";
	UserIdent = "TNM";
	DefaultChannel = interface.channel;

	i = InStr(interface.server, ":");
	if(i == -1)
	{
		ServerAddress = interface.server;
		ServerPort = 6667;
	}
	else
	{
		ServerAddress = Left(interface.server, i);
		ServerPort = Int(Mid(interface.server, i+1));
	}

	ResetBuffer();
	ServerIpAddr.Port = ServerPort;
	SetTimer(20, False);
//	player.ClientMessageIRC( ConnectingToText@ServerAddress );
	Resolve( ServerAddress );
}*/

function string ChopLeft(string Text)
{
	while(Text != "" && InStr(": !", Left(Text, 1)) != -1)
		Text = Mid(Text, 1);
	return Text;
}

function string RemoveNickPrefix(string Nick)
{
	while(Nick != "" && InStr(":@+%", Left(Nick, 1)) != -1)
		Nick = Mid(Nick, 1);
	return Nick;
}

function string Chop(string Text)
{
	while(Text != "" && InStr(": !", Left(Text, 1)) != -1)
		Text = Mid(Text, 1);
	while(Text != "" && InStr(": !", Right(Text, 1)) != -1)
		Text = Left(Text, Len(Text)-1);

	return Text;
}

function Resolved( IpAddr Addr )
{
	// Set the address
	ServerIpAddr.Addr = Addr.Addr;

	// Handle failure.
	if( ServerIpAddr.Addr == 0 )
	{
		player.ClientMessageIRC( InvalidAddressText );
//		interface.bNoRetry=true;
//		interface.ConnectFailed();
		return;
	}

	// Display success message.
	Log( "UBrowserIRCLink: Server is "$ServerAddress$":"$ServerIpAddr.Port );

	// Bind the local port.
	if( BindPort() == 0 )
	{
		player.ClientMessageIRC( ErrorBindingText );
//		interface.bNoRetry=true;
//		interface.ConnectFailed();
		return;
	}

	Open( ServerIpAddr );
}

event Closed()
{
//	interface.Disconnected("Connection terminated by user");
	player.ClientMessageIRC("* Connection terminated by user");
}

// Host resolution failue.
function ResolveFailed()
{
	player.ClientMessageIRC(ResolveFailedText);
//	interface.ConnectFailed();
}

event Timer()
{
	player.ClientMessageIRC(TimeOutError);
//	interface.ConnectFailed();
	return;
}

event Opened()
{
	SetTimer(0, False);
	player.ClientMessageIRC(ConnectedText);
	Enable('Tick');
	GotoState('LoggingIn');
}

function Tick(float DeltaTime)
{
	local string Line;

	DoBufferQueueIO();
	if(ReadBufferedLine(Line))
		ProcessInput(Line);
}

function SendCommandText(string Text)
{
	local int i, j;
	local string Cmd, Temp, Temp2;

	// Process fake commands like /MSG
	if(Left(Text, 4) ~= "MSG ")
		Text = "PRIVMSG "$Mid(Text, 4);
	if(Left(Text, 6) ~= "LEAVE ")
		Text = "PART "$Mid(Text, 6);

	// Add colons for commands: PRIVMSG, QUIT, KILL, KICK, NOTICE
	i = InStr(Text, " ");
	if(i != -1)
	{
		Cmd = Caps(Left(Text, i));
		Text = Cmd$Mid(Text, i);

		switch(Cmd)
		{
		// CMD nick :message
		case "PRIVMSG":
		case "NOTICE":
		case "KILL":
		case "TOPIC":
			Temp = ChopLeft(Mid(Text, i+1));
			i = InStr(Temp, " ");
			if(i != -1)
				Text = Cmd@Left(Temp, i)$" :"$ChopLeft(Mid(Temp, i+1));
			break;
		// hack for CTCP
		case "CTCP":
			Temp = ChopLeft(Mid(Text, i+1));
			i = InStr(Temp, " ");
			if(i != -1)
				Text = "PRIVMSG "$Left(Temp, i)$" :"$Chr(1)$ChopLeft(Mid(Temp, i+1))$Chr(1);
			break;
		// CMD #channel nick :message
		case "KICK":
			Temp = ChopLeft(Mid(Text, i+1));
			i = InStr(Temp, " ");
			if(i != -1)
			{
				Temp2 = ChopLeft(Mid(Temp, i+1));
				j = InStr(Temp2, " ");
				if(j != -1)
					Text = Cmd@Left(Temp, i)@Left(Temp2, j)$" :"$ChopLeft(Mid(Temp2, j+1));
			}
			break;
		// CMD :message
		case "QUIT":
			Text = Cmd$" :"$ChopLeft(Mid(Text, i+1));
			break;
		}
	}
	else
		Text = Caps(Text);	

	SendBufferedData(Text$CRLF);
}

function SendChannelText(string Channel, string Text)
{
//	interface.Talk(NickName,Text);
	player.ClientMessageIRC("<"$NickName$">"@Text);
	SendBufferedData("PRIVMSG "$Channel$" :"$Text$CRLF);
}

function SendChannelAction(string Channel, string Text)
{
//	interface.Action(NickName,Text);
	player.ClientMessageIRC("*"@NickName@Text);
	SendBufferedData("PRIVMSG "$Channel$" :"$Chr(1)$"ACTION "$Text$Chr(1)$CRLF);
}

function SendPrivateText(string Reciever, string Text)
{
//	interface.PrivateText(Reciever,Text);
	player.ClientMessageIRC("*"$Reciever$"*"@Text);
	SendBufferedData("PRIVMSG"@Reciever@":"$Text$CRLF);
}

function ProcessInput(string Line)
{
	// Respond to PING
	if(Left(Line, 5) == "PING ")
		SendBufferedData("PONG "$Mid(Line, 5)$CRLF);
}

state LoggingIn
{
	function ProcessInput(string Line)
	{
		local string Temp;
		
		Temp = ParseDelimited(Line, " ", 2);

		if(ParseDelimited(Line, " ", 1)== "ERROR")
			player.ClientMessageIRC(ChopLeft(ParseDelimited(Line, ":", 2, True)));

		// Handle nick already in use on connect...
		if(Temp == "433")
		{
			player.ClientMessageIRC(ChopLeft(ParseDelimited(Line, " ", 3, True)));
		}
		else
		if(Int(Temp) != 0)
		{
			player.ClientMessageIRC(ChopLeft(ParseDelimited(Line, " ", 3, True)));
			GotoState('LoggedIn');
		}

		Global.ProcessInput(Line);
	}

	function SendCommandText(string Text)
	{
		Global.SendCommandText(Text);
		if(ParseDelimited(Text, " ", 1) ~= "NICK")
		{
//			interface.ChangedNick(NickName, Chop(ParseDelimited(Text, " ", 2)));
			player.ClientMessageIRC("*"@NickName@"is now known as"@Chop(ParseDelimited(Text, " ", 2)));
		}
	}

Begin:
	SendBufferedData("USER "$UserIdent$" localhost "$ServerAddress$" :"$FullName$CRLF);
	SendBufferedData("NICK "$NickName$CRLF);
}

state LoggedIn
{
	function ProcessInput(string Line)
	{
		local string Temp, Temp2, Temp3;
		local bool bAddModifier;
		local int i;
		local string Command;

		Global.ProcessInput(Line);
		
		Command = ParseDelimited(Line, " ", 2);

		if(ParseDelimited(Line, " ", 1) == "ERROR")
		{
			player.ClientMessageIRC(ChopLeft(ParseDelimited(Line, ":", 2, True)));
		}
		else if(Command == "JOIN")
		{
			Temp = ParseDelimited(Line, ":!", 2);
			/*if(Temp ~= NickName)
				Temp = "";*/
//			interface.Join(Temp);
			player.ClientMessageIRC("*"@Temp@"has joined"@DefaultChannel);
		}
		else if(Command == "PART")
		{
			Temp = ParseDelimited(Line, ":!", 2);
			/*if(Temp ~= NickName)
				Temp = "";*/
//			interface.Part(Temp);
			player.ClientMessageIRC("*"@Temp@"has left"@DefaultChannel);
		}
		else if(Command == "NICK")
		{
//			interface.ChangedNick(ParseDelimited(Line, ":!", 2), Chop(ParseDelimited(Line, " ", 3)));
			player.ClientMessageIRC("*"@ParseDelimited(Line, ":!", 2)@"is now known as"@Chop(ParseDelimited(Line, " ", 3)));
		}
		else if(Command == "QUIT")
		{
//			interface.UserQuit(ParseDelimited(Line, ":!", 2), ChopLeft(ParseDelimited(Line, " ", 3, True)));
			player.ClientMessageIRC("*"@ParseDelimited(Line, ":!", 2)@"has quit IRC (Reason:"@ChopLeft(ParseDelimited(Line, " ", 3, True))$").");
		}
		else if(Command == "353")	// NAMES
		{
			/*Temp2 = ParseDelimited(Line, "#", 2);
			Temp2 = ParseDelimited(Temp2, " :", 1);

			Temp = ParseDelimited(Line, ":", 3, True);
			while(Temp != "")
			{
				// Nickname
				Temp3 = ParseDelimited(Temp, " ", 1);

				interface.NewUser(RemoveNickPrefix(Temp3));

				if(Left(Temp3, 1) == "@")
					interface.ChangeOp(RemoveNickPrefix(Temp3), True);
				else if(Left(Temp3, 1) == "%")
					interface.ChangeHalfOp(RemoveNickPrefix(Temp3), True);
				else if(Left(Temp3, 1) == "+")
					interface.ChangeVoice(RemoveNickPrefix(Temp3), True);

				Temp = ParseDelimited(Temp, " ", 2, True);
			}	*/
		}
		else if(Command == "366")	// End of NAMES
		{
		}
		else if(Command == "331")	// RPL_NOTOPIC
		{
//			interface.JoinedChannel();
//			SendBufferedData("MODE"@interface.channel$CRLF);
		}
		else if(Command == "332")	// RPL_TOPIC
		{
//			interface.topic=ParseDelimited(Line,":",3,true);
			player.ClientMessageIRC("Topic is: '"$ParseDelimited(Line,":",3,true)$"'");
		}
		else if(Command == "333")	// TOPIC INFO
		{
/*			Temp2=ParseDelimited(Line," ",5);
			Temp3=left(Temp2,InStr(Temp2,"!"));
			Temp3=Temp3@"("$right(Temp2,len(Temp2)-InStr(Temp2,"!")-1)$")";
			interface.topic_user=Temp3;
			Temp3=ParseDelimited(Line," ",6,true);
			interface.SetTopicTime(int(Temp3));
//			interface.JoinedChannel();
			SendBufferedData("MODE"@interface.channel$CRLF);*/
		}
		else if(Command == "324")
		{
/*			interface.modes=ParseDelimited(Line," ",5,true);
			interface.JoinedChannel();*/
		}
		else if(Command == "341")   // RPL_INVITING
		{
		}
/*		else if(Command == "301")	// RPL_AWAY
		{
			SystemPage.IsAway(Chop(ParseDelimited(Line, " ", 4)), ChopLeft(ParseDelimited(Line, ":", 3, True)));
		}
		else if(Command == "NOTICE")
		{
			Temp = ParseDelimited(Line, ": ", 2);
			Temp2 = ParseDelimited(Line, ":! ", 2);

			if(InStr(Temp, "!") != -1 && InStr(Temp2, ".") == -1)
			{
				// it's a Nick.
				Temp = ChopLeft(ParseDelimited(Line, " ", 4, True));
				if(Asc(Left(Temp, 1)) == 1 && Asc(Right(Temp, 1)) == 1)
					SystemPage.CTCP("", Temp2, Mid(Temp, 1, Len(Temp) - 2));
				else
					SystemPage.UserNotice(Temp2, Temp);
			}
			else
				player.ClientMessageIRC(ChopLeft(ParseDelimited(Line, " ", 4, True)));
		}*/
		else if(Command == "329") //some channel number that's sent that I haven't had luck googling
		{
		}
		else if(Int(Command)!= 0)
		{
			player.ClientMessageIRC(ChopLeft(ParseDelimited(Line, " ", 4, True)));
		}
		else if(Command == "MODE")
		{/*
			// channel mode
			Temp = Chop(ParseDelimited(Line, " ", 4));
			// channel
			Temp3 = Chop(ParseDelimited(Line, " ", 3));
			i = 5;
			bAddModifier = True;
			while(Temp != "")
			{
				Temp2 = Left(Temp, 1);
				if(Temp2 == "+")
					bAddModifier = True;
				if(Temp2 == "-")
					bAddModifier = False;

				if(Temp2 == "o")
				{
					interface.ChangeOp(Chop(ParseDelimited(Line, " ", i)), bAddModifier);
					i++;
				}

				if(Temp2 == "h")
				{
					interface.ChangeHalfOp(Chop(ParseDelimited(Line, " ", i)), bAddModifier);
					i++;
				}
					
				if(Temp2 == "v")
				{
					interface.ChangeVoice(Chop(ParseDelimited(Line, " ", i)), bAddModifier);
					i++;
				}

				Temp = Mid(Temp, 1);
			}*/
			 
//			interface.SetMode(ParseDelimited(Line, ":!", 2), ChopLeft(ParseDelimited(Line, " ", 4, True)));
			player.ClientMessageIRC("*"@ParseDelimited(Line, ":!", 2)@"sets mode:"@ChopLeft(ParseDelimited(Line, " ", 4, True)));

		}
		else if(Command == "KICK")
		{
//			interface.Kick(Chop(ParseDelimited(Line, " ", 4)), ParseDelimited(Line, ":!", 2), ChopLeft(ParseDelimited(Line, ":", 3, True)));
		}
		else if(Command == "INVITE")
		{
			player.ClientMessageIRC(ParseDelimited(Line, ":!", 2)@InviteString@ParseDelimited(Line, ":", 3));	
		}
		else if(command == "TOPIC")
		{
//			interface.UserSetTopic(ParseDelimited(Line,":!",2),ParseDelimited(Line,":",3,true));
			player.ClientMessageIRC("*"@ParseDelimited(Line,":!",2)@"sets topic: '"$ParseDelimited(Line,":",3,true)$"'");
		}
		else if(Command == "PRIVMSG")
		{
			Temp = Chop(ParseDelimited(Line, " ", 3));
			Temp2 = ChopLeft(ParseDelimited(Line, " ", 4, True));

			if(Mid(Temp2, 1, 7) == "ACTION " && Asc(Left(Temp2, 1))==1 && Asc(Right(Temp2, 1))==1)
			{
				Temp2 = Mid(Temp2, 8);
				Temp2 = Left(Temp2, Len(Temp2) - 1);

				//if(Temp != "" && InStr("&#@", Left(Temp, 1)) != -1)
//					interface.action(ParseDelimited(Line, ":!", 2), Temp2);
				player.ClientMessageIRC("*"@ParseDelimited(Line, ":!", 2)@Temp2);
				/*else
					interface.PrivateAction(ParseDelimited(Line, ":!", 2), Temp2);*/
			}
			else if(Asc(Left(Temp2, 1))==1 && Asc(Right(Temp2, 1))==1)
			{
				Temp2 = Mid(Temp2, 1, Len(Temp2) - 2);
				
				switch(Temp2)
				{
				case "BREAKOUT":
					SendBufferedData("NOTICE "$ParseDelimited(Line, ":!", 2)$" :"$Chr(1)
							$"BREAKOUT"@"Breakout high score:"@player.GameHighScoreBreakout$Chr(1)$CRLF);
					break;
				case "TETRIS":
					SendBufferedData("NOTICE "$ParseDelimited(Line, ":!", 2)$" :"$Chr(1)
							$"TETRIS"@"Tetris high score:"@player.GameHighScoreTetris$Chr(1)$CRLF);
					break;
				case "DXPONG":
					SendBufferedData("NOTICE "$ParseDelimited(Line, ":!", 2)$" :"$Chr(1)
							$"DXPONG"@"Pong high score:"@player.GameHighScorePong$Chr(1)$CRLF);
					break;
				case "LIGHTSOUT":
					SendBufferedData("NOTICE "$ParseDelimited(Line, ":!", 2)$" :"$Chr(1)
							$"LIGHTSOUT"@"Lights out puzzles solved:"@player.GameHighScoreLightsOut$Chr(1)$CRLF);
					break;
				case "TIME":
					if(class'tnmTime'.static.IsEnabled())
						SendBufferedData("NOTICE "$ParseDelimited(Line, ":!", 2)$" :"$Chr(1)
							$ "TIME"
							@ left(class'tnmTime'.static.GetDayOfWeekStr(),3)
							@ left(class'tnmTime'.static.GetMonthStr(),3)
							@ class'tnmTime'.static.GetDate()
							@ right("0"$class'tnmTime'.static.GetHour(),2)$":"
							$ right("0"$class'tnmTime'.static.GetMinute(),2)$":"
							$ right("0"$class'tnmTime'.static.GetSecond(),2)
							@ class'tnmTime'.static.GetYear()
							$ Chr(1)$CRLF);					
					break;
				case "VERSION":
					SendBufferedData("NOTICE "$ParseDelimited(Line, ":!", 2)$" :"$Chr(1)$"VERSION "$VersionString$Level.EngineVersion$Chr(1)$CRLF);
//					SystemPage.CTCP(Temp, ParseDelimited(Line, ":!", 2), Temp2);
					break;
				default:
//					SystemPage.CTCP(Temp, ParseDelimited(Line, ":!", 2), Temp2);
					break;
				}
			}
			else
			{
				if(Temp != "" && InStr("&#@", Left(Temp, 1)) != -1)
					player.ClientMessageIRC("<"$ParseDelimited(Line, ":!", 2)$">"@Temp2);
//					interface.Talk(ParseDelimited(Line, ":!", 2), Temp2);
				else
					player.ClientMessageIRC("*"$ParseDelimited(Line, ":!", 2)$"*"@Temp2);
//					interface.PrivateText(ParseDelimited(Line, ":!", 2), Temp2);
			}
		}
	}
Begin:
	JoinChannel(DefaultChannel);
}

function JoinChannel(string Channel)
{
	player.ClientMessageIRC("* Joining"@Channel);
	if(Left(Channel, 1) == "#")
		SendBufferedData("JOIN "$Channel$CRLF);
}

function PartChannel(string Channel)
{
	player.ClientMessageIRC("* Parting"@Channel);
	if(Left(Channel, 1) == "#")
		SendBufferedData("PART "$Channel$CRLF);
}

function SetNick(string NewNick)
{
	SendBufferedData("NICK "$NewNick$CRLF);
}

function SetAway(string AwayText)
{
	SendBufferedData("AWAY :"$AwayText$CRLF);
}

function DestroyLink()
{
	if(IsConnected())
	{
		SendText("QUIT :"$DisconnectReason$CRLF);
		Close();
	}
	else
		Destroy();
}

defaultproperties
{
    InvalidAddressText="Invalid server address, aborting."
    ErrorBindingText="Error binding local port, aborting."
    ResolveFailedText="Failed to resolve server address, aborting."
    ConnectedText="Connected."
    ConnectingToText="Connecting to"
    TimeOutError="Timeout connecting to server."
    InviteString="invites you to join"
    DisconnectReason="TNM Ingame IRC (Passive). Created by NVShacker."
    VersionString="NVShacker's TNM IRC Client version "
}
