class tnmConPlay extends conplay;

const killedlabel = "Killed_";
const separatorlabel = "_and_";

//#exec new TrueTypeFontFactory Name="tnmConFont" FontName="Calibri" Height=16 AntiAlias=1 XPad=2 CharactersPerPage=64
//#exec new TrueTypeFontFactory Name="tnmConFontLarge" FontName="Calibri" Height=18 AntiAlias=1 XPad=2 CharactersPerPage=64

function PostTerminateConversation()
{
	local name triggertag;
	local trigger t;
	local name interuptedflag;

	if ( con != none )
	{
		interuptedflag = player.rootWindow.StringToName( con.conName $ "_Interrupted" );
		if ( !player.flagBase.GetBool(interuptedflag) )
		{
			triggertag = player.rootWindow.StringToName(con.conName $ "_Stopped");
			if(triggertag!='') //can never be too safe
				foreach allactors(class'trigger', t, triggertag)
				{
					t.Trigger(none, none);
				}
		}
	}

	super.PostTerminateConversation();
}

function ConWinFinished()
{
	// Nuke the conversation window
	if (displayMode == DM_FirstPerson)
	{
		if (conWinFirst != None)
			conWinFirst.Destroy();
	}
	else
	{
		if (conWinThird != None)
			conWinThird.Destroy();

		// Show the hud display if this was a third-person convo
		if (!bForcePlay && !trestkon(player).bCinematic)
			rootWindow.hud.Show();
	}

	PostTerminateConversation();
 
	// Now nuke ourself.
	Destroy();
}

//remove bForcePlay checks
function AddConActor(Actor newConActor, bool bFirstPerson)
{	
	if ((newConActor != None))
	{
		// Only do if we have space and this pawn isn't already speaking
		if ((!IsConActorInList(newConActor)) && (conActorCount < 9))
		{
			ConActors[conActorCount++] = newConActor;

			if (newConActor.IsA('ScriptedPawn'))
				ScriptedPawn(newConActor).EnterConversationState(bFirstPerson);
			else if (newConActor.IsA('DeusExDecoration'))
				DeusExDecoration(newConActor).EnterConversationState(bFirstPerson);
		}
	}
}

function TurnSpeakingActors(Actor speaker, Actor speakingTo)
{
	TurnActor(speaker,    speakingTo);
	TurnActor(speakingTo, speaker);
}

function Bool StartConversation(DeusExPlayer newPlayer, optional Actor newInvokeActor, optional bool bForcePlay)
{
	if ( Super(ConPlayBase).StartConversation(newPlayer, newInvokeActor, bForcePlay) == False )
		return False;

	bEndingConversation = False;

	// Check to see if this conversation uses random camera placement
	randomCamera = con.bRandomCamera;

	// Based on whether we're in first-person or third-person mode, 
	// we need to derive our conversation window differently.  First-person
	// conversation mode is non-interactive and only allows speech, for
	// the most part.

	if ( con.bFirstPerson )
	{
		displayMode = DM_FirstPerson;

		conWinFirst = rootWindow.hud.CreateConWindowFirst();

		// Initialize Windowing System
		conWinFirst.conPlay = Self;
	}
	else
	{
		displayMode = DM_ThirdPerson;

		// Hide the hud display if this is a third-person convo
		rootWindow.hud.Hide();

		conWinThird = ConWindowActive(rootWindow.NewChild(Class'tnmConWindowActive', False));
		conWinThird.SetForcePlay(bForcePlay);

		// Setup default camera information, but only if bForcePlay is set to false
		if (!bForcePlay)
		{
			cameraInfo = con.CreateConCamera();
			cameraInfo.InitializeCameraValues(Self);

			if ( randomCamera )
				cameraInfo.SetupRandomCameraPosition();
		}

		// Initialize Windowing System
		conWinThird.conPlay = Self;

		// Align the conversation window
		conWinThird.SetWindowAlignments(HALIGN_Full, VALIGN_Full);
		conWinThird.Show();
	}

	// Check to see if this is a passive or interactive conversation
	// Passive conversations are beyond the PC's control and do not have
	// things like Choices, etc. in them.

	if ( con.bNonInteractive )
		playMode = PM_Passive;
	else
		playMode = PM_Active;

	// Grab the first event!
	currentEvent = con.eventList;

	// Create a ConHistory object
	if (!bForcePlay)
		SetupHistory(player.GetDisplayName(startActor, True));

	// Play this event!
	GotoState('PlayEvent');

	return True;
}

function EEventAction SetupEventRandomLabel( ConEventRandomLabel event, out String nextLabel )
{
	local RandomEventInfoLink link;
	local int index;

	if (event.bCycleEvents)
	{
		nextLabel = trestkon(player).GetRandomEventLabel( event );
	}
	else
	{
		// Pick a random label
		nextLabel = event.GetRandomLabel();
	}

	return EA_JumpToLabel;
}

function EEventAction SetupEventAddSkillPoints( ConEventAddSkillPoints event, out String nextLabel )
{
	player.SkillPointsAdd(event.pointsToAdd);
	player.ClientMessage(event.awardMessage);

	nextLabel = "";
	return EA_NextEvent;
}

function EEventAction SetupEventAddGoal( ConEventAddGoal event, out String nextLabel )
{
	local DeusExGoal goal;

	// First check to see if this goal exists
	goal = player.AddGoal(event.goalName, event.bPrimaryGoal);
//	goal.SetText(event.goalText);
	if ( event.bGoalCompleted )
		player.GoalCompleted(event.goalName);
	else
		goal.SetText(event.goalText);

	return EA_NextEvent;
}

function class<inventory> getitemclass(string item)
{
//	return class<inventory>( DynamicLoadObject( item, class'Class' ) );
	return class<inventory>(class'tnmUtil'.static.LookupClass(item));
}

function EEventAction SetupEventCheckObject( ConEventCheckObject event, out String nextLabel )
{
	local EEventAction nextAction;
	local Name keyName;
	local bool bHasObject;

	// Okay this is some HackyHack stuff here.  We want the ability to 
	// check if the player has a particular nanokey.  Sooooooo.
	
	if ((event.checkObject == None) && (Left(event.objectName, 3) == "NK_"))
	{
		// Look for key
		keyName    = player.rootWindow.StringToName(Right(event.ObjectName, Len(event.ObjectName) - 3));
		bHasObject = ((player.KeyRing != None) && (player.KeyRing.HasKey(keyName)));
	}
	else 
	{
		bHasObject = (player.FindInventoryType(getitemclass(event.objectname)) != None);
	}

	// Now branch appropriately

	if (bHasObject)
	{
		nextAction = EA_NextEvent;
		nextLabel  = "";
	}
	else
	{
		nextAction = EA_JumpToLabel;
		nextLabel  = event.failLabel;
	}

	return nextAction;
}

function EEventAction SetupEventTransferObject( ConEventTransferObject event, out String nextLabel )
{
	local EEventAction nextAction;
	local Inventory invItemFrom;
	local Inventory invItemTo;
	local ammo AmmoType;
	local bool bSpawnedItem;
	local bool bSplitItem;
	local int itemsTransferred;

/*
log("SetupEventTransferObject()------------------------------------------");
log("  event = " $ event);
log("  event.giveObject = " $ event.giveObject);
log("  event.fromActor  = " $ event.fromActor );
log("  event.toActor    = " $ event.toActor );
*/
	itemsTransferred = 1;

	if ( event.failLabel != "" )
	{
		nextAction = EA_JumpToLabel;
		nextLabel  = event.failLabel;
	}
	else
	{
		nextAction = EA_NextEvent;
		nextLabel = "";
	}

	// First verify that the receiver exists!
	if (event.toActor == None)
	{
		log("SetupEventTransferObject:  WARNING!  toActor does not exist!");
		log("  Conversation = " $ con.conName);
		return nextAction;
	}

	// First, check to see if the giver actually has the object.  If not, then we'll
	// fabricate it out of thin air.  (this is useful when we want to allow
	// repeat visits to the same NPC so the player can restock on items in some
	// scenarios).
	//
	// Also check to see if the item already exists in the recipient's inventory

	if (event.fromActor != None)
		invItemFrom = Pawn(event.fromActor).FindInventoryType(getitemclass(event.Objectname));

	invItemTo   = Pawn(event.toActor).FindInventoryType(getitemclass(event.Objectname));

//log("  invItemFrom = " $ invItemFrom);
//log("  invItemTo   = " $ invItemTo);

	// If the player is doing the giving, make sure we remove it from 
	// the object belt.

	// If the giver doesn't have the item then we must spawn a copy of it
	if (invItemFrom == None)
	{
		if ( event.FromActor.IsA('trestkon') )
			return nextAction;

		invItemFrom = Spawn(getitemclass(event.Objectname));
		bSpawnedItem = True;
	}

	// If we're giving this item to the player and he does NOT yet have it,
	// then make sure there's enough room in his inventory for the 
	// object!

	if ((invItemTo == None) &&
		(DeusExPlayer(event.toActor) != None) && 
	    (DeusExPlayer(event.toActor).FindInventorySlot(invItemFrom, True) == False))
	{
		// First destroy the object if we previously Spawned it
		if (bSpawnedItem)
			invItemFrom.Destroy();
				
		return nextAction;
	}

	// Okay, there's enough room in the player's inventory or we're not 
	// transferring to the player in which case it doesn't matter.
	//
	// Now check if the recipient already has the item.  If so, we are just
	// going to give it to him, with a few special cases.  Otherwise we
	// need to spawn a new object.

	if (invItemTo != None)
	{
		// Check if this item was in the player's hand, and if so, remove it
		RemoveItemFromPlayer(invItemFrom);

		// If this is ammo, then we want to just increment the ammo count
		// instead of adding another ammo to the inventory

		if (invItemTo.IsA('Ammo'))
		{
			// If this is Ammo and the player already has it, make sure the player isn't
			// already full of this ammo type! (UGH!)
			if (!Ammo(invItemTo).AddAmmo(Ammo(invItemFrom).AmmoAmount))
			{
				invItemFrom.Destroy();
				return nextAction;
			}

			// Destroy our From item
			invItemFrom.Destroy();		
		}

		// Pawn cannot have multiple weapons, but we do want to give the 
		// player any ammo from the weapon
		else if ((invItemTo.IsA('Weapon')) && (DeusExPlayer(event.ToActor) != None))
		{

			AmmoType = Ammo(DeusExPlayer(event.ToActor).FindInventoryType(Weapon(invItemTo).AmmoName));

			if ( AmmoType != None )
			{
				// Special case for Grenades and LAMs.  Blah.
				if ((AmmoType.IsA('AmmoEMPGrenade')) || 
				    (AmmoType.IsA('AmmoGasGrenade')) || 
					(AmmoType.IsA('AmmoNanoVirusGrenade')) ||
					(AmmoType.IsA('AmmoLAM')))
				{
					if (!AmmoType.AddAmmo(event.TransferCount))
					{
						invItemFrom.Destroy();
						return nextAction;
					}
				}
				else
				{
					if (!AmmoType.AddAmmo(Weapon(invItemTo).PickUpAmmoCount))
					{
						invItemFrom.Destroy();
						return nextAction;
					}

					event.TransferCount = Weapon(invItemTo).PickUpAmmoCount;
					itemsTransferred = event.TransferCount;
				}

				if (event.ToActor.IsA('DeusExPlayer'))
					DeusExPlayer(event.ToActor).UpdateAmmoBeltText(AmmoType);

				// Tell the player he just received some ammo!
				invItemTo = AmmoType;
			}
			else
			{
				// Don't want to show this as being received in a convo
				invItemTo = None;
			}

			// Destroy our From item
			invItemFrom.Destroy();
			invItemFrom = None;
		}

		// Otherwise check to see if we need to transfer more than 
		// one of the given item
		else
		{
			itemsTransferred = AddTransferCount(invItemFrom, invItemTo, event, Pawn(event.toActor), False);

			// If no items were transferred, then the player's inventory is full or 
			// no more of these items can be stacked, so abort.
			if (itemsTransferred == 0)
				return nextAction;

			// Now destroy the originating object (which we either spawned
			// or is sitting in the giver's inventory), but check to see if this 
			// item still has any copies left first

			if (((invItemFrom.IsA('DeusExPickup')) && (DeusExPickup(invItemFrom).bCanHaveMultipleCopies) && (DeusExPickup(invItemFrom).NumCopies <= 0)) ||
			   ((invItemFrom.IsA('DeusExPickup')) && (!DeusExPickup(invItemFrom).bCanHaveMultipleCopies)) ||
			   (!invItemFrom.IsA('DeusExPickup')))
			{
				invItemFrom.Destroy();
				invItemFrom = None;
			}
		}
	}

	// Okay, recipient does *NOT* have the item, so it must be give
	// to that pawn and the original destroyed
	else
	{
		// If the item being given is a stackable item and the 
		// recipient isn't receiving *ALL* the copies, then we 
		// need to spawn a *NEW* copy and give that to the recipient.
		// Otherwise just do a "SpawnCopy", which transfers ownership
		// of the object to the new owner.

		if ((invItemFrom.IsA('DeusExPickup')) && (DeusExPickup(invItemFrom).bCanHaveMultipleCopies) && 
		    (DeusExPickup(invItemFrom).NumCopies > event.transferCount))
		{
			itemsTransferred = event.TransferCount;
			invItemTo = Spawn(getitemclass(event.Objectname));
			invItemTo.GiveTo(Pawn(event.toActor));
			DeusExPickup(invItemFrom).NumCopies -= event.transferCount;
			bSplitItem   = True;
			bSpawnedItem = True;
		}
		else
		{
			invItemTo = invItemFrom.SpawnCopy(Pawn(event.toActor));
		}

//log("  invItemFrom = "$  invItemFrom);
//log("  invItemTo   = " $ invItemTo);

		if (DeusExPlayer(event.toActor) != None)
			DeusExPlayer(event.toActor).FindInventorySlot(invItemTo);

		// Check if this item was in the player's hand *AND* that the player is 
		// giving the item to someone else.
		if ((DeusExPlayer(event.fromActor) != None) && (!bSplitItem))
			RemoveItemFromPlayer(invItemFrom);

		// If this was a DataVaultImage, then the image needs to be 
		// properly added to the datavault
		if ((invItemTo.IsA('DataVaultImage')) && (event.toActor.IsA('DeusExPlayer')))
		{
			DeusExPlayer(event.toActor).AddImage(DataVaultImage(invItemTo));
				
			if (conWinThird != None)
				conWinThird.ShowReceivedItem(invItemTo, 1);
			else
				DeusExRootWindow(player.rootWindow).hud.receivedItems.AddItem(invItemTo, 1);

			invItemFrom = None;
			invItemTo   = None;
		}

		// Special case for Credit Chits also
		else if ((invItemTo.IsA('Credits')) && (event.toActor.IsA('DeusExPlayer')))
		{
			if (conWinThird != None)
				conWinThird.ShowReceivedItem(invItemTo, Credits(invItemTo).numCredits);
			else
				DeusExRootWindow(player.rootWindow).hud.receivedItems.AddItem(invItemTo, Credits(invItemTo).numCredits);

			player.Credits += Credits(invItemTo).numCredits;
			
			invItemTo.Destroy();

			invItemFrom = None;
			invItemTo   = None;
		}

		// Now check to see if the transfer event specified transferring
		// more than one copy of the object
		else
		{
			itemsTransferred = AddTransferCount(invItemFrom, invItemTo, event, Pawn(event.toActor), True);

			// If no items were transferred, then the player's inventory is full or 
			// no more of these items can be stacked, so abort.
			if (itemsTransferred == 0)
			{
				invItemTo.Destroy();
				return nextAction;
			}

			// Update the belt text
			if (invItemTo.IsA('Ammo'))
				player.UpdateAmmoBeltText(Ammo(invItemTo));
			else
				player.UpdateBeltText(invItemTo);
		}
	}

	// Show the player that he/she/it just received something!
	if ((DeusExPlayer(event.toActor) != None) && (conWinThird != None) && (invItemTo != None))
	{
		if (conWinThird != None)
			conWinThird.ShowReceivedItem(invItemTo, itemsTransferred);
		else
			DeusExRootWindow(player.rootWindow).hud.receivedItems.AddItem(invItemTo, itemsTransferred);
	}

	nextAction = EA_NextEvent;
	nextLabel = "";

	return nextAction;
}

static function bool IsList(out string list)
{
  local bool result;
  result = Left(list,len(killedlabel)) ~= killedLabel;
  if (result)
    list = Right(list,len(list) - len(killedLabel));
  return result;
}

static function bool GetMap(out string list, out string map, out int kill)
{
  local string str;
  local int pos;
  pos = instr(list, separatorlabel);
  if ( pos == -1 )
  {
    for(pos=len(list)-1;pos>=0;pos--)
      if(mid(list,pos,1)=="_")
        break;
    map = left(list, pos);
    Log( "kill string: " $ mid(list, pos+1));
    kill = int(mid(list, pos+1));
    list = "";
    return false;
  }
  else
  {
    kill = 0;
    map = left( list, pos );
    list = right( list, len(list) - pos - len(separatorlabel) );
    return true;
  }
}

function EEventAction SetupEventCheckFlag( ConEventCheckFlag event, out String nextLabel )
{
	return class'tnmconplay'.static.g_SetupEventCheckFlag(deusexplayer(GetPlayerPawn()),event,nextLabel);
}

static function bool g_FlagSet( name flagname, deusexplayer player )
{
	local string list;
	local int killed, basealive, kill, mapbasealive;
	local bool next;
	local string map;
	local bool check;
	local tnmmissionscript script;

	if ( left(string(flagName),11) == "Killed_M23_" )
	{
		list="Killed_23_ABIExterior_and_23_ABIInterior_and_23_ABIRuins_and_23_ABILabs_"$mid(string(flagName), 11);
	}
	else
	{
		list = string(flagName);
	}
	if ( IsList(list) )
	{
		killed = 0;
		basealive = 0;
		next=true;
		while(next)
		{
			next=class'tnmconplay'.static.GetMap(list, map, kill);
			mapbasealive = player.flagBase.GetInt(player.rootwindow.StringToName(map $ "_startcount"));
			if ( mapbasealive > 0)
			{
				foreach player.allactors( class'tnmmissionscript', script, )
				{
					Log(mapbasealive);
					Log(script.CountLiving(map));
					killed += mapbasealive - script.CountLiving(map);
					break;
				}
				basealive += mapbasealive;
			}
		}

		check= basealive == 0 || 100 * killed / basealive < kill || killed == 0;
	}
	else if ( flagName == 'HAS_LlamaHostageCorpse' )
	{
		check=player.inhand != none && player.inhand.isA( 'tnmpovcorpse' ) && tnmpovcorpse(player.inhand).givenbindname == "LlamaHostage";
	}
	else if ( flagName == 'HAS_MasterKaleCorpse' )
	{
		check=player.inhand != none && player.inhand.isA( 'tnmpovcorpse' ) && tnmpovcorpse(player.inhand).givenbindname == "Master_Kale";
	}
	else
	{
		check=player.flagBase.GetBool(flagName);
	}

	return check;
}

static function EEventAction g_SetupEventCheckFlag( deusexplayer player, ConEventCheckFlag event, out String nextLabel )
{
	local ConFlagRef currentRef;
	local EEventAction action;
	local string list;
	local int kill;
	local int killed;
	local int basealive;
	local int mapbasealive;
	local string map;
	local bool check, next;
	local int i;

	// Default values if we actually make it all the way 
	// through the while loop below.

	nextLabel = event.setLabel;
	action = EA_JumpToLabel;
	
	// Loop through our list of FlagRef's, checking the value of each.
	// If we hit a bad match, then we'll stop right away since there's
	// no point of continuing.

	currentRef = event.flagRef;
	while( currentRef != None )
	{	
		if ( class'tnmconplay'.static.g_FlagSet(currentRef.flagName, player) != currentRef.value )
		{
			nextLabel = "";
			action = EA_NextEvent;
			break;
		}

		currentRef = currentRef.nextFlagRef;
	}
	
	return action;
}

state ConPlayAnim
{
 Begin:
     ConEventAnimation(currentEvent).bLoopAnim = (ConEventAnimation(currentEvent).playMode == 0);

     if ( ConEventAnimation(currentEvent).sequence == 'FinishPlayingAnim' )
          ConEventAnimation(currentEvent).eventOwner.FinishAnim();
     else if ( ConEventAnimation(currentEvent).bLoopAnim )
          ConEventAnimation(currentEvent).eventOwner.LoopAnim( ConEventAnimation(currentEvent).sequence );
     else
          ConEventAnimation(currentEvent).eventOwner.PlayAnim( ConEventAnimation(currentEvent).sequence );

     if ((ConEventAnimation(currentEvent).playLength > 0))
     {
          Sleep(Float(ConEventAnimation(currentEvent).playLength));
	  ConEventAnimation(currentEvent).eventOwner.FinishAnim();
     }
     else if (( !ConEventAnimation(currentEvent).bLoopAnim ) && ( ConEventAnimation(currentEvent).bFinishAnim ))
          ConEventAnimation(currentEvent).eventOwner.FinishAnim();

     currentEvent = currentEvent.nextEvent;
     GotoState('PlayEvent');
}

function int FontIndex()
{
	local int resWidth;
	resWidth = GetCurrentResolutionWidth();

	if(resWidth>1152)
		return 0;
	return 1;
}

function Font GetCurrentNameFont()
{
	if(trestkon(player).bUseSmallConplayfonts)
		return ConversationNameFonts[1];
	else
		return ConversationNameFonts[FontIndex()];
}

function Font GetCurrentSpeechFont()
{
	if(trestkon(player).bUseSmallConplayfonts)
		return ConversationSpeechFonts[1];
	else
		return ConversationSpeechFonts[FontIndex()];
}

defaultproperties
{
    ConversationSpeechFonts(0)=Font'DeusExUI.FontConversationLarge'
    ConversationSpeechFonts(1)=Font'DeusExUI.FontConversation'
    ConversationNameFonts(0)=Font'DeusExUI.FontConversationLargeBold'
    ConversationNameFonts(1)=Font'DeusExUI.FontConversationBold'
}
