//=============================================================================
// TNMPawn.
//=============================================================================
class TNMPawn extends ScriptedPawn
	abstract;

var int i,j; //can be used as local int

var() bool bSmartWeapons;
var() bool bEmitCarcass; //prevents people from freaking out when the carcass is spawned, for missionscript purposes

//<ALARM VARS>
	enum EAlarmReason  {
		AR_None,			//includes alarm before attack and before flee
		AR_FoundCarcass,
		AR_DisabledBot,
		AR_SecurityAlert,
		AR_Fire,
		AR_LostPlayer,
		AR_KilledPlayer,
	};

	var() bool bRestoreOrders;
	var name originalOrders;
	var name originalOrderTag;

	var(AlarmTrigger) bool bAlarmCarcass;
	var(AlarmTrigger) bool bAlarmBot;
	var(AlarmTrigger) bool bAlarmSecurity;
	var(AlarmTrigger) bool bAlarmFire;
	var(AlarmTrigger) bool bAlarmLostPlayer;
	var(AlarmTrigger) bool bAlarmKilledPlayer;
	var Ealarmreason alarmreason;
//</ALARM VARS>

//<DAMAGE VARS>
	var float Fat;
	var bool bImmuneToGib;
//</DAMAGE VARS>

//<FIREWALL VARS>
	var bool bFirewall;
	var bool bFading;
	var float FadeTime;
//</FIREWALL VARS>

//<AUG VARS>
	var(tnmpawnaugs) float AugHealthLimit;
	var(tnmpawnaugs) bool bAugmented;
	var tnmpawnaugmanager TNMPAM; //whooo achronyms
	var(tnmpawnaugs) float Energy;
	var(tnmpawnaugs) class<tnmaugmentation> Augs[13];
	var float stealthmodifier;
	var bool bvisionactive;
//</AUG VARS>

//<THEFT VARS>
	var(Reactions) bool bReactTheft;
//</THEFT VARS>

//formation vars
var int 		formationDesiredDistance;
var int 		formationDesiredYaw;
var int 		formationInitialYaw;
var Name		formationPatrolTag;
//var FormationController formationcontroller;
var int			formationID;

var string augstring;
var float stuntime;

var bool bHelmeted;

var bool bHateBreakAndEnter;

//DDL breath moisture code
var particlegenerator breathgen;
var float breathtimer;
var float breathtime;
var() bool bVisibleBreath;
var() bool bUseLipsyncHack;
var bool bLipsyncHackActive;

var float timewithouto2;

//Copied here from Pawn to check for missing lip synching animations
function LipSynch(float deltaTime)
{
	local name animseq;
	local float rnd;
	local float tweentime;
	local tnmconplay cp;

	// update the animation timers that we are using
	animTimer[0] += deltaTime;
	animTimer[1] += deltaTime;
	animTimer[2] += deltaTime;

	if (bIsSpeaking)
	{
		//log(nextPhoneme, name);
		// if our framerate is high enough (>20fps), tween the lips smoothly
		if (Level.TimeSeconds - animTimer[3]  < 0.05)
			tweentime = 0.1;
		else
			tweentime = 0.0;

		// the last animTimer slot is used to check framerate
		animTimer[3] = Level.TimeSeconds;

		//log(nextPhoneme$" "$bUseLipsyncHack,name);
		if(bLipsyncHackActive || (nextPhoneme == "" && bUseLipsyncHack))
		{
			bLipsyncHackActive = true;
			switch(rand(8))
			{
			case 0:
				nextPhoneme="A";
				break;
			case 1:
				nextPhoneme="E";
				break;
			case 2:
				nextPhoneme="F";
				break;
			case 3:
				nextPhoneme="M";
				break;
			case 4:
				nextPhoneme="O";
				break;
			case 5:
				nextPhoneme="T";
				break;
			case 6:
				nextPhoneme="U";
				break;
			case 7:
				nextPhoneme="X";
				break;
			}
		}

		if (nextPhoneme == "A")
			animseq = 'MouthA';
		else if (nextPhoneme == "E")
			animseq = 'MouthE';
		else if (nextPhoneme == "F")
			animseq = 'MouthF';
		else if (nextPhoneme == "M")
			animseq = 'MouthM';
		else if (nextPhoneme == "O")
			animseq = 'MouthO';
		else if (nextPhoneme == "T")
			animseq = 'MouthT';
		else if (nextPhoneme == "U")
			animseq = 'MouthU';
		else if (nextPhoneme == "X")
			animseq = 'MouthClosed';

		if (animseq != '')
		{
			if (lastPhoneme != nextPhoneme)
			{
				lastPhoneme = nextPhoneme;
				if (HasAnim(animseq))
					TweenBlendAnim(animseq, tweentime);
			}
		}
	}
	else if (bWasSpeaking)
	{
		bWasSpeaking = False;
		if ( HasAnim('MouthClosed') )
			TweenBlendAnim('MouthClosed', tweentime);
	}

	// blink randomly
	if (animTimer[0] > 2.0)
	{
		animTimer[0] = 0;
		if ( HasAnim('Blink') )
			if (FRand() < 0.4)
				PlayBlendAnim('Blink', 1.0, 0.1, 1);
	}

	LoopHeadConvoAnim();
	LoopBaseConvoAnim();
}

function bool GetCarcassData(actor sender, out Name killer, out Name alliance,
							 out Name CarcassName, optional bool bCheckName)
{
	local trestkon  dxPlayer;
	local DeusExCarcass carcass;
	local POVCorpse     corpseItem;
	local bool          bCares;
	local bool          bValid;

	alliance = '';
	killer   = '';

	bValid   = false;
	dxPlayer = trestkon(sender);
	carcass  = DeusExCarcass(sender);
	if (dxPlayer != None)
	{
		if (dxplayer.bBreakAndEnter && bHateBreakAndEnter) //hello major hack
		{
			killer      = 'Player';
			return true; //treat the player as if hes carrying a corpse
		}
		else
		{
			corpseItem = POVCorpse(dxPlayer.inHand);
			if (corpseItem != None)
			{
				if (corpseItem.bEmitCarcass)
				{
					alliance    = corpseItem.Alliance;
					killer      = corpseItem.KillerAlliance;
					CarcassName = corpseItem.CarcassName;
					bValid      = true;
				}
			}
		}
	}
	else if (carcass != None)
	{
		if (carcass.bEmitCarcass)
		{
			alliance    = carcass.Alliance;
			killer      = carcass.KillerAlliance;
			CarcassName = carcass.CarcassName;
			bValid      = true;
		}
	}

	bCares = false;
	if (bValid && (!bCheckName || !HaveSeenCarcass(CarcassName)))
	{
		if (bFearCarcass)
			bCares = true;
		else
		{
			if (GetAllianceType(alliance) == ALLIANCE_Friendly)
			{
				if (bHateCarcass)
					bCares = true;
				else if (bReactCarcass)
				{
					if (GetAllianceType(killer) == ALLIANCE_Hostile)
						bCares = true;
				}
			}
		}
	}

	return bCares;
}

function UpdateReactionCallbacks()
{
	if (bReactTheft)
	{
		AISetEventCallback('Theft', 'HandleTheft', , false, false, false, false);
	}
	else
	{
		AISetEventCallback('Theft', 'HandleFutz', , false, false, false, false);
	}
	super.UpdateReactionCallbacks();
}

function SetSkinStyle(ERenderStyle newStyle, optional texture newTex, optional float newScaleGlow)
{
	local int i;

	super.SetSkinStyle(newstyle,newTex,newScaleGlow);

	if(newStyle!=STY_Translucent || newTex==None)
		return;

	//yay reusable code
	if	(Mesh==LodMesh'GM_DressShirt_B')
	{
		MultiSkins[4]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_DressShirt')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_Jumpsuit' || Mesh==LodMesh'mp_jumpsuit')
	{
		MultiSkins[5]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_DressShirt_F')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_DressShirt_S')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_Suit')
	{
		MultiSkins[5]=Texture'BlackMaskTex';
		MultiSkins[6]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_Trench')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GM_Trench_F')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GFM_TShirtPants')
	{
		MultiSkins[3]=Texture'BlackMaskTex';
		MultiSkins[4]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GFM_SuitSkirt_F')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GFM_SuitSkirt')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GFM_Trench')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GFM_Dress')
	{
		//no glasses
	}
	else if	(Mesh==LodMesh'GMK_DressShirt_F')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
	else if	(Mesh==LodMesh'GMK_DressShirt')
	{
		MultiSkins[6]=Texture'BlackMaskTex';
		MultiSkins[7]=Texture'BlackMaskTex';
	}
}

function float GetCowerHeight()
{
	return (Default.CollisionHeight*0.75);
}

function PlayCowerBegin()
{
	super.PlayCowerBegin();
	SetBasedPawnSize(CollisionRadius, GetCowerHeight());
}

function PlayCowerEnd()
{
	super.PlayCowerEnd();
	ResetBasedPawnSize();
}

function HandleTheft(Name event, EAIEventState state, XAIParams params)
{
	if (state == EAISTATE_Begin || state == EAISTATE_Pulse)
		ReactToTheft();  // only players can steal
}

function ReactToTheft()
{
	if (bReactTheft && (FutzTimer <= 0) && !bDistressed) //put it on thesame timer as futzes
	{
		FutzTimer = 2.0;
		PlayTheftSound();
	}
}

function PlayTheftSound()
{
	local DeusExPlayer dxPlayer;
	local Name         conName;
	local string conNameString;

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if (dxPlayer != None)
	{
		if (dxPlayer.barkManager != None)
		{
			if (BarkBindName == "")
				conNameString = BindName $ "_Bark";
			else
				conNameString = BarkBindName $ "_Bark";

			conNameString = conNameString $ "Theft";

			// Take the string name and convert it to a name
			conName = DeusExRootWindow(dxPlayer.RootWindow).StringToName(conNameString);

			dxPlayer.StartConversationByName(conName, self, !bInterruptState);
		}
	}
}

function Destroyed()
{
	if(breathgen != none)
		breathgen.delayeddestroy();

	super.Destroyed();
	KillShadow(); //shadows were being left behind when filtering out pawns for difficulty settings
}

function FollowOrders(optional bool bDefer) //for Formation state -shacker
{
	if(Orders=='Formation')
	{
		FindOrderActor();
		if (bDefer)  // hack
			SetState(Orders);
		else
			GotoState(Orders);
	}
	else
		super.FollowOrders(bDefer);
}

function float GetAugScoreModifier(deusexplayer enemyplayer, class<Augmentation> aug)
{
	local float result;
	result = enemyPlayer.AugmentationSystem.GetAugLevelValue(aug);
	if (result == -1)
		return 0;
	else
	{
		result = 100 *  result;
		return result;
	}
}

function bool SwitchToBestWeapon()
{
	local Inventory    inv;
	local DeusExWeapon curWeapon;
	local float        score;
	local DeusExWeapon dxWeapon;
	local DeusExWeapon bestWeapon;
	local float        bestScore;
	local int          fallbackLevel;
	local int          curFallbackLevel;
	local bool         bBlockSpecial;
	local bool         bValid;
	local bool         bWinner;
	local float        minRange, accRange;
	local float        range, centerRange;
	local float        cutoffRange;
	local float        enemyRange;
	local float        minEnemy, accEnemy, maxEnemy;
	local ScriptedPawn enemyPawn;
	local tnmpawn      tpawn;
	local Robot        enemyRobot;
	local DeusExPlayer enemyPlayer;
	local float        enemyRadius;
	local bool         bEnemySet;
	local int          loopCount, i;  // hack - check for infinite inventory
	local Inventory    loopInv;       // hack - check for infinite inventory

	if (bInConversation)
		return false;

	if (ShouldDropWeapon())
	{
		DropWeapon();
		return false;
	}

	bBlockSpecial = false;
	dxWeapon = DeusExWeapon(Weapon);
	if (dxWeapon != None)
	{
		if (dxWeapon.AITimeLimit > 0)
		{
			if (SpecialTimer <= 0)
			{
				bBlockSpecial = true;
				FireTimer = dxWeapon.AIFireDelay;
			}
		}
	}

	bestWeapon      = None;
	bestScore       = 0;
	fallbackLevel   = 0;
	inv             = Inventory;

	bEnemySet   = false;
	minEnemy    = 0;
	accEnemy    = 0;
	enemyRange  = 400;  // default
	enemyRadius = 0;
	enemyPawn   = None;
	enemyRobot  = None;
	if (Enemy != None)
	{
		bEnemySet   = true;
		enemyRange  = VSize(Enemy.Location - Location);
		enemyRadius = Enemy.CollisionRadius;
		if (DeusExWeapon(Enemy.Weapon) != None)
			DeusExWeapon(Enemy.Weapon).GetWeaponRanges(minEnemy, accEnemy, maxEnemy);
		enemyPawn   = ScriptedPawn(Enemy);
		enemyRobot  = Robot(Enemy);
		enemyPlayer = DeusExPlayer(Enemy);
	}

	loopCount = 0;
	for ( inv = Inventory; inv != None; inv = inv.Inventory)
	{
		// THIS IS A MAJOR HACK!!!
		loopCount++;
		if (loopCount == 9999)
		{
			log("********** RUNAWAY LOOP IN SWITCHTOBESTWEAPON ("$self$") **********");
			loopInv = Inventory;
			i = 0;
			while (loopInv != None)
			{
				i++;
				if (i > 300)
					break;
				log("   Inventory "$i$" - "$loopInv);
				loopInv = loopInv.Inventory;
			}
		}

		curWeapon = DeusExWeapon(inv);
		if (curWeapon != None)
		{
			bValid = true;
			if (curWeapon.ReloadCount > 0)
			{
				if (curWeapon.AmmoType == None)
					bValid = false;
				else if (curWeapon.AmmoType.AmmoAmount < 1)
					bValid = false;
			}

			if ( curWeapon.beltDescription == "SPYWARE" )
				bValid = false;

			// Ensure we can actually use this weapon here
			if (bValid)
			{
				// lifted from DeusExWeapon...
				if ((curWeapon.EnviroEffective == ENVEFF_Air) || (curWeapon.EnviroEffective == ENVEFF_Vacuum) ||
				    (curWeapon.EnviroEffective == ENVEFF_AirVacuum))
					if (curWeapon.Region.Zone.bWaterZone)
						bValid = false;
			}

			if (bValid)
			{
				GetWeaponBestRange(curWeapon, minRange, accRange);
				cutoffRange = minRange+(CollisionRadius+enemyRadius);
				range = (accRange - minRange) * 0.5;
				centerRange = minRange + range;
				if (range < 50)
					range = 50;
				if (enemyRange < centerRange)
					score = (centerRange - enemyRange)/range;
				else
					score = (enemyRange - centerRange)/range;
				if ((minRange >= minEnemy) && (accRange <= accEnemy))
					score += 0.5;  // arbitrary
				if ((cutoffRange >= enemyRange-CollisionRadius) && (cutoffRange >= 256)) // do not use long-range weapons on short-range targets
					score += 10000;

				curFallbackLevel = 3;
				if (curWeapon.bFallbackWeapon && !bUseFallbackWeapons)
					curFallbackLevel = 2;
				if (!bEnemySet && !curWeapon.bUseAsDrawnWeapon)
					curFallbackLevel = 1;
				if ((curWeapon.AIFireDelay > 0) && (FireTimer > 0))
					curFallbackLevel = 0;
				if (bBlockSpecial && (curWeapon.AITimeLimit > 0) && (SpecialTimer <= 0))
					curFallbackLevel = 0;

				// Adjust score based on opponent and damage type.
				// All damage types are listed here, even the ones that aren't used by weapons... :)
				// (hacky...)


				if (enemyPlayer != none)
				{
					if(!curWeapon.bInstantHit)
					{
						if (!class<deusexprojectile>(curWeapon.ProjectileClass).default.bIgnoresNanoDefense)
						{
							score += enemyPlayer.AugmentationSystem.GetAugLevelValue(class'AugDefense');
						}
					}
				}

				switch (curWeapon.WeaponDamageType())
				{
					case 'Shocked':
						if(bSmartWeapons)
							if (enemyPlayer != none)
								score += GetAugScoreModifier( enemyplayer, class'AugShield' );
						break;
					case 'Exploded':
						// Massive explosions are always good
						score -= 0.2;
						if(bSmartWeapons)
							if (enemyPlayer != none)
								score += GetAugScoreModifier( enemyplayer, class'AugShield' );
						break;

					case 'Stunned':
						if (enemyPawn != None)
						{
							if (enemyPawn.bStunned)
								score += 1000;
							else
								score -= 1.5;
						}
						if (enemyPlayer != None)
							score += 10;
						break;

					case 'TearGas':
						if (enemyPawn != None)
						{
							if (enemyPawn.bStunned)
								//score += 1000;
								bValid = false;
							else
								score -= 5.0;
						}
						if (enemyRobot != None)
							//score += 10000;
							bValid = false;
						break;

					case 'HalonGas':
						if (enemyPawn != None)
						{
							if (enemyPawn.bStunned)
								//score += 1000;
								bValid = false;
							else if (enemyPawn.bOnFire)
								//score += 10000;
								bValid = false;
							else
								score -= 3.0;
						}
						if (enemyRobot != None)
							//score += 10000;
							bValid = false;
						break;

					case 'PoisonGas':
					case 'Poison':
					case 'PoisonEffect':
					case 'Radiation':
						if (enemyRobot != None)
							//score += 10000;
							bValid = false;
						break;

					case 'Burned':
					case 'Flamed':
						if(bSmartWeapons)
						{
							if (enemyPlayer != none)
								score += GetAugScoreModifier( enemyplayer, class'AugShield' );
						}
						if (enemyRobot != None)
							score += 0.5;
						break;

					case 'AutoShot':
					case 'Shot':
						if(bSmartWeapons)
							if (enemyPlayer != none)
								score += GetAugScoreModifier( enemyplayer, class'AugBallistic' );
						if (enemyRobot != None)
							score += 0.5;
						break;

					case 'Sabot':
						if (enemyRobot != None)
							score -= 0.5;
						break;

					case 'EMP':
						bValid = false;
						if(bSmartWeapons)
						{
							if (enemyPlayer != none)
							{
								score += GetAugScoreModifier( enemyplayer, class'AugEMP' );
								bValid = true;
							}
						}

						if (enemyRobot != None)
						{
							score -= 5.0;
							bValid = true;
						}

						if (enemypawn != none)
						{
							tpawn = tnmpawn(enemypawn);
							if (tpawn != none)
							{
								if (tpawn.bFirewall || tpawn.bAugmented)
								{
									score -= 5.0;
									bValid = true;
								}
							}
						}

						break;
					case 'NanoVirus':
						if (enemyRobot != None)
							score -= 5.0;
						else
							//score += 10000;
							bValid = false;
						break;

					case 'Drowned':
					default:
						break;
				}

				// Special case for current weapon
				if ((curWeapon == Weapon) && (WeaponTimer < 10.0))
				{
					// If we last changed weapons less than five seconds ago,
					// keep this weapon
					if (WeaponTimer < 5.0)
						score = -10;

					// If between five and ten seconds, use a sliding scale
					else
						score -= (10.0 - WeaponTimer)/5.0;
				}

				// Throw a little randomness into the computation...
				else
				{
					score += FRand()*0.1 - 0.05;

					//not sure why this would be required.
					//if (score < 0)
					//	score = 0;
				}

				if (bValid)
				{
					// ugly
					if (bestWeapon == None)
						bWinner = true;
					else if (curFallbackLevel > fallbackLevel)
						bWinner = true;
					else if (curFallbackLevel < fallbackLevel)
						bWinner = false;
					else if (bestScore > score)
						bWinner = true;
					else
						bWinner = false;
					if (bWinner)
					{
						bestScore     = score;
						bestWeapon    = curWeapon;
						fallbackLevel = curFallbackLevel;
					}
				}
			}
		}
	}

	// If we're changing weapons, reset the weapon timers
	if (Weapon != bestWeapon)
	{
		if (!bEnemySet)
			WeaponTimer = 10;  // hack
		else
			WeaponTimer = 0;

		ReloadTimer = 0;

		if (bestWeapon != None)
		{
			if (bestWeapon.AITimeLimit > 0)
				SpecialTimer = bestWeapon.AITimeLimit;

			//Added to play the out of ammo bark
			if (Weapon != none)
			{
				if (Weapon.ReloadCount > 0)
				{
					if ( bestWeapon.bHandToHand )
					{
						if (Weapon.AmmoType == None)
							PlayOutOfAmmoSound();
						else if (Weapon.AmmoType.AmmoAmount < 1)
							PlayOutOfAmmoSound();
					}
				}
			}
		}
	}

	SetWeapon(bestWeapon);

	return false;
}

function SwitchToKilledSkin()
{
}

function TakeDamageBase(int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType,
						bool bPlayAnim)
{
	if (damagetype =='HalonGas')
		if (bOnFire)
			ExtinguishFire();

	super.TakeDamageBase(Damage, instigatedBy, hitlocation, momentum, damageType, bPlayAnim);
}



function PlayerDetected()
{
	local tnmmissionscript scr;
	foreach allactors(class'tnmmissionscript',scr)
		scr.PlayerDetected();
}

state Crouching
{
	ignores EnemyNotVisible;

	function AnimEnd()
	{
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		Global.HitWall(HitNormal, Wall);
	}

	function Tick(float deltaSeconds)
	{
		Global.Tick(deltaSeconds);
	}

	function BeginState()
	{
		local actor focus;

		StandUp();
		SetEnemy(None, EnemyLastSeen, true);
		bCanJump = false;

		bStasis = False;

		SetupWeapon(false);
		SetDistress(false);
		SeekPawn = None;
		EnableCheckDestLoc(false);

		foreach allactors(class'actor',focus,OrderTag)
			break;

		LookAtActor(focus, true, true, true, 0, 0.5);
		if (ShouldCrouch())
			StartCrouch();
	}

	function EndState()
	{
		EnableCheckDestLoc(false);
		bAcceptBump = True;

		if (JumpZ > 0)
			bCanJump = true;
		bStasis = True;

		StopBlendAnims();
		EndCrouch();
	}

	function bool ShouldCrouch()
	{
		if (bCanCrouch && !Region.Zone.bWaterZone)
			return true;
		else
			return false;
	}

	function StartCrouch()
	{
		if (!bCrouching)
		{
			bCrouching = true;
			SetBasedPawnSize(CollisionRadius, GetCrouchHeight());
//			PlayDuck();
			PlayAnim('Crouch');
		}
	}

	function EndCrouch()
	{
		if (bCrouching)
		{
			bCrouching = false;
			ResetBasedPawnSize();
		}
	}

Begin:
	WaitForLanding();
	Acceleration=vect(0,0,0);

	bStasis = True;
}



// ----------------------------------------------------------------------
// GotoDisabledState()
// ----------------------------------------------------------------------

function GotoDisabledState(name damageType, EHitLocation hitPos)
{
	if (!bCollideActors && !bBlockActors && !bBlockPlayers)
		return;
	else if ((damageType == 'TearGas') || (damageType == 'HalonGas'))
		GotoState('RubbingEyes');
	else if (damageType == 'Stunned')
		{
		stuntime = 15;
		GotoState('Stunned');
		}
	else if (damageType == 'fistStunned')
		{
		stuntime = 5;
		GotoState('Stunned');
		}
	else if (CanShowPain())
		TakeHit(hitPos);
	else
		GotoNextState();
}

state Stunned
{
	ignores seeplayer, hearnoise, bump, hitwall;

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation,
						Vector momentum, name damageType)
	{
		TakeDamageBase(Damage, instigatedBy, hitlocation, momentum, damageType, false);
	}

	function ReactToInjury(Pawn instigatedBy, Name damageType, EHitLocation hitPos)
	{
		if ((damageType != 'TearGas') && (damageType != 'HalonGas') && (damageType != 'Stunned'))
			Global.ReactToInjury(instigatedBy, damageType, hitPos);
	}

	function SetFall()
	{
		StartFalling(NextState, NextLabel);
	}

	function AnimEnd()
	{
		PlayWaiting();
	}

	function BeginState()
	{
		StandUp();
		Disable('AnimEnd');
		bInterruptState = false;
		BlockReactions();
		bCanConverse = False;
		bStasis = False;
		SetupWeapon(false);
		SetDistress(true);
		bStunned = True;
		bInTransientState = true;
		EnableCheckDestLoc(false);
	}

	function EndState()
	{
		EnableCheckDestLoc(false);
		bInterruptState = true;
		ResetReactions();
		bCanConverse = True;
		bStasis = True;

		// if we're dead, don't reset the flag
		if (Health > 0)
			bStunned = False;
		bInTransientState = false;
	}

Begin:
	Acceleration = vect(0, 0, 0);
	PlayStunned();
	Sleep(stuntime);
	if (HasNextState())
		GotoNextState();
	else
		GotoState('Wandering');
}


function PostBeginPlay()
{
	Super.PostBeginPlay();

	// change the sounds for chicks
	if (bIsFemale)
	{
		HitSound1 = Sound'FemalePainMedium';
		HitSound2 = Sound'FemalePainLarge';
		Die = Sound'FemaleDeath';
	}

	//added
	if (baugmented)
	{
		if (TNMPAM !=none)
			TNMPAM.destroy();
		TNMPAM = none;
		TNMPAM = Spawn(class'tnmpawnAugManager', Self);
		if (TNMPAM != none)
		{
			TNMPAM.setbase(self);
			TNMPAM.CreateAugmentations(Self);
			TNMPAM.activateaugs();
		}
	}
	//added

	//DDL breath stuff
	if (bInWorld && bVisibleBreath && breathgen == none)
	{
		spawnBreathgen();
	}

}


// ----------------------------------------------------------------------
// HandleDamage()
// ----------------------------------------------------------------------

function EHitLocation HandleDamage(int actualDamage, Vector hitLocation, Vector offset, name damageType)
{
	local EHitLocation hitPos;
	local float        headOffsetZ, headOffsetY, armOffset;

	// calculate our hit extents
	headOffsetZ = CollisionHeight * 0.7;
	headOffsetY = CollisionRadius * 0.3;
	armOffset   = CollisionRadius * 0.35;

	if ( bHelmeted )
	{
		if (offset.z > CollisionHeight * 0.7)
		{
			if ((damagetype == 'knockedout') || (damagetype == 'headstun'))
				actualDamage = 0;
		}
	}

	if (actualDamage > 0)
		if (offset.z > headOffsetZ)
			if(damagetype=='headstun')
				{
				healthhead = 1;
				damagetype = 'knockedout';
				TakeDamage( 50, none, hitlocation, vect(0,0,0),'knockedout');
				}

	super.handledamage(actualdamage,hitlocation,offset,damagetype);
}



function bool WillTakeStompDamage(actor stomper)
{
	// This blows chunks!
	if (stomper.IsA('PlayerPawn') && (GetPawnAllianceType(Pawn(stomper)) != ALLIANCE_Hostile))
		return false;
	else
		return true;
}


function tick(float deltatime)
{
	fat += deltatime;
	if (fat >=0.5)
	{
		fat = 0.0;
		if (fatness > default.fatness) //not sure if this will take the default fatness of tnmpawn or the class that is inheriting this method.
			fatness -= 1;
	}

	//DDL breath stuff
	if(breathgen != none)
	{
		Updatebreathgen(deltatime);
	}

	if ( tnmzoneinfo(HeadRegion.Zone).bNoOxygen )
	{
		timewithouto2 += deltatime;
		if ( timewithouto2 > 30 )
		{
			TakeDamage(5, None, Location, vect(0,0,0), 'Drowned'); 
			timewithouto2 -= 1;
		}
	}

	if (bDisappear && (InStasis() || (LastRendered() > 5.0)))
	{
		LeaveWorld();
		return;
	}

	super.tick(deltatime);
	if (TNMPAM!=none)
		TNMPAM.activateaugs();
}

function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation,
						Vector momentum, name damageType)
{
	local int totalFat; //needed to avoid integer overflow for fatness calculation
	local tnmaugmentation TNMA;

	if (damagetype == 'Uberexploded')
		damagetype = 'exploded';

	if(damageType=='FistStunned')
		Damage=1;

	if (damagetype == 'fat')
	{
		if (!binvincible)
		{
			if (damage > 0)
			{
				if (baugmented && (TNMPAM != none))
				{
					TNMA = TNMPAM.findaug(class'tnmAugShield');
					if ((TNMA != none) && (TNMA.bisactive))
					{
						damage = damage * TNMA.value;
						augdamage(0,instigatedby,hitlocation,momentum,damagetype);
					}
				}

				totalFat = fatness + damage;
				if (totalFat > 255)
					takedamage(10000,instigatedby,hitlocation,momentum,'exploded');
				else
				{
					takedamage(1,instigatedby, hitlocation, momentum, 'shot');
					fatness += damage;
				}
			}
		}
	}
	else if (damagetype == 'gibbed')
	{
		if (!bimmunetogib)
			takedamage(10000,instigatedby,hitlocation,momentum,'exploded');
	}
	else if (damagetype == 'nogib')
	{
		health = 0;
		takedamage(1,instigatedby,hitlocation,momentum,'shot');
	}
	else if (damagetype == 'FistEMP')
	{
		takedamage(damage*2.5,instigatedby,hitlocation,momentum,'EMP');
		takedamage(damage,instigatedby,hitlocation,momentum,'KnockedOut');
	}
	else
	{
		if (baugmented && (TNMPAM != none))
			augdamage(damage,instigatedby,hitlocation,momentum,damagetype);
		else
			empdamage(damage,instigatedby,hitlocation,momentum,damagetype);
	}


	if (health <=0)
	{
		if (TNMPAM != none)
		{
			TNMPAM.deactivateall();
			TNMPAM.destroy();
			TNMPAM = none;
		}
	}
	else
		if (baugmented && (TNMPAM != none) && (health <= aughealthlimit))
			TNMPAM.activateaugs(true,false);	//health,combat
}

function empdamage( int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType)
{
	super.takedamage(damage,instigatedby,hitlocation,momentum,damagetype);

	if (damagetype == 'emp')
	{
		if(baugmented)
		{
			energy -= damage;
			if (energy <= 0)
				TNMPAM.deactivateall();
		}
		if (bfirewall)
		{
			if (health <= 0)
				firewallexplosion();
		}
	}
}

function float ModifyDamage(int Damage, Pawn instigatedBy, Vector hitLocation,
							Vector offset, Name damageType)
{
	local int   actualDamage;
	local float headOffsetZ, headOffsetY, armOffset;

	actualDamage = Damage;

	// calculate our hit extents
	headOffsetZ = CollisionHeight * 0.7;
	headOffsetY = CollisionRadius * 0.3;
	armOffset   = CollisionRadius * 0.35;

	// if the pawn is stunned, damage is 4X
	if (bStunned)
		actualDamage *= 4;

	// if the pawn is hit from behind at point-blank range, he is killed instantly
	else if (offset.x < 0)
		if ((instigatedBy != None) && (VSize(instigatedBy.Location - Location) < 64))
			actualDamage  *= 10;

	actualDamage = Level.Game.ReduceDamage(actualDamage, DamageType, self, instigatedBy);

	if (ReducedDamageType == 'All') //God mode
		actualDamage = 0;
	else if (Inventory != None) //then check if carrying armor
		actualDamage = Inventory.ReduceDamage(actualDamage, DamageType, HitLocation);

	// gas, EMP and nanovirus do no damage
	if (damageType == 'TearGas' || damageType == 'NanoVirus')
		actualDamage = 0;
	if ((damageType == 'EMP') && !bfirewall)
		actualdamage = 0;

	return actualDamage;

}

// ----------------------------------------------------------------------
// FilterDamageType()
// ----------------------------------------------------------------------

function bool FilterDamageType(Pawn instigatedBy, Vector hitLocation,
							   Vector offset, Name damageType)
{
	// Special cases for certain damage types
	if (damageType == 'HalonGas')
		if (bOnFire)
			ExtinguishFire();

	if (damageType == 'EMP')
	{
		return ((bfirewall) || (baugmented));
	}

	return true;

}


// ----------------------------------------------------------------------
// ShouldReactToInjuryType()
// ----------------------------------------------------------------------

function bool ShouldReactToInjuryType(name damageType,
									  bool bHatePrimary, bool bHateSecondary)
{
	local bool bIsPrimary;

	bIsPrimary = IsPrimaryDamageType(damageType);
	if ((bHatePrimary && bIsPrimary)||(bHateSecondary && !bIsPrimary))
		return true;
	else
		return false;
}


function bool IsPrimaryDamageType(name damageType)
{
	local bool bPrimary;

	switch (damageType)
	{
		case 'Exploded':
		case 'TearGas':
		case 'HalonGas':
		case 'PoisonGas':
		case 'PoisonEffect':
		case 'Radiation':
		case 'Drowned':
		case 'NanoVirus':
			bPrimary = false;
			break;
		case 'EMP':
			bPrimary = bFirewall || bAugmented;
			break;
		case 'FistStunned':
		case 'Stunned':
		case 'KnockedOut':
		case 'Burned':
		case 'Flamed':
		case 'Poison':
		case 'Shot':
		case 'Sabot':
		case 'fat':
		default:
			bPrimary = true;
			break;
	}

	return (bPrimary);
}

function firewallexplosion()
{
	gotostate('firewalldeath');//place holder. for now!!!
}

function augdamage( int damage, pawn instigatedby, vector hitlocation, vector momentum, name damagetype)
{
	local int newdamage;
	local tnmaugmentation TNMA;

	newdamage = damage;

	if ((damageType == 'Shot') || (damageType == 'AutoShot'))
	{
		TNMA = TNMPAM.findaug(class'tnmAugBallistic');
		if ((TNMA != none) && (TNMA.bisactive))
		{
			newDamage *= TNMA.value;
			Spawn(Class'BallisticShieldFX',Self);
		}
	}

	else if (damageType == 'EMP')
	{

		TNMA = TNMPAM.findaug(class'tnmAugEMP');
		if ((TNMA != none) && (TNMA.bisactive))
		{
			newDamage *= TNMA.value;
			Spawn(Class'EMPShieldFX',Self);
		}
	}

	else if ((damageType == 'Burned') || (damageType == 'Flamed') ||
		(damageType == 'Exploded') || (damageType == 'Shocked') ||
		(damageType == 'fat'))
	{
		TNMA = TNMPAM.findaug(class'tnmAugShield');
		if ((TNMA != none) && (TNMA.bisactive))
		{
			newDamage *= TNMA.value;
			Spawn(Class'EnergyShieldFX',Self);
		}
	}
	else if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'Radiation') ||
		(damageType == 'HalonGas')  || (damageType == 'PoisonEffect') || (damageType == 'Poison'))
	{
		TNMA = TNMPAM.findaug(class'tnmAugEnviro');
		if ((TNMA != none) && (TNMA.bisactive))
		{
			newDamage *= TNMA.value;
			if((damageType=='TearGas'||damageType=='HalonGas') && newdamage==0)
				damageType='PoisonGas'; //don't rub your eyes!
			Spawn(Class'EnviroShieldFX',Self);
		}
	}

//	if (bDrawShield && damage > newdamage)
//		drawshield();

	if ((newdamage < 1) && (newdamage > 0))
		newdamage = 1;

	empdamage(newdamage,instigatedby,hitlocation,momentum,damagetype);
}


State Attacking
{

	function BeginState()
	{
		PlayerDetected();

		if (baugmented && (TNMPAM != none))
			TNMPAM.activateaugs(false,true);	//health,combat

		StandUp();

		// hack
		if (MaxRange < MinRange+10)
			MaxRange = MinRange+10;
		bCanFire      = false;
		bFacingTarget = false;

		SwitchToBestWeapon();

		//EnemyLastSeen = 0;
		BlockReactions();
		bCanConverse = False;
		bAttacking = True;
		bStasis = False;
		SetDistress(true);

		CrouchTimer = 0;
		EnableCheckDestLoc(false);
	}

	function EndState()
	{
		if (baugmented && (TNMPAM != none))
			TNMPAM.DeactivateAll();
		//TNMPAM.activateaugs(false,false);	//health,combat
		//NOT WORKING? Worked out why. Goes into fleeing if doesn't have weapon.
		//Don't really need to have fleeing since it's a fair assumption that anyone
		//with a combat activated aug will have a weapon but it's probably best to be sure.

		EnableCheckDestLoc(false);
		bCanFire      = false;
		bFacingTarget = false;

		ResetReactions();
		bCanConverse = True;
		bAttacking = False;
		bStasis = True;
		bReadyToReload = false;

		EndCrouch();
	}
}

State Fleeing
{
	function BeginState()
	{
		PlayerDetected();
		StandUp();
		Disable('AnimEnd');
		//Disable('Bump');
		BlockReactions();
		if (!bCower)
			bCanConverse = False;
		bStasis = False;
		SetupWeapon(false, true);
		SetDistress(true);
		EnemyReadiness = 1.0;
		//ReactionLevel  = 1.0;
		SeekPawn = None;
		EnableCheckDestLoc(false);
	}

	function EndState()
	{
		EnableCheckDestLoc(false);
		Enable('AnimEnd');
		//Enable('Bump');
		ResetReactions();
		if (!bCower)
			bCanConverse = True;
		bStasis = True;
		ResetBasedPawnSize(); //in case the cowering gets interupted
	}

	function FinishFleeing()
	{
		if (bLeaveAfterFleeing || !bRestoreOrders)
			GotoState('Wandering');
		else
			FollowOrders();
	}
}

// ----------------------------------------------------------------------
// PlayFootStep()
//
// Plays footstep sounds based on the texture group
// (yes, I know this looks nasty -- I'll have to figure out a cleaner way to do this)
// ----------------------------------------------------------------------

function PlayFootStep()
{
	local Sound stepSound;
	local float rnd;
	local name mat;
	local float speedFactor, massFactor;
	local float volume, pitch, range;
	local float radius, maxRadius;
	local float volumeMultiplier;

	local DeusExPlayer dxPlayer;
	local float shakeRadius, shakeMagnitude;
	local float playerDist;

	rnd = FRand();
	mat = GetFloorMaterial();

	volumeMultiplier = 1.0;
	if (WalkSound == None)
	{
		if (FootRegion.Zone.bWaterZone)
		{
			if (rnd < 0.33)
				stepSound = Sound'WaterStep1';
			else if (rnd < 0.66)
				stepSound = Sound'WaterStep2';
			else
				stepSound = Sound'WaterStep3';
		}
		else
		{
			switch(mat)
			{
				case 'Textile':
				case 'Paper':
					volumeMultiplier = 0.7;
					if (rnd < 0.25)
						stepSound = Sound'CarpetStep1';
					else if (rnd < 0.5)
						stepSound = Sound'CarpetStep2';
					else if (rnd < 0.75)
						stepSound = Sound'CarpetStep3';
					else
						stepSound = Sound'CarpetStep4';
					break;

				case 'Foliage':
				case 'Earth':
					volumeMultiplier = 0.6;
					if (rnd < 0.25)
						stepSound = Sound'GrassStep1';
					else if (rnd < 0.5)
						stepSound = Sound'GrassStep2';
					else if (rnd < 0.75)
						stepSound = Sound'GrassStep3';
					else
						stepSound = Sound'GrassStep4';
					break;

				case 'Metal':
				case 'Ladder':
					volumeMultiplier = 1.0;
					if (rnd < 0.25)
						stepSound = Sound'MetalStep1';
					else if (rnd < 0.5)
						stepSound = Sound'MetalStep2';
					else if (rnd < 0.75)
						stepSound = Sound'MetalStep3';
					else
						stepSound = Sound'MetalStep4';
					break;

				case 'Ceramic':
				case 'Glass':
				case 'Tiles':
					volumeMultiplier = 0.7;
					if (rnd < 0.25)
						stepSound = Sound'TileStep1';
					else if (rnd < 0.5)
						stepSound = Sound'TileStep2';
					else if (rnd < 0.75)
						stepSound = Sound'TileStep3';
					else
						stepSound = Sound'TileStep4';
					break;

				case 'Wood':
					volumeMultiplier = 0.7;
					if (rnd < 0.25)
						stepSound = Sound'WoodStep1';
					else if (rnd < 0.5)
						stepSound = Sound'WoodStep2';
					else if (rnd < 0.75)
						stepSound = Sound'WoodStep3';
					else
						stepSound = Sound'WoodStep4';
					break;

				case 'Brick':
				case 'Concrete':
				case 'Stone':
				case 'Stucco':
				default:
					volumeMultiplier = 0.7;
					if (rnd < 0.25)
						stepSound = Sound'StoneStep1';
					else if (rnd < 0.5)
						stepSound = Sound'StoneStep2';
					else if (rnd < 0.75)
						stepSound = Sound'StoneStep3';
					else
						stepSound = Sound'StoneStep4';
					break;
			}
		}
	}
	else
		stepSound = WalkSound;

	// compute sound volume, range and pitch, based on mass and speed
	speedFactor = VSize(Velocity)/120.0;
	massFactor  = Mass/150.0;
	radius      = 768.0;
	maxRadius   = 2048.0;
//	volume      = (speedFactor+0.2)*massFactor;
//	volume      = (speedFactor+0.7)*massFactor;
	volume      = massFactor*1.5;
	range       = radius * volume;
	pitch       = (volume+0.5);
	volume      = 1.0;
	range       = FClamp(range, 0.01, maxRadius);
	pitch       = FClamp(pitch, 1.0, 1.5);

	// play the sound and send an AI event
	PlaySound(stepSound, SLOT_Interact, volume * stealthmodifier, , range, pitch);
	AISendEvent('LoudNoise', EAITYPE_Audio, volume*volumeMultiplier * stealthmodifier, range*volumeMultiplier);

	// Shake the camera when heavy things tread
	if (Mass > 400)
	{
		dxPlayer = DeusExPlayer(GetPlayerPawn());
		if (dxPlayer != None)
		{
			playerDist = DistanceFromPlayer;
			shakeRadius = FClamp((Mass-400)/600, 0, 1.0) * (range*0.5);
			shakeMagnitude = FClamp((Mass-400)/1600, 0, 1.0);
			shakeMagnitude = FClamp(1.0-(playerDist/shakeRadius), 0, 1.0) * shakeMagnitude;
			if (shakeMagnitude > 0)
				dxPlayer.JoltView(shakeMagnitude);
		}
	}
}


// ----------------------------------------------------------------------
// ComputeActorVisibility()
// ----------------------------------------------------------------------

function float ComputeActorVisibility(actor seeActor)
{
local deusexplayer player;
player = deusexplayer(seeactor);

if (bvisionactive)
{
		return 1.0;
}
else
	return super.computeactorvisibility(seeactor);
}


function ZoneChange(ZoneInfo newZone)
{
	if (!bInWorld)
		return;

	if(!Newzone.bWaterZone && bVisibleBreath && breathgen == none)
	{
		spawnBreathgen();
	}
	else if((newzone.bWaterZone || !bVisibleBreath) && breathgen != none)
	{
		breathgen.DelayedDestroy();
	}

	super.ZoneChange(newzone);
}

function HeadZoneChange(ZoneInfo newZone)
{
	if (!bInWorld)
		return;

	if(!Newzone.bWaterZone && bVisibleBreath && breathgen == none)
	{
		spawnBreathgen();
	}
	else if((newzone.bWaterZone || !bVisibleBreath) && breathgen != none)
	{
		breathgen.DelayedDestroy();
	}
	super.HeadZoneChange(newzone);
}

function vector getBreathOffset()
{
	local vector loc;

	if(bIsFemale)
	{
		loc.X += CollisionRadius * 0.15;
		loc.Z += BaseEyeHeight*0.9;
	}
	else
	{
		loc.X += collisionradius * 0.5;
		loc.Z += BaseEyeHeight*0.91;
	}
	loc = loc >> rotation;
	loc += location;
	return loc;
}


function spawnbreathgen()
{
	local vector loc;

	loc = getBreathOffset();

	//log("spawning breathgen", name);

	breathgen = spawn(Class'particlegenerator',self,,loc,rotation);
	if(breathgen != none)
	{
		breathgen.particleTexture=texture'effects.smoke.smokepuff1';
		breathgen.checkTime = 0.1;
		breathgen.riseRate = 3.0;
		breathgen.ejectSpeed = 12.5;
		breathgen.bRandomEject = true;
		breathgen.particleLifeSpan = 0.5;
		breathgen.SetBase(self);
	}
	if(AnimSequence == 'BreatheLight' || AnimSequence == 'BreatheLight2H' || AnimSequence == 'SitBreathe')
	{
		//about halfway through is full inhale
		breathtimer = breathtime * self.animframe;
	}
	else
		breathtimer = frand() * breathtime;
}





function updatebreathgen(float dt)
{
	local float mod;
	local int temp;
	local vector loc;

	loc = getBreathOffset();

	breathgen.SetLocation(loc);
	breathgen.setrotation(rotation);


	breathtimer += dt;

	if(breathtimer > breathtime)
		breathtimer = 0.0;

	if((breathtimer < breathtime * 0.5 || breathtimer > breathtime * 0.9) && breathgen.bSpewing)
	{
		breathgen.UnTrigger(self,self);
	}
	else
	{
		if(breathtimer < breathtime * 0.75)
		{
			mod = (breathtimer - (breathtime * 0.5))/(breathtime * 0.25);
		}
		else
		{
			mod = (breathtime - breathtimer)/(breathtime * 0.15);
		}
		if(mod < 0)
		{
			breathgen.UnTrigger(self,self);
			mod = 0;
		}
		else
		{
			if(!breathgen.bSpewing)
				breathgen.Trigger(self,self);
			breathgen.ejectSpeed = 12.5 * mod;
		}
	}
}

// ----------------------------------------------------------------------
// PlayAnimPivot()
// ----------------------------------------------------------------------

function PlayAnimPivot(name Sequence, optional float Rate, optional float TweenTime,
					   optional vector NewPrePivot)
{
	local bool bAdjustBreath;

	if (Rate == 0)
	{
		if(sequence == 'BreatheLight' || sequence == 'BreatheLight2H' || sequence == 'SitBreathe')
			bAdjustBreath = true;

		Rate = 1.0;
	}
	if (TweenTime == 0)
		TweenTime = 0.1;
	PlayAnim(Sequence, Rate, TweenTime);
	if(bAdjustbreath && breathgen != none)
		breathtimer = breathtime * animframe;  //synch up breathing
	PrePivotTime    = TweenTime;
	DesiredPrePivot = NewPrePivot + PrePivotOffset;
	if (PrePivotTime <= 0)
		PrePivot = DesiredPrePivot;
}

// ----------------------------------------------------------------------
// TweenAnimPivot()
// ----------------------------------------------------------------------

function TweenAnimPivot(name Sequence, float TweenTime,
						optional vector NewPrePivot)
{
	if (TweenTime == 0)
		TweenTime = 0.1;
	TweenAnim(Sequence, TweenTime);
	if(breathgen != none && (sequence == 'BreatheLight' || sequence == 'BreatheLight2H' || sequence == 'SitBreathe'))
 		breathtimer = breathtime * animframe;  //synch up breathing
	PrePivotTime    = TweenTime;
	DesiredPrePivot = NewPrePivot + PrePivotOffset;
	if (PrePivotTime <= 0)
		PrePivot = DesiredPrePivot;
}


// ----------------------------------------------------------------------
// LoopAnimPivot()
// ----------------------------------------------------------------------

function LoopAnimPivot(name Sequence, optional float Rate, optional float TweenTime, optional float MinRate,
					   optional vector NewPrePivot)
{
	local bool bAdjustBreath;

	if (Rate == 0)
	{
		if(sequence == 'BreatheLight' || sequence == 'BreatheLight2H' || sequence == 'SitBreathe')
			bAdjustBreath = true;
		Rate = 1.0;
	}
	if (TweenTime == 0)
		TweenTime = 0.1;
	LoopAnim(Sequence, Rate, TweenTime, MinRate);
	if(bAdjustbreath && breathgen != none)
		breathtimer = breathtime * animframe;  //synch up breathing
	PrePivotTime    = TweenTime;
	DesiredPrePivot = NewPrePivot + PrePivotOffset;
	if (PrePivotTime <= 0)
		PrePivot = DesiredPrePivot;
}


// ----------------------------------------------------------------------
// state Dying - copied
// ----------------------------------------------------------------------

state FirewallDeath
{
	ignores SeePlayer, EnemyNotVisible, HearNoise, KilledBy, Trigger, Bump, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, Falling, WarnTarget, Died, Timer, TakeDamage;

	function Tick(float deltaSeconds)
	{
		Global.Tick(deltaSeconds);

		if (bfading)
		{
			fadetime += deltaseconds;
			if (Style != STY_Translucent)
				Style = STY_Translucent;
			ScaleGlow = default.scaleglow * (3 - fadetime) / 3;
			drawscale = default.drawscale * (3 - fadetime) / 3;
		}
	}

	function BeginState()
	{
		if(breathgen != none)
			breathgen.DelayedDestroy();

		EnableCheckDestLoc(false);
		StandUp();

		// don't do that stupid timer thing in Pawn.uc
		AIClearEventCallback('Futz');
		AIClearEventCallback('MegaFutz');
		AIClearEventCallback('Player');
		AIClearEventCallback('WeaponDrawn');
		AIClearEventCallback('LoudNoise');
		AIClearEventCallback('WeaponFire');
		AIClearEventCallback('Carcass');
		AIClearEventCallback('Distress');

		bInterruptState = false;
		BlockReactions(true);
		bCanConverse = False;
		bStasis = False;
		SetDistress(true);
		DeathTimer = 0;
	}

Begin:
	Acceleration = vect(0, 0, 0);
	Playfirewalldeathanims();
	Sleep(3);
Frag(Rand(5)+5);
for (i=0;i<=8;i++)
	multiskins[i] = Texture(DynamicLoadObject("Extras.Matrix_A00", class'Texture'));
	sleep(2);
	bfading = true;
	KillShadow();
	bHasShadow = False;
	//fade
	sleep(3);
	Destroy();
}

function Playfirewalldeathanims()
{
	LoopAnimPivot('Shocked');
/*
	FinishAnim();
	PlayAnim('HitTorso', 2.0, 0.1);
	FinishAnim();
	PlayAnim('HitHead', 2.0, 0.1);
	FinishAnim();
	PlayAnim('HitTorsoBack', 2.0, 0.1);
	FinishAnim();
	PlayAnim('HitHeadBack', 2.0, 0.1);
	FinishAnim();
	PlayAnim('HitHead', 3.0, 0.1);
	FinishAnim();
	PlayAnim('HitHeadBack', 3.0, 0.1);
	FinishAnim();
	PlayAnim('HitHead', 5.0, 0.1);
	FinishAnim();
	PlayAnim('HitHeadBack', 5.0, 0.1);
	FinishAnim();
*/
}

function Frag(int NumFrags)
{
	local int i;
	local DeusExFragment s;
	local vector v;

	for (i=0 ; i<NumFrags ; i++)
	{
		v = location;
		v.z += (frand()*2 - 1) * collisionheight;
		v.y += (frand()*2 - 1) * collisionradius;
		v.x += (frand()*2 - 1) * collisionradius;

		s = Spawn(class'metalfragment', self,,v);
		if (s != None)
		{
			s.CalcVelocity(v,0);
			s.DrawScale = Frand() +1;
			s.Skin = multiskins[Rand(4) - 1];
		}
	}
}

//=======================================================================//
//Alarm AI                                                               //
//=======================================================================//

function cameraalarm()
{
if (bAlarmSecurity)
	ALARM(AR_SecurityAlert);
}

function ALARM(EAlarmReason reason)
{
	//debug output
//	switch ( reason )
//	{
//		case AR_None: 	trestkon(GetPlayerPawn()).DebugMessage("Pawn triggering alarm because: AR_None"); break;
//		case AR_FoundCarcass: 	trestkon(GetPlayerPawn()).DebugMessage("Pawn triggering alarm because: AR_FoundCarcass"); break;
//		case AR_DisabledBot: 	trestkon(GetPlayerPawn()).DebugMessage("Pawn triggering alarm because: AR_DisabledBot"); break;
//		case AR_SecurityAlert: 	trestkon(GetPlayerPawn()).DebugMessage("Pawn triggering alarm because: AR_SecurityAlert"); break;
//		case AR_Fire: 	trestkon(GetPlayerPawn()).DebugMessage("Pawn triggering alarm because: AR_Fire"); break;
//		case AR_LostPlayer: 	trestkon(GetPlayerPawn()).DebugMessage("Pawn triggering alarm because: AR_LostPlayer"); break;
//		case AR_KilledPlayer: 	trestkon(GetPlayerPawn()).DebugMessage("Pawn triggering alarm because: AR_KilledPlayer"); break;
//	}

	if(IsValidEnemy(GetPlayerPawn())) //thanks Chris Rosenkreutz
	{
		alarmreason = reason;
		SetOrders('Alerting');
	}
}

//horrible way of doing it but the function gets called at the perfect time so it's
// better than copying the whole seeking state
//need give up search as well!!
function PlayAreaSecureSound()
{
	local DeusExPlayer dxPlayer;

	// Should we do a player check here?

	dxPlayer = DeusExPlayer(GetPlayerPawn());
	if ((dxPlayer != None) && (Enemy == dxPlayer))
	{
		dxPlayer.StartAIBarkConversation(self, BM_AreaSecure);
		if(bAlarmKilledPlayer)
			ALARM(AR_KilledPlayer);
	}
}



// ----------------------------------------------------------------------
// state Seeking
//
// Look for enemies in the area
// ----------------------------------------------------------------------

State Seeking
{
	function SetFall()
	{
		StartFalling('Seeking', 'ContinueSeek');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		Global.HitWall(HitNormal, Wall);
		CheckOpenDoor(HitNormal, Wall);
	}

	function bool GetNextLocation(out vector nextLoc)
	{
		local float   dist;
		local rotator rotation;
		local bool    bDone;
		local float   seekDistance;
		local Actor   hitActor;
		local vector  HitLocation, HitNormal;
		local vector  diffVect;
		local bool    bLOS;

		if (bSeekLocation)
		{
			if (SeekType == SEEKTYPE_Guess)
				seekDistance = (200+FClamp(GroundSpeed*EnemyLastSeen*0.5, 0, 1000));
			else
				seekDistance = 300;
		}
		else
			seekDistance = 60;

		dist  = VSize(Location-destLoc);
		bDone = false;
		bLOS  = false;

		if (dist < seekDistance)
		{
			bLOS = true;
			foreach TraceVisibleActors(Class'Actor', hitActor, hitLocation, hitNormal,
			                           destLoc, Location+vect(0,0,1)*BaseEyeHeight)
			{
				if (hitActor != self)
				{
					if (hitActor == Level)
						bLOS = false;
					else if (IsPointInCylinder(hitActor, destLoc, 16, 16))
						break;
					else if (hitActor.bBlockSight && !hitActor.bHidden)
						bLOS = false;
				}
				if (!bLOS)
					break;
			}
		}

		if (!bLOS)
		{
			if (PointReachable(destLoc))
			{
				rotation = Rotator(destLoc - Location);
				if (seekDistance == 0)
					nextLoc = destLoc;
				else if (!AIDirectionReachable(destLoc, rotation.Yaw, rotation.Pitch, 0, seekDistance, nextLoc))
					bDone = true;
				if (!bDone && bDefendHome && !IsNearHome(nextLoc))
					bDone = true;
				if (!bDone)  // hack, because Unreal's movement code SUCKS
				{
					diffVect = nextLoc - Location;
					if (Physics == PHYS_Walking)
						diffVect *= vect(1,1,0);
					if (VSize(diffVect) < 20)
						bDone = true;
					else if (IsPointInCylinder(self, nextLoc, 10, 10))
						bDone = true;
				}
			}
			else
			{
				MoveTarget = FindPathTo(destLoc);
				if (MoveTarget == None)
					bDone = true;
				else if (bDefendHome && !IsNearHome(MoveTarget.Location))
					bDone = true;
				else
					nextLoc = MoveTarget.Location;
			}
		}
		else
			bDone = true;

		return (!bDone);
	}

	function bool PickDestination()
	{
		local bool bValid;

		bValid = false;
		if (/*(EnemyLastSeen <= 25.0) &&*/ (SeekLevel > 0))
		{
			if (bSeekLocation)
			{
				bValid  = true;
				destLoc = LastSeenPos;
			}
			else
			{
				bValid = AIPickRandomDestination(130, 250, 0, 0, 0, 0, 2, 1.0, destLoc);
				if (!bValid)
				{
					bValid  = true;
					destLoc = Location + VRand()*50;
				}
				else
					destLoc += vect(0,0,1)*BaseEyeHeight;
			}
		}

		return (bValid);
	}

	function NavigationPoint GetOvershootDestination(float randomness, optional float focus)
	{
		local NavigationPoint navPoint, bestPoint;
		local float           distance;
		local float           score, bestScore;
		local int             yaw;
		local rotator         rot;
		local float           yawCutoff;

		if (focus <= 0)
			focus = 0.6;

		yawCutoff = int(32768*focus);
		bestPoint = None;
		bestScore = 0;

		foreach ReachablePathnodes(Class'NavigationPoint', navPoint, None, distance)
		{
			if (distance < 1)
				distance = 1;
			rot = Rotator(navPoint.Location-Location);
			yaw = rot.Yaw + (16384*randomness);
			yaw = (yaw-Rotation.Yaw) & 0xFFFF;
			if (yaw > 32767)
				yaw  -= 65536;
			yaw = abs(yaw);
			if (yaw <= yawCutoff)
			{
				score = yaw/distance;
				if ((bestPoint == None) || (score < bestScore))
				{
					bestPoint = navPoint;
					bestScore = score;
				}
			}
		}

		return bestPoint;
	}

	function Tick(float deltaSeconds)
	{
		animTimer[1] += deltaSeconds;
		Global.Tick(deltaSeconds);
		UpdateActorVisibility(Enemy, deltaSeconds, 1.0, true);
	}

	function HandleLoudNoise(Name event, EAIEventState state, XAIParams params)
	{
		local Actor bestActor;
		local Pawn  instigator;

		if (state == EAISTATE_Begin || state == EAISTATE_Pulse)
		{
			bestActor = params.bestActor;
			if ((bestActor != None) && (EnemyLastSeen > 2.0))
			{
				instigator = Pawn(bestActor);
				if (instigator == None)
					instigator = bestActor.Instigator;
				if (instigator != None)
				{
					if (IsValidEnemy(instigator))
					{
						SetSeekLocation(instigator, bestActor.Location, SEEKTYPE_Sound);
						destLoc = LastSeenPos;
						if (bInterruptSeek)
							GotoState('Seeking', 'GoToLocation');
					}
				}
			}
		}
	}

	function HandleSighting(Pawn pawnSighted)
	{
		if ((EnemyLastSeen > 2.0) && IsValidEnemy(pawnSighted))
		{
			SetSeekLocation(pawnSighted, pawnSighted.Location, SEEKTYPE_Sight);
			destLoc = LastSeenPos;
			if (bInterruptSeek)
				GotoState('Seeking', 'GoToLocation');
		}
	}

	function BeginState()
	{
		PlayerDetected();
		StandUp();
		Disable('AnimEnd');
		destLoc = LastSeenPos;
		SetReactions(true, true, false, true, true, true, true, true, true, false, true, true);
		bCanConverse = False;
		bStasis = False;
		SetupWeapon(true);
		SetDistress(false);
		bInterruptSeek = false;
		EnableCheckDestLoc(false);
	}

	function EndState()
	{
		EnableCheckDestLoc(false);
		Enable('AnimEnd');
		ResetReactions();
		bCanConverse = True;
		bStasis = True;
		StopBlendAnims();
		SeekLevel = 0;
	}

Begin:
	WaitForLanding();
	PlayWaiting();
	if ((Weapon != None) && bKeepWeaponDrawn && (Weapon.CockingSound != None) && !bSeekPostCombat)
		PlaySound(Weapon.CockingSound, SLOT_None,,, 1024);
	Acceleration = vect(0,0,0);
	if (!PickDestination())
		Goto('DoneSeek');

GoToLocation:
	bInterruptSeek = true;
	Acceleration = vect(0,0,0);

	if ((DeusExWeapon(Weapon) != None) && DeusExWeapon(Weapon).CanReload() && !Weapon.IsInState('Reload'))
		DeusExWeapon(Weapon).ReloadAmmo();

	if (bSeekPostCombat)
		PlayPostAttackSearchingSound();
	else if (SeekType == SEEKTYPE_Sound)
		PlayPreAttackSearchingSound();
	else if (SeekType == SEEKTYPE_Sight)
	{
		if (ReactionLevel > 0.5)
			PlayPreAttackSightingSound();
	}
	else if ((SeekType == SEEKTYPE_Carcass) && bSeekLocation)
		PlayCarcassSound();

	StopBlendAnims();

	if ((SeekType == SEEKTYPE_Sight) && bSeekLocation)
		Goto('TurnToLocation');

	EnableCheckDestLoc(true);
	while (GetNextLocation(useLoc))
	{
		if (ShouldPlayWalk(useLoc))
			PlayRunning();
		MoveTo(useLoc, MaxDesiredSpeed);
		CheckDestLoc(useLoc);
	}
	EnableCheckDestLoc(false);

	if ((SeekType == SEEKTYPE_Guess) && bSeekLocation)
	{
		MoveTarget = GetOvershootDestination(0.5);
		if (MoveTarget != None)
		{
			if (ShouldPlayWalk(MoveTarget.Location))
				PlayRunning();
			MoveToward(MoveTarget, MaxDesiredSpeed);
		}

		if (AIPickRandomDestination(CollisionRadius*2, 200+FRand()*200, Rotation.Yaw, 0.75, Rotation.Pitch, 0.75, 2,
		                            0.4, useLoc))
		{
			if (ShouldPlayWalk(useLoc))
				PlayRunning();
			MoveTo(useLoc, MaxDesiredSpeed);
		}
	}

TurnToLocation:
	Acceleration = vect(0,0,0);
	PlayTurning();
	if ((SeekType == SEEKTYPE_Guess) && bSeekLocation)
		destLoc = Location + Vector(Rotation+(rot(0,1,0)*(Rand(16384)-8192)))*1000;
	if (bCanTurnHead)
	{
		Sleep(0);  // needed to turn head
		LookAtVector(destLoc, true, false, true);
		TurnTo(Vector(DesiredRotation)*1000+Location);
	}
	else
		TurnTo(destLoc);
	bSeekLocation = false;
	bInterruptSeek = false;

	PlayWaiting();
	Sleep(FRand()*1.5+3.0);

LookAround:
	if (bCanTurnHead)
	{
		if (FRand() < 0.5)
		{
			if (!bSeekLocation)
			{
				PlayTurnHead(LOOK_Left, 1.0, 1.0);
				Sleep(1.0);
			}
			if (!bSeekLocation)
			{
				PlayTurnHead(LOOK_Forward, 1.0, 1.0);
				Sleep(0.5);
			}
			if (!bSeekLocation)
			{
				PlayTurnHead(LOOK_Right, 1.0, 1.0);
				Sleep(1.0);
			}
		}
		else
		{
			if (!bSeekLocation)
			{
				PlayTurnHead(LOOK_Right, 1.0, 1.0);
				Sleep(1.0);
			}
			if (!bSeekLocation)
			{
				PlayTurnHead(LOOK_Forward, 1.0, 1.0);
				Sleep(0.5);
			}
			if (!bSeekLocation)
			{
				PlayTurnHead(LOOK_Left, 1.0, 1.0);
				Sleep(1.0);
			}
		}
		PlayTurnHead(LOOK_Forward, 1.0, 1.0);
		Sleep(0.5);
		StopBlendAnims();
	}
	else
	{
		if (!bSeekLocation)
			Sleep(1.0);
	}

FindAnotherPlace:
	SeekLevel--;
	if (PickDestination())
		Goto('GoToLocation');

DoneSeek:
//will have to change this somewhat.
	if (bSeekPostCombat)
	{
		if(bAlarmLostPlayer)
			ALARM(AR_LostPlayer);
		PlayTargetLostSound();
	}
	else
	{
		if(bAlarmLostPlayer)
			ALARM(AR_LostPlayer);
		PlaySearchGiveUpSound();
	}
if (SeekType == SEEKTYPE_Carcass)
	if(bAlarmCarcass)
		ALARM(AR_FoundCarcass);

	bSeekPostCombat = false;
	SeekPawn = None;
	if (Orders != 'Seeking')
		FollowOrders();
	else
		restoreorders(); // this could be an improvement on the old code? GotoState('Wandering');

ContinueSeek:
ContinueFromDoor:
	FinishAnim();
	Goto('FindAnotherPlace');

}

//copied from state Following

state Formation
{
	function SetFall()
	{
		StartFalling('Following', 'ContinueFollow');
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		Global.HitWall(HitNormal, Wall);
		CheckOpenDoor(HitNormal, Wall);
	}

	function Tick(float deltaSeconds)
	{
		Global.Tick(deltaSeconds);

		if (BackpedalTimer >= 0)
			BackpedalTimer += deltaSeconds;

		animTimer[1] += deltaSeconds;
		if ((Physics == PHYS_Walking) && (orderActor != None))
		{
			if (Acceleration == vect(0,0,0))
				LookAtActor(orderActor, true, true, true, 0, 0.25);
			else
				PlayTurnHead(LOOK_Forward, 1.0, 0.25);
		}
	}

	function PickDestination()
	{
		local float   dist;
		local int     dir;
		local rotator rot;

		if ( orderActor != none )
		{
			destLoc   = vect(0, 0, 0);
			rot = rot(0,0,0);

			rot.Yaw=(65536+formationDesiredYaw+orderActor.Rotation.Yaw-formationInitialYaw)%65536;
			destLoc = OrderActor.Location+Vector(rot/*+OrderActor.Rotation*/)*formationDesiredDistance;
			dist = VSize(Location-destLoc);
			if (dist > 75)
			{
				MoveTarget = FindPathTo(destLoc);
				if (MoveTarget != None)
					destPoint = MoveTarget;
			}
			else
			{
				if ( destPoint != none )
					destPoint.SetLocation(destLoc);
			}
		}
		BackpedalTimer = -1;
	}

	function BeginState()
	{
		StandUp();
		bStasis = False;
		SetupWeapon(false);
		SetDistress(false);
		BackpedalTimer = -1;
		SeekPawn = None;
		EnableCheckDestLoc(true);
	}

	function EndState()
	{
		EnableCheckDestLoc(false);
		bAcceptBump = False;
		bStasis = True;
		StopBlendAnims();
	}

	function FindLeader()
	{
		local TNMPawn p;
		OrderActor = none;
		foreach AllActors(Class'TNMPawn', p)
		{
			if(p.Orders == 'Patrolling' && p.OrderTag == formationPatrolTag)
			{
//				deusexplayer(GetPlayerPawn()).DebugMessage("Got One");
				OrderActor = p;
				return;
			}
		}
	}

	function FindController()
	{
/*		local FormationController fc;
		foreach (Allactors(class'FormationController', c, OrderTag)
		{
			formationController = fc;
			break;
		}
*/
	}


Begin:
	FindController();

	if(formationDesiredDistance==0)
	{
		if (orderActor == None)
			GotoState('Standing');
		formationDesiredDistance=VSize(Location-OrderActor.Location);
		formationDesiredYaw=Rotator(Location-OrderActor.Location).Yaw;
		formationInitialYaw=OrderActor.Rotation.Yaw;
		formationPatrolTag=ScriptedPawn(OrderActor).OrderTag;
		Acceleration = vect(0, 0, 0);
		destPoint = None;
	}

GetFormation:
	if(OrderActor==None || !ScriptedPawn(OrderActor).IsInState('Patrolling'))
	{
		sleep(FRand()*3.0);
		FindLeader();
		if(OrderActor == None)
		{
			Orders='Patrolling';
			OrderTag=formationPatrolTag;
			GotoState('Patrolling');
		}
	}
	PickDestination();

Follow:
	if (destPoint != None && !IsPointInCylinder(self, destLoc, 16-CollisionRadius))
	{
		EnableCheckDestLoc(true);
		MoveTarget = FindPathToward(destPoint);
		if(VSize(Location-destLoc)<250)
		{
			if(ShouldPlayWalk(destLoc))
				PlayWalking();
			MoveTo(destLoc, GetWalkingSpeed());
		}
		else
		{
			PlayRunning();
			MoveTo(destLoc, MaxDesiredSpeed);
		}

		CheckDestLoc(destLoc, true);
		EnableCheckDestLoc(false);
	}

Wait:
	//PlayTurning();
	//TurnToward(orderActor);
	PlayWaiting();

WaitLoop:
	Acceleration=vect(0,0,0);
	Sleep(0.0);
	Goto('GetFormation');

ContinueFollow:
ContinueFromDoor:
	Acceleration=vect(0,0,0);
	Goto('GetFormation');

}

// ----------------------------------------------------------------------
// state Alerting
//
// Warn other NPCs that an enemy is about
// ----------------------------------------------------------------------

State Alerting
{
	function SetFall()
	{
		StartFalling('Alerting', 'ContinueAlert');
	}

	function Tick(float deltaSeconds)
	{
		Global.Tick(deltaSeconds);
	}

	function HitWall(vector HitNormal, actor Wall)
	{
		if (Physics == PHYS_Falling)
			return;
		Global.HitWall(HitNormal, Wall);
		CheckOpenDoor(HitNormal, Wall);
	}

	function Bump(actor bumper)
	{
		if (bAcceptBump)
		{
			if (bumper == AlarmActor)
			{
				bAcceptBump = False;
				GotoState('Alerting', 'SoundAlarm');
			}
		}

		// Handle conversations, if need be
		Global.Bump(bumper);
	}

	function bool IsAlarmReady(Actor actorAlarm)
	{
		local bool      bReady;
		local AlarmUnit alarm;

		bReady = false;
		alarm = AlarmUnit(actorAlarm);
		if ((alarm != None) && !alarm.bDeleteMe)
			if (!alarm.bActive)
				if ((alarm.associatedPawn == None) ||
				    (alarm.associatedPawn == self))
					bReady = true;

		return bReady;
	}

	function TriggerAlarm()
	{
		if ((AlarmActor != None) && !AlarmActor.bDeleteMe)
		{
			if (AlarmActor.hackStrength > 0)  // make sure the alarm hasn't been hacked
				AlarmActor.Trigger(self, Enemy);
		}
	}

	function bool IsAlarmInRange(AlarmUnit alarm)
	{
		local bool bInRange;

		bInRange = false;
		if ((alarm != None) && !alarm.bDeleteMe)
			if ((VSize((alarm.Location-Location)*vect(1,1,0)) <
			     (CollisionRadius+alarm.CollisionRadius+24)) &&
			    (Abs(alarm.Location.Z-Location.Z) < (CollisionHeight+alarm.CollisionHeight)))
				bInRange = true;

		return (bInRange);
	}

	function vector FindAlarmPosition(Actor alarm)
	{
		local vector alarmPos;

		alarmPos = alarm.Location;
		alarmPos += vector(alarm.Rotation.Yaw*rot(0,1,0))*(CollisionRadius+alarm.CollisionRadius);

		return (alarmPos);
	}

	function bool GetNextAlarmPoint(AlarmUnit alarm)
	{
		local vector alarmPoint;
		local bool   bValid;

		destPoint = None;
		destLoc   = vect(0,0,0);
		bValid    = false;

		if ((alarm != None) && !alarm.bDeleteMe)
		{
			alarmPoint = FindAlarmPosition(alarm);
			if (PointReachable(alarmPoint))
			{
				destLoc = alarmPoint;
				bValid = true;
			}
			else
			{
				MoveTarget = FindPathTo(alarmPoint);
				if (MoveTarget != None)
				{
					destPoint = MoveTarget;
					bValid = true;
				}
			}
		}

		return (bValid);
	}

	function AlarmUnit FindTarget()
	{
		local ScriptedPawn pawnAlly;
		local AlarmUnit    alarm;
		local float        dist;
		local AlarmUnit    bestAlarm;
		local float        bestDist;

		bestAlarm = None;

		// Do we have any allies on this level?
//		foreach AllActors(Class'ScriptedPawn', pawnAlly)
//			if (GetPawnAllianceType(pawnAlly) == ALLIANCE_Friendly)
//				break;

		// Yes, so look for an alarm box that isn't active...
//		if (pawnAlly != None)
//		{
			foreach RadiusActors(Class'AlarmUnit', alarm, 2400)
			{
				if (GetAllianceType(alarm.Alliance) != ALLIANCE_Hostile)
				{
					dist = VSize((Location-alarm.Location)*vect(1,1,2));  // use squished sphere
					if ((bestAlarm == None) || (dist < bestDist))
					{
						bestAlarm = alarm;
						bestDist  = dist;
					}
				}
			}


			// Is the nearest alarm already going off?  And can we reach it?
			if (!IsAlarmReady(bestAlarm) || !GetNextAlarmPoint(bestAlarm))
				bestAlarm = None;
//		}

		// Return our target alarm box
		return (bestAlarm);
	}

	function bool PickDestination()
	{
		local bool      bDest;
		local AlarmUnit alarm;

		// Init
		destPoint = None;
		destLoc   = vect(0, 0, 0);
		bDest     = false;

		// Find an alarm we can trigger
		alarm = FindTarget();
		if (alarm != None)
		{
			// Find a way to get there
			AlarmActor = alarm;
			alarm.associatedPawn = self;
			bDest = true;  // if alarm != none, we've already computed the route to the alarm
		}

		// Return TRUE if we were successful
		return (bDest);
	}

	function BeginState()
	{
		PlayerDetected();
		StandUp();
		//Disable('AnimEnd');
		bAcceptBump = False;
		bCanConverse = False;
		AlarmActor = None;
		bStasis = False;
		BlockReactions();
		SetupWeapon(false);
		SetDistress(false);
		EnemyReadiness = 1.0;
		ReactionLevel  = 1.0;
		EnableCheckDestLoc(false);
	}

	function EndState()
	{
		EnableCheckDestLoc(false);
		ResetReactions();
		bAcceptBump = False;
		//Enable('AnimEnd');
		bCanConverse = True;
		if (AlarmActor != None)
			if (AlarmActor.associatedPawn == self)
				AlarmActor.associatedPawn = None;
		AlarmActor = None;
		bStasis = True;
	}

Begin:
//	if ((Enemy == None) && (alarmreason == AR_none))
//		GotoState('Seeking');

	//EnemyLastSeen = 0;

	destPoint = None;

//	if ((RaiseAlarm == RAISEALARM_Never)&&(alarmreason ==AR_none))
//		GotoState('Fleeing');

	if (AlarmTimer > 0)
		PlayGoingForAlarmSound();

Alert:
	if (AlarmTimer > 0)
		Goto('Done');

	WaitForLanding();
	if (!PickDestination())
		Goto('Done');

Moving:
	// Can we go somewhere?
	bAcceptBump = True;
	EnableCheckDestLoc(true);
	while (true)
	{
		if (destPoint != None)
		{
			if (ShouldPlayWalk(MoveTarget.Location))
				PlayRunning();
			MoveToward(MoveTarget, MaxDesiredSpeed);
			CheckDestLoc(MoveTarget.Location, true);
		}
		else
		{
			if (ShouldPlayWalk(destLoc))
				PlayRunning();
			MoveTo(destLoc, MaxDesiredSpeed);
			CheckDestLoc(destLoc);
		}
		if (IsAlarmInRange(AlarmActor))
			break;
		else if (!GetNextAlarmPoint(AlarmActor))
			break;
	}
	EnableCheckDestLoc(false);

SoundAlarm:
	Acceleration=vect(0,0,0);
	bAcceptBump = False;
	if (IsAlarmInRange(AlarmActor))
	{
		TurnToward(AlarmActor);
		PlayPushing();
		FinishAnim();
		TriggerAlarm();
	}

Done:
	bAcceptBump = False;

	switch( alarmreason )
	{
		case AR_foundCarcass:
		case AR_DisabledBot:
		case AR_securityAlert:
		case AR_fire:
		case AR_lostplayer:
		case AR_killedplayer:
			alarmreason = AR_None;
			restoreorders();
			break;
		case AR_None:
		default:
			alarmreason = AR_None; //not sure if this needs to go before every gotostate or not and I'm too lazy to find out.
			if (RaiseAlarm == RAISEALARM_BeforeAttacking)
				GotoState('Attacking');
			else
				GotoState('Fleeing');
			break;
	};
ContinueAlert:
ContinueFromDoor:
	Goto('Alert');

}


// ----------------------------------------------------------------------
// CheckCarcassPresence()
// ----------------------------------------------------------------------

function bool CheckCarcassPresence(float deltaSeconds)
{

	local DeusExDecoration deco;
	local tnmrobot bot;
	local float         maxDecoDist;
	local int superfluousinteger;
	local float visibility;

	if(isinstate('alerting'))
		return false; //I don't even know why this function is a bool

	maxDecoDist = 1200;
	if (CarcassCheckTimer <= 0)
	{
		/* huge slowdown
		deco = none;
		foreach CycleActors(Class'deusexdecoration', deco, superfluousinteger)
		{
			if (deco.Physics != PHYS_Falling)
			{
				if (VSize(deco.Location-Location) < maxDecoDist)
				{
					if(deco.IsInState('Burning'))
					{
						visibility = AICanSee(deco, ComputeActorVisibility(deco), true, true, true, true);
						if (visibility > 0)
							if(bAlarmFire)
								ALARM(AR_Fire);
					}
				}
			}
		}
		*/
		if (bLookingForCarcass)
		{
			bot = none;
			foreach CycleActors(Class'tnmrobot', bot, superfluousinteger)
			{
				if (bot.Physics != PHYS_Falling)
				{
					if (VSize(bot.Location-Location) < maxDecoDist)
					{
						if(bot.IsInState('Disabled') && bot.EMPHitPoints <= 0)
						{
							if (GetAllianceType(bot.alliance) == ALLIANCE_Friendly )
							{
								visibility = AICanSee(bot, ComputeActorVisibility(bot), true, true, true, true);
								if (visibility > 0)
									if(bAlarmBot)
										ALARM(AR_foundcarcass); //AR_DisabledBot);
							}
						}
					}
				}
			}
		}
	}
	super.CheckCarcassPresence(deltaSeconds);
}

function restoreorders()
{
	if ( bRestoreOrders )
	{
		orders = originalorders;
		ordertag = originalordertag;
		FollowOrders();
	}
	else
	{
		GotoState('Wandering');
	}
}


function PreBeginPlay()
{
	if ( bRestoreOrders )
	{
		originalOrders = orders;
		originalOrderTag = ordertag;
	}
	super.prebeginplay();
}

// Smoke39 - implementing new on-fire effect
function CatchFire()
{
	local Fire f;
	local int i;
	local vector loc;

	if (bOnFire || Region.Zone.bWaterZone || (BurnPeriod <= 0) || bInvincible)
		return;

	bOnFire = True;
	burnTimer = 0;

	EnableCloak(false);
	// big ugly block replaced with this line
	Spawn(class'TNMFire', self);
	SetTimer(1.0, True);
}

// do not extinguish fire on death
function UpdateFire()
{
	HealthTorso -= 5;
	GenerateTotalHealth();
	if (Health <= 0)
	{
		TakeDamage(10, None, Location, vect(0,0,0), 'Burned');
//		ExtinguishFire();
	}
}

function ExtinguishFire()
{
	local TNMFire f;

	bOnFire = False;
	burnTimer = 0;
	SetTimer(0, False);

	foreach BasedActors(class'TNMFire', f)
		f.Destroy();
}

function PlayDying(name damageType, vector hitLoc)
{
	local Vector X, Y, Z;
	local float dotp;

	if (Region.Zone.bWaterZone)
		PlayAnimPivot('WaterDeath',, 0.1);
	else if (bSitting)  // if sitting, always fall forward
		PlayAnimPivot('DeathFront',, 0.1);
	else
	{
		GetAxes(Rotation, X, Y, Z);
		dotp = (Location - HitLoc) dot X;

		// die from the correct side
		if (dotp < 0.0)		// shot from the front, fall back
			PlayAnimPivot('DeathBack',, 0.1);
		else				// shot from the back, fall front
			PlayAnimPivot('DeathFront',, 0.1);
	}

	// don't scream if we are stunned
	if (bStunned)
	{	
		if (bIsFemale)
			PlaySound(Sound'FemaleUnconscious', SLOT_Pain,,,, RandomPitch());
		else
			PlaySound(Sound'MaleUnconscious', SLOT_Pain,,,, RandomPitch());
	}
	else
	{
		PlayDyingSound();
	}
}

// do not extinguish fire on death
function Died( pawn Killer, name damageType, vector HitLocation )
{
	local DeusExPlayer player;
	local name flagName;

	// Set a flag when NPCs die so we can possibly check it later
	player = DeusExPlayer(GetPlayerPawn());

//	ExtinguishFire();

	// set the instigator to be the killer
	Instigator = Killer;

	if (player != None)
	{
		// Abort any conversation we may have been having with the NPC
		if (bInConversation)
			player.AbortConversation();

		// Abort any barks we may have been playing
		if (player.BarkManager != None)
			player.BarkManager.ScriptedPawnDied(Self);
	}

	//set bStunned ourselves so it can be read prior to Died
	bStunned = (damageType == 'Stunned') || (damageType == 'KnockedOut') ||
	           (damageType == 'Poison') || (damageType == 'PoisonEffect');
	Super(Pawn).Died(Killer, damageType, HitLocation); 

	if (player != None)
	{
		if (bImportant)
		{
			if (bStunned)
				flagName = player.rootWindow.StringToName(BindName$"_Unconscious");
			else
				flagName = player.rootWindow.StringToName(BindName$"_Dead");

			player.flagBase.SetBool(flagName, True);
			// make sure the flag never expires
			player.flagBase.SetExpiration(flagName, FLAG_Bool, 0);
		}
	}
}

function Carcass SpawnCarcass()
{
	local TNMCarcass carc;
	local TNMFire f;
	local Flame f2;

	carc = TNMCarcass(Super.SpawnCarcass()); //its assumed that the carcass will be a tnmcarcass

	if(carc==None) //gibbed
		DropItems();

	// transfer our fire to our carcass
	if ( carc != None )
	{
		foreach BasedActors(class'TNMFire', f)
		{
			if (carc.bDontTransferFlame)
				f.Destroy();
			else
			{
				f.SetOwner(carc);
				f.SetBase(carc);
				f.Mesh = carc.Mesh;
			}
		}

		//prevent some accesssed nones
		foreach AllActors(class'Flame', f2)
			if(f2.Owner==Self)
				if ( carc.bDontTransferFlame )
					f2.Destroy();
				else
					f2.SetOwner(carc);

		carc.bImportant = bImportant;
		carc.bEmitCarcass=bEmitCarcass;
	}

	return carc;
}

function DropItems()
{
	local bool bValidItem;
	local inventory item, nextItem;
	local Vector loc;

	if(inventory != none)
	{
		do
		{
			item = Inventory;
			nextItem = item.Inventory;
			bValidItem = true;

			loc.X = (1-2*FRand()) * CollisionRadius;
			loc.Y = (1-2*FRand()) * CollisionRadius;
			loc.Z = (1-2*FRand()) * CollisionHeight;
			loc += Location;

	                DeleteInventory(item);

			if((DeusExWeapon(item) != None) && (DeusExWeapon(item).bNativeAttack))
				bValidItem = false;
				else if(Ammo(item) != none)
					bValidItem = false;

				if(!bValidItem)
					Item.Destroy();
			else
				class'tnmCarcass'.static.FlingItem(item, 300, loc);

			item = nextItem;
		}
		until (item == None)
	}
}

State Leaving
{
	function BeginState()
	{
		bTransient = False;
		bDisappear = True; //let's try to get LeaveWorld called instead
		GotoState('Patrolling');
	}

Begin:
	// shouldn't ever reach this point
}

function InitializeInventory()
{
	local int i;
	local flagbase flags;
	local trestkon t;
	t=trestkon(getplayerpawn());
	flags=t.flagBase;
	for(i=0;i<8;i++)
	{
		if(initialinventory[i].inventory==none)
			break;
		if(flags.getbool(t.rootwindow.stringtoname("GOT_"$initialinventory[i].inventory.name)))
			initialinventory[i].inventory=class<tnmuniqueweapon>(initialinventory[i].inventory).default.genericVersion;
	}
	super.InitializeInventory();
}

state Burning
{
	function BeginState()
	{
		StandUp();
		BlockReactions();
		bCanConverse = False;
		SetupWeapon(false, true);
		bStasis = False;
		SetDistress(true);
		EnemyLastSeen = 0;
		SeekPawn = None;
		EnableCheckDestLoc(false);
	}

Begin:
	if (!bOnFire)
		Goto('Done');
	PlayOnFireSound();

NewEnemy:
	Acceleration = vect(0, 0, 0);

Run:
	if (!bOnFire)
		Goto('Done');
	PlayPanicRunning();
	PickDestination();
	if (destPoint != None)
	{
		MoveToward(MoveTarget, MaxDesiredSpeed);
		while ((MoveTarget != None) && (MoveTarget != destPoint))
		{
			MoveTarget = FindPathToward(destPoint);
			if (MoveTarget != None)
				MoveToward(MoveTarget, MaxDesiredSpeed);
		}
	}
	else
		MoveTo(destLoc, MaxDesiredSpeed);

	Goto('Run');

Done:
	if (IsValidEnemy(Enemy))
		GotoState('HandlingEnemy', 'Begin');
	else
		FollowOrders();

ContinueBurn:
ContinueFromDoor:
	Goto('Run');
}

State Patrolling
{
Begin:
	destPoint = None;

Patrol:
	//Disable('Bump');
	WaitForLanding();
	PickDestination();

Moving:
	// Move from pathnode to pathnode until we get where we're going
	if (destPoint != None)
	{
		if (!IsPointInCylinder(self, destPoint.Location, 16-CollisionRadius))
		{
			EnableCheckDestLoc(true);
			MoveTarget = FindPathToward(destPoint);

			if ( MoveTarget == none)
			{
				Log("TNMPawn Failed to return to patrol");
				GotoState('Wandering');
			}

			while (MoveTarget != None)
			{
				if (ShouldPlayWalk(MoveTarget.Location))
					PlayWalking();
				MoveToward(MoveTarget, GetWalkingSpeed());
				CheckDestLoc(MoveTarget.Location, true);
				if (MoveTarget == destPoint)
					break;
				MoveTarget = FindPathToward(destPoint);
			}
			EnableCheckDestLoc(false);
		}
	}
	else
	{
		Goto('Patrol');
	}

Pausing:
	if (!bAlwaysPatrol)
		bStasis = true;
	Acceleration = vect(0, 0, 0);

	// Turn in the direction dictated by the WanderPoint, or a random direction
	if (PatrolPoint(destPoint) != None)
	{
		if ((PatrolPoint(destPoint).pausetime > 0) || (PatrolPoint(destPoint).NextPatrolPoint == None))
		{
			if (ShouldPlayTurn(Location + PatrolPoint(destPoint).lookdir))
				PlayTurning();
			TurnTo(Location + PatrolPoint(destPoint).lookdir);
			Enable('AnimEnd');
			TweenToWaiting(0.2);
			PlayScanningSound();
			//Enable('Bump');
			sleepTime = PatrolPoint(destPoint).pausetime * ((-0.9*restlessness) + 1);
			Sleep(sleepTime);
			Disable('AnimEnd');
			//Disable('Bump');
			FinishAnim();
		}
	}

	Goto('Patrol');

ContinuePatrol:
ContinueFromDoor:
	FinishAnim();
	PlayWalking();
	Goto('Moving');

}

defaultproperties
{
    bEmitCarcass=True
    bRestoreOrders=True
    originalOrders='
    AugHealthLimit=-999999.00
    Energy=500.00
    stealthmodifier=1.00
    breathtime=2.00
    BaseAccuracy=0.20
    maxRange=1000.00
    MinHealth=20.00
    bPlayIdle=True
    bCanCrouch=True
    bSprint=True
    CrouchRate=1.00
    SprintRate=1.00
    bHateCarcass=True
    bReactFutz=True
    bReactLoudNoise=True
    bReactAlarm=True
    bReactShot=True
    bReactCarcass=True
    bReactDistress=True
    EnemyTimeout=5.00
    bCanTurnHead=True
    WaterSpeed=80.00
    AirSpeed=160.00
    AccelRate=500.00
    BaseEyeHeight=40.00
    UnderWaterTime=20.00
    AttitudeToPlayer=4
    HitSound1=Sound'DeusExSounds.Player.MalePainSmall'
    HitSound2=Sound'DeusExSounds.Player.MalePainMedium'
    Die=Sound'DeusExSounds.Player.MaleDeath'
    VisibilityThreshold=0.01
    DrawType=2
    Mass=150.00
    Buoyancy=155.00
    BindName="HumanMilitary"
}
