class tnmpawnaugmanager extends actor;

var tnmpawn TNMP;

var tnmAugmentation FirstAug;

var() sound LoopSound;

event Destroyed()
{
	local tnmAugmentation anAug;

	anAug = FirstAug;
	while(anAug != None)
	{
		anAug.Destroy();
		anAug = anAug.next;
	}
	super.destroyed();
}

function float getcombatvalue()
{
	local tnmaugmentation aug;
	aug = findaug(class'tnmnpcaugcombat');
	if (aug != none)
		return aug.value;
	else
		return 1.0;
}


function tnmaugmentation findaug(class<tnmaugmentation> augclass)
{
	local tnmAugmentation anAug;

	anAug = FirstAug;
	while(anAug != None)
	{
		if (anaug.class == augclass)
			return anaug;
		anAug = anAug.next;
	}
}

function ActivateAugs(optional bool bhealth, optional bool bcombat)
{
	local tnmAugmentation anAug;

	if (TNMP != None)
	{
		TNMP.ambientsound = None;
		if (TNMP.Energy > 0)
		{
			anAug = FirstAug;
			while(anAug != None)
			{
				if((!anaug.bhealthactivated && !anaug.bcombatactivated)
					|| (bhealth && anaug.bhealthactivated)
					|| (bcombat && anaug.bcombatactivated))
					anAug.Activate();
				anAug = anAug.next;
//				if (anAug.bhealthactivated || anAug.bcombatactivated)
//					TNMP.ambientsound = loopsound;
			}
		}
		else
		{
			anAug = FirstAug;
			while(anAug != None)
			{
				anAug.DeActivate();
				anAug = anAug.next;
			}
		}	
	}
}

/*
function Deactivatesome(optional bool bhealth, optional bool bcombat)
{
	local tnmAugmentation anAug;

	anAug = FirstAug;
	while(anAug != None)
	{
		if ((anaug.bhealthactivated && bhealth)||(anaug.bcombatactivated && bcombat))
		anAug.Deactivate();
		anAug = anAug.next;
	}
}*/

// ----------------------------------------------------------------------
// DeactivateAll()
//
// Loops through all the Augmentations, deactivating any that are active.
// ----------------------------------------------------------------------

function DeactivateAll()
{
	local tnmAugmentation anAug;

	anAug = FirstAug;
	while(anAug != None)
	{
		anAug.Deactivate();
		anAug = anAug.next;
	}
}

// ----------------------------------------------------------------------
// CreateAugmentations()
// ----------------------------------------------------------------------

function CreateAugmentations(tnmpawn newtnmpawn)
{
	local int augIndex;
	local tnmAugmentation anAug;
	local tnmAugmentation lastAug;

	FirstAug = None;
	LastAug  = None;

	TNMP = newtnmpawn;

	for(augIndex=0; augIndex<arrayCount(TNMP.augs); augIndex++)
	{
		if(TNMP.augs[augindex] != none)
		{
			anAug = Spawn(TNMP.augs[augIndex], Self);
			anAug.setbase(self);
			anAug.TNMP = TNMP;
			if ((!anaug.bhealthactivated)&&(!anaug.bcombatactivated))
				anaug.activate();

			// Manage our linked list
			if (anAug != None)
			{
				if (FirstAug == None)
				{
					FirstAug = anAug;
				}
				else
				{
					LastAug.next = anAug;
				}

				LastAug  = anAug;
			}
		}
	}
}


// ----------------------------------------------------------------------
// NumAugsActive()
//
// How many augs are currently active?
// ----------------------------------------------------------------------

simulated function int NumAugsActive()
{
	local tnmAugmentation anAug;
	local int count;

	if (TNMP == None)
		return 0;

	count = 0;
	anAug = FirstAug;
	while(anAug != None)
	{
		if (anAug.bIsActive)
			count++;

		anAug = anAug.next;
	}

	return count;
}

/*function string getaugstring(bool bactive)
{
	local tnmAugmentation anAug;
	local string augstring;

	if (TNMP == None)
		return "";

	augstring = "";
	anAug = FirstAug;

	if (anaug != none)
		if (bactive)
			augstring = "Augmentation:" $ CHR(10) $ CHR (13);
		else
			augstring = CHR(10) $ CHR(13);
	anAug = anAug.next;
	while(anAug != None)
	{
		if (anAug.bIsActive == bactive)
		{
			augstring = augstring $ anAug.augmentationname;
			augstring = augstring $ CHR(10) $ CHR (13);

//			if (anAug.bIsActive) //obsolete yo
//				augstring = augstring $ "(active)";
		}

			anAug = anAug.next;
	}

	return augstring;
}*/

function drawaugtext(gc gc, float boxBRX, float boxTLY, float margin)
{
local float x, y, w, h, w2, h2;
local tnmAugmentation anAug;
local string str;

	if (TNMP == None)
		return;
	anAug = FirstAug;


	gc.GetTextExtent(0, w, h, "Augmentations:");
	x = boxBRX - w - margin;
	y = boxTLY + margin;

	while(anAug != None)
	{
		str = anAug.AugmentationName;

		gc.GetTextExtent(0, w2, h2, str);

		if (w2>w)
		{
			w = w2;
			x = boxBRX - w - margin;
		}
		anAug = anAug.next;
	}

	anAug = FirstAug;

	gc.SetTextColorRGB(0,255,0);
	str = "Augmentations:";

	gc.GetTextExtent(0, w2, h, str);

	gc.DrawText(x, y, w, h, str);
	boxTLY += h;

	while(anAug != None)
	{
		if (anAug.bIsActive)
			gc.SetTextColorRGB(255,255,0);
		else
			gc.SetTextColorRGB(255,255,255);

		str = anAug.AugmentationName;

		gc.GetTextExtent(0, w2, h, str);
		y = boxTLY + margin;
		gc.DrawText(x, y, w, h, str);
		boxTLY += h;
		anAug = anAug.next;
	}
}

defaultproperties
{
    DrawType=0
}
