class tnmscopeview extends deusexscopeview;

var bool bUsingGasMask;

var Color IFFColor;

event Tick(float deltaSeconds)
{
	local Crosshair        cross;
	local DeusExRootWindow dxRoot;

	dxRoot = DeusExRootWindow(GetRootWindow());
	if ((dxRoot != None) && (dxroot.hud != none)) //added hud!=none to account for destroyed hud in platform game
	{
		cross = dxRoot.hud.cross;

		if (bActive)
			cross.SetCrosshair(false);
		else
			cross.SetCrosshair(player.bCrosshairVisible);
	}
}

function ActivateView(int newFOV, bool bNewBinocs, bool bInstant)
{
	if (!bUsingGasMask)
	{
		super.ActivateView(newFOV,bNewBinocs,bInstant);
		Trestkon(player).scopeFOV=desiredFOV-player.Default.DefaultFOV;

		//fix the crosshair reappearing after reload. This hack overcomes a DX hack
		tnmcrosshair(deusexrootwindow(Trestkon(player).rootwindow).hud.cross).SetScoping(true);
	}
}

function DeActivateView()
{
	local tnmCrosshair cross;
	local DeusExHUD hud;
	super.DeactivateView();
	hud = deusexrootwindow(winParent).hud;
	cross = tnmCrosshair( hud.cross );
	cross.SetScoping(false);
	Trestkon(player).scopeFOV=0;
}

event DrawWindow(GC gc)
{
	local float			fromX, toX;
	local float			fromY, toY;
	local float			scopeWidth, scopeHeight;
	local tnmweapon weapon;

	Super(window).DrawWindow(gc);

	if (GetRootWindow().parentPawn != None)
	{
		if (player.IsInState('Dying'))
			return;
	}

	// Figure out where to put everything
	if (bBinocs)
	{
		scopeWidth  = 512;
		scopeHeight = 256;
	}
	else
	{
		scopeWidth  = 512;
		scopeHeight = 512;
	}

	fromX = (width-scopeWidth)/2;
	fromY = (height-scopeHeight)/2;
	toX   = fromX + scopeWidth;
	toY   = fromY + scopeHeight;

	// Draw the black borders
	gc.SetTileColorRGB(0, 0, 0);
	gc.SetStyle(DSTY_Normal);
	if ( Player.Level.NetMode == NM_Standalone )	// Only block out screen real estate in single player
	{
		gc.DrawPattern(0, 0, width, fromY, 0, 0, Texture'Solid');
		gc.DrawPattern(0, toY, width, fromY, 0, 0, Texture'Solid');
		gc.DrawPattern(0, fromY, fromX, scopeHeight, 0, 0, Texture'Solid');
		gc.DrawPattern(toX, fromY, fromX, scopeHeight, 0, 0, Texture'Solid');
	}
	// Draw the center scope bitmap
	// Use the Header Text color 

//	gc.SetStyle(DSTY_Masked);
	if (bBinocs)
	{
		gc.SetStyle(DSTY_Modulated);
		gc.DrawTexture(fromX,       fromY, 256, scopeHeight, 0, 0, Texture'HUDBinocularView_1');
		gc.DrawTexture(fromX + 256, fromY, 256, scopeHeight, 0, 0, Texture'HUDBinocularView_2');

		gc.SetTileColor(colLines);
		gc.SetStyle(DSTY_Masked);
		gc.DrawTexture(fromX,       fromY, 256, scopeHeight, 0, 0, Texture'HUDBinocularCrosshair_1');
		gc.DrawTexture(fromX + 256, fromY, 256, scopeHeight, 0, 0, Texture'HUDBinocularCrosshair_2');
	}
	else
	{
		// Crosshairs - Use new scope in multiplayer, keep the old in single player
		if ( Player.Level.NetMode == NM_Standalone )
		{
		    weapon = tnmweapon(Player.inHand);
		    if (weapon != None)
		    {
			switch ( weapon.ScopeType )
			{
			case EScopeType_Custom:
				gc.SetStyle(DSTY_Modulated);
				gc.DrawTexture(fromX, fromY, scopeWidth, scopeHeight, 0, 0, weapon.ScopeTexture01);
				gc.DrawTexture(fromX+scopeWidth/2, fromY, scopeWidth, scopeHeight, 0, 0, weapon.ScopeTexture02);
				gc.DrawTexture(fromX, fromY+scopeHeight/2, scopeWidth, scopeHeight, 0, 0, weapon.ScopeTexture03);
				gc.DrawTexture(fromX+scopeWidth/2, fromY+scopeHeight/2, scopeWidth, scopeHeight, 0, 0, weapon.ScopeTexture04);
				weapon.DrawAdditionalScope(gc, width, height);
				break;
			case EScopeType_HighTech:
				gc.SetStyle(DSTY_Modulated);
				gc.DrawTexture(fromX, fromY, scopeWidth, scopeHeight, 0, 0, texture'TNMHUDScopeHitechCrosshair01');
				gc.DrawTexture(fromX+scopeWidth/2, fromY, scopeWidth, scopeHeight, 0, 0, texture'TNMHUDScopeHitechCrosshair02');
				gc.DrawTexture(fromX, fromY+scopeHeight/2, scopeWidth, scopeHeight, 0, 0, texture'TNMHUDScopeHitechCrosshair03');
				gc.DrawTexture(fromX+scopeWidth/2, fromY+scopeHeight/2, scopeWidth, scopeHeight, 0, 0, texture'TNMHUDScopeHitechCrosshair04');

				gc.SetTileColorRGB(255, 255, 255);
				gc.SetStyle(DSTY_Masked);
				gc.DrawTexture(fromX, fromY, scopeWidth, scopeHeight, 0, 0, texture'TNMHUDScopeHitechView01');
				gc.DrawTexture(fromX+scopeWidth/2, fromY, scopeWidth, scopeHeight, 0, 0, texture'TNMHUDScopeHitechView02');
				gc.DrawTexture(fromX, fromY+scopeHeight/2, scopeWidth, scopeHeight, 0, 0, texture'TNMHUDScopeHitechView03');
				gc.DrawTexture(fromX+scopeWidth/2, fromY+scopeHeight/2, scopeWidth, scopeHeight, 0, 0, texture'TNMHUDScopeHitechView04');

				gc.SetTileColorRGB(IFFColor.R, IFFColor.G, IFFColor.B);
				gc.SetStyle(DSTY_Normal);
				gc.DrawPattern(width/2 - 2, height/2 - 2, 2, 2, 0, 0, Texture'Solid');
				break;
			default:
				gc.SetStyle(DSTY_Modulated);
				gc.DrawTexture(fromX, fromY, scopeWidth, scopeHeight, 0, 0, Texture'TNMHUDScopeView01');
				gc.DrawTexture(fromX+scopeWidth/2, fromY, scopeWidth, scopeHeight, 0, 0, Texture'TNMHUDScopeView02');
				gc.DrawTexture(fromX, fromY+scopeHeight/2, scopeWidth, scopeHeight, 0, 0, Texture'TNMHUDScopeView03');
				gc.DrawTexture(fromX+scopeWidth/2, fromY+scopeHeight/2, scopeWidth, scopeHeight, 0, 0, Texture'TNMHUDScopeView04');
				gc.SetTileColorRGB(IFFColor.R, IFFColor.G, IFFColor.B);
				gc.SetStyle(DSTY_Normal);
				gc.DrawPattern(width/2 - 2, height/2 - 2, 2, 2, 0, 0, Texture'Solid');
				gc.SetTileColor(colLines);
				gc.SetStyle(DSTY_Masked);
				gc.DrawTexture(fromX, fromY, scopeWidth, scopeHeight, 0, 0, Texture'TNMHUDScopeCrosshair01');
				gc.DrawTexture(fromX+scopeWidth/2, fromY, scopeWidth, scopeHeight, 0, 0, Texture'TNMHUDScopeCrosshair02');
				gc.DrawTexture(fromX, fromY+scopeHeight/2, scopeWidth, scopeHeight, 0, 0, Texture'TNMHUDScopeCrosshair03');
				gc.DrawTexture(fromX+scopeWidth/2, fromY+scopeHeight/2, scopeWidth, scopeHeight, 0, 0, Texture'TNMHUDScopeCrosshair04');
				break;
			}
		    }
		}
	}
}

defaultproperties
{
}
