//=============================================================================
// AugDatalink.
//=============================================================================
class TDPAugpm extends Augmentation;

var() localized string AugmentationName;
var() localized string Description;
var() localized string RealAugmentationName;
var() localized string RealDescription;

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
state Active
{
Begin:
}

// ----------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------

simulated function bool UpdateInfo(Object winObject)
{
	local PersonaInfoWindow winInfo;
	local String strOut;
	local TDPLevelInfo info;

	winInfo = PersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.Clear();
	
	if ((info != None) && (info.bRealWorld))
	{
		winInfo.SetTitle(RealAugmentationName);
	}
	Else
	{
		winInfo.SetTitle(AugmentationName);
	}

	if (bUsingMedbot)
	{
		winInfo.SetText(Sprintf(OccupiesSlotLabel, AugLocsText[AugmentationLocation]));
		
		if ((info != None) && (info.bRealWorld))
		{
			winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ RealDescription);
		}
		Else
		{
			winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ Description);
		}
	}
	else
	{
		if ((info != None) && (info.bRealWorld))
		{
			winInfo.SetText(RealDescription);
		}
		Else
		{
			winInfo.SetText(Description);
		}
	}

	winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ Sprintf(EnergyRateLabel, Int(EnergyRate)));

	strOut = Sprintf(CurrentLevelLabel, CurrentLevel + 1);
	
	if (CanBeUpgraded())
		strOut = strOut @ CanUpgradeLabel;
	else if (CurrentLevel == MaxLevel )
		strOut = strOut @ MaximumLabel;

	winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ strOut);

	// Always Active?
	if (bAlwaysActive)
		winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ AlwaysActiveLabel);

	return True;
}

// ----------------------------------------------------------------------
// Deactivate()
// ----------------------------------------------------------------------

function Deactivate()
{
	Super.Deactivate();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

function bool IncLevel()
{
	if ( CurrentLevel >= MaxLevel )
	{
		Player.ClientMessage(Sprintf(AugAlreadyHave, AugmentationName));
		return False;
	}

	if (bIsActive)
		Deactivate();

	CurrentLevel++;
				
	Player.ClientMessage(Sprintf(AugNowHave, AugmentationName, CurrentLevel + 1));
}

defaultproperties
{
    EnergyRate=0.00
    MaxLevel=0
    Icon=Texture'DeusExUI.UserInterface.AugIconDatalink'
    smallIcon=Texture'DeusExUI.UserInterface.AugIconDatalink_Small'
    bAlwaysActive=True
    AugmentationName="Personal Message Inbox"
    Description="Upgraded version of the Private Messaging system allows forumites to send each other images and notes as well as text messages. All Private Messages are still stored in the datavault for future reference.|n|nNote: Your version has been damaged in a battle, please repair. |n<SCAN>Damaged parts: Send "Text, images"; Receive "No error detected".</SCAN> |n|nNO UPGRADES"
    RealAugmentationName="Infolink"
    RealDescription="One-way micro-transceiver array allows agents in the field to receive messages from Control, and to store and later retrieve relevant maps, conversations, and notes.|n|n<DARMA LABORATORY: ELECTRONIC, NOTE> Stoled from Pages Biotech, Cannot be upgraded: Top system atm: Can receive pms from any internet server. <END NOTE>|n|nNO UPGRADES"
    LevelValues(0)=1.00
    LevelValues(1)=1.00
    LevelValues(2)=1.00
    LevelValues(3)=1.00
    AugmentationLocation=6
}
