//=============================================================================
// Decoration: Frob them and get items.
//=============================================================================
class TDPCTIContainers extends TDPDecoration;

/*struct InventoryItemDecoration  {
	var() class<Inventory> Inventory;
	var() int              count;
};*/

var() bool bHasItem;
var() class<Inventory>	spawnItemClass;	// item to give the player if frobbed
var() class<Ammo>	spawnAmmoClass;	// ammo to give the player if frobbed
var() int 		SAmmoAmount;	// Amount of ammo to give the player

//var(Inventory) InventoryItemDecoration InitialInventory[8];  // Initial inventory items held in the carcass

/*function PostBeginPlay()
{
	local int i, j;
	local Inventory inv;

	bCollideWorld = true;

	// Use the carcass name by default
	CarcassName = Name;

	// Add initial inventory items
	for (i=0; i<8; i++)
	{
		if ((InitialInventory[i].inventory != None) && (InitialInventory[i].count > 0))
		{
			for (j=0; j<InitialInventory[i].count; j++)
			{
				inv = spawn(InitialInventory[i].inventory, self);
				if (inv != None)
				{
					inv.bHidden = True;
					inv.SetPhysics(PHYS_None);
					AddInventory(inv);
				}
			}
		}
	}

}

function Frob(Actor Frobber, Inventory frobWith)
{
	local Inventory item, nextItem, startItem;
	local Pawn P;
	local DeusExWeapon W;
	local bool bFoundSomething;
	local DeusExPlayer player;
	local ammo AmmoType;
	local bool bPickedItemUp;
	local DeusExPickup invItem;
	local int itemCount;

	player = DeusExPlayer(Frobber);
	bFoundSomething = False;
	bSearchMsgPrinted = False;
	P = Pawn(Frobber);

	if (P != None)
	{
		if ( (player != None) && (Level.NetMode == NM_Standalone) )
			DeusExRootWindow(player.rootWindow).hud.receivedItems.RemoveItems();

		if (Inventory != None)
		{
			item = Inventory;
			startItem = item;
			do
			{
				nextItem = item.Inventory;

				bPickedItemUp = False;

				if (item.IsA('Ammo'))
				{
					DeleteInventory(item);
					item.Destroy();
					item = None;
				}
				else if ( (item.IsA('DeusExWeapon')) )
				{
					W = DeusExWeapon(item);

               				if (W.IsA('WeaponNanoVirusGrenade') || W.IsA('WeaponGasGrenade') || W.IsA('WeaponEMPGrenade') || W.IsA('WeaponLAM'))
                  				W.PickupAmmoCount = 1;
              				else if (Level.NetMode == NM_Standalone)
                  				W.PickupAmmoCount = Rand(4) + 1;
				}
				if (item != None)
				{
					bFoundSomething = True;

					if (item.IsA('NanoKey'))
					{
						if (player != None)
						{
							player.PickupNanoKey(NanoKey(item));
							AddReceivedItem(player, item, 1);
							DeleteInventory(item);
							item.Destroy();
							item = None;
						}
						bPickedItemUp = True;
					}
					else if (item.IsA('Credits'))
					{
						if (player != None)
						{
							AddReceivedItem(player, item, Credits(item).numCredits);
							player.Credits += Credits(item).numCredits;
							P.ClientMessage(Sprintf(Credits(item).msgCreditsAdded, Credits(item).numCredits));
							DeleteInventory(item);
							item.Destroy();
							item = None;
						}
						bPickedItemUp = True;
					}
					else if (item.IsA('DeusExWeapon'))
					{
						W = DeusExWeapon(player.FindInventoryType(item.Class));

						if ((W != None) || ((W == None) && (!player.FindInventorySlot(item, True))))
						{
							if ((Weapon(item).AmmoType != None) && (Weapon(item).AmmoType.AmmoAmount > 0))
							{
								AmmoType = Ammo(player.FindInventoryType(Weapon(item).AmmoName));

                        					if ((AmmoType != None) && (AmmoType.AmmoAmount < AmmoType.MaxAmmo))
								{
                           						AmmoType.AddAmmo(Weapon(item).PickupAmmoCount);
                           						AddReceivedItem(player, AmmoType, Weapon(item).PickupAmmoCount);
                           
									player.UpdateAmmoBeltText(AmmoType);

									if (AmmoType.PickupViewMesh == Mesh'TestBox')
										P.ClientMessage(item.PickupMessage @ item.itemArticle @ item.itemName, 'Pickup');
									else
										P.ClientMessage(AmmoType.PickupMessage @ AmmoType.itemArticle @ AmmoType.itemName, 'Pickup');

									Weapon(item).AmmoType.AmmoAmount = 0;
								}
							}

							if ((W == None) && (!player.FindInventorySlot(item, True)))
								P.ClientMessage(Sprintf(Player.InventoryFull, item.itemName));

							if (W != None)
							{
								DeleteInventory(item);
								item.Destroy();
								item = None;
							}

							bPickedItemUp = True;
						}
					}

					else if (item.IsA('DeusExAmmo'))
					{
						if (DeusExAmmo(item).AmmoAmount == 0)
							bPickedItemUp = True;
					}

					if (!bPickedItemUp)
					{
						if ((item.IsA('DeusExPickup')) && (DeusExPickup(item).bCanHaveMultipleCopies) && (player.FindInventoryType(item.class) != None))
						{
							invItem   = DeusExPickup(player.FindInventoryType(item.class));
							itemCount = DeusExPickup(item).numCopies;

							if ((invItem.MaxCopies > 0) && (DeusExPickup(item).numCopies + invItem.numCopies > invItem.MaxCopies))
							{	
								if ((invItem.MaxCopies - invItem.numCopies) > 0)
								{
									itemCount = (invItem.MaxCopies - invItem.numCopies);
									DeusExPickup(item).numCopies -= itemCount;
									invItem.numCopies = invItem.MaxCopies;
									P.ClientMessage(invItem.PickupMessage @ invItem.itemArticle @ invItem.itemName, 'Pickup');
									AddReceivedItem(player, invItem, itemCount);
								}
								else
								{
									P.ClientMessage(Sprintf(msgCannotPickup, invItem.itemName));
								}
							}
							else
							{
								invItem.numCopies += itemCount;
								DeleteInventory(item);

								P.ClientMessage(invItem.PickupMessage @ invItem.itemArticle @ invItem.itemName, 'Pickup');
								AddReceivedItem(player, invItem, itemCount);
							}
						}
						else
						{
							if ((P.Inventory == None) || (Level.Game.PickupQuery(P, item)))
							{
								DeusExPlayer(P).FrobTarget = item;
								if (DeusExPlayer(P).HandleItemPickup(Item) != False)
								{
                           DeleteInventory(item);

                           item.bInObjectBelt=False;
                           item.BeltPos=-1;
									
                           item.SpawnCopy(P);

									AddReceivedItem(player, item, 1);
									
									P.ClientMessage(Item.PickupMessage @ Item.itemArticle @ Item.itemName, 'Pickup');
									PlaySound(Item.PickupSound);
								}
							}
							else
							{
								DeleteInventory(item);
								item.Destroy();
								item = None;
							}
						}
					}
				}
				item = nextItem;
			}
			until ((item == None) || (item == startItem));
		}
		if (!bFoundSomething)
			P.ClientMessage(msgEmpty);
	}
   if ((player != None) && (Level.Netmode != NM_Standalone))
   {
	player.ClientMessage(Sprintf(msgRecharged, 25));
	PlaySound(sound'BioElectricHiss', SLOT_None,,, 256);
	player.Energy += 25;
	if (player.Energy > player.EnergyMax)
		player.Energy = player.EnergyMax;
   }

	Super.Frob(Frobber, frobWith);

   if ((Level.Netmode != NM_Standalone) && (Player != None))   
   {
	bQueuedDestroy = true;
	Destroy();	  
   }
}

// ----------------------------------------------------------------------
// AddReceivedItem()
// ----------------------------------------------------------------------

function AddReceivedItem(DeusExPlayer player, Inventory item, int count)
{
	local DeusExWeapon w;
	local Inventory altAmmo;

	if (!bSearchMsgPrinted)
	{
		player.ClientMessage(msgSearching);
		bSearchMsgPrinted = True;
	}

   DeusExRootWindow(player.rootWindow).hud.receivedItems.AddItem(item, 1);

	// Make sure the object belt is updated
	if (item.IsA('Ammo'))
		player.UpdateAmmoBeltText(Ammo(item));
	else
		player.UpdateBeltText(item);

	// Deny 20mm and WP rockets off of bodies in multiplayer
	if ( Level.NetMode != NM_Standalone )
	{
		if ( item.IsA('WeaponAssaultGun') || item.IsA('WeaponGEPGun') )
		{
			w = DeusExWeapon(player.FindInventoryType(item.Class));
			if (( Ammo20mm(w.AmmoType) != None ) || ( AmmoRocketWP(w.AmmoType) != None ))
			{
				altAmmo = Spawn( w.AmmoNames[0] );
				DeusExAmmo(altAmmo).AmmoAmount = w.PickupAmmoCount;
				altAmmo.Frob(player,None);
				altAmmo.Destroy();
				w.AmmoType.Destroy();
				w.LoadAmmo( 0 );
			}
		}
	}
}

// ----------------------------------------------------------------------
// AddInventory()
//
// copied from Engine.Pawn
// Add Item to this carcasses inventory. 
// Returns true if successfully added, false if not.
// ----------------------------------------------------------------------

function bool AddInventory( inventory NewItem )
{
	// Skip if already in the inventory.
	local inventory Inv;

	for( Inv=Inventory; Inv!=None; Inv=Inv.Inventory )
		if( Inv == NewItem )
			return false;

	// The item should not have been destroyed if we get here.
	assert(NewItem!=None);

	// Add to front of inventory chain.
	NewItem.SetOwner(Self);
	NewItem.Inventory = Inventory;
	NewItem.InitialState = 'Idle2';
	Inventory = NewItem;

	return true;
}

// ----------------------------------------------------------------------
// DeleteInventory()
// 
// copied from Engine.Pawn
// Remove Item from this pawn's inventory, if it exists.
// Returns true if it existed and was deleted, false if it did not exist.
// ----------------------------------------------------------------------

function bool DeleteInventory( inventory Item )
{
	// If this item is in our inventory chain, unlink it.
	local actor Link;

	for( Link = Self; Link!=None; Link=Link.Inventory )
	{
		if( Link.Inventory == Item )
		{
			Link.Inventory = Item.Inventory;
			break;
		}
	}
   Item.SetOwner(None);
}*/

function Frob(actor Frobber, Inventory frobWith)
{
	Local TDPNeo Player;

	if(bHasItem)
	{
		if (player != None)
		{
			if (spawnItemClass != None)	// spawn the item
			{
				frobWith = Spawn(spawnItemClass);
			}
			if (spawnAmmoClass != None)	// Spawn the ammo
			{
				frobWith = Spawn(spawnAmmoClass);

				if (frobWith != None)
				{
					if (Self.IsA('Dart'))
						Ammo(frobWith).AmmoAmount = SAmmoAmount * 3;
					else
						Ammo(frobWith).AmmoAmount = SAmmoAmount;
				}
			}
			if (frobWith != None)
			{
				player.FrobTarget = frobWith;

				frobWith.Destroy();

				player.FrobTarget = None;
			}
		}
	}
	super.Frob(Frobber, frobWith);
}

defaultproperties
{
//    msgSearching="You found:"
//    msgEmpty="You don't find anything"
//    msgCannotPickup="You cannot pickup the %s"
}