//=============================================================================
// TDPInfoLinKDisplay
//=============================================================================
class TDPInfoLinKDisplay expands HUDBaseWindow
	transient;

#exec OBJ LOAD FILE=TDPInfoPortraits

// ----------------------------------------------------------------------
// Local Variables
// ----------------------------------------------------------------------

var Window              winLine;
var Window				winPortrait;
var StaticWindow		winStatic;
var TextWindow			winName;
var TextWindow			winQueued;
var ComputerWindow		winText;

// defaults
var Color colName;
var Color colCursor;
var Color colQueued;
var Color colLine;

var Font  fontName;
var Font  fontText;
var int   fontTextX;
var int   fontTextY;

var Texture speakerPortrait;
var Bool    bPortraitVisible;

var Texture texBackgrounds[2];
var Texture texBorders[2];

// Time for PMs
var localized string strQueued;
var localized string IncomingTransmission;

// Small hack for the real world PM System, back to Datalink :D.
var localized string RealstrQueued;
var localized string RealIncomingTransmission;

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	// Assign border textures
	SetSize(431, 114);

	// Create Controls
	CreateControls();
}

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	local TDPLevelInfo info;

	// Create window for person speaking
	winPortrait = NewChild(Class'Window');
	winPortrait.SetSize(64, 64);
	winPortrait.SetPos(20, 25);
	winPortrait.SetBackgroundStyle(DSTY_Normal);

	// Window used to display static
	winStatic = StaticWindow(NewChild(Class'StaticWindow'));
	winStatic.SetSize(64, 64);
	winStatic.RandomizeStatic();
	winStatic.SetPos(20, 25);
	winStatic.SetBackgroundStyle(DSTY_Modulated);
	winStatic.Raise();
	winStatic.Hide();

	// Create the name bar
	winName = TextWindow(NewChild(Class'TextWindow'));
	winName.SetTextAlignments(HALIGN_Left, VALIGN_Center);
	winName.SetSize(293, 15);
	winName.SetPos(94, 15);
	winName.SetFont(fontName);
	winName.SetTextColor(colName);
	winName.SetTextMargins(0, 0);
	if ((info != None) && (info.bRealWorld))
	{
		winName.SetText(IncomingTransmission);
	}
	Else
	{
		winName.SetText(RealIncomingTransmission);
	}

	// Create the queued bar
	winQueued = TextWindow(NewChild(Class'TextWindow'));
	winQueued.SetTextAlignments(HALIGN_Right, VALIGN_Center);
	winQueued.SetSize(200, 15);
	winQueued.SetPos(187, 15);
	winQueued.SetFont(fontName);
	winQueued.SetTextColor(colQueued);
	winQueued.SetTextMargins(0, 0);

	// Create the computer window
	winText = ComputerWindow(NewChild(Class'ComputerWindow'));
	winText.SetPos(94, 36);
	winText.SetTextSize(42, 6);
	winText.SetTextFont(fontText, fontTextX, fontTextY, colText);
	winText.SetTextTiming(0.03);
	winText.SetFadeSpeed(0.75);
	winText.SetCursorColor(colCursor);
	winText.EnableWordWrap(True);

	// Create line between name and scrolling text
	winLine = NewChild(Class'Window');
	winLine.SetSize(293, 1);
	winLine.SetPos(94, 32);
	winLine.SetBackgroundStyle(DSTY_Normal);
	winLine.SetBackground(Texture'Solid');
	winLine.SetTileColor(colLine);
}

// ----------------------------------------------------------------------
// DrawBackground()
// ----------------------------------------------------------------------

function DrawBackground(GC gc)
{
	gc.SetStyle(backgroundDrawStyle);
	gc.SetTileColor(colBackground);
	gc.DrawTexture(  0, 0, 256, height, 0, 0, texBackgrounds[0]);
	gc.DrawTexture(256, 0, 175, height, 0, 0, texBackgrounds[1]);
}

// ----------------------------------------------------------------------
// DrawBorder()
// ----------------------------------------------------------------------

function DrawBorder(GC gc)
{
	if (bDrawBorder)
	{
		gc.SetStyle(borderDrawStyle);
		gc.SetTileColor(colBorder);
		gc.DrawTexture(  0, 0, 256, height, 0, 0, texBorders[0]);
		gc.DrawTexture(256, 0, 175, height, 0, 0, texBorders[1]);
	}
}

// ----------------------------------------------------------------------
// DisplayText()
// ----------------------------------------------------------------------

function DisplayText(String newText)
{
	winText.Print(newText, False);
}

// ----------------------------------------------------------------------
// AppendText()
// ----------------------------------------------------------------------

function AppendText(String newText)
{
	winText.Print(NewText, False);
}

// ----------------------------------------------------------------------
// SetSpeaker()
//
// Sets the speaker's name in the window and also the portrait 
// displayed in the window
// ----------------------------------------------------------------------

function SetSpeaker(String bindName, String displayName)
{
	local String portraitStringName;
	local DeusExLevelInfo info;

	winName.SetText(displayName);

	portraitStringName = "TDPInfoPortraits." $ Left(bindName, 16);

// I don't want to use the same hack as the BobPageAugmented's hack for Darma because it only works if we meet Darma IMEDIATLY when the mission XX start.
// I don't know alot in convos because I don't really tried it yet (Started by mapping --> Texturing --> Coding --> Texts/Convos/Script --> Modelling).

	speakerPortrait = Texture(DynamicLoadObject(portraitStringName, class'Texture'));
}

// ----------------------------------------------------------------------
// MessageQueued()
// Hehe, small hack for the real world
// ----------------------------------------------------------------------

function MessageQueued(Bool bQueued)
{
	local DeusExLevelInfo info;

	info = player.GetLevelInfo();

	if ((info != None) && (info.MissionNumber == 30) || (info.MissionNumber == 29))
	{
		if ( bQueued )
		{
			winQueued.SetText(strQueued);
		}
		else
		{
			winQueued.SetText("");
		}
	}
	Else
	{
		if ( bQueued )
		{
			winQueued.SetText(RealstrQueued);
		}
		else
		{
			winQueued.SetText("");
		}
	}

}

// ----------------------------------------------------------------------
// ClearScreen()
// ----------------------------------------------------------------------

function ClearScreen()
{
	winText.ClearScreen();
}

// ----------------------------------------------------------------------
// ShowTextCursor()
// ----------------------------------------------------------------------

function ShowTextCursor(Bool bShow)
{
	winText.ShowTextCursor(bShow);
}

// ----------------------------------------------------------------------
// ShowDatalinkIcon()
// ----------------------------------------------------------------------

function ShowDatalinkIcon(bool bShow)
{
	winPortrait.SetBackground(Texture'DataLinkIcon');
	winPortrait.SetBackgroundStyle(DSTY_Masked);
	winPortrait.Show(bShow);

	bPortraitVisible = False;
	bTickEnabled     = False;

	winStatic.Hide();
}

// ----------------------------------------------------------------------
// ShowPortrait()
// ----------------------------------------------------------------------

function ShowPortrait()
{
	winPortrait.SetBackground(speakerPortrait);
	winPortrait.SetBackgroundStyle(DSTY_Normal);
	winPortrait.Show(True);

	bPortraitVisible = True;
	
	winStatic.Show();
}

// ----------------------------------------------------------------------
// StyleChanged()
// ----------------------------------------------------------------------

event StyleChanged()
{
	local ColorTheme theme;

	Super.StyleChanged();

	theme = player.ThemeManager.GetCurrentHUDColorTheme();

	colName   = theme.GetColorFromName('HUDColor_HeaderText');
	colLine   = theme.GetColorFromName('HUDColor_NormalText');;
	colCursor = colName;
	colQueued = theme.GetColorFromName('HUDColor_NormalText');
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
defaultproperties
{
    FontName=Font'DeusExUI.FontMenuHeaders_DS'
    fontText=Font'DeusExUI.FontFixedWidthSmall_DS'
    fontTextX=7
    fontTextY=10
    texBackgrounds(0)=Texture'DeusExUI.UserInterface.HUDInfolinkBackground_1'
    texBackgrounds(1)=Texture'DeusExUI.UserInterface.HUDInfolinkBackground_2'
    texBorders(0)=Texture'DeusExUI.UserInterface.HUDInfolinkBorder_1'
    texBorders(1)=Texture'DeusExUI.UserInterface.HUDInfolinkBorder_2'
    strQueued="unreaded PM(s)."
    IncomingTransmission="PERSONNAL MESSAGE..."
    RealstrQueued="message(s) waiting..."
    RealIncomingTransmission="INCOMING TRANSMISSION..."
}
