//====================================================================================
// TDP Neo, the new protagonist.
//====================================================================================
class TDPNeo extends Trestkon;

//====================================================================================
// TDP
//====================================================================================

#exec obj load file="..\TNM\TEXTURES\TNM_Core_tex.utx

// takeclothes vars
var Actor ClothesTarget;

// for the clothesbags
Var string 		ClothesName;		// human readable name

replication
{
    // client to server
	reliable if (Role < ROLE_Authority)
		ClothesTarget;
}

function Possess() //modified to spawn the custom frobdisplay...
{
	local deusexrootwindow root;
        local actordisplaywindow pooractordisplay;

	Super.Possess();

	root = DeusExRootWindow(rootwindow); //find our root

	if ((root != none) && (!root.actordisplay.IsA('ExActorDisplayWindow')))//if we're not the custom type...
	{
		pooractordisplay = root.actordisplay;

 		root.actorDisplay.Hide(); //HIDE the old actordisplay and tell us what it was...
		log("ExPlayer: Destroying old actordisplay called: "$pooractordisplay$"!");
//		ClientMessage("|p4ExPlayer: Destroying old actordisplay called: "$pooractordisplay$"!");
		pooractordisplay.Destroy();  //then kill us...
		root.actordisplay = None; //make us THINK we've been destroyed
//          	root.actorDisplay = ExActorDisplayWindow(root.NewChild(Class'ExActorDisplayWindow')); //and spawn a new one of our custom type...
         	root.actorDisplay.SetWindowAlignments(HALIGN_Full, VALIGN_Full); //this is important I think... 
         	log("ExPlayer: Attempting to create new actordisplay... actor display now called: "$root.actorDisplay$"!"); //tell us the NEW actor display
//         	ClientMessage("|p3ExPlayer: Attempting to create new actordisplay... actor display now called: "$root.actorDisplay$"!"); //tell us the NEW actor display
	}
}

exec function ShowProp(string NewProp)
{
	local DeusExRootWindow root;
	local bool bShow;

	if (!bCheatsEnabled)
		return;

	if (NewProp != "") 
		bShow = True;

	root = DeusExRootWindow(rootWindow);

	//if(root!=None)
        	//if (ExActorDisplayWindow(root.actorDisplay) != None)
           	//	ExActorDisplayWindow(root.actorDisplay).ShowCusProp(bShow, NewProp);
}

state CantFire
{
	ignores SeePlayer, HearNoise, Bump;

	exec function Fire( optional float F )
	{
	}

	exec function AltFire( optional float F )
	{
	}

	function AnimEnd()
	{
		if ( (Role == ROLE_Authority) && (Health > 0) )
		{
			GotoState('PlayerWalking');
			PendingWeapon.SetDefaultDisplayProperties();
			ChangedWeapon();
		}
	}

	event PlayerTick( float DeltaTime )
	{
		Weapon = None; 
	}
	
	function ChangedWeapon()
	{
		Weapon = None;
		Inventory.ChangedWeapon();
	}

	function EndState()
	{
		GotoState('PlayerWalking');
	}

	function BeginState()
	{
		if ( carriedDecoration != None )
			DropDecoration();
	}
}

event TravelPostAccept()
{
	local DeusExLevelInfo info;
	local bool bhasvisor;
	local bool bhascoat;
	local int tempskin;
	local flagbase flags;
	local tnmTextureController tc;
	local int i;

	Super.TravelPostAccept();

	foreach AllActors(class'tnmTextureController',tc)
		tc.beginplay();

	if(buf_contents[0]!="")
	{
		buf=class'CommandBuffer'.static.FromString(self);
		for(i=0;i<arraycount(buf_contents);i++)
			buf_contents[i]="";
		buf.GotoState('Executing');
	}

	flags = flagbase;
	tempskin = PlayerSkin;
	
	if (tempskin >= 12)
	{
		tempskin -= 12;
		bhascoat = true;
	}
	if (tempskin >= 6)
	{
		tempskin -= 6;
		bhasvisor = true;
	}

	if (bhascoat)
	{
		flags.SetBool('TNMPACS_Coat' , bhascoat);
		Mesh = LodMesh'DeusExCharacters.GM_Trench';
		Multiskins[0] = Texture'TDP.Player.PCTex0B';
		Multiskins[1] = Texture'TDP.Player.PCTex3';
		Multiskins[2] = Texture'TDP.Player.PCTex2';
		Multiskins[3] = Texture'TDP.Player.PCTex0B';
		Multiskins[4] = Texture'TDP.Player.PCTex1B';
		Multiskins[5] = Texture'TDP.Player.PCTex3';
	}
	else
	{
		Mesh = LodMesh'MPCharacters.mp_jumpsuit';
		Multiskins[0] = Texture'TDP.Player.PCTex0B';
		Multiskins[1] = Texture'TDP.Player.PCTex2';
		Multiskins[2] = Texture'TDP.Player.PCTex1';
		Multiskins[3] = Texture'TDP.Player.PCTex0B';
	}

	if (bhasvisor)
	{
		flags.SetBool('TNMPACS_Eyewear' , bhasvisor);
		if (bhascoat)
		{
			Multiskins[6] = Texture'tnm.Skins.FramesTex4';
			Multiskins[7] = Texture'tnm.Skins.LensesTex5';
		}
		else
		{
			Multiskins[6] = Texture'deusexcharacters.skins.gogglestex1';
		}
	}
	else
	{
		if (bhascoat)
		{
			Multiskins[6] = Texture'DeusExItems.Skins.GrayMaskTex';
			Multiskins[7] = Texture'DeusExItems.Skins.PinkMaskTex';
		}
		else
		{
			Multiskins[6] = Texture'DeusExItems.Skins.PinkMaskTex';
			Multiskins[7] = Texture'DeusExItems.Skins.PinkMaskTex';
		}
	}

	switch(tempskin)
	{
		case 0:	MultiSkins[3] = Texture'TDP.Player.PCTex0B'; MultiSkins[0] = Texture'TDP.Player.PCTex0B'; break;
		case 1:	MultiSkins[3] = Texture'TDP.Player.PCTex0C'; MultiSkins[0] = Texture'TDP.Player.PCTex0C'; break;
		case 2:	MultiSkins[3] = Texture'TDP.Player.PCTex0';  MultiSkins[0] = Texture'TDP.Player.PCTex0'; break;
//		case 3:	MultiSkins[3] = Texture'tnm.skins.TrestkonTex6'; MultiSkins[0] = Texture'tnm.skins.TrestkonTex6'; break;
//		case 4:	MultiSkins[3] = Texture'tnm.skins.TrestkonTex7'; MultiSkins[0] = Texture'tnm.skins.TrestkonTex7'; break;
//		case 5:	MultiSkins[3] = Texture'tnm.skins.TrestkonTex8'; MultiSkins[0] = Texture'tnm.skins.TrestkonTex8'; break;
	}

	//horrible!   Sorry Shane! if you can find a better way, be my guest! -DDL
	settimer(1.0,true);
}

// ----------------------------------------------------------------------
// TakeClothes()
// 
// Steal his clothes
// ----------------------------------------------------------------------

exec function TakeClothes()
{

	local int 		i;
	local ClothesBag	Clothes;
	Local TDPCarcass	Carcass;

	if (ClothesTarget != None)
	{

/*Only allow taking thoses mesh:
GM_DressShirt
GM_DressShirt_F (send to GM_DressShirt?)
GM_DressShirt_S (send to GM_DressShirt?)
GM_DressShirt_B
GM_Jumpsuit
GM_ScubaSuit
GM_Suit
GM_Trench
GM_Trench_F (send to GM_Trench?)

To do:
- Spawn a clothebag if clothes got changed with the old player settings in it.
- Change the target mesh & clothes (not skin) to some nudes (not completely of course) textures and to one of the mesh.
- Set the name of the clothes bag to "ClothesName" (var)*/

		if(ClothesTarget.IsA('ClothesBag'))
		{		
			If((ClothesBag(ClothesTarget).ClothesMesh == LodMesh'GM_DressShirt') || 
			(ClothesBag(ClothesTarget).ClothesMesh == LodMesh'GM_DressShirt_F') || 
			(ClothesBag(ClothesTarget).ClothesMesh == LodMesh'GM_DressShirt_S') || 
			(ClothesBag(ClothesTarget).ClothesMesh == LodMesh'GM_DressShirt_B') || 
			(ClothesBag(ClothesTarget).ClothesMesh == LodMesh'GM_Jumpsuit') || 
			(ClothesBag(ClothesTarget).ClothesMesh == LodMesh'GM_ScubaSuit') || 
			(ClothesBag(ClothesTarget).ClothesMesh == LodMesh'GM_Suit') || 
			(ClothesBag(ClothesTarget).ClothesMesh == LodMesh'GM_Trench') || 
			(ClothesBag(ClothesTarget).ClothesMesh == LodMesh'GM_Trench_F') ||
			(ClothesBag(ClothesTarget).ClothesMesh == LodMesh'MP_Jumpsuit'))
			{
				//change the player
				for (i=0; i< ArrayCount(MultiSkins);i++)
					MultiSkins[i] = ClothesBag(ClothesTarget).ClothesSkins[i];

				Mesh = ClothesBag(ClothesTarget).ClothesMesh;
				Alliance = ClothesBag(ClothesTarget).DisguisedAlliance;
				Texture = ClothesBag(ClothesTarget).ClothesTexture;
				CarcassType = ClothesBag(ClothesTarget).DisguisedCarcassType;
				ClothesName = ClothesBag(ClothesTarget).ClothesName;

				//change the target
				ClothesTarget.Destroy();
				ClothesTarget = None;
				return;
			}
		}
		else if(ClothesTarget.IsA('TDPCarcass'))
		{
			If(TDPCarcass(ClothesTarget).bNude)
				Return;

			If((TDPCarcass(ClothesTarget).ClothesMesh == LodMesh'GM_DressShirt') || 
			(TDPCarcass(ClothesTarget).ClothesMesh == LodMesh'GM_DressShirt_F') || 
			(TDPCarcass(ClothesTarget).ClothesMesh == LodMesh'GM_DressShirt_S') || 
			(TDPCarcass(ClothesTarget).ClothesMesh == LodMesh'GM_DressShirt_B') || 
			(TDPCarcass(ClothesTarget).ClothesMesh == LodMesh'GM_Jumpsuit') || 
			(TDPCarcass(ClothesTarget).ClothesMesh == LodMesh'GM_ScubaSuit') || 
			(TDPCarcass(ClothesTarget).ClothesMesh == LodMesh'GM_Suit') || 
			(TDPCarcass(ClothesTarget).ClothesMesh == LodMesh'GM_Trench') || 
			(TDPCarcass(ClothesTarget).ClothesMesh == LodMesh'GM_Trench_F') ||
			(TDPCarcass(ClothesTarget).ClothesMesh == LodMesh'MP_Jumpsuit'))
			{
				//change the player
				for (i=0; i< ArrayCount(MultiSkins);i++)
					MultiSkins[i] = TDPCarcass(ClothesTarget).ClothesSkins[i];

				Mesh = TDPCarcass(ClothesTarget).ClothesMesh;
				Alliance = TDPCarcass(ClothesTarget).DisguisedAlliance;
				Texture = TDPCarcass(ClothesTarget).ClothesTexture;
				CarcassType = TDPCarcass(ClothesTarget).DisguisedCarcassType;
				ClothesName = TDPCarcass(ClothesTarget).ClothesName;

				//change the target
				TDPCarcass(ClothesTarget).bNude = true;
				return;
			}
		}
	}
}

exec function IamTheOne()
{
	if (Sprite == None)
	{
		Sprite = Texture(DynamicLoadObject("TNM_Core_tex.TrainingTex", class'Texture'));
		ConsoleCommand("RMODE 6");
	}
	else
	{
		Sprite = None;
		ConsoleCommand("RMODE 5");
	}
}

exec function IamXana() // Forum City System.
{
	if (Sprite == None)
	{
		Sprite = Texture(DynamicLoadObject("Extras.Matrix_A00", class'Texture'));
		ConsoleCommand("RMODE 6");
	}
	else
	{
		Sprite = None;
		ConsoleCommand("RMODE 5");
	}
}

//=====================================End Of Cheats===================================

// ----------------------------------------------------------------------
// CreateThemeManager()
// ----------------------------------------------------------------------

function CreateColorThemeManager()
{
	if (ThemeManager == None)
	{
		ThemeManager = Spawn(Class'ColorThemeManager', Self);

		// Add all default themes.
		// Add new ones.

		// Menus
		ThemeManager.AddTheme(class<ColorThemeMenu>(DynamicLoadObject("TNMGUI.ColorThemeMenu_TNM",class'Class')));
		ThemeManager.AddTheme(class<ColorThemeMenu>(DynamicLoadObject("TNMGUI.ColorThemeMenu_WorldCorp",class'Class')));
		ThemeManager.AddTheme(class<ColorThemeMenu>(DynamicLoadObject("TNMGUI.ColorThemeMenu_DeusExDefault",class'Class')));
		ThemeManager.AddTheme(Class'ColorThemeMenu_BlueAndGold');
		ThemeManager.AddTheme(Class'ColorThemeMenu_CoolGreen');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Cops');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Cyan');
		ThemeManager.AddTheme(Class'ColorThemeMenu_DesertStorm');
		ThemeManager.AddTheme(Class'ColorThemeMenu_DriedBlood');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Dusk');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Earth');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Green');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Grey');
		ThemeManager.AddTheme(Class'ColorThemeMenu_IonStorm');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Lava');
		ThemeManager.AddTheme(Class'ColorThemeMenu_NightVision');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Ninja');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Olive');
		ThemeManager.AddTheme(Class'ColorThemeMenu_PaleGreen');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Pastel');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Plasma');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Primaries');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Purple');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Red');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Seawater');
		ThemeManager.AddTheme(Class'ColorThemeMenu_SoylentGreen');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Starlight');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Steel');
		ThemeManager.AddTheme(Class'ColorThemeMenu_SteelGreen');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Superhero');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Terminator');
		ThemeManager.AddTheme(Class'ColorThemeMenu_Violet');

		// HUD
		ThemeManager.AddTheme(class<ColorThemeHUD>(DynamicLoadObject("TNMGUI.ColorThemeHUD_TNM",class'Class')));
		ThemeManager.AddTheme(class<ColorThemeHUD>(DynamicLoadObject("TNMGUI.ColorThemeHUD_WorldCorp",class'Class')));
		ThemeManager.AddTheme(class<ColorThemeHUD>(DynamicLoadObject("TNMGUI.ColorThemeHUD_PDX",class'Class')));
		ThemeManager.AddTheme(class<ColorThemeHUD>(DynamicLoadObject("TNMGUI.ColorThemeHUD_DeusExDefault",class'Class')));
		ThemeManager.AddTheme(Class'ColorThemeHUD_Amber');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Cops');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Cyan');
		ThemeManager.AddTheme(Class'ColorThemeHUD_DarkBlue');
		ThemeManager.AddTheme(Class'ColorThemeHUD_DesertStorm');
		ThemeManager.AddTheme(Class'ColorThemeHUD_DriedBlood');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Dusk');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Grey');
		ThemeManager.AddTheme(Class'ColorThemeHUD_IonStorm');
		ThemeManager.AddTheme(Class'ColorThemeHUD_NightVision');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Ninja');
		ThemeManager.AddTheme(Class'ColorThemeHUD_PaleGreen');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Pastel');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Plasma');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Primaries');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Purple');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Red');
		ThemeManager.AddTheme(Class'ColorThemeHUD_SoylentGreen');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Starlight');
		ThemeManager.AddTheme(Class'ColorThemeHUD_SteelGreen');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Superhero');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Terminator');
		ThemeManager.AddTheme(Class'ColorThemeHUD_Violet');
	}
}

// ----------------------------------------------------------------------
// PostIntro()
// ----------------------------------------------------------------------

function PostIntro()
{
	if (bStartNewGameAfterIntro)
	{
		bStartNewGameAfterIntro = False;
		StartNewgame(strStartMap);
	}
	else
		Level.Game.SendPlayer(Self, "tdponly");
}

//Technically does the same thing as postintro when called during an outro but for the sake of correct naming
function PostOutro()
{
	//called from showmainmenu and AbortCinematicConvo() in tnmConWindowActive

	local tnmmission25 script;
	if ( left(CurrentMap(), 10) ~= "tdpendgame" )
	{
		foreach allactors(class'tnm.tnmMission25', script)
			break;
		script.RollCredits();
		if ( conPlay != none ) //it seems like conPlay sometimes exists and sometimes doesn't so added this to prevent accessed none warnings
		{
			conPlay.StopSpeech();
			conplay.Destroy(); //Huge hack but I have no idea how the conversation is even still running
		}
		CurrentCam.EndCinematic();
		SetInstantSoundVolume(0); //todo - see if this will cause problems
	}
	else if ( CurrentMap() ~= "TNMDenouement" )
	{
		Level.Game.SendPlayer(Self, "tdponly");
	}
	else
		Level.Game.SendPlayer(Self, "tdpdenouement");
}

// ----------------------------------------------------------------------
// RestrictInput()
// ----------------------------------------------------------------------

function bool RestrictInput()
{
	local DeusExLevelInfo info;

	info = GetLevelInfo();

	if ( bJustTraveled )
		return true;

	if(info!=none && (info.mapname~="tdpdenouement" || left(info.mapname,10)~="tdpendgame"))
		return true;

	return super.restrictinput();
}

// ----------------------------------------------------------------------
// ShowMainMenu()
// ----------------------------------------------------------------------

exec function ShowMainMenu()
{
	local DeusExRootWindow root;
	local DeusExLevelInfo info;
	local MissionEndgame Script;

	if (bIgnoreNextShowMenu)
	{
		bIgnoreNextShowMenu = False;
		return;
	}

	info = GetLevelInfo();

	// Special case baby!
	//
	// If the Intro map is loaded and we get here, that means the player
	// pressed Escape and we want to either A) start a new game
	// or B) return to the dx.dx screen.  Either way we're going to
	// abort the Intro by doing this.
	//
	// If this is one of the Endgames (which have a mission # of 99)
	// then we also want to call the Endgame's "FinishCinematic"
	// function

	// force the texture caches to flush
	ConsoleCommand("FLUSH");

	if ((info != None) && (info.MapName ~= "tdpintro"))
	{
		bIgnoreNextShowMenu = True;
		PostIntro();
	}
	else if ( bCinematic && TCAM != None && TCAM.Interuptable)
	{
		Endcinematic();
		return;
	}
	else if (info!=none && (info.mapname~="TdpDenouement" || left(info.mapname,10)~="tdpendgame"))
	{
		bIgnoreNextShowMenu = True;
//		Level.Game.SendPlayer(Self, "tdponly");
		PostOutro();
	}
	else if ((info != None) && (info.MissionNumber == 99))
	{
		foreach AllActors(class'MissionEndgame', Script)
			break;

		if (Script != None)
			Script.FinishCinematic();
	}
	else
	{
		root = DeusExRootWindow(rootWindow);
		if (root != None)
			root.InvokeMenu(Class<DeusExBaseWindow>(dynamicloadobject("TdpGUI.tdpMenuMain", class'class')));
	}
}

// ----------------------------------------------------------------------
// StartTrainingMission()
// ----------------------------------------------------------------------

function StartTrainingMission()
{
	if (DeusExRootWindow(rootWindow) != None)
		DeusExRootWindow(rootWindow).ClearWindowStack();

	// Make sure the player isn't asked to do this more than
	// once if prompted on the main menu.
	if (!bAskedToTrain)
	{
		bAskedToTrain = True;
		SaveConfig();
	}

	SkillSystem.ResetSkills();
	ResetPlayer(True);
	DeleteSaveGameFiles();
	bStartingNewGame = True;
	Level.Game.SendPlayer(Self, "30_TDPTraining");
}

function ResetPlayer(optional bool bTraining)
{
	local inventory anItem;
	local inventory nextItem;
	local int skill_tmp;

	if(!bTraining)
		skill_tmp=SkillPointsAvail;

	flagbase.DeleteAllFlags();

	ResetPlayerToDefaults();

	if(!bTraining)
		SkillPointsAvail=skill_tmp;

	// Reset Augmentations
	if (AugmentationSystem != None)
	{
		AugmentationSystem.ResetAugmentations();
		AugmentationSystem.Destroy();
		AugmentationSystem = None;
	}

//	anItem = Spawn(class<DataVaultImage>(DynamicLoadObject("TDPDataVault.TDPDV_KidnapNote",class'Class')));
//	anItem.frob(Self,None);

	if(!bTraining)
	{
		anItem = Spawn(class'nanokey');
//		nanokey(anitem).KeyID = 'TrestkonsRavingLocker';
//		nanokey(anitem).Description = "Password to your weapon locker.";
		anItem.Frob(Self, None);
		anItem.bInObjectBelt = True;
	}

	anitem = Spawn(class'TNM.weaponfists');
	playerfists = weaponfists(anitem);
	anitem.Frob(self, none);
	anitem.binobjectbelt = false;

	InitPCGames();

//	NoteAdd( "Account number: 905279|nPin code: 2049");
}

defaultproperties
{
    lives=5
    strstartintromap="tdpintro"
    strstartmapunrealistic="Mario_01.dx"
    blackiceDL="PM_Cassandra_FailedHack"
    TruePlayerName="Guylian Cox"
    Credits=200
    strStartMap="26_TrestkonAppartement"
    CarcassType=Class'TDPNeoCarcass'
    bNoFlash=False
    AccelRate=2048.00
    Tag=|p7Neo|p1
    Texture=Texture'DeusExItems.Skins.PinkMaskTex'
    Mesh=LodMesh'MPCharacters.mp_jumpsuit'
    MultiSkins(0)=Texture'TDP.Player.PCTex0B'
    MultiSkins(1)=Texture'TDP.Player.PCTex2'
    MultiSkins(2)=Texture'TDP.Player.PCTex1'
    MultiSkins(3)=Texture'TDP.Player.PCTex0B'
    MultiSkins(4)=Texture'DeusExItems.Skins.PinkMaskTex'
    MultiSkins(5)=Texture'DeusExItems.Skins.PinkMaskTex'
    MultiSkins(6)=Texture'DeusExItems.Skins.PinkMaskTex'
    MultiSkins(7)=Texture'DeusExItems.Skins.PinkMaskTex'
    RotationRate=(Pitch=3072,Yaw=65000,Roll=2048),
    FamiliarName="|p7Neo|p1"
    UnfamiliarName="|p7Neo|p1"
    ClothesName="Neo"
}
