class tdpaugmentationmanager extends augmentationmanager;

function Augmentation GetAugFromKey(int keynum)
{
	local Augmentation anAug;

	if ((keyNum < 0) || (keyNum > 9))
		return none;
	anAug = FirstAug;
	while(anAug != None)
	{
		if ((anAug.HotKeyNum - 3 == keyNum) && (anAug.bHasIt))
			break;
		anAug = anAug.next;
	}
	return anAug;
}

function DeactivateAll()
{
	local Augmentation anAug;

	anAug = FirstAug;
	while(anAug != None)
	{
		if (anAug.bIsActive && anAug.GetEnergyRate() != 0 )
			anAug.Deactivate();
		anAug = anAug.next;
	}
}

simulated function Float CalcEnergyUse(float deltaTime)
{
	local float energyUse;
	local Augmentation anAug;
	local Augmentation PowerAug;

	energyUse = 0;

	anAug = FirstAug;
	while(anAug != None)
	{
           if (anAug.IsA('AugPower'))
              PowerAug = anAug;
	   if (anAug.bHasIt && anAug.bIsActive)
	   {
	     energyUse += ((anAug.GetEnergyRate()/60) * deltaTime);
	   }
 	   anAug = anAug.next;
	}

	//Power aug is now always active
	if (PowerAug != none)				
	   energyUse *= PowerAug.LevelValues[PowerAug.CurrentLevel];

	return energyUse;
}

//modified these to use classischildof:

simulated function Augmentation FindAugmentation(Class<Augmentation> findClass)
{
	local Augmentation anAug;

	anAug = FirstAug;
	while(anAug != None)
	{
		if (ClassIsChildOf(anAug.Class, findClass))
			break;

		anAug = anAug.next;
	}

	return anAug;
}

simulated function float GetAugLevelValue(class<Augmentation> AugClass)
{
	local Augmentation anAug;
	local float retval;

	retval = 0;

	anAug = FirstAug;
	while(anAug != None)
	{
		if (ClassIsChildOf(anAug.Class, augClass))
		{
			if (anAug.bHasIt && anAug.bIsActive)
				return anAug.LevelValues[anAug.CurrentLevel];
			else
				return -1.0;
		}

		anAug = anAug.next;
	}

	return -1.0;
}

simulated function int GetClassLevel(class<Augmentation> augClass)
{
	local Augmentation anAug;

	anAug = FirstAug;
	while(anAug != None)
	{
		if (ClassIsChildOf(anAug.Class, augClass))
		{
			if (anAug.bHasIt && anAug.bIsActive)
				return anAug.CurrentLevel;
			else
				return -1;
		}

		anAug = anAug.next;
	}

	return -1;
}

// Smoke39 - I've added extra indentation to the augs that were already changed here
// (i.e., the ones that aren't just the DX aug with my aug can upgrade tweak)
defaultproperties
{
    augClasses(0)=Class'tnmpcAugSpeed'
    augClasses(1)=Class'tnmpcAugTarget'
    augClasses(2)=Class'tnmpcAugCloak'
    augClasses(3)=Class'tnmpcAugBallistic'
    augClasses(4)=Class'tnmpcAugRadarTrans'
    augClasses(5)=Class'tnmpcAugShield'
    augClasses(6)=Class'tnmpcAugEnviro'
    augClasses(7)=Class'tnmpcAugEMP'
    augClasses(8)=Class'tnmpcAugCombat'
    augClasses(9)=Class'tnmpcAugHealing'
    augClasses(10)=Class'tnmpcAugStealth'
    augClasses(12)=Class'tnmAugLight'
    augClasses(13)=Class'tnmpcAugMuscle'
    augClasses(14)=Class'tnmpcAugVision'
    augClasses(15)=Class'tnmpcAugDrone'
    augClasses(16)=Class'tnmpcAugDefense'
    augClasses(17)=Class'AugBot'
    augClasses(18)=Class'TDPAugpm'
    augClasses(19)=Class'tnmpcAugHeartLung'
    augClasses(20)=Class'tnmpcAugPower'
    augClasses(21)=Class'tnmpcAugAqualung'
    augClasses(22)=Class'SlowMotionAug'
    defaultAugs(0)=Class'tnmAugLight'
    defaultAugs(2)=Class'Augpm'
}
