//=============================================================================
// BloodSpurt.
//=============================================================================
class WBloodSpurt extends Effects;

auto state Flying
{
	function BeginState()
	{
		Velocity = vect(0,0,0);
		DrawScale -= FRand() * 0.5;
		PlayAnim('Spurt');

		// Gore check
		if (Level.Game.bLowGore || Level.Game.bVeryLowGore)
		{
			Destroy();
			return;
		}
	}
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		ScaleGlow = 2.0;
		DrawScale *= 1.5;
		LifeSpan *= 2.0;
		bUnlit=True;
	}
}

defaultproperties
{
    LifeSpan=0.50
    DrawType=2
    Style=4
    Mesh=LodMesh'DeusExItems.BloodSpurt'
    MultiSkins(0)=Texture'WBloodTex1'
    bFixedRotationDir=True
    NetUpdateFrequency=5.00
}
