//=============================================================================
// FleshFragment.
//=============================================================================
class WFleshFragment expands DeusExFragment;

var bool bSpray;

//ALL THIS NEEDS TO BE HERE! If it's not this will throw up terribly!
auto state Flying
{
	simulated function timer()
	{
	 bSpray = False;
	}

	function BeginState()
	{
		Super.BeginState();

		Velocity = VRand() * 300;
		DrawScale = FRand() + 1.5;
		bSpray = True;	
	}
}

//wccc's stuff here.
simulated function HitWall (vector HitNormal, actor HitWall)
{
	local Sound sound;
	local float volume, radius;

	// if we are stuck, stop moving
	if (lastHitLoc == Location)
		Velocity = vect(0,0,0);
	else
		Velocity = Elasticity*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	speed = VSize(Velocity);	
	if (bFirstHit && speed<400) 
	{
		bFirstHit=False;
		bRotatetoDesired=True;
		bFixedRotationDir=False;
		DesiredRotation.Pitch=0;	
		DesiredRotation.Yaw=FRand()*65536;
		DesiredRotation.roll=0;
	}
	RotationRate.Yaw = RotationRate.Yaw*0.75;
	RotationRate.Roll = RotationRate.Roll*0.75;
	RotationRate.Pitch = RotationRate.Pitch*0.75;
	if ( ( (speed < 60) && (HitNormal.Z > 0.7) ) || (speed == 0) )
	{
		SetPhysics(PHYS_none, HitWall);
		if (Physics == PHYS_None)
		{
			bBounce = false;
			bSpray = false;
		}
	}

	volume = 0.5+FRand()*0.5;
	radius = 768;
	if (FRand()<0.5)
		sound = ImpactSound;
	else
		sound = MiscSound;
	PlaySound(sound, SLOT_None, volume,, radius, 0.85+FRand()*0.3);
	if (sound != None)
		AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius * 0.5);		// lower AI sound radius for gameplay balancing

	lastHitLoc = Location;
}

function GibTheGibs(float GibOfGibScale, int NumSubGibs, vector GibLoc)
{
	local int i;
	local WFleshFragment f;
 
	//numerical iterators are awesome on how flexible they are!
	if(DrawScale > 0.25)
	{
		for(i=NumSubGibs;i>0;i--)
		{
			f = Spawn(class'WFleshFragment',,,GibLoc + VRand(),RotRand(True));
			if (f != none) 
				f.DrawScale = GibOfGibScale;
		}
	}
	else if(DrawScale <= 0.25) 
		i = 0;
	if(i == 0) 
		Destroy();
}

function TakeDamage(int OwFactor, pawn Jerk, vector boobooLoc, vector Knockback, name boobootype)
{
	if (DrawScale <= 0.25)
		Destroy();
	if (DrawScale > 0.25)
	{
		GibTheGibs(Drawscale / 2, OwFactor / 4, boobooLoc);
	}
}
//End of WCCC's stuffs.

function Tick(float deltaTime)
{
	Super.Tick(deltaTime);
	
	if((bSpray) && (!IsInState('Dying')))
		if(FRand() < 0.35) // was 0.5 before.
			Spawn(class'WBloodDrop',,, Location);
}

defaultproperties
{
    Fragments(0)=LodMesh'DeusExItems.FleshFragment1'
    Fragments(1)=LodMesh'DeusExItems.FleshFragment2'
    Fragments(2)=LodMesh'DeusExItems.FleshFragment3'
    Fragments(3)=LodMesh'DeusExItems.FleshFragment4'
    numFragmentTypes=4
    elasticity=0.40
    bSpray=True
    ImpactSound=Sound'DeusExSounds.Generic.FleshHit1'
    MiscSound=Sound'DeusExSounds.Generic.FleshHit2'
    Mesh=LodMesh'DeusExItems.FleshFragment1'
    CollisionRadius=2.00
    CollisionHeight=2.00
    Mass=5.00
    Buoyancy=5.50
    bVisionImportant=True
    LifeSpan=999.000000
    bCollideActors=True
    bProjTarget=True
    bBlockActors=True
    bBlockPlayers=True
    DrawType=DT_Mesh
    MultiSkins(0)=Texture'WFleshFragmentTex1'
}
