//=============================================================================
// ChangeStateLaser -- Darma
// Used to change PLAYER's states. NPC states can be switched with OrdersTrigger (same effect, put the name of the state in it).
// Used to avoid the player killing in a non-killing zone, DL Technology.
// Could be putted in a zoneinfo.
//=============================================================================
class ChangeStateLaser expands TDPBeams;

var(LaserEffect) name State;

/*Player States:

The ones with ** are useless with this class

[Engine.Pawn]
Dying
**GameEnded

[Engine.PlayerPawn]
**InvalidState (auto when invalid)
PlayerWalking
FeigningDeath
PlayerSwimming
PlayerFlying
CheatFlying
PlayerWaiting
PlayerSpectating
PlayerWaking

[DeusEx.DeusExPlayer]
**Interpolating
Paralyzed
**Conversation

[TNM.Trestkon]
**Cinematic

[TDP.TDPNeo]
CannotFire*/

/*static*/ function doLaserEffects(TDPBeams beam, Actor ac) 
{
	local TDPNeo a; 

	if(ac.IsA('TDPNeo'))
	{
		a = TDPNeo(ac); 
		a.GotoState( State );
	}
}

defaultproperties
{
    laserTexture=FireTexture'TDP_Effects.Laser.IKLaser'
    laserSpotTexture=FireTexture'TDP_Effects.spot.IKSpot'
    Mesh=LodMesh'hdtpBeamTrigger'
    MultiSkins(0)=Texture'TDPDeco.Laser.IKBeamTriggerTex1'
    MultiSkins(1)=FireTexture'TDP_Effects.spot.IKSpot'
    enabledTextures(0)=Texture'TDPDeco.Laser.IKBeamTriggerTex1'
    enabledTextures(1)=FireTexture'TDP_Effects.spot.IKSpot'
    State=CannotFire
}
