//=============================================================================
// IKLaser.  (Made by RedGreasel for The Darma Project)
// Added something to control if damage deco / pawns
//=============================================================================
class IKLaser expands TDPBeams;

var() bool bAffectNPC;
var() bool bAffectDeco;

static function doLaserEffects(TDPBeams beam, Actor ac)
{
	local DeusExDecoration a;
	local DeusExCarcass b;
	local ScriptedPawn c;
	local DeusExPlayer d;
	if(ac.IsA('DeusExDecoration')){
		a = DeusExDecoration(ac);


			a.bInvincible = false;
			a.HitPoints = 0;
			a.TakeDamage(1<<20,none,ac.Location,vect(0,0,0),'Exploded');
		
	}
	else if(ac.IsA('DeusExCarcass')){
		b = DeusExCarcass(ac);
		b.chunkUp(1<<7);
		b.TakeDamage(1<<20,none,ac.Location,vect(0,0,0),'Exploded');
		return;
	}
	else if(ac.IsA('ScriptedPawn')){

		c = ScriptedPawn(ac);

			c.bInvincible = false;
			c.ReducedDamageType = '';
			c.Health = 0;
			c.TakeDamage(1<<20,none,ac.Location,vect(0,0,0),'Exploded');
		
	}
	else if(ac.IsA('DeusExPlayer')){
		d = DeusExPlayer(ac);
		d.ReducedDamageType = '';
		d.Health = 0;
		d.TakeDamage(1<<20,none,ac.Location,vect(0,0,0),'Exploded');
	}
}

defaultproperties
{
    laserTexture=FireTexture'TDP_Effects.Laser.IKLaser'
    laserSpotTexture=FireTexture'TDP_Effects.spot.IKSpot'
    Mesh=LodMesh'hdtpBeamTrigger'
    MultiSkins(0)=Texture'TDPDeco.Laser.IKBeamTriggerTex1'
    MultiSkins(1)=FireTexture'TDP_Effects.spot.IKSpot'
    enabledTextures(0)=Texture'TDPDeco.Laser.IKBeamTriggerTex1'
    enabledTextures(1)=FireTexture'TDP_Effects.spot.IKSpot'
}
