//=============================================================================
// Inexilium added
//=============================================================================
class TDPHUDHitDisplay expands HUDBaseWindow;

struct BodyPart
{
	var Window partWindow;
	var int    lastHealth;
	var int    healHealth;
	var int    displayedHealth;
	var float  damageCounter;
	var float  healCounter;
   var float  refreshCounter;
};

var BodyPart head;
var BodyPart torso;
var BodyPart armLeft;
var BodyPart armRight;
var BodyPart legLeft;
var BodyPart legRight;
var BodyPart armor;

var Color    colArmor;

var float    damageFlash;
var float    healFlash;

var Bool			bVisible;
var Actor	player;		// Smoke39 - changed to Actor from DeusExPlayer

// Breathing underwater bar
var ProgressBarWindow winBreath;
var bool	bUnderwater;
var float	breathPercent;

// Energy bar
var ProgressBarWindow winEnergy;
var float	energyPercent;

// Used by DrawWindow
var Color colBar;
var int ypos;

// Defaults
var Texture texBackground;
var Texture texBorder;

var localized string O2Text;
var localized string EnergyText;

// Smoke39
var bool bSimple;	// low level targeting aug?
var bool bEMP;		// show EMP HP for bots?

//TDP - Inexilium
var localized string InexText;
var ProgressBarWindow winInex;
var float	InexPercent;

/*Todo: add the inexilium bar IF the player has the aug that make him invincible or the aug that slow down the time. (in purple).*/

// ----------------------------------------------------------------------
// InitWindow()
// ----------------------------------------------------------------------

event InitWindow()
{
	local window bodyWin;

	Super.InitWindow();

	bTickEnabled = True;

	Hide();

	// Smoke39 - cast to DeusExPlayer no longer necessary
	player = DeusExRootWindow(GetRootWindow()).parentPawn;

	SetSize(84, 106);

	CreateBodyPart(head,     Texture'HUDHitDisplay_Head',     39, 17,  4,  7);
	CreateBodyPart(torso,    Texture'HUDHitDisplay_Torso',    36, 25, 10,  23);
	CreateBodyPart(armLeft,  Texture'HUDHitDisplay_ArmLeft',  46, 27, 10,  23);
	CreateBodyPart(armRight, Texture'HUDHitDisplay_ArmRight', 26, 27, 10,  23);
	CreateBodyPart(legLeft,  Texture'HUDHitDisplay_LegLeft',  41, 44,  8,  36);
	CreateBodyPart(legRight, Texture'HUDHitDisplay_LegRight', 33, 44,  8,  36);

	bodyWin = NewChild(Class'Window');
	bodyWin.SetBackground(Texture'HUDHitDisplay_Body');
	bodyWin.SetBackgroundStyle(DSTY_Translucent);
	bodyWin.SetConfiguration(24, 15, 34, 68);
	bodyWin.SetTileColor(colArmor);
	bodyWin.Lower();

	winEnergy = CreateProgressBar(15, 20);
	//Inexilium
	winwinInex = CreateProgressBar(20, 20);
	winBreath = CreateProgressBar(61, 20);

	damageFlash = 0.4;  // seconds
	healFlash   = 1.0;  // seconds
}

// ----------------------------------------------------------------------
// CreateProgressBar()
// ----------------------------------------------------------------------

function ProgressBarWindow CreateProgressBar(int posX, int posY)
{
	local ProgressBarWindow winProgress;

	winProgress = ProgressBarWindow(NewChild(Class'ProgressBarWindow'));
	winProgress.UseScaledColor(True);
	winProgress.SetSize(5, 55);
	winProgress.SetPos(posX, posY);
	winProgress.SetValues(0, 100);
	winProgress.SetCurrentValue(0);
	winProgress.SetVertical(True);

	return winProgress;
}

// ----------------------------------------------------------------------
// CreateBodyPart()
// ----------------------------------------------------------------------

function CreateBodyPart(out BodyPart part, texture tx, float newX, float newY,
                        float newWidth, float newHeight)
{
	local window newWin;

	newWin = NewChild(Class'Window');
	newWin.SetBackground(tx);
	newWin.SetBackgroundStyle(DSTY_Translucent);
	newWin.SetConfiguration(newX, newY, newWidth, newHeight);
	newWin.SetTileColorRGB(0, 0, 0);

	part.partWindow      = newWin;
	part.displayedHealth = 0;
	part.lastHealth      = 0;
	part.healHealth      = 0;
	part.damageCounter   = 0;
	part.healCounter     = 0;
	part.refreshCounter  = 0;
}

// ----------------------------------------------------------------------
// SetHitColor()
// ----------------------------------------------------------------------

// Smoke39 - simplified
function SetHitColor(out BodyPart part, float deltaSeconds, bool bHide, float hit)
{
	local Color col;

	if ( hit > 0.0 )
	{
		hit *= 100.0;
		if ( hit > 50.0 )
		{
			col.r = (50.0 - (hit-50.0)) / 50.0 * 255;
			col.g = 255;
		}
		else
		{
			col.r = 255;
			col.g = hit / 50.0 * 255;
		}
	}

	part.partWindow.SetTileColor(col);
}

// ----------------------------------------------------------------------
// DrawWindow()
// ----------------------------------------------------------------------

event DrawWindow(GC gc)
{
	Super.DrawWindow(gc);

	// Smoke39 - only do this stuff for real players
	if ( DeusExPlayer(player) == None )
	{
		// Smoke39 - show bot EMP HP bar label
		if ( Robot(Player) != None && bEMP )
		{
			gc.SetFont( Font'FontTiny' );
			gc.SetTextColor( winEnergy.GetBarColor() );
			gc.DrawText(13, 74, 8, 8, " E");
		}
		return;
	}

	// Draw energy bar
	gc.SetFont(Font'FontTiny');
	gc.SetTextColor(winEnergy.GetBarColor());
	gc.DrawText(13, 74, 8, 8, EnergyText);

	// If we're underwater draw the breathometer
	if (bUnderwater)
	{
		ypos = breathPercent * 0.55;

		// draw the breath bar
		colBar = winBreath.GetBarColor();

		// draw the O2 text and blink it if really low
		gc.SetFont(Font'FontTiny');
		if (breathPercent < 10)
		{
			// Smoke39 - have to cast to DeusExPlayer
			if ( DeusExPlayer(player).swimTimer % 0.5 > 0.25 )
				colBar.r = 255;
			else
				colBar.r = 0;
		}

		gc.SetTextColor(colBar);
		gc.DrawText(61, 74, 8, 8, O2Text);
	}

	// TDP - If we're having an inexilium aug, add the inexilium bar.
	if (/*TO SET!!*/)
	{
		// draw the inex bar

		colBar = winInex.GetBarColor();

		gc.SetFont(Font'FontTiny');
		gc.SetTextColor(winInex.GetBarColor());
		gc.DrawText(20, 74, 8, 8, InexText);
	}
}

// ----------------------------------------------------------------------
// DrawBackground()
// ----------------------------------------------------------------------

function DrawBackground(GC gc)
{
	gc.SetStyle(backgroundDrawStyle);
	gc.SetTileColor(colBackground);
	gc.DrawTexture(11, 11, 60, 76, 0, 0, texBackground);
}

// ----------------------------------------------------------------------
// DrawBorder()
// ----------------------------------------------------------------------

function DrawBorder(GC gc)
{
	if (bDrawBorder)
	{
		gc.SetStyle(borderDrawStyle);
		gc.SetTileColor(colBorder);
		gc.DrawTexture(0, 0, 84, 106, 0, 0, texBorder);
	}
}

// ----------------------------------------------------------------------
// Tick()
//
// Update the Energy and Breath displays
// ----------------------------------------------------------------------

event Tick(float deltaSeconds)
{
	local float ratio;
	local Pawn PP;
	local DeusExPlayer DXP;

/*	Smoke39 - none of my code seriously takes MP into account, and this bit needs casting, so I'm just commenting it out
	// DEUS_EX AMSD Server doesn't need to do this.
	if ((player.Level.NetMode != NM_Standalone)  && (!Player.PlayerIsClient()))
	{
		Hide();
		return;
	}
*/
	if ( player != None && bVisible )
	{
		// Smoke39 - only general info for non-pawns (or just 100% for weird things...)
		if ( !player.IsA('Pawn') )
		{
			if ( player.IsA('DeusExDecoration') )
				ratio = Float(DeusExDecoration(player).HitPoints) / Float(DeusExDecoration(player).Default.HitPoints);
			else
				ratio = 1;

			SetHitColor(head,     deltaSeconds, false, ratio);
			SetHitColor(torso,    deltaSeconds, false, ratio);
			SetHitColor(armLeft,  deltaSeconds, false, ratio);
			SetHitColor(armRight, deltaSeconds, false, ratio);
			SetHitColor(legLeft,  deltaSeconds, false, ratio);
			SetHitColor(legRight, deltaSeconds, false, ratio);
		}
		// Smoke39 - only general info at low levels and for inhumans
		else if ( bSimple || player.IsA('Robot') || player.IsA('Animal') )
		{
			ratio = float(Pawn(player).Health) / float(Pawn(player).Default.Health);
			SetHitColor(head,     deltaSeconds, false, ratio);
			SetHitColor(torso,    deltaSeconds, false, ratio);
			SetHitColor(armLeft,  deltaSeconds, false, ratio);
			SetHitColor(armRight, deltaSeconds, false, ratio);
			SetHitColor(legLeft,  deltaSeconds, false, ratio);
			SetHitColor(legRight, deltaSeconds, false, ratio);
		}
		else // Smoke39 - all modified to use ratios
		{
			PP = Pawn(player);
			SetHitColor(head,     deltaSeconds, false, float(PP.HealthHead) / float(PP.Default.HealthHead));
			SetHitColor(torso,    deltaSeconds, false, float(PP.HealthTorso) / float(PP.Default.HealthTorso));
			SetHitColor(armLeft,  deltaSeconds, false, float(PP.HealthArmLeft) / float(PP.Default.HealthArmLeft));
			SetHitColor(armRight, deltaSeconds, false, float(PP.HealthArmRight) / float(PP.Default.HealthArmRight));
			SetHitColor(legLeft,  deltaSeconds, false, float(PP.HealthLegLeft) / float(PP.Default.HealthLegLeft));
			SetHitColor(legRight, deltaSeconds, false, float(PP.HealthLegRight) / float(PP.Default.HealthLegRight));
		}

		// Smoke39 - no energy or breath meters for non-players, using DXP instead of lots of casts
		DXP = DeusExPlayer(player);
		if ( DXP == None )
		{
			// Smoke39 - show bot EMP HP
			if ( player.IsA('Robot') && bEMP )
				energyPercent = 100.0 * (float(Robot(player).EMPHitPoints) / float(Robot(Player).Default.EMPHitPoints));
			else
				energyPercent = 0;
			winEnergy.SetCurrentValue(energyPercent);

			Show();
			return;
		}

		// Calculate the energy bar percentage
		energyPercent = 100.0 * (DXP.Energy / DXP.EnergyMax);
		winEnergy.SetCurrentValue(energyPercent);
		
		// If we're underwater, draw the breath bar
		if (bUnderwater)
		{
			// if we are already underwater
			if (DXP.HeadRegion.Zone.bWaterZone)
			{
				// if we are still underwater
				breathPercent = 100.0 * DXP.swimTimer / DXP.swimDuration;
				breathPercent = FClamp(breathPercent, 0.0, 100.0);
			}
			else
			{
				// if we are getting out of the water
				bUnderwater = False;
				breathPercent = 100;
			}
		}
		else if (DXP.HeadRegion.Zone.bWaterZone)
		{
			// if we just went underwater
			bUnderwater = True;
			breathPercent = 100;
		}

		// Now show or hide the breath meter
		if (bUnderwater)
		{
			if (!winBreath.IsVisible())
				winBreath.Show();

			winBreath.SetCurrentValue(breathPercent);
		}
		else
		{
			if (winBreath.IsVisible())
				winBreath.Hide();
		}

		Show();
	}
	else if ( bVisible )
	{
		// Smoke39 - no player, targeting aug is searching, blank everything out
		SetHitColor(head,     deltaSeconds, false, 0);
		SetHitColor(torso,    deltaSeconds, false, 0);
		SetHitColor(armLeft,  deltaSeconds, false, 0);
		SetHitColor(armRight, deltaSeconds, false, 0);
		SetHitColor(legLeft,  deltaSeconds, false, 0);
		SetHitColor(legRight, deltaSeconds, false, 0);
		winEnergy.SetCurrentValue(0);
		Show();
	}
}

// ----------------------------------------------------------------------
// SetVisibility()
// ----------------------------------------------------------------------

function SetVisibility( bool bNewVisibility )
{
	bVisible = bNewVisibility;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
    colArmor=(R=255,G=255,B=255,A=0),
    texBackground=Texture'DeusExUI.UserInterface.HUDHitDisplayBackground_1'
    texBorder=Texture'DeusExUI.UserInterface.HUDHitDisplayBorder_1'
    O2Text="O2"
    EnergyText="BE"
    InexText="IX"
}
