//=============================================================================
// summonwindow basically copied that otherone
//=============================================================================
class TDPsummonwindow expands ToolWindow;

// Windows 

var string 			list[1200];
var int 			weaponIndex,
				ammoIndex,
				augIndex,
				itemIndex,
				charIndex,
				animalIndex,
				robotsIndex;

var ToolListWindow		lstClasses;
var ToolButtonWindow		btnLoad;    
var ToolButtonWindow		btnCancel;  

var ToolRadioButtonWindow 	radWeapons,
				radAmmunition,
				radAugmentations,
				radItems,
				radCharacters,
				radAnimals,
				radRobots,
				curRad;
var int				curOffset;

var ToolEditWindow         	EDITnum;
var string 			filterstring;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	// Center this window	
	SetSize(370, 430);
	SetTitle("Summon Class");

	// Create the controls
	CreateControls();
	PopulateClassList();
}

// ----------------------------------------------------------------------
// DestroyWindow()
// ----------------------------------------------------------------------

event DestroyWindow()
{
}

function string CreateFilterString(string s)
{
	local int i;
	local string ret;
	ret="";
	for(i=0;i<256;i++)
		if(InStr(s,chr(i))==-1)
			ret=ret$chr(i);
	return ret;
}

// ----------------------------------------------------------------------
// CreateControls()
// ----------------------------------------------------------------------

function CreateControls()
{
	// Flags list box
	CreateClassList();
	
	// Buttons
	btnLoad   = CreateToolButton(280, 362, "|&Summon");
	btnCancel = CreateToolButton(280, 387, "|&Close");


	CreateToolLabel(282,344,"Amount:",self);
	editNum = CreateToolEditWindow(323, 340, 32, 32, 18);

	editNum.SetText(1);
	editNum.MoveInsertionPoint(MOVEINSERT_End);
	editNum.SetFilter(CreateFilterString(filterString));

	radWeapons=CreateToolRadioButton(280, 38, "Weapons", true);
	radAugmentations=CreateToolRadioButton(280, 58, "Augs", false);
	radAmmunition=CreateToolRadioButton(280, 78, "Ammo", false);
	radItems=CreateToolRadioButton(280, 98, "Items", false);
	radCharacters=CreateToolRadioButton(280, 118, "Characters", false);
	radAnimals=CreateToolRadioButton(280, 138, "Critters", false);
	radRobots=CreateToolRadioButton(280, 158, "Bots", false);
}

// ----------------------------------------------------------------------
// CreateClassList()
// ----------------------------------------------------------------------

function CreateClassList()
{
	// Now create the List Window
	lstClasses = CreateToolList(15, 38, 255, 372);
	lstClasses.EnableMultiSelect(False);
	lstClasses.EnableAutoExpandColumns(True);
}

// ----------------------------------------------------------------------
// PopulateClassList()
// ----------------------------------------------------------------------

function PopulateClassList()
{

	local int i;
	local string s;

	lstClasses.DeleteAllRows();

	for( i=0; i<arraycount(list); i++)
	{
		if(list[i]=="WEAPONS:")
			weaponIndex=i;
		else if(list[i]=="AMMUNITION:")
			ammoIndex=i;
		else if(list[i]=="AUGMENTATIONS:")
			augIndex=i;
		else if(list[i]=="ITEMS:")
			itemIndex=i;
		else if(list[i]=="CHARACTERS:")
			charIndex=i;
		else if(list[i]=="ANIMALS:")
			animalIndex=i;
		else if(list[i]=="ROBOTS:")
			robotsIndex=i;
	}

	SetListSet("WEAPONS");

	EnableButtons();
}

function SetListSet(string set)
{
	local int i;
	local string s;

	lstClasses.DeleteAllRows();

	switch(set)
	{
	case "WEAPONS":
		for(i=weaponIndex+1;i<ammoIndex;i++)
		{
			s = left(list[i],instr(list[i],":"));
			lstClasses.AddRow( s );
		}
		curOffset=weaponIndex;
		break;
	case "AMMUNITION":
		for(i=ammoIndex+1;i<augIndex;i++)
		{
			s = left(list[i],instr(list[i],":"));
			lstClasses.AddRow( s );
		}
		curOffset=ammoIndex;
		break;
	case "AUGMENTATIONS":
		for(i=augIndex+1;i<itemIndex;i++)
		{
			s = left(list[i],instr(list[i],":"));
			lstClasses.AddRow( s );
		}
		curOffset=augIndex;
		break;
	case "ITEMS":
		for(i=itemIndex+1;i<charIndex;i++)
		{
			s = left(list[i],instr(list[i],":"));
			lstClasses.AddRow( s );
		}
		curOffset=itemIndex;
		break;
	case "CHARACTERS":
		for(i=charIndex+1;i<animalIndex;i++)
		{
			s = left(list[i],instr(list[i],":"));
			lstClasses.AddRow( s );
		}
		curOffset=charIndex;
		break;
	case "ANIMALS":
		for(i=animalIndex+1;i<robotsIndex;i++)
		{
			s = left(list[i],instr(list[i],":"));
			lstClasses.AddRow( s );
		}
		curOffset=animalIndex;
		break;
	case "ROBOTS":
		for(i=robotsIndex+1;i<arraycount(list);i++)
		{
			s = left(list[i],instr(list[i],":"));
			if (s=="")
				break;
			lstClasses.AddRow( s );
		}
		curOffset=robotsIndex;
		break;
	}
}

// ----------------------------------------------------------------------
// ButtonActivated()
// ----------------------------------------------------------------------

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local int i1,i2,i3;
	local string s1;
	local string classname;
	local class<actor> newclass;

	bHandled = True;

	switch( buttonPressed )
	{
		case btnLoad:
			i1 = lstClasses.RowIdToIndex(lstClasses.GetSelectedRow())+1+curOffset;
			i2 = len(list[i1]);
			i3 = instr(list[i1],":");
			s1 = right(list[i1], i2 - i3 - 1);

			player.SpawnMass(stringtoname(s1),int(editnum.GetText()));
//			root.popwindow();
			break;

		case btnCancel:
			root.PopWindow();
			break;

		default:
			bHandled = False;
			break;
	}

	if ( !bHandled ) 
		bHandled = Super.ButtonActivated( buttonPressed );

	return bHandled;
}

event bool ToggleChanged(Window button, bool bNewToggle)
{
	local bool bHandled;
	local ToolRadioButtonWindow rad;

	bHandled=true;
	rad=ToolRadioButtonWindow(button);

	switch(rad)
	{
	case curRad:
		if(!bNewToggle)
			rad.SetToggle(true);
		break;
	case radWeapons:
		if(bNewToggle)
		{
			curRad=rad;
			radAmmunition.SetToggle(false);
			radAugmentations.SetToggle(false);
			radItems.SetToggle(false);
			radCharacters.SetToggle(false);
			radAnimals.SetToggle(false);
			radRobots.SetToggle(false);
			SetListSet("WEAPONS");
		}
		break;
	case radAmmunition:
		if(bNewToggle)
		{
			curRad=rad;
			radWeapons.SetToggle(false);
			radAugmentations.SetToggle(false);
			radItems.SetToggle(false);
			radCharacters.SetToggle(false);
			radAnimals.SetToggle(false);
			radRobots.SetToggle(false);
			SetListSet("AMMUNITION");
		}
		break;
	case radAugmentations:
		if(bNewToggle)
		{
			curRad=rad;
			radWeapons.SetToggle(false);
			radAmmunition.SetToggle(false);
			radItems.SetToggle(false);
			radCharacters.SetToggle(false);
			radAnimals.SetToggle(false);
			radRobots.SetToggle(false);
			SetListSet("AUGMENTATIONS");
		}
		break;
	case radItems:
		if(bNewToggle)
		{
			curRad=rad;
			radWeapons.SetToggle(false);
			radAmmunition.SetToggle(false);
			radAugmentations.SetToggle(false);
			radCharacters.SetToggle(false);
			radAnimals.SetToggle(false);
			radRobots.SetToggle(false);
			SetListSet("ITEMS");
		}
		break;
	case radCharacters:
		if(bNewToggle)
		{
			curRad=rad;
			radWeapons.SetToggle(false);
			radAmmunition.SetToggle(false);
			radAugmentations.SetToggle(false);
			radItems.SetToggle(false);
			radAnimals.SetToggle(false);
			radRobots.SetToggle(false);
			SetListSet("CHARACTERS");
		}
		break;
	case radAnimals:
		if(bNewToggle)
		{
			curRad=rad;
			radWeapons.SetToggle(false);
			radAmmunition.SetToggle(false);
			radAugmentations.SetToggle(false);
			radItems.SetToggle(false);
			radCharacters.SetToggle(false);
			radRobots.SetToggle(false);
			SetListSet("ANIMALS");
		}
		break;
	case radRobots:
		if(bNewToggle)
		{
			curRad=rad;
			radWeapons.SetToggle(false);
			radAmmunition.SetToggle(false);
			radAugmentations.SetToggle(false);
			radItems.SetToggle(false);
			radCharacters.SetToggle(false);
			radAnimals.SetToggle(false);
			SetListSet("ROBOTS");
		}
		break;
	default:
		bHandled=false;
	}
	return bHandled||super.ToggleChanged(button,bNewToggle);
}

// ----------------------------------------------------------------------
// ListSelectionChanged() 
//
// When the user clicks on an item in the list, update the buttons
// appropriately
// ----------------------------------------------------------------------

event bool ListSelectionChanged(window list, int numSelections, int focusRowId)
{
	EnableButtons();

	return true;
}

// ----------------------------------------------------------------------
// ListRowActivated()
// ----------------------------------------------------------------------

event bool ListRowActivated(window list, int rowId)
{
//this was returning true and loading the map. will have to change back if dodgy
	return false;
}

// ----------------------------------------------------------------------
// EnableButtons()
//
// Checks the state of the list control and updates the pushbuttons
// appropriately
// ----------------------------------------------------------------------

function EnableButtons()
{
	btnLoad.SetSensitivity( lstClasses.GetNumSelectedRows() > 0 );

	SetFocusWindow(lstClasses);
}

function ToolRadioButtonWindow CreateToolRadioButton(int posX, int posY, String label, bool bDefaultValue)
{
	local ToolRadioButtonWindow newRadio;

	newRadio = ToolRadioButtonWindow(winContainer.NewChild(Class'ToolRadioButtonWindow'));
	newRadio.SetPos(posX, posY);
	newRadio.SetText(label);
	newRadio.SetToggle(bDefaultValue);

	return newRadio;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
    List(0)="WEAPONS:"
    List(1)="Alpha's Service Pistol:WeaponUniqueAO"
    List(2)="Assault Rifle:WeaponTNMAssaultGun"
    List(3)="Assault Shotgun:WeaponTNMAssaultShotgun"
    List(4)="Baton:WeaponTNMBaton"
    List(5)="Blow Pipe:WeaponBlowPipe"
    List(6)="Combat Knife:WeaponTNMCombatKnife"
    List(7)="Crowbar:WeaponTNMCrowbar"
    List(8)="Daikatana:WeaponDaikatana"
    List(9)="Dragons Tooth Sword:WeaponTNMNanoSword"
    List(10)="EMP Grenade:WeaponTNMEMPGrenade"
    List(11)="PHAT-Rifle:WeaponFatRifle"
    List(12)="Fire Blade:WeaponFireBlade"
    List(13)="Firestaff:WeaponFireStaff"
    List(14)="Flamethrower:WeaponTNMFlamethrower"
    List(15)="Foon:WeaponFoon"
    List(16)="Gas Grenade:WeaponTNMGasGrenade"
    List(17)="GEP Gun:WeaponTNMGEPGun"
    List(18)="Gibinator:WeaponGibinator"
    List(19)="Golden Spork:WeaponSporkGolden"
    List(20)="Hammer:WeaponHammer"
    List(21)="Katana (Default):WeaponKatana"
    List(22)="Katana (Digital Ronin):WeaponKatanaRonin"
    List(23)="Katana (Slicer):WeaponKatanaSlicer"
    List(24)="Kylie's Assault Rifle:WeaponUniqueKylie"
    List(25)="LAM:WeaponTNMLAM"
    List(26)="LAW:WeaponTNMLAW"
    List(27)="Laser Pistol:WeaponLaser"
    List(28)="Mine:WeaponMine"
    List(29)="Mini Crossbow:WeaponTNMMiniCrossbow"
    List(30)="Molotov Cocktail:WeaponMolBottle"
    List(31)="Napalm Launcher:WeaponNapalmLauncher"
    List(32)="NVSHacker's Screwdriver:WeaponUniqueNVS"
    List(33)="Pepper Gun:WeaponTNMPepperGun"
    List(34)="Pistol:WeaponTNMPistol"
    List(35)="Plasma Rifle:WeaponTNMPlasmarifle"
    List(36)="PS20:WeaponTNMHideAGun"
    List(37)="Pumpgun:WeaponShotgun"
    List(38)="Quad Launcher:WeaponQdRocket"
    List(39)="Riot Prod:WeaponTNMProd"
    List(40)="Sawed-Off Shotgun:WeaponTNMSawedOffShotgun"
    List(41)="Scrambler Grenade:WeaponTNMNanoVirusGrenade"
    List(42)="Screw Driver:WeaponScrewDriver"
    List(43)="Sniper Rifle:WeaponTNMRifle"
    List(44)="Spork:WeaponSpork"
    List(45)="Stealth Pistol:WeaponTNMStealthPistol"
    List(46)="Sword:WeaponTNMSword"
    List(47)="Throwing Foons:WeaponThrowFoon"
    List(48)="Throwing Knives:WeaponTNMShuriken"
    List(49)="Throwing Sporks:WeaponThrowSpork"
    List(50)="Trestkons Pistols:WeaponDoubleGuns"
    List(51)="Trip Bomb:WeaponTripBomb"
    List(52)="Vortex Grenade:WeaponPlasmanade"
    List(53)="Wrench:WeaponWrench"
    List(54)="ZeroPresence's Sniper Rifle:WeaponUniqueZP"
    List(55)="AMMUNITION:"
    List(56)="45 caliber:Ammo45"
    List(57)="10 mm:Ammo10mm"
    List(58)="20 mm:Ammo20mm"
    List(59)="30.06 mm:Ammo3006"
    List(60)="7.62 mm:Ammo762mm"
    List(61)="Blow Darts:AmmoBlowDart"
    List(62)="Dart (Regular):AmmoDart"
    List(63)="Dart (Flare):AmmoDartFlare"
    List(64)="Dart (Tranq):AmmoDartPoison"
    List(65)="Gibinator Battery:AmmoGibBattery"
    List(66)="Laser Battery:AmmoLaserBattery"
    List(67)="Mana Potion:AmmoManaPotion"
    List(68)="Napalm (FlameThrower):AmmoTNMNapalm"
    List(69)="Napalm (Napalm Launcher):AmmoNapalmL"
    List(70)="Pepper Cartridge:AmmoPepper"
    List(71)="PHAT-ray Canister:AmmoFatRifle"
    List(72)="Plasma Clip:AmmoPlasma"
    List(73)="Quad Rockets:AmmoQdRocket"
    List(74)="Rice Bags:AmmoRicebag"
    List(75)="Riot Prod Battery:AmmoBattery"
    List(76)="Rockets (EMP):AmmoEMPRocket"
    List(77)="Rockets (Regular):AmmoRocket"
    List(78)="Rockets (WP):AmmoRocketWP"
    List(79)="Shells (Regular):AmmoShell"
    List(80)="Shells (Sabot):AmmoSabot"
    List(81)="Spider Canister:AmmoSpiderCannister"
    List(82)="AUGMENTATIONS:"
    List(83)="Aqualung/Environmental:AugCannisterALER"
    List(84)="Ballistic/EMP Shield:AugCannisterBPES"
    List(85)="Cloak/Radar Transparency:AugCannisterCRT"
    List(86)="Regeneration/Energy Shield:AugCannisterHS"
    List(87)="Muscle/Combat Strength:AugCannisterMC"
    List(88)="ADS/Spy Drone:AugCannisterSDAD"
    List(89)="Synth Heart/Power:AugCannisterSHPR"
    List(90)="Speed/Run Silent:AugCannisterSS"
    List(91)="Targetting/Vision:AugCannisterTV"
    List(92)="ITEMS:"
    List(93)="Ambrosia Vial:VialAmbrosia"
    List(94)="Aug Upgrade Canister:AugmentationUpgradeCannister"
    List(95)="Ballistic Armor:BallisticArmor"
    List(96)="Beans:Beans"
    List(97)="Binoculars:Binoculars"
    List(98)="Biocell (Blue):BioelectricCell"
    List(99)="Biocell (Red):RedBiocell"
    List(100)="Candybar:Candybar"
    List(101)="Chemical Bottle:ChemicalBottle"
    List(102)="Cigarettes:Cigarettes"
    List(103)="Coffee:PlasticCoffee"
    List(104)="Credits (100):Credits"
    List(105)="Credits (2000):Credits2000"
    List(106)="Crystal Melk:TNMVialCrack"
    List(107)="Dog Blood:DogBlood"
    List(108)="Fire Extinguisher:WeaponFireExting"
    List(109)="Flare:Flare"
    List(110)="Floppy Disk (Hentai):FloppyDisk"
    List(111)="Floppy Disk (Virus):VirusDisk"
    List(112)="Forty:Liquor40oz"
    List(113)="Gas Mask:GasMask"
    List(114)="Gloves (Lethal):FistPickupLethal"
    List(115)="Gloves (Shocking):FistPickupShock"
    List(116)="Gloves (Stunning):FistPickupStun"
    List(117)="Hazmat Suit:HazMatSuit"
    List(118)="Karkian Snot:KarkianSnot"
    List(119)="Ketchup Bar:KetchupBar"
    List(120)="Liquor Bottle:LiquorBottle"
    List(121)="Lockpick:Lockpick"
    List(122)="Lollerskates:LollerSkates"
    List(123)="Medkit:MedKit"
    List(124)="Multitool:Multitool"
    List(125)="Nosferatus Teeth:NosferatusTeeth"
    List(126)="Painting Tube:PaintingTube"
    List(127)="Poster Tube:PosterTube"
    List(128)="Rebreather:Rebreather"
    List(129)="Sodacan:Sodacan"
    List(130)="Soy Food:SoyFood"
    List(131)="Spyware Device:WeaponBlackBox"
    List(132)="Tech Goggles:TechGoggles"
    List(133)="Thermoptic Camo:AdaptiveArmor"
    List(134)="Uranium Stick:UraniumStick"
    List(135)="Weapon Mod (Accuracy):WeaponModAccuracy"
    List(136)="Weapon Mod (Clip Size):WeaponModClip"
    List(137)="Weapon Mod (Laser):WeaponModLaser"
    List(138)="Weapon Mod (Range):WeaponModRange"
    List(139)="Weapon Mod (Recoil):WeaponModRecoil"
    List(140)="Weapon Mod (Reload):WeaponModReload"
    List(141)="Weapon Mod (Scope):WeaponModScope"
    List(142)="Weapon Mod (Silencer):WeaponModSilencer"
    List(143)="Wine Bottle:Winebottle"
    List(144)="CHARACTERS:"
    List(145)="ABI Commando:ABICommando"
    List(146)="ABI Elite Guard:ABIEliteGuard"
    List(147)="ABI Security Guard (Male):ABISecurityGuard"
    List(148)="ABI Security Guard (Female):ABIFemaleGuard"
    List(149)="Abomination:Abomnation"
    List(150)="Aemer:Aemer"
    List(151)="AJ:AJ"
    List(152)="Alien (Normal):Alien"
    List(153)="Alien (Mini):MiniAlien"
    List(154)="Alien (Phaser):Phaser"
    List(155)="Alien (Stalker):Stalker"
    List(156)="Alpha Operator:AlphaOperator"
    List(157)="Andreus:Andreus"
    List(158)="Arny:Arny"
    List(159)="Athanatos:Athanatos"
    List(160)="Athena:Athena"
    List(161)="AT Jazz:Jazz"
    List(162)="Beeblequix:Beeblequix"
    List(163)="Beefman:Beefman"
    List(164)="Board Guest 1:BoardGuest1"
    List(165)="Board Guest 2:BoardGuest2"
    List(166)="Breadfan:Breadfan"
    List(167)="Cerulean Security Guard (Helmet):CSIGuard"
    List(168)="Cerulean Security Guard (No Helmet):CSIGuardLight"
    List(169)="Chris the Cynic:Chris"
    List(170)="Compudoc:Compudoc"
    List(171)="Dark Templar:DarkTemplar"
    List(172)="Dazza:Dazza"
    List(173)="Deus Diablo:DD"
    List(174)="Despot:Despot"
    List(175)="DP:DP"
    List(176)="Dreamcast:Dreamcast"
    List(177)="Test Dummy:Dummy"
    List(178)="Endar:Endar"
    List(179)="Evil Invasion:EvilInvasion"
    List(180)="Fender2k1:Fender2k1"
    List(181)="Firewall Agent:FireWall"
    List(182)="Firewall Officer:FireWall2"
    List(183)="Ghandaiah:Ghand"
    List(184)="Glottis:Glottis"
    List(185)="Goat 1:Goat1"
    List(186)="Goat 2:Goat2"
    List(187)="Goat 3:Goat3"
    List(188)="Goat Female:GoatFemale"
    List(189)="Goat Templar 1:GoatTemplar1"
    List(190)="Goat Templar 2:GoatTemplar2"
    List(191)="Goat Templar 3:GoatTemplar3"
    List(192)="Grub:Grub"
    List(193)="Gwog:Gwog"
    List(194)="Hao Niu-rou:Hao"
    List(195)="Harvey:Harvey"
    List(196)="Hobbes:Hobbes"
    List(197)="Illuminati IIS:Illuminati"
    List(198)="Jackie:Jackie"
    List(199)="Jaysee:Jaysee"
    List(200)="jimmycracker:jimmycracker"
    List(201)="Jonas Waever:Jonas"
    List(202)="Kevo-sama:Kevo"
    List(203)="King Kashue:KingKashue"
    List(204)="Krissy:Krissy"
    List(205)="Kunio Kun:KunioKun"
    List(206)="Kylie Griffin:Kylie"
    List(207)="Llama 1:Llama1"
    List(208)="Llama 2:Llama2"
    List(209)="Llama 3:Llama3"
    List(210)="LlamaFemale:LlamaFemale"
    List(211)="Lo Vaquero:LoVaquero"
    List(212)="MadMax:MadMax"
    List(213)="Man In Black:ManInBlack"
    List(214)="Master_Kale:Master_Kale"
    List(215)="Mercedes:Mercedes"
    List(216)="MIB:TNMMIB"
    List(217)="Midashand:Midashand"
    List(218)="Mole:Mole"
    List(219)="Nice-But-Dim:NBDRat"
    List(220)="Nosferatu:Nosferatu"
    List(221)="NVSHacker:NVSHacker"
    List(222)="OiNutter:OiNutter"
    List(223)="Ozmo:Ozmo"
    List(224)="Phasmatis:Phasmatis"
    List(225)="PimpJojo:PimpJojo"
    List(226)="Raving Nutter:RavingNutter"
    List(227)="Ricemanu:Ricemanu"
    List(228)="Ryan:Ryan"
    List(229)="Ryan Hitman 1:RyanHitman1"
    List(230)="Ryan Hitman 2:RyanHitman2"
    List(231)="Scara B. King:ScaraKing"
    List(232)="Silver Dragon:SD"
    List(233)="Slicer:Slicer"
    List(234)="Steve Tack:SteveTack"
    List(235)="SymGeosis:SymGeosis"
    List(236)="That Guy (Hologram):ThatGuy"
    List(237)="That Guy (Real):ThatGuyFleshy"
    List(238)="The Fury:Fury"
    List(239)="Treskton:Treskton"
    List(240)="TheRenegadeMaster:TRM"
    List(241)="Vavrek:Vavrek"
    List(242)="walton simons:Walton"
    List(243)="WC Commando:WCCommando"
    List(244)="WCID Agent:WCIDAgent"
    List(245)="WC Security Guard:WCSecurity"
    List(246)="WC Thug:WCThug"
    List(247)="WIB:TNMWIB"
    List(248)="Winquman:Winquman"
    List(249)="Wolfy:Wolfy"
    List(250)="Yardbomb:Yardbomb"
    List(251)="ZeroPresence:ZeroPresence"
    List(252)="ANIMALS:"
    List(253)="Cat:TNMCat"
    List(254)="Doberman:TNMDoberman"
    List(255)="Dog:TNMMutt"
    List(256)="Fish 1:Fish"
    List(257)="Fish 2:Fish2"
    List(258)="Fly:Fly"
    List(259)="Gray:Gray"
    List(260)="Greasel:TNMGreasel"
    List(261)="Karkian:TNMKarkian"
    List(262)="Karkian Baby:TNMKarkianBaby"
    List(263)="Pigeon:Pigeon"
    List(264)="Rat:TNMRat"
    List(265)="Red Greasel:RedGreasel"
    List(266)="Seagull:Seagull"
    List(267)="Snow Wolf:SnowWolf"
    List(268)="ROBOTS:"
    List(269)="A2 (Lethal Weaponry):NVSHackerPet"
    List(270)="A2 (Non-Lethal Weaponry):NVSHackerPetNonLethal"
    List(271)="Cleaner Bot:TNMCleanerBot"
    List(272)="Hoverbot:Hoverbot"
    List(273)="Leviathan:Leviathan"
    List(274)="Med Bot:TNM_MedBot"
    List(275)="Military Bot (ABI):MilitaryBotABI"
    List(276)="Military Bot (GS):MilitaryBotGS"
    List(277)="Military Bot (PDX):MilitaryBotPDX"
    List(278)="Military Bot (WC):MilitaryBotWC"
    List(279)="Repair Bot:TNM_RepairBot"
    List(280)="Security Bot 2 (ABI):SecurityBot2ABI"
    List(281)="Security Bot 2 (GS):SecurityBot2GS"
    List(282)="Security Bot 2 (PDX):SecurityBot2PDX"
    List(283)="Security Bot 2 (WC):SecurityBot2WC"
    List(284)="Security Bot 3 (GS):SecurityBot3GS"
    List(285)="Security Bot 3 (PDX):SecurityBot3PDX"
    List(286)="Security Bot 3 (WC):SecurityBot3WC"
    List(287)="Security Bot 4:SecurityBot4Flamer"
    List(288)="Spiderbot (Small):TNMSpiderBot"
    List(289)="Spiderbot (Medium):TNMSpiderBotMed"
    List(290)="Spiderbot (Large):TNMSpiderBotBig"
    filterString="0123456789"
}
