//=================================================
// WeaponSGStaff.
//=================================================

class WeaponSGStaff extends TDPUniqueWeapon;

#exec TEXTURE IMPORT NAME=SGStaffTex0 FILE=textures\sgu_staffTex1.bmp GROUP=Skins FLAGS=2

//In-hand 1st view
#exec MESH IMPORT MESH=SGStaff ANIVFILE=MODELS\SGStaff_a.3d DATAFILE=MODELS\SGStaff_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=SGStaff X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=SGStaff SEQ=All STARTFRAME=0 NUMFRAMES=30
// add further '#exec MESH SEQUENCE' lines here to define additional animation sections

#exec MESHMAP NEW MESHMAP=SGStaff MESH=SGStaff


//Edit X, Y, and Z values in line below to change size of mesh in game
#exec MESHMAP SCALE MESHMAP=SGStaff X=2.166400 Y=2.166400 Z=2.166400

#exec MESHMAP SETTEXTURE MESHMAP=SGStaff NUM=0 TEXTURE=SGStaffTex0

//========================================================================

//In-hand 3rd view
#exec MESH IMPORT MESH=SGStaff3rd ANIVFILE=MODELS\SGStaff3rd_a.3d DATAFILE=MODELS\SGStaff3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=SGStaff3rd X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=SGStaff3rd SEQ=All STARTFRAME=0 NUMFRAMES=30
// add further '#exec MESH SEQUENCE' lines here to define additional animation sections

#exec MESHMAP NEW MESHMAP=SGStaff3rd MESH=SGStaff3rd


//Edit X, Y, and Z values in line below to change size of mesh in game
#exec MESHMAP SCALE MESHMAP=SGStaff3rd X=2.166400 Y=2.166400 Z=2.166400

#exec MESHMAP SETTEXTURE MESHMAP=SGStaff3rd NUM=0 TEXTURE=SGStaffTex0

//=========================================================================

//In-hand pickup
#exec MESH IMPORT MESH=SGStaffPickup ANIVFILE=MODELS\SGStaffPickup_a.3d DATAFILE=MODELS\SGStaffPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=SGStaffPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=SGStaffPickup SEQ=All STARTFRAME=0 NUMFRAMES=30
// add further '#exec MESH SEQUENCE' lines here to define additional animation sections

#exec MESHMAP NEW MESHMAP=SGStaffPickup MESH=SGStaffPickup


//Edit X, Y, and Z values in line below to change size of mesh in game
#exec MESHMAP SCALE MESHMAP=SGStaffPickup X=2.166400 Y=2.166400 Z=2.166400

#exec MESHMAP SETTEXTURE MESHMAP=SGStaffPickup NUM=0 TEXTURE=SGStaffTex0

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
	}
}

defaultproperties
{
    LowAmmoWaterMark=12
    GoverningSkill=Class'SkillWeaponHeavy'
    EnviroEffective=5
    reloadTime=2.00
    HitDamage=35
    maxRange=24000
    AccurateRange=14400
    BaseAccuracy=0.60
    bCanHaveScope=True
    ScopeFOV=20
    bCanHaveLaser=True
    AreaOfEffect=1
    bPenetrating=False
    recoilStrength=0.30
    mpReloadTime=0.50
    mpHitDamage=20
    mpBaseAccuracy=0.50
    mpAccurateRange=8000
    mpMaxRange=8000
    mpReloadCount=12
    bCanHaveModBaseAccuracy=True
    bCanHaveModReloadCount=True
    bCanHaveModAccurateRange=True
    bCanHaveModReloadTime=True
    bCanHaveModRecoilStrength=True
    AmmoName=Class'AmmoPlasma'
    ReloadCount=12
    PickupAmmoCount=12
    ProjectileClass=Class'PlasmaBolt'
    shakemag=50.00
    DrawnScale=0.2
    FireSound=Sound'DeusExSounds.Weapons.PlasmaRifleFire'
    AltFireSound=Sound'DeusExSounds.Weapons.PlasmaRifleReloadEnd'
    CockingSound=Sound'DeusExSounds.Weapons.PlasmaRifleReload'
    SelectSound=Sound'DeusExSounds.Weapons.PlasmaRifleSelect'
    InventoryGroup=100
    ItemName="StarGate Staff"
    PlayerViewOffset=(X=18.00,Y=0.00,Z=-7.00),
    PlayerViewMesh=SGStaff
    PickupViewMesh=SGStaffPickup
    ThirdPersonMesh=SGStaff3rd
    LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
    Icon=Texture'DeusExUI.Icons.BeltIconPlasmaRifle'
    largeIcon=Texture'DeusExUI.Icons.LargeIconPlasmaRifle'
    largeIconWidth=203
    largeIconHeight=66
    invSlotsX=4
    invSlotsY=2
    Description="An experimental weapon imported in our world from a TV Show: StarGate SG-1 by the Darma Laboratory. Currently bugged, the laboratory is trying to make it perfect weapon.|n<SCAN>CURRENT BUGS:|n - Need to reload|n - has no animations|n - Do not use the hand-tex|n - Too big|n - Don't show hands|n - Textures unapplieds|n - Use Plama gun belt image|n - Use plasma bolt|n - Use ammoplasma</SCAN>"
    beltDescription="StarGate"
    Mesh=SGStaff
    CollisionRadius=7.60
    CollisionHeight=2.20
    Mass=25.00
}
