//=============================================================================
// Slow down the game. boost the player. 
// Note: Need to replace tracehit stuff into real bullets.
// Use Inexilium (Second Inexilium aug?)
//=============================================================================
class AugBulletTime extends Augmentation;

#exec TEXTURE IMPORT FILE=Textures\AugIconSlomo.pcx		NAME=AugIconSlomo 			GROUP="Augs" Mips=Off Flags=2
#exec TEXTURE IMPORT FILE=Textures\AugIconSlomo_Small.pcx 	NAME=AugIconSlomo_Small 		GROUP="Augs" Mips=Off Flags=2
#exec AUDIO IMPORT FILE="Sounds\SlomoAugLoop.mp3" 		NAME="SlomoAugLoop" 			GROUP="Augs"

var() config float slowspeed;
var() float normalspeed;

function SetSpeed(float Speed)	
{   
    Level.Game.Level.TimeDilation = Speed;
    Level.Game.SetTimer(Level.TimeDilation, true);
}

state Active
{
Begin:
	normalspeed = level.default.timedilation;
	slowspeed = normalspeed / LevelValues[CurrentLevel];
	SetSpeed(slowspeed);
	Player.GroundSpeed *= LevelValues[CurrentLevel];			
	Player.JumpZ *= (((LevelValues[CurrentLevel] - 1) * 0.2) + 1);		
	Player.AccelRate *= (LevelValues[CurrentLevel] * 3);			
}

function Deactivate()
{	
	normalspeed = level.default.timedilation;
	Super.Deactivate();	
	SetSpeed(normalspeed);							
	Player.GroundSpeed = Player.Default.GroundSpeed;
	Player.JumpZ = Player.Default.JumpZ;
	Player.AccelRate = Player.Default.AccelRate;
}

defaultproperties
{
    EnergyRate=30.00
    Icon=Texture'AugIconSlomo'
    smallIcon=Texture'AugIconSlomo_Small'
    AugmentationName="Chronos"
    Description="This is a reflex and mental speed increase augmentation.|n|nTECH ONE: Speed and perception are doubled.|n|nTECH TWO: Speed and perception are tripled.|n|nTECH THREE: Speed and perception are quadrupled.|n|nTECH FOUR: Speed and perception are quintupled."
    LevelValues(0)=2.00
    LevelValues(1)=3.00
    LevelValues(2)=4.00
    LevelValues(3)=5.00
    AugmentationLocation=4
    ActivateSound=Sound'DeusExSounds.Augmentation.AugActivate'
    DeActivateSound=Sound'DeusExSounds.Augmentation.AugDeactivate'
    LoopSound=Sound'TDP.Augs.SlomoAugLoop'
}
