//============================================================================================
//Auth: Smuggler.
//Clock: Display Player local time on a texture.
//Darma: I would like to put this into a actor. When you frob it, it show you your local time.
//To TDP Team: Yeah, I got the autorization to use this.
//============================================================================================
class ChronosClock extends Actor;

var() Texture TextureOwner;

simulated function PostBeginPlay()
{
	if (ScriptedTexture(TextureOwner) != None)
		ScriptedTexture(TextureOwner).NotifyActor = Self;
}


simulated function Destroyed()
{
	if (ScriptedTexture(TextureOwner) != None)
		ScriptedTexture(TextureOwner).NotifyActor = None;
}


simulated event RenderTexture(ScriptedTexture Tex)
{
	Tex.DrawText(0, 0, ClockString(), Font'DeusExUI.FontFixedWidthLocation');
}


simulated final function string ClockString()
{
	local string str;
	local int ti;

	ti = Level.Hour;

	if (ti > 12)
		ti -= 12;

	if (ti == 0)
		ti = 12;

	if (ti < 10)
		str = str $ "0";
	str = str $ ti $ ":";

	if (Level.Minute < 10)
		str = str $ "0";
	str = str $ Level.Minute $ ":";

	if (Level.Second < 10)
		str = str $ "0";
	str = str $ Level.Second;

	if (Level.Hour >= 12)
		str = str @ "PM";
	else
		str = str @ "AM";

	return str;
}

defaultproperties
{
    bHidden=True
    bNoDelete=True
    RemoteRole=2
    bAlwaysRelevant=True
    NetPriority=2.00
}
