//=============================================================================
// TDPComputers
//=============================================================================
class TDPComputers extends TnmComputers;

enum EComputerNodesTDP
{
CN_DL, // Darma Laboratory
CN_PDXBank, // PDX Bank Net, To keep
CN_PDXNet, // PDX Net, Will be removed
CN_DXO, // New DXO HQ
CN_MelkNett, //MelkNett(TM),
CN_DXI, //Deus Ex Incarnate,
CN_SBI, // Sphere Business Inc, Cover for DL
CN_Cafe, // A simple cafe coallition
CN_DEBUG, // Debug Server (In the system)
CN_BOS, // BlueOS (non-networked)
CN_Llama, // LlamaNet
CN_S101 // Summer 101 Devellopement Team Server
};

var() EComputerNodesTDP ComputerNodeTDP;

event PreBeginPlay()
{
	if(terminalTypeStr!="")
		terminalType=class<NetworkTerminal>(DynamicLoadObject(terminalTypeStr, class'Class'));
}

// ----------------------------------------------------------------------
// GetNodeName()
// ----------------------------------------------------------------------

function String GetNodeName()
{
	return nodeInfo[Int(ComputerNodeTDP)].nodeName;
}

// ----------------------------------------------------------------------
// GetNodeDesc()
// ----------------------------------------------------------------------

function String GetNodeDesc()
{
	return nodeInfo[Int(ComputerNodeTDP)].nodeDesc;
}

// ----------------------------------------------------------------------
// GetNodeAddress()
// ----------------------------------------------------------------------

function String GetNodeAddress()
{
	return nodeInfo[Int(ComputerNodeTDP)].nodeAddress;
}

// ----------------------------------------------------------------------
// GetNodeTexture()
// ----------------------------------------------------------------------

function Texture GetNodeTexture()
{
	return nodeInfo[Int(ComputerNodeTDP)].nodeTexture;
}


// ----------------------------------------------------------------------
// Nodes
// ----------------------------------------------------------------------

function clean()
{
	if ((termwindow.winComputer.winStatus != None) && (termwindow.winComputer.compOwner.IsA('Computers')))
		termwindow.winComputer.winStatus.SetText(tnmComputers(termwindow.winComputer.compOwner).GetNodeAddress());
}

function Frob(Actor Frobber, Inventory frobWith)
{
	if(!bUsable)
	{
		Trestkon(Frobber).ClientMessage("This machine is being used by someone else.");
		return;
	}

	super.Frob(Frobber,frobWith);
}

defaultproperties
{
     specialOptionflags(0)=(bDesiredValue=True)
     specialOptionflags(1)=(bDesiredValue=True)
     specialOptionflags(2)=(bDesiredValue=True)
     specialOptionflags(3)=(bDesiredValue=True)
     TextPackage="TDPText"
     NodeInfo(0)=(nodeName="DL Server",nodeDesc="Darma Laboratory Server",nodeAddress="StarGate:LocalNode:TDP//DLServer//NODE.34@778/Login",nodeTexture=Texture'TDP.Nodes.TDPNodeDL')
     NodeInfo(1)=(nodeName="PDXBank",nodeDesc="PDX, Banking Departement",nodeAddress="ForumPlanet:GlobalNode:DL//PDXNET//NODE.65@435/Login",nodeTexture=Texture'TDP.Nodes.TDPNodePDXB')
     NodeInfo(2)=(nodeName="PDXNet",nodeDesc="PDXNet",nodeAddress="ForumPlanet:GlobalNode:DL//PDXNET//NODE.65@435/Login",nodeTexture=Texture'TDP.Nodes.TDPNodePDX')
     NodeInfo(3)=(nodeName="DeusEx.org",nodeDesc="DeusEx.org",nodeAddress="ForumPlanet:GlobalNode:DL//DXO//NODE.65@435/Login",nodeTexture=Texture'TDP.Nodes.TDPNodeDXO')
     NodeInfo(4)=(nodeName="MelkNett(TM)",nodeDesc="MelkNett(TM)",nodeAddress="ForumPlanet:GlobalNode:DL//MELKNET//NODE.78@793/Login",nodeTexture=Texture'TDP.Nodes.TDPNodemelknett')
     NodeInfo(5)=(nodeName="Deus Ex Incarnate",nodeDesc="Deus Ex Incarnate",nodeAddress="ForumPlanet:GlobalNode:DL//DXI//NODE.44@156/Login",nodeTexture=Texture'TDP.Nodes.TDPNodeDXI')
     NodeInfo(6)=(nodeName="SBI",nodeDesc="Sphere Business INC.",nodeAddress="ForumPlanet:GlobalNode:DL//SBI//NODE.22@756/Login",nodeTexture=Texture'TDP.Nodes.TDPNodeSBI')
     NodeInfo(7)=(nodeName="The Cafe",nodeDesc="Local Caf",nodeAddress="ForumPlanet:GlobalNode:DL//CAFE//NODE.89@274/Login",nodeTexture=Texture'TDP.Nodes.TDPNodeCafe')
     NodeInfo(8)=(nodeName="DEBUG",nodeDesc="DEBUG ERROR REPORT THIS A BUG.",nodeAddress="UNREAL//DEUSEX//TNM//TDP//NARCICUSS//TRESTKON",nodeTexture=Texture'TDP.Nodes.TDPNodeSBI')
     NodeInfo(9)=(nodeName="BlueOS",nodeDesc="Local Machine (no network detected)",nodeAddress="LocalMachine//system/bluekernel/interface/Login",nodeTexture=Texture'TDP.Nodes.TDPNodeBOS')
     NodeInfo(10)=(nodeName="LlamaNet",nodeDesc="THE Llama!!",nodeAddress="ForumPlanet:GlobalNode:DL//LlamaNET//NODE.78@793/Login",nodeTexture=Texture'TDP.Nodes.TDPNodeLlama')
     NodeInfo(11)=(nodeName="S101",nodeDesc="Summer 101 Devellopement Team",nodeAddress="Moddb:GlobalNode:Mod//S101//NET//NODE.78@793/Login",nodeTexture=Texture'TDP.Nodes.TDPNodeS101')
     bUsable=True
}
