//=============================================================================
// TDPCredits :/
//=============================================================================
class tdpcredits extends CreditsScrollWindow;

#exec OBJ LOAD FILE=TNM

var Texture CreditsBannerTextures[6];
var Texture TeamPhotoTextures[6];
var Float   creditsEndSoundLength;

// Easter egg processing
var String easterStrings[9];
var String foundStrings[9];
var String easterSearch;
var Int    easterPhraseIndex;
var Float  easterEggTimer;
var int    maxRandomPhrases;
var bool   bShowEasterPhrases;
var int    phraseCount;
var int    phraseIndex;

// Easter Egg Sounds
var Sound  EggBadLetterSounds[8];
var Sound  EggGoodLetterSounds[5];
var Sound  EggFoundSounds[3];

var float creditsmusictimeremaining;
var dxogg CreditsMusic;

function PrintPicture(
	Texture pictureTextures[6], 
	int textureCols,
	int textureRows,
	int imageX, 
	int imageY)
{
	local PictureWindow winPicture;

	winPicture = PictureWindow(winScroll.NewChild(Class'TranslucentPictureWindow'));
	winPicture.SetTextures(pictureTextures, textureCols, textureRows);
	winPicture.SetSize(imageX, imageY);
}

event DrawWindow(GC gc)
{
	gc.SetTileColorRGB(255,255,255);
	gc.SetStyle(DSTY_Translucent);

	gc.DrawTexture(width-256,height-512,256,256,0,0,Texture'tnm.tnmcreditstrestkon01');
	gc.DrawTexture(width-256,height-256,256,256,0,0,Texture'tnm.tnmcreditstrestkon01');

	super.DrawWindow(gc);
}

function ProcessText()
{
	local DeusExTextParser parser;
	PrintPicture(CreditsBannerTextures, 2, 1, 512, 256);
	PrintLn();

	// Create the text parser
	parser = new(None) Class'DeusExTextParser';

	// Attempt to find the text object
	if (parser.OpenText('TDPCredits',"TDPText"))
	{
		while(parser.ProcessText())
			ProcessTextTag(parser);

		parser.CloseText();
	}

	CriticalDelete(parser);

	ProcessFinished();

}


// ----------------------------------------------------------------------
// ProcessFinished()
// ----------------------------------------------------------------------

function ProcessFinished()
{
	local DXOgg music;
	local tnmoggmusicmanager tnmmusic;

	//PrintLn();
	//PrintPicture(TeamPhotoTextures, 3, 1, 600, 236);
	Super.ProcessFinished();

	//ew hack hack hack
	foreach GetPlayerPawn().AllActors(Class'DXOgg',music)
	{
		music.SetCurrentOgg("Blank.ogg", "Blank.ogg",0.0,MTRAN_Instant);
		tnmmusic=tnmoggmusicmanager(music);
		if(tnmmusic!=none)
			tnmmusic.pause();
	}
	creditsmusic=music;
	if(creditsmusic==none) creditsmusic=GetPlayerPawn().Spawn(Class'DXOgg');
	creditsmusic.SetCurrentOgg("TDP_Theme.ogg", "TDP_Theme.ogg", 0.0, MTRAN_Instant);
	creditsmusictimeremaining = 214.0;
}

// ----------------------------------------------------------------------
// FinishedScrolling()
// ----------------------------------------------------------------------

function FinishedScrolling()
{
	if (player.bQuotesenabled)
	{
		// Shut down the music
//		player.ClientSetMusic(player.Level.Song, savedSongSection, 255, MTRAN_FastFade);
//		player.PlaySound(Sound'CreditsEnd');
	}
	else
	{
		Super.FinishedScrolling();
	}
}

// ----------------------------------------------------------------------
// Tick()
// ----------------------------------------------------------------------

function Tick(float deltaTime)
{
	local dxogg music;

	Super.Tick(deltaTime);

	if ( creditsmusictimeremaining > 0 )
	{
		creditsmusictimeremaining -= deltaTime;
		if ( creditsmusictimeremaining <= 0 )
			creditsmusic.SetCurrentOgg("Stereo_Plus_Belle_La_Vie.ogg", "Stereo_Plus_Belle_La_Vie.ogg", 0.0, MTRAN_Instant);
	}

	if (!bScrolling)
	{
		creditsEndSoundLength -= deltaTime;

		if (creditsEndSoundLength < 0.0)
		{
			bTickEnabled = False;
			InvokeQuotesWindow();
		}
	}

	if (bShowEasterPhrases)
	{
		easterEggTimer -= deltaTime;

		phraseCount = Rand(maxRandomPhrases);
		// Create a random number of phrases
		for(phraseIndex=0; phraseIndex<phraseCount; phraseIndex++)
			CreateEasterPhrase();

		if (easterEggTimer < 0.0)
		{
			bShowEasterPhrases = False;
			easterEggTimer = Default.easterEggTimer;
		}
	}
}

// ----------------------------------------------------------------------
// InvokeQuotesWindow()
// ----------------------------------------------------------------------

function InvokeQuotesWindow()
{
	local tdpQuotesWindow winQuotes;

	// Check to see if the 
	if (player.bQuotesEnabled)
	{
		winQuotes = TDPQuotesWindow(root.InvokeMenuScreen(Class'TDPQuotesWindow'));
		winQuotes.SetLoadIntro(bLoadIntro);
		winQuotes.SetClearStack(True);
	}
}

// ----------------------------------------------------------------------
// DestroyWindow()
// ----------------------------------------------------------------------

event DestroyWindow()
{
	local TNMOggMusicManager music;

	creditsmusic.SetCurrentOgg("Blank.ogg", "Blank.ogg",0.0,MTRAN_Instant);
	creditsmusic.Destroy();

	foreach getplayerpawn().allactors(class'TNMOggMusicManager', music)
		music.unpause();

	// load denouement, which isn't exactly what this was intended for but it works
	if (bLoadIntro)
	{
		player.ClientTravel("TDPDenouement.dx", TRAVEL_Relative, True);
	}

	Super.DestroyWindow();
}

// ----------------------------------------------------------------------
// KeyPressed() 
// ----------------------------------------------------------------------

event bool KeyPressed(string key)
{
	local bool bKeyHandled;

	if (IsKeyDown(IK_Alt))
		return False;

	// Check to see if the key entered is one of the 
	// easter egg phrases
	// 
	// First check to see if this is an alphanum character

	if (player.bCheatsEnabled)
	{
		if (((key >= "A") && (key <= "Z")) ||
		    ((key >= "a") && (key <= "z")) ||
		    ((key >= "0") && (key <= "9")))
		{
			bKeyHandled = True;

			// Convert lower-case to upper
			if ((key >= "a") && (key <= "z"))
				key = Chr(Asc(key) - 32);

			easterSearch = easterSearch $ key;

			// If this egg wasn't found *AND* the string is at 
			// least two characters found, then play a BZZT sound
			if (!ProcessEasterEgg())
			{
				// If the string is > 1 character, play a BZZT 
				// sound.
				if (Len(easterSearch) > 1)
				{
					// Play BZZT
					PlayEggBadLetter();
				}

				// Reset string
				easterSearch = "";
			}
		}
	}

	if (bKeyHandled)
		return True;
	else
		return Super.KeyPressed(key);
}

// ----------------------------------------------------------------------
// ProcessEasterEgg()
// ----------------------------------------------------------------------

function bool ProcessEasterEgg()
{
	local Int eggIndex;
	local bool bPartialPhrase;
	local bool bEggFound;

	bPartialPhrase = False;

	// Loop through all the eggs and see if we have a matching phrase
	for(eggIndex=0; eggIndex<arrayCount(easterStrings); eggIndex++)
	{
		if (easterstrings[eggIndex] == easterSearch)
		{
			EggFound(eggIndex);
			bEggFound = True;
			bPartialPhrase = False;
			break;
		}

		// Do a partial search
		if (InStr(easterStrings[eggIndex], easterSearch) != -1)
		{
			bPartialPhrase = True;
		}
	}

	// If this was a partial match, play a sound
	if (bPartialPhrase)
		PlayEggGoodLetter();

	return (bPartialPhrase || bEggFound);
}

// ----------------------------------------------------------------------
// EggFound()
// ----------------------------------------------------------------------

function EggFound(int eggIndex)
{
	PlayEggFoundSound();

	easterPhraseIndex  = eggIndex;
	bShowEasterPhrases = True;

	// Now act on the phrase
	if (easterSearch == "QUOTES")
	{
		player.bQuotesEnabled = True;
		player.SaveConfig();
	}
	else if (easterSearch == "BIGHEAD")
	{
	}

	easterSearch = "";
}

// ----------------------------------------------------------------------
// CreateEasterPhrase()
// ----------------------------------------------------------------------

function CreateEasterPhrase()
{
	local FadeTextWindow winFade;

	winFade = FadeTextWindow(NewChild(Class'FadeTextWindow'));
	winFade.SetText(foundStrings[easterPhraseIndex]);
	winFade.SetPos(Rand(width) - Rand(100), Rand(height));
}

// ----------------------------------------------------------------------
// PlayEggFoundSound()
// ----------------------------------------------------------------------

function PlayEggFoundSound()
{
	// Temporary
	player.PlaySound(EggFoundSounds[Rand(ArrayCount(EggFoundSounds))]);
}

// ----------------------------------------------------------------------
// PlayEggGoodLetter()
// ----------------------------------------------------------------------

function PlayEggGoodLetter()
{
	// Temporary
	player.PlaySound(EggGoodLetterSounds[Rand(ArrayCount(EggGoodLetterSounds))]);
}

// ----------------------------------------------------------------------
// PlayEggBadLetter()
// ----------------------------------------------------------------------

function PlayEggBadLetter()
{
	// Temporary
	player.PlaySound(EggBadLetterSounds[Rand(ArrayCount(EggBadLetterSounds))]);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     creditsmusictimeremaining=-1.0
     CreditsBannerTextures(0)=tnm.tnmcreditstrestkon01
     CreditsBannerTextures(1)=tnm.tnmcreditstrestkon02
     TeamPhotoTextures(0)=Texture'DeusExUI.UserInterface.TeamFront_1'
     TeamPhotoTextures(1)=Texture'DeusExUI.UserInterface.TeamFront_2'
     TeamPhotoTextures(2)=Texture'DeusExUI.UserInterface.TeamFront_3'
     creditsEndSoundLength=4.000000
     easterStrings(0)="QUOTES"
     easterStrings(1)="DANCEPARTY"
     easterStrings(2)="THEREISNOSPOON"
     easterStrings(3)="HUTHUT"
     easterStrings(4)="BIGHEAD"
     easterStrings(5)="IAMWARREN"
     easterStrings(6)="MOREFROGS"
     easterStrings(7)="MOON"
     easterStrings(8)="ME"
     foundStrings(0)="QUOTES ENABLED!"
     foundStrings(1)="DANCE PARTY ENABLED!"
     foundStrings(2)="MAY TRICKS MODE ENABLED!"
     foundStrings(3)="HUT HUT HUT HUT HUT!"
     foundStrings(4)="EVEN CYLONS, ER, TNM TEAM MEMBERS HAVE FEELINGS :("
     foundStrings(5)="GENERAL PROTECTION FAULT!"
     foundStrings(6)="I HAVE TEN FINGERS AND TEN TOES!"
     foundStrings(7)="MY CAT IS BEATING MY FEET!"
     foundStrings(8)="ME AND YOU"
     easterEggTimer=3.000000
     maxRandomPhrases=5
     EggBadLetterSounds(0)=Sound'DeusExSounds.Generic.Buzz1'
     EggBadLetterSounds(1)=Sound'DeusExSounds.Generic.LargeExplosion1'
     EggBadLetterSounds(2)=Sound'DeusExSounds.Generic.GlassBreakLarge'
     EggBadLetterSounds(3)=Sound'DeusExSounds.Generic.SplashLarge'
     EggBadLetterSounds(4)=Sound'DeusExSounds.Animal.CatDie'
     EggBadLetterSounds(5)=Sound'DeusExSounds.NPC.ChildDeath'
     EggBadLetterSounds(6)=Sound'DeusExSounds.Special.FlushToilet'
     EggGoodLetterSounds(0)=Sound'DeusExSounds.Generic.KeyboardClick1'
     EggGoodLetterSounds(1)=Sound'DeusExSounds.Generic.KeyboardClick2'
     EggGoodLetterSounds(2)=Sound'DeusExSounds.Generic.KeyboardClick1'
     EggGoodLetterSounds(3)=Sound'DeusExSounds.Generic.KeyboardClick2'
     EggGoodLetterSounds(4)=Sound'DeusExSounds.Generic.KeyboardClick3'
     EggFoundSounds(0)=Sound'DeusExSounds.Special.Airplane2'
     EggFoundSounds(1)=Sound'DeusExSounds.Generic.Beep2'
     EggFoundSounds(2)=Sound'DeusExSounds.Generic.Foghorn'
//     ScrollMusicString="Credits_Music.Credits_Music"
     textName=tdpcredits
}
