//==============================================
//The Darma Project's Needed Textures
// auth: Darma
//==============================================
class TDPImport expands Object abstract;

//--------------------------------------------------------------------------
//Textures: 
//--------------------------------------------------------------------------

//==========================================================================
//Player
//==========================================================================

#exec TEXTURE IMPORT FILE=Textures\Player\body.pcx 		NAME=body 		GROUP="Mario"
#exec TEXTURE IMPORT FILE=Textures\Player\head.pcx 		NAME=head 		GROUP="Mario"
#exec TEXTURE IMPORT FILE=Textures\Player\PCTex0.pcx 		NAME=PCTex0 		GROUP="Player"
#exec TEXTURE IMPORT FILE=Textures\Player\PCTex0B.pcx 		NAME=PCTex0B 		GROUP="Player"
#exec TEXTURE IMPORT FILE=Textures\Player\PCTex0C.pcx		NAME=PCTex0C 		GROUP="Player"
#exec TEXTURE IMPORT FILE=Textures\Player\PCTex1.pcx 		NAME=PCTex1		GROUP="Player"
#exec TEXTURE IMPORT FILE=Textures\Player\PCTex1B.pcx 		NAME=PCTex1B 		GROUP="Player"
#exec TEXTURE IMPORT FILE=Textures\Player\PCTex2.pcx 		NAME=PCTex2 		GROUP="Player"
#exec TEXTURE IMPORT FILE=Textures\Player\PCTex3.pcx 		NAME=PCTex3 		GROUP="Player"

//==========================================================================
//White Blood for WCCC's character by Darmy
//==========================================================================

#exec TEXTURE IMPORT FILE=Textures\WCCCBlood\WCCCFlatFXTex1.pcx NAME=WFlatFXTex1 		GROUP="Blood"
#exec TEXTURE IMPORT FILE=Textures\WCCCBlood\WCCCFlatFXTex2.pcx NAME=WFlatFXTex2 		GROUP="Blood"
#exec TEXTURE IMPORT FILE=Textures\WCCCBlood\WCCCFlatFXTex3.pcx NAME=WFlatFXTex3 		GROUP="Blood"
#exec TEXTURE IMPORT FILE=Textures\WCCCBlood\WCCCFlatFXTex5.pcx NAME=WFlatFXTex5 		GROUP="Blood"
#exec TEXTURE IMPORT FILE=Textures\WCCCBlood\WCCCFlatFXTex6.pcx NAME=WFlatFXTex6 		GROUP="Blood"
#exec TEXTURE IMPORT FILE=Textures\WCCCBlood\WCCCFleshFragmentTex1.pcx NAME=WFleshFragmentTex1 	GROUP="Blood"
#exec TEXTURE IMPORT FILE=Textures\WCCCBlood\WCCCBloodTex1.pcx  NAME=WBloodTex1 		GROUP="Blood"

//==========================================================================
//nodes
//==========================================================================
#exec TEXTURE IMPORT FILE="Textures\Nodes\nodeDL.pcx"		NAME="TDPNodeDL"	GROUP="Nodes" 	MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\Nodes\nodePDX.pcx" 		NAME="TDPNodePDX"	GROUP="Nodes"	MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\Nodes\nodemelknett.pcx"	NAME="TDPNodemelknett"	GROUP="Nodes" 	MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\Nodes\nodePDXB.pcx"		NAME="TDPNodePDXB"	GROUP="Nodes" 	MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\Nodes\nodeCafe.pcx"		NAME="TDPNodeCafe"	GROUP="Nodes" 	MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\Nodes\NodeDXO.pcx"		NAME="TDPNodeDXO"	GROUP="Nodes" 	MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\Nodes\NodeDXI.pcx"		NAME="TDPNodeDXI"	GROUP="Nodes" 	MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\Nodes\NodeSBI.pcx"		NAME="TDPNodeSBI"	GROUP="Nodes" 	MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\Nodes\NodeBOS.pcx"		NAME="TDPNodeBOS"	GROUP="Nodes" 	MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\Nodes\NodeLlama.pcx"	NAME="TDPNodeLlama"	GROUP="Nodes" 	MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\Nodes\NodeS101.pcx"		NAME="TDPNodeS101"	GROUP="Nodes" 	MIPS=Off 

//--------------------------------------------------------------------------
//Mesh:
//--------------------------------------------------------------------------

//==========================================================================
//Mario
//==========================================================================

#exec MESH IMPORT MESH=Mario ANIVFILE=Models\Mario_a.3d DATAFILE=Models\Mario_d.3d ZEROTEX=0 MLOD=1

#exec MESH SEQUENCE MESH=Mario SEQ=All STARTFRAME=0 NUMFRAMES=30 RATE=30 GROUP=None

#exec MESHMAP SCALE MESHMAP=Mario X=0,18922 Y=0,18922 Z=0,18922
#exec MESH ORIGIN MESH=Mario X=0 Y=0 Z=0 PITCH=0 YAW=0 ROLL=0

#exec MESH LODPARAMS MESH=Mario HYSTERESIS=0 STRENGTH=1 MINVERTS=10 MORPH=0,3 ZDISP=0

//==========================================================================
//Mario Carcass
//==========================================================================

#exec MESH IMPORT MESH=MarioDeath ANIVFILE=Models\MarioDeath_a.3d DATAFILE=Models\MarioDeath_d.3d ZEROTEX=0 MLOD=1

#exec MESH SEQUENCE MESH=MarioDeath SEQ=All STARTFRAME=0 NUMFRAMES=30 RATE=30 GROUP=None

#exec MESHMAP SCALE MESHMAP=MarioDeath X=0,19043 Y=0,19043 Z=0,19043
#exec MESH ORIGIN MESH=MarioDeath X=0 Y=0 Z=0 PITCH=0 YAW=0 ROLL=0

#exec MESH LODPARAMS MESH=MarioDeath HYSTERESIS=0 STRENGTH=1 MINVERTS=10 MORPH=0,3 ZDISP=0


//--------------------------------------------------------------------------
//Sounds:
//--------------------------------------------------------------------------

//==========================================================================
//Mario
//==========================================================================

#exec AUDIO IMPORT FILE="Sounds\death1.wav" NAME="death1" GROUP="Mario"
#exec AUDIO IMPORT FILE="Sounds\pain25_1.wav" NAME="pain25_1" GROUP="Mario"
#exec AUDIO IMPORT FILE="Sounds\pain100_1.wav" NAME="pain100_1" GROUP="Mario"
#exec AUDIO IMPORT FILE="Sounds\pain75_1.wav" NAME="pain75_1" GROUP="Mario"
#exec AUDIO IMPORT FILE="Sounds\jump1.wav" NAME="jump1" GROUP="Mario"

//==========================================================================
//Ambiant
//==========================================================================

#exec AUDIO IMPORT FILE="Sounds\TDPAlarm1.mp3" NAME="TDPAlarm1" GROUP="Ambiant"
#exec AUDIO IMPORT FILE="Sounds\TDPAlarm2.mp3" NAME="TDPAlarm2" GROUP="Ambiant"
#exec AUDIO IMPORT FILE="Sounds\TDPAlarm3.mp3" NAME="TDPAlarm3" GROUP="Ambiant"
#exec AUDIO IMPORT FILE="Sounds\TDPAlarm4.mp3" NAME="TDPAlarm4" GROUP="Ambiant"
#exec AUDIO IMPORT FILE="Sounds\TDPAlarm5.mp3" NAME="TDPAlarm5" GROUP="Ambiant"

defaultproperties
{
}
