class TDPMissionScript extends MissionScript;

var float wait;

var int PDXFloor1AggressiveKills;
var int GoatCityAggressiveKills;
var int LlamaTempleAggressiveKills;
var int DXOAggressiveKills;
var int FCAggressiveKills;

var name CountExclusions[32];

var bool bNeedToCount;

var() localized string NeoMissingMsg;
var() localized string NeoMissingTitle;

function fade( float fadetime, actor target, bool fadein)
{
	local fader f;
	f=Spawn(Class'fader');
	f.SetBase(target);
	f.Start(fadetime, target, fadein);
}

function DecrementTimers()
{
}

function HandleTimers()
{
}

function DecrementTimer(name timerstartedname, name timername)
{
	local int old;
	if (flags != none)
	{
		if (flags.GetBool(timerstartedname))
		{
			old = flags.GetInt(timername);
			if (old > 0)
			{
				flags.SetInt(timername,old - 1,,);
			}
		}
	}
}

function DeleteTimer(name timerstartedname, name timername)
{
	flags.DeleteFlag(timerstartedname, FLAG_Bool);
	flags.DeleteFlag(timername, FLAG_Int);
}

function AddTimer(name timerstartedname, name timername, int seconds)
{
	if (!flags.GetBool(timerstartedname))
	{
		flags.SetBool(timerstartedname, true,,);
		flags.SetInt(timername,seconds,,);
	}
}

function bool IsTimerDone(name timerstartedname, name timername)
{
	if (flags != none)
	{
		if (flags.GetBool(timerstartedname))
		{
			return flags.GetInt(timername) <= 0;
		}
		else
			return false;
	}
}

function PlayerDetected()
{
}

function HandleGameEvent(name scriptFunction)
{
	//child classes should overwrite this.
	//They will contain a case statement that works out which function to call.
	//Upon finding the function they should call it and then return
	//If the function cannot be handled this super function should be called which
	//will log the error

	//Function not found in script

	switch ( scriptFunction )
	{
		case 'PlayOutroTrack': PlayOutroTrack(); break;
		default: Log("Function '" $ scriptFunction $ "' could not be found in mission script");
	}
}

function PlayOutroTrack()
{
    local tnmoggmusicmanager ogg;
    foreach allactors(class'tnmoggmusicmanager', ogg)
    {
        ogg.bPlayOutro = true;
    }
}

function TeleportPawn(ScriptedPawn pawn, name patrolTag, name orders, optional bool bRandom, optional bool bRotate)
{
	local PatrolPoint point;

	if (pawn != None)
	{
		point = GetPatrolPoint(patrolTag, bRandom);
		if (point != None)
		{
			pawn.SetLocation(point.Location);
			if (bRotate)
				pawn.SetRotation(point.Rotation);
			pawn.SetOrders(orders,patrolTag, True);
		}
	}
}

function SetupExclusions()
{
}

function int Killed()
{
	return ExpectedLiving(localURL) - CountLiving(localURL);
}

function bool PlayerHasItem(Name itemType)
{
	local Inventory item, nextItem, lastItem;

	if (Player.Inventory != None)
	{
		item = Player.Inventory;
		nextItem = item.Inventory;
		lastItem = item;

		do
		{
			if ((item != None) && item.IsA(itemType))
				return true;

			item = nextItem;

			if (item != None)
				nextItem = item.Inventory;
		}
		until ((item == None) || (item == lastItem));
	}

	return false;
}

function int ExpectedLiving(string location)
{
	local name flagname;
	flagname = Player.rootWindow.stringtoname(location $ "_StartCount");
	return flags.getint(flagname);
}

function int CountLiving(string location)
{
	local name flagname;
 	if ( player != none) //if the player is none forget it.
	{
		flagname = Player.rootWindow.stringtoname(location $ "_Count");
		if (localURL ~= location)
		{
			SetupExclusions();
			flags.SetInt(flagname, CountCareLiving(), ,26);
		}
		return flags.getint(flagname);
	}
	else
	{
		return 999999;
	}
}

function int DoInitialCount()
{
	local name flagname;
	local int count;
	
	flagname = Player.rootWindow.stringtoname(localurl $ "_StartCount");
	if ( flags.getint(flagname) != 0 )
	{
		count = flags.getint(flagname);
	}
	else
	{
		count = CountLiving(localurl);
		flags.SetInt(flagname, count, , 26);
	}

	return count;
}

function int CountCareLiving()
{
	local tnmpawn p;
	local tnmcarcass c;
	local tnmpovcorpse povc;
	local int count;
	local int i;
	local bool b;

	count = 0;
	foreach AllActors(class'TNMPawn', p)
	{
		b = true;

		for ( i=0; i < 32 && CountExclusions[i] != ''; i++)
		{
			if ( CountExclusions[i] == p.Tag )
				b = false;
		}

		if ( b )
		{
			if ( p.IsA('tnmAnimal') )
				b = false;
		}

		if ( b )
		{
			switch ( TDPNeo(player).PawnDifficulty )
			{
				case 0: b = P.bDifficulty0;
				case 1: b = P.bDifficulty1;
				case 2: b = P.bDifficulty2;
				case 3: b = P.bDifficulty3;
			}
		}

		if ( b )
		{
			count++;
		}
	}
	foreach AllActors(class'TNMCarcass', c)
	{
		b = true;
		for ( i=0; i < 32 && CountExclusions[i] != ''; i++)
		{
			if (c.Tag == CountExclusions[i])
				b = false;
		}
		if ( b )
		{
			if (c.bNotDead)
				count++;
			else if (c.KillerBindName != "JCDenton")
				count++;
			else if (c.bAnimalCarcass)
				count++;
		}
	}
	foreach AllActors(class'tnmPovCorpse', povc)
	{
		b = true;
		for ( i=0; i < 32 && CountExclusions[i] != ''; i++)
		{
			if (povc.Tag == CountExclusions[i])
				b = false;
		}
		if ( b )
		{
			if (povc.bNotDead)
				count++;
			else if (povc.KillerBindName != "JCDenton")
				count++;
		}
	}
	return count;
}

function KnockOut(tnmpawn p)
{
	p.HealthTorso = 0;
	p.Health = 0;
	p.bStunned = True;
	p.TakeDamage(1, p, p.Location, vect(0,0,0), 'KnockedOut');
}

function OpenDoor(deusexmover m)
{
	m.GotoState( 'TriggerControl',  );
	m.trigger(self,none);
	m.bLocked = false;
}

function SealDoor(name door)
{
	local deusexmover m;
	foreach allactors(class'deusexmover', m, door)
	{
		if (m.keynum != 0)
		{
			m.GotoState( 'TriggerToggle',  );
			m.trigger(self,none);
		}
		m.bLocked = true;
		m.bPickable = false;
		m.bBreakable = false;
		m.bFrobbable = false;
		m.PostBeginPlay();
	}
}

function SkillAward(int skillPointsAdded, string awardMessage)
{
	player.SkillPointsAdd(skillPointsAdded);
	player.ClientMessage(awardMessage);
}

function FirstFrame()
{
	local deusexrootwindow root;
	local window warning;
	local name flagName;
	local tnmPawn P;
	local int i;

	if (!player.isA('TDPNeo'))
	{
		Log("TNM Player class not being used. Please Reinstall");
		root = DeusExRootWindow(player.rootWindow);
		if (root != none)
		{
			warning = MessageBox(NeoMissingTitle,neoMissingMsg , 1, True, none);
		}
	}

	flags.DeleteFlag('PlayerTraveling', FLAG_Bool);

	// Check to see which NPCs should be dead from prevous missions
	foreach AllActors(class'tnmPawn', P)
	{
		if (P.bImportant)
		{
			flagName = Player.rootWindow.StringToName(P.BindName$"_Dead");
			if (flags.GetBool(flagName))
			{
				if (p.BindName == "Kylie" && dxinfo.missionnumber == 24)
					p.SwitchToKilledSkin();
				else
					P.Destroy();
			}
		}
	}

	// print the mission startup text only once per map
	flagName = Player.rootWindow.StringToName("M"$Caps(dxInfo.mapName)$"_StartupText");
	if (!flags.GetBool(flagName) && (dxInfo.startupMessage[0] != ""))
	{
		for (i=0; i<ArrayCount(dxInfo.startupMessage); i++)
			DeusExRootWindow(Player.rootWindow).hud.startDisplay.AddMessage(dxInfo.startupMessage[i]);
		DeusExRootWindow(Player.rootWindow).hud.startDisplay.StartMessage();
		flags.SetBool(flagName, True);
	}

	flagName = Player.rootWindow.StringToName("M"$dxInfo.MissionNumber$"MissionStart");
	if (!flags.GetBool(flagName))
	{
		// Remove completed Primary goals and all Secondary goals
		Player.ResetGoals();

		// Remove any Conversation History.
		Player.ResetConversationHistory();

		// Set this flag so we only get in here once per mission.
		flags.SetBool(flagName, True);
	}

	bNeedToCount = true;
}

//fixes a FirstFrame delay
function Tick(float dt)
{
	if ( bNeedToCount )
	{
		if (TDPNeo(player).bFiltered)
		{
			DoInitialCount();
			bNeedToCount = false;
		}
	}

	if(wait<0)
		return;
	wait-=dt;
	if(wait<0)
		super.Timer();
}

function Timer()
{
//	super.Timer();
	DecrementTimers();
	HandleTimers();
}

function MenuUIMessageBoxWindow MessageBox
	( 
	String msgTitle,
	String msgText, 
	int msgBoxMode, 
	bool hideCurrentScreen,
	Window winParent
	)	
{
	local MenuUIMessageBoxWindow msgBox;
	local DeusExRootWindow root;

	root = DeusExRootWindow(player.rootWindow);

	msgBox = MenuUIMessageBoxWindow(root.PushWindow(Class'MessageSelfDestroy', hideCurrentScreen ));
	msgBox.SetTitle(msgTitle);
	msgBox.SetMessageText(msgText);
	msgBox.SetMode(msgBoxMode);
	msgBox.SetNotifyWindow(winParent);

	return msgBox;
}


function PreTravel()
{
	CountLiving(localURL);
	if ( player != none )
		tdpneo(player).LastMap = localURL;
	super.PreTravel();
}

//there may be a way of reading this so I'll chuck this in a funciton in case I find it
function string LastMap()
{
	return tdpneo(player).LastMap;
}

function SendPM(string PM)
{
	Player.StartDataLinkTransmission(PM);
}

function inventory GiveItemTo(string itemName, tnmpawn reciever)
{
	local class<inventory> item;
	local inventory inv;

	item = class<inventory>(DynamicLoadObject(itemName, class'class',));

	inv = Spawn(item,reciever,,reciever.location,reciever.rotation);

	if (inv != None)
	{
		inv.InitialState='Idle2';
		inv.GiveTo(reciever);
		inv.SetBase(reciever);
	}
}

function inventory SpawnItemAt(string itemName, name SpawnLocationTag)
{
	local vector loc;
	local rotator rot;
	local actor a;
	local class<inventory> item;

	foreach allactors(class'actor',a,SpawnLocationTag)
	{
		loc = a.location;
		rot = a.rotation;
		break;
	}

	item = class<inventory>(DynamicLoadObject(itemName, class'class',));
	
	return Spawn(item,,,loc,rot);
}

function Actor SpawnActorAt(string actorName, name SpawnLocationTag)
{
	local vector loc;
	local rotator rot;
	local actor a;
	local class<actor> actor;

	foreach allactors(class'actor',a,SpawnLocationTag)
	{
		loc = a.location;
		rot = a.rotation;
		break;
	}

	actor = class<actor>(DynamicLoadObject(actorName, class'class',));
	
	return Spawn(actor,,,loc,rot);
}

//more or less copied from goaladdtrigger
function AddGoal(name goalName, string goalText, bool bPrimaryGoal, bool bGoalCompleted)
{
	local DeusExGoal goal;

	goal = player.AddGoal(goalName, bPrimaryGoal);
	if ( bGoalCompleted )
		player.GoalCompleted(goalName);	
	goal.SetText(goalText);
}

function KillPawn(tnmpawn p)
{
	p.HealthTorso = 0;
	p.Health = 0;
	p.bStunned = false;
	p.TakeDamage(1, p, p.Location, vect(0,0,0), 'shot');
}

function PawnKilled(pawn killed, pawn killer)
{
}

function bool DisplayNews(string filename)
{
	return true;
}

defaultproperties
{
     neoMissingMsg="Correct player class not detected. Please reinstall."
     neoMissingTitle="Neo Missing"
     wait=0.15
}
