class TDPcarcass extends deusexcarcass;

var() bool bUnconscious;
var() bool bBloodPool;

var() bool bInWorld;
var vector worldposition;
var bool bWorldCollideActors;
var bool bWorldBlockActors;
var bool bWorldBlockPlayers;

var float health;
var string givenname;
var string givenbindname;
var bool binwater;
var float drowntime;

var() bool bImportant;

var float BloodOffset;
var tnmBloodPool pool;

// Smoke39
var() bool bAmbientFlaming;	// sets self on fire upon entering the player's view if true
var bool bSearched;		// to let us be picked up after being searched even if we still have stuff

var() float BurnTime;
var bool bSeen;

var bool bDontTransferFlame;

//******************************************************
//TDP Vars
//******************************************************

//Vars for clothes transfert stuffs
var(Clothes) Name    		DisguisedAlliance;                   // What alliance
var(Clothes) texture 		ClothesSkins[8];
Var(Clothes) Mesh		ClothesMesh;
Var(Clothes) Texture		ClothesTexture;
Var(Clothes) class<carcass>	DisguisedCarcassType;
var(Clothes) bool bNude;
Var 	     string 		ClothesName;		// human readable name

//Special stuffs
Var() bool BWhiteblood;
var WBloodPool pool2;

// ----------------------------------------------------------------------
// EnterWorld()
// ----------------------------------------------------------------------

function EnterWorld()
{
	PutInWorld(true);
}


// ----------------------------------------------------------------------
// LeaveWorld()
// ----------------------------------------------------------------------

function LeaveWorld()
{
	PutInWorld(false);
}


// ----------------------------------------------------------------------
// PutInWorld()
// ----------------------------------------------------------------------

function PutInWorld(bool bEnter)
{
	if (bInWorld && !bEnter)
	{
		bInWorld            = false;
		//GotoState('Idle');
		bHidden             = true;
		bDetectable         = false;
		WorldPosition       = Location;
		bWorldCollideActors = bCollideActors;
		bWorldBlockActors   = bBlockActors;
		bWorldBlockPlayers  = bBlockPlayers;
		SetCollision(false, false, false);
		bCollideWorld       = false;
		SetPhysics(PHYS_None);
		SetLocation(Location+vect(0,0,20000));  // move it out of the way
	}
	else if (!bInWorld && bEnter)
	{
		bInWorld    = true;
		bHidden     = Default.bHidden;
		bDetectable = Default.bDetectable;
		SetLocation(WorldPosition);
		SetCollision(bWorldCollideActors, bWorldBlockActors, bWorldBlockPlayers);
		bCollideWorld = true;
		SetPhysics(PHYS_falling);
	}
}

// ----------------------------------------------------------------------
// PostBeginPlay()
// ----------------------------------------------------------------------

function PostBeginPlay()
{
	Super.PostBeginPlay();
	if (!bInWorld) //copied from scriptedpawn. Blame them.
	{
	bInWorld = true;
	LeaveWorld();
	}

	// Smoke39 - if we should burn ambiently, set the timer to check if the player's around
	if ( bAmbientFlaming )
		SetTimer( 0.125, false );
}

function PostPostBeginPlay()
{
	super.PostPostBeginPlay();
	if(GivenName=="")
	{
		bNotDead=bUnconscious;
		GivenName=FamiliarName;
		GivenBindName=BindName;
		initagain();
	}
}

// Smoke39 - be set on fire once the player sees us
function Timer()
{
	local TNMFire f;

	if ( bAmbientFlaming )
	{
		f = Spawn( class'TNMFire', self );

		if ( f != None )
		{
			f.LifeSpan = 0;
		}
		else
			SetTimer( 0.125, false );
	}
	else
		Super.Timer();
}

function ExtinguishFire()
{
	local TNMFire f;

	bAmbientFlaming = False;
	SetTimer(0, False);

	foreach BasedActors(class'TNMFire', f)
		f.Destroy();
}

function ChunkUp(int Damage)
{
	local int i;
	local float size;
	local Vector loc;
	local FleshFragment chunk;
	local WFleshFragment chunk2;
	local bool bValidItem;
	local float gibstrength;
	local inventory item, nextItem;

	// gib the carcass
	size = (CollisionRadius + CollisionHeight) / 2;
	if (size > 10.0)
	{
		for (i=0; i<size/4.0; i++)
		{
			loc.X = (1-2*FRand()) * CollisionRadius;
			loc.Y = (1-2*FRand()) * CollisionRadius;
			loc.Z = (1-2*FRand()) * CollisionHeight;
			loc += Location;
			If(BWhiteblood)
			{
				chunk2 = spawn(class'WFleshFragment', None,, loc);

				if (chunk2 != None)
				{
					chunk2.DrawScale = size / 25;
					chunk2.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
					chunk2.bFixedRotationDir = True;
					chunk2.RotationRate = RotRand(False);
				}
			}
			Else
			{
				chunk = spawn(class'FleshFragment', None,, loc);

				if (chunk != None)
				{
					chunk.DrawScale = size / 25;
					chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
					chunk.bFixedRotationDir = True;
					chunk.RotationRate = RotRand(False);
				}
			}
		}
	}

	//ddl's inventory drop code
	gibstrength = fclamp(damage, 10, 30);

	if(inventory != none && !bAnimalCarcass)
	{
		do
		{
			item = Inventory;
			nextItem = item.Inventory;
			bValidItem = true;

			loc.X = (1-2*FRand()) * CollisionRadius;
			loc.Y = (1-2*FRand()) * CollisionRadius;
			loc.Z = (1-2*FRand()) * CollisionHeight;
			loc += Location;

	                DeleteInventory(item);

			if((DeusExWeapon(item) != None) && (DeusExWeapon(item).bNativeAttack))
				bValidItem = false;
			else if(Ammo(item) != none)
				bValidItem = false;

			if(!bValidItem)
				Item.Destroy();
			else
				FlingItem(item, gibstrength*10, loc);

			item = nextItem;
		}
		until (item == None)
	}

	Super(Carcass).ChunkUp(Damage);
}

function float ShieldDamage(name damageType)
{
	// handle special damage types
	if ((damageType == 'Stunned')
	 || (damageType == 'KnockedOut') 
	 || (damageType == 'PoisonGas') 
	 || (damageType == 'PoisonEffect') 
	 || (damageType == 'Poison') 
	 || (damagetype == 'EMP')
	 || (damagetype == 'headstun')
	 || (damagetype == 'TearGas'))
		return 0.0;
	else
		return 1.0;
}

function TakeDamage(int Damage, Pawn instigatedBy, Vector hitLocation, Vector momentum, name damageType)
{
	local deusexplayer player;
	local name flagname;

	if (damageType == 'HalonGas')
		ExtinguishFire();

	health -= shielddamage(damagetype) * damage;
	if (health <= 0)
	{
		bGenerateFlies = default.bgenerateflies;
		bNotDead = false;
		initagain();
		if (bImportant)
		{
			player = deusexplayer(getplayerpawn());
			flagName = player.rootWindow.StringToName(givenBindName$"_Unconscious");
			player.flagBase.DeleteFlag(flagName, FLAG_Bool);
			flagname = player.rootWindow.StringToName(givenBindName$"_Dead");
			player.flagBase.SetBool(flagName, True);
			player.flagBase.SetExpiration(flagName, FLAG_Bool, 0);
		}
	}
	super.takedamage(damage,instigatedby,hitlocation,momentum,damagetype);
}


// ----------------------------------------------------------------------
// InitFor()
// ----------------------------------------------------------------------

function InitFor(Actor Other)
{
	if (Other != None)
	{
		givenname = ScriptedPawn(Other).FamiliarName;
		givenbindname = scriptedpawn(other).bindname;
		ClothesName = ScriptedPawn(Other).FamiliarName;

		// set as unconscious or add the pawns name to the description
		if (!bAnimalCarcass)
		{
			if (bNotDead)
				itemName = msgNotDead;
			if (Other.IsA('ScriptedPawn'))
				itemName = itemName $ " (" $ ScriptedPawn(Other).FamiliarName $ ")";
		}

		Mass           = Other.Mass;
		Buoyancy       = Mass * 1.2;
		MaxDamage      = 0.8*Mass;
		if (ScriptedPawn(Other) != None)
			if (ScriptedPawn(Other).bBurnedToDeath)
				CumulativeDamage = MaxDamage-1;

		SetScaleGlow();

		// Will this carcass spawn flies?
		if (bAnimalCarcass)
		{
			itemName = msgAnimalCarcass;
			if (FRand() < 0.2)
				bGenerateFlies = true;
		}
		else if (!Other.IsA('Robot') && !bNotDead)
		{
			if (FRand() < 0.1)
				bGenerateFlies = true;
		}

		if (Other.AnimSequence == 'DeathFront')
			Mesh = Mesh2;

		// set the instigator and tag information
		if (Other.Instigator != None)
		{
			KillerBindName = Other.Instigator.BindName;
			KillerAlliance = Other.Instigator.Alliance;
		}
		else
		{
			KillerBindName = Other.BindName;
			KillerAlliance = '';
		}
		Tag = Other.Tag;
		Alliance = Pawn(Other).Alliance;
		CarcassName = Other.Name;
	}
}

function initagain()
{
		if (!bAnimalCarcass)
		{
			ClothesName = itemName $ " (" $ givenname $ ")";

			if (bNotDead)
				itemName = msgNotDead;
			else
				itemname = default.itemname;

			if (givenname!="")
				itemName = itemName $ " (" $ givenname $ ")";
		}
}


// ----------------------------------------------------------------------
// ZoneChange()
// ----------------------------------------------------------------------

function ZoneChange(ZoneInfo NewZone)
{
	binwater = NewZone.bWaterZone;
	if (binwater)
		ExtinguishFire();
	Super.ZoneChange(NewZone);
}


function Tick(float deltaSeconds)
{
	local bool decrementburntimer;
	local TNMFire f;

	decrementburntimer = false;

	if ( lastrendertime > 0 ) //Not sure if its by design or a coincidence but -10 means never rendered so this checks that theyve been rendered.
		bSeen = true;

	Super.Tick(deltaSeconds);
	if (binwater)
	{
		drowntime -= deltaseconds;
		if (drowntime <= 0)
		{
			drowntime=default.drowntime;
			TakeDamage(5, None, Location, vect(0,0,0), 'Drowned');
		}
	}
	if (bAmbientFlaming)
	{
		foreach BasedActors(class'TNMFire', f)
			decrementburntimer = true;
	}
	else
		decrementburntimer = true;	

	if (decrementburntimer && bSeen)
		burntime -= deltaSeconds;

	if (burntime <= 0)
	{
		ExtinguishFire();
		bGenerateFlies = default.bGenerateFlies;
	}
	else
	{
		bGenerateFlies = false;
	}
}

// ----------------------------------------------------------------------
// Frob()
//
// search the body for inventory items and give them to the frobber
// ----------------------------------------------------------------------

function Frob(Actor Frobber, Inventory frobWith)
{
	local Inventory item, nextItem, startItem;
	local Pawn P;
	local DeusExWeapon W;
	local bool bFoundSomething;
	local DeusExPlayer player;
	local ammo AmmoType;
	local bool bPickedItemUp;
	local tdpPOVCorpse corpse;
	local DeusExPickup invItem;
	local int itemCount;
	local int i;
	local TNMFire f;
	local float stack_z;

	// Smoke39 - don't frob flaming stuff, moron! XO
	foreach BasedActors( class'TNMFire', f )
	{
		Frobber.TakeDamage( 1 /*enough to set the jerk on fire*/, None, Location, vect(0,0,0), 'Flamed' );
		return;
	}

//log("DeusExCarcass::Frob()--------------------------------");

	// Can we assume only the *PLAYER* would actually be frobbing carci?
	player = DeusExPlayer(Frobber);

	// No doublefrobbing in multiplayer.
	if (bQueuedDestroy)
		return;

	bFoundSomething = False;
	bSearchMsgPrinted = False;
	P = Pawn(Frobber);
	if (P != None)
	{
		// Make sure the "Received Items" display is cleared
      // DEUS_EX AMSD Don't bother displaying in multiplayer.  For propagation
      // reasons it is a lot more of a hassle than it is worth.
		if ( (player != None) && (Level.NetMode == NM_Standalone) )
         		DeusExRootWindow(player.rootWindow).hud.receivedItems.RemoveItems();

		if (Inventory != None && !bSearched)
		{

			item = Inventory;
			startItem = item;

			do
			{
//				log("===>DeusExCarcass:item="$item );

				nextItem = item.Inventory;

				bPickedItemUp = False;

				if (item.IsA('Ammo'))
				{
					// Only let the player pick up ammo that's already in a weapon
					DeleteInventory(item);
					item.Destroy();
					item = None;
				}
				else if ( (item.IsA('DeusExWeapon')) )
				{
               // Any weapons have their ammo set to a random number of rounds (1-4)
               // unless it's a grenade, in which case we only want to dole out one.
               // DEUS_EX AMSD In multiplayer, give everything away.
               W = DeusExWeapon(item);
               
               // Grenades and LAMs always pickup 1
               if (W.IsA('WeaponNanoVirusGrenade') || 
                  W.IsA('WeaponGasGrenade') || 
                  W.IsA('WeaponEMPGrenade') ||
		  W.IsA('WeaponMine') ||
		  W.IsA('WeaponPlasmanade') ||
		  W.IsA('WeaponTNMEMPGrenade') ||
		  W.IsA('WeaponTNMGasGrenade') ||
		  W.IsA('WeaponTNMNanoVirusGrenade') ||
		  W.IsA('WeaponTripBomb') ||
		  W.IsA('WeaponTripBomb') ||
		  W.IsA('WeaponTNMLAM') ||
                  W.IsA('WeaponLAM'))
                  W.PickupAmmoCount = 1;
               else if (Level.NetMode == NM_Standalone)
                  W.PickupAmmoCount = Rand(4) + 1;
				}
				
				if (item != None)
				{
					bFoundSomething = True;

					if (item.IsA('NanoKey'))
					{
						if (player != None)
						{
							player.PickupNanoKey(NanoKey(item));
							AddReceivedItem(player, item, 1);
							DeleteInventory(item);
							item.Destroy();
							item = None;
						}
						bPickedItemUp = True;
					}
					else if (item.IsA('Credits'))		// I hate special cases
					{
						if (player != None)
						{
							AddReceivedItem(player, item, Credits(item).numCredits);
							player.Credits += Credits(item).numCredits;
							P.ClientMessage(Sprintf(Credits(item).msgCreditsAdded, Credits(item).numCredits));
							DeleteInventory(item);
							item.Destroy();
							item = None;
						}
						bPickedItemUp = True;
					}
					else if (item.IsA('DeusExWeapon'))   // I *really* hate special cases
					{
						// Okay, check to see if the player already has this weapon.  If so,
						// then just give the ammo and not the weapon.  Otherwise give
						// the weapon normally. 
						W = DeusExWeapon(player.FindInventoryType(item.Class));

						// If the player already has this item in his inventory, piece of cake,
						// we just give him the ammo.  However, if the Weapon is *not* in the 
						// player's inventory, first check to see if there's room for it.  If so,
						// then we'll give it to him normally.  If there's *NO* room, then we 
						// want to give the player the AMMO only (as if the player already had 
						// the weapon).

						if ((W != None) || ((W == None) && (!player.FindInventorySlot(item, True))))
						{
							// Don't bother with this is there's no ammo
							if ((Weapon(item).AmmoType != None) && (Weapon(item).AmmoType.AmmoAmount > 0))
							{
								AmmoType = Ammo(player.FindInventoryType(Weapon(item).AmmoName));

                        if ((AmmoType != None) && (AmmoType.AmmoAmount < AmmoType.MaxAmmo))
								{
                           AmmoType.AddAmmo(Weapon(item).PickupAmmoCount);
                           AddReceivedItem(player, AmmoType, Weapon(item).PickupAmmoCount);
                           
									// Update the ammo display on the object belt
									player.UpdateAmmoBeltText(AmmoType);

									// if this is an illegal ammo type, use the weapon name to print the message
									if (AmmoType.PickupViewMesh == Mesh'TestBox')
										P.ClientMessage(item.PickupMessage @ item.itemArticle @ item.itemName, 'Pickup');
									else
										P.ClientMessage(AmmoType.PickupMessage @ AmmoType.itemArticle @ AmmoType.itemName, 'Pickup');

									// Mark it as 0 to prevent it from being added twice
									Weapon(item).AmmoType.AmmoAmount = 0;
								}
							}

							// Print a message "Cannot pickup blah blah blah" if inventory is full
							// and the player can't pickup this weapon, so the player at least knows
							// if he empties some inventory he can get something potentially cooler
							// than he already has. 
							if ((W == None) && (!player.FindInventorySlot(item, True)))
							{
								P.ClientMessage(Sprintf(Player.InventoryFull, item.itemName));
								DeleteInventory(item);
								stack_z+=4.0;
								item.DropFrom(Location+vect(0,0,1)*stack_z+VRand()*CollisionRadius*vect(1,1,0));
							}

							// Only destroy the weapon if the player already has it.
							if (W != None)
							{
								// Destroy the weapon, baby!
								DeleteInventory(item);
								item.Destroy();
								item = None;
							}

							bPickedItemUp = True;
						}
					}

					else if (item.IsA('DeusExAmmo'))
					{
						if (DeusExAmmo(item).AmmoAmount == 0)
							bPickedItemUp = True;
					}

					if (!bPickedItemUp)
					{
						// Special case if this is a DeusExPickup(), it can have multiple copies
						// and the player already has it.

						if ((item.IsA('DeusExPickup')) && (DeusExPickup(item).bCanHaveMultipleCopies) && (player.FindInventoryType(item.class) != None))
						{
							invItem   = DeusExPickup(player.FindInventoryType(item.class));
							itemCount = DeusExPickup(item).numCopies;

							// Make sure the player doesn't have too many copies
							if ((invItem.MaxCopies > 0) && (DeusExPickup(item).numCopies + invItem.numCopies > invItem.MaxCopies))
							{	
								// Give the player the max #
								if ((invItem.MaxCopies - invItem.numCopies) > 0)
								{
									itemCount = (invItem.MaxCopies - invItem.numCopies);
									DeusExPickup(item).numCopies -= itemCount;
									invItem.numCopies = invItem.MaxCopies;
									P.ClientMessage(invItem.PickupMessage @ invItem.itemArticle @ invItem.itemName, 'Pickup');
									AddReceivedItem(player, invItem, itemCount);
								}
								else
								{
									P.ClientMessage(Sprintf(msgCannotPickup, invItem.itemName));
									DeleteInventory(item);
									stack_z+=4.0;
									item.DropFrom(Location+vect(0,0,1)*stack_z+VRand()*CollisionRadius*vect(1,1,0));									
								}
							}
							else
							{
								invItem.numCopies += itemCount;
								DeleteInventory(item);
								P.ClientMessage(invItem.PickupMessage @ invItem.itemArticle @ invItem.itemName, 'Pickup');
								AddReceivedItem(player, invItem, itemCount);
							}
						}
						else
						{
							if (!player.FindInventorySlot(item, True))
							{
								P.ClientMessage(Sprintf(Player.InventoryFull, item.itemName));
								DeleteInventory(item);
								stack_z+=4.0;
								item.DropFrom(Location+vect(0,0,1)*stack_z+VRand()*CollisionRadius*vect(1,1,0));
							}
							// check if the pawn is allowed to pick this up
							else if ((P.Inventory == None) || (Level.Game.PickupQuery(P, item)))
							{
								DeusExPlayer(P).FrobTarget = item;
								if (DeusExPlayer(P).HandleItemPickup(Item) != False)
								{
								   DeleteInventory(item);

								   // DEUS_EX AMSD Belt info isn't always getting cleaned up.  Clean it up.
								   item.bInObjectBelt=False;
								   item.BeltPos=-1;
											
								   item.SpawnCopy(P);

									// Show the item received in the ReceivedItems window and also 
									// display a line in the Log
									AddReceivedItem(player, item, 1);
									
									P.ClientMessage(Item.PickupMessage @ Item.itemArticle @ Item.itemName, 'Pickup');
									PlaySound(Item.PickupSound);
								}
							}
							else
							{								
								DeleteInventory(item);
								item.Destroy();
								item = None;
							}
						}
					}
				}

				item = nextItem;
			}
			until ((item == None) || (item == startItem));
		}

//log("  bFoundSomething = " $ bFoundSomething);
	}

    if ( !bFoundSomething || bSearched)
    {
	// if we've already been searched, let the player pick us up
	// don't pick up animal carcii
	if (!bAnimalCarcass)
	{
      // DEUS_EX AMSD Since we don't have animations for carrying corpses, and since it has no real use in multiplayer,
      // and since the PutInHand propagation doesn't just work, this is work we don't need to do.
      // Were you to do it, you'd need to check the respawning issue, destroy the POVcorpse it creates and point to the
      // one in inventory (like I did when giving the player starting inventory).
		// Smoke39 - if we have nothing OR we've been searched
		if ((Inventory == None) && (player != None) && (player.inHand == None) && (Level.NetMode == NM_Standalone))
		{
			if (!bInvincible)
			{
				corpse = Spawn(class'tdpPOVCorpse');
				if (corpse != None)
				{
					// destroy the actual carcass and put the fake one
					// in the player's hands
					corpse.carcClassString = String(Class);
					corpse.KillerAlliance = KillerAlliance;
					corpse.KillerBindName = KillerBindName;
					corpse.Alliance = Alliance;
					corpse.bNotDead = bNotDead;
					corpse.bEmitCarcass = bEmitCarcass;
					corpse.CumulativeDamage = CumulativeDamage;
					corpse.MaxDamage = MaxDamage;
					corpse.CorpseItemName = itemName;
					corpse.CarcassName = CarcassName;
					corpse.Frob(player, None);
					corpse.SetBase(player);
					corpse.health = health;
					corpse.givenname = givenname;
					corpse.givenbindname = givenbindname;
					corpse.bImportant = bImportant;
					corpse.InheritedTag = Tag;
					for (i = 0;i<8;i++)
						corpse.InheritedMultiSkinsStr[i] = ""$Multiskins[i];
						corpse.ClothesSkins[i] = ClothesSkins[i];

					corpse.DisguisedAlliance = DisguisedAlliance;
					corpse.ClothesMesh = ClothesMesh;
					corpse.ClothesTexture = ClothesTexture;
					corpse.DisguisedCarcassType = DisguisedCarcassType;
					corpse.ClothesName = ClothesName;
					corpse.BWhiteblood = BWhiteblood;
					corpse.bNude = bNude;
					corpse.InheritedSkinStr = ""$Skin;
					corpse.InheritedTextureStr = ""$Texture;
					corpse.bCheckSkins=true;
					player.PutInHand(corpse);
					bQueuedDestroy=True;
					if ( pool != none)
						pool.bStopExpanding = true;
					if ( pool2 != none)
						pool2.bStopExpanding = true;

					Destroy();
					return;
				}
			}
		}
	}
    }

    if (!bFoundSomething)
    	P.ClientMessage(msgEmpty);


    // Smoke39 - record that we've been searched
    bSearched = true;

   if ((player != None) && (Level.Netmode != NM_Standalone))
   {
      player.ClientMessage(Sprintf(msgRecharged, 25));
      
      PlaySound(sound'BioElectricHiss', SLOT_None,,, 256);
      
      player.Energy += 25;
      if (player.Energy > player.EnergyMax)
         player.Energy = player.EnergyMax;
   }

//no idea why this is even there in their code	Super.Frob(Frobber, frobWith);

   if ((Level.Netmode != NM_Standalone) && (Player != None))   
   {
	   bQueuedDestroy = true;
	   Destroy();	  
   }
}

function Landed(vector HitNormal)
{
	super.Landed(HitNormal);
	if (Velocity.Z < -420*2)
	{
		TakeDamage(21, none, Location, velocity, 'fell');
	}
}

//more (slightly modified) ddl inventory dropping stuff
static function FlingItem(inventory item, float str, vector loc)
{
	local vector dir;
	local InfoDeviceFragment Frag;

	dir = vrand();
	dir.Z += 1;

	if(datavaultimage(item) != none)
	{
		Frag = item.spawn(class'InfoDeviceFragment',,,loc,rotrand());

		if(frag != none)
		{
			frag.ImageClass = datavaultimage(item).Class;
			frag.bFixedrotationdir = true;
			frag.rotationrate = rotrand(false);
			frag.velocity = dir * str * 2 * (1 + frand()) / 5;
		}
		item.destroy();
		return;
	}

	if(!item.SetLocation(loc))
	{
	    item.Destroy();
	    return;
	}
	if(item.IsA('Weapon')) //do weap specific stuff, I guess
	{
		weapon(item).AIRating = weapon(item).default.AIrating;
		weapon(item).bMuzzleFlash = 0;
		if (Weapon(item).AmmoType != None)
		{
			if (Weapon(item).AmmoType.PickupViewMesh == LodMesh'DeusExItems.TestBox') //'nades etc pickup 1
			{
				if(weapon(item).Ammotype.Class == Class'Deusex.AmmoNone') //swords, knives, etc
				{
					weapon(item).PickUpAmmoCount = 0;
					weapon(item).Ammotype.AmmoAmount = 0; //just in case?
				}
				else
				{
					weapon(item).PickupAmmoCount = 1; //Weapon(item).AmmoType.AmmoAmount;
    					Weapon(item).AmmoType.AmmoAmount = 0;
    					if(frand() > str * 0.001)
	    				{
	    					FlingProjectile(weapon(item),str,loc);
	    					item.Destroy();
							return;
					}
				}
			}
			else
				Weapon(item).PickupAmmoCount = rand(weapon(item).default.PickupAmmoCount) + 1;
		}
	}
	item.SetPhysics(PHYS_Falling);
	item.RemoteRole = ROLE_DumbProxy;
	item.NetPriority = 2.5;
	item.BecomePickup();
	item.bCollideWorld = true;
	item.GotoState('PickUp', 'Dropped');
	item.Velocity = dir * str * 2 * (1 + frand());
	item.bFixedRotationDir = True;
	item.RotationRate = rotrand(true);
}

static function FlingProjectile(weapon weap, float str, vector loc)
{
	local projectile proj;
	local vector dir;

	if(weap.ProjectileClass == none)
		return;

	proj = weap.Spawn(weap.ProjectileClass,,,loc,rotator(vrand()));
	if(proj != none)
	{
		dir = vrand();
		dir.Z += 1;
		proj.Velocity = dir * str * 2 * (1 + frand());
		proj.bFixedRotationDir = True;
		proj.RotationRate = rotrand(true);
	}
}

//end ddl stuff

auto state Dead
{
	function HandleLanding()
	{
		local Vector HitLocation, HitNormal, EndTrace;
		local Actor hit;
		local vector offset;

		if (!bNotDead)
		{
			// trace down about 20 feet if we're not in water
			if (!Region.Zone.bWaterZone)
			{
				EndTrace = Location - vect(0,0,320);
				hit = Trace(HitLocation, HitNormal, EndTrace, Location, False);

				if (!bBloodPool || ((DeusExMPGame(Level.Game) != None) && (!DeusExMPGame(Level.Game).bSpawnEffects)))
				{
					pool = None;
					pool2 = None;
				}
				else if(BWhiteblood)
				{
					if ( Mesh == Mesh2 )
						offset.X = -BloodOffset;
					else
						offset.X = BloodOffset;
					offset.Y = 0;
					offset.Z = 0;
					offset = offset >> Rotation;

                			pool2 = spawn(class'WBloodPool',,, HitLocation+HitNormal + offset , Rotator(HitNormal));
				}
				else
				{
					if ( Mesh == Mesh2 )
						offset.X = -BloodOffset;
					else
						offset.X = BloodOffset;
					offset.Y = 0;
					offset.Z = 0;
					offset = offset >> Rotation;
                			pool = spawn(class'tnmBloodPool',,, HitLocation+HitNormal + offset , Rotator(HitNormal));
            			}

				if (pool != None)
					pool.maxDrawScale = CollisionRadius / 40.0;

				if (pool2 != None)
					pool2.maxDrawScale = CollisionRadius / 40.0;
			}
			AIStartEvent('Food', EAITYPE_Visual);
		}

		if (!bAnimalCarcass)
			SetCollisionSize(40.0, Default.CollisionHeight);

		if (bEmitCarcass)
			AIStartEvent('Carcass', EAITYPE_Visual);
	}

Begin:
	while (Physics == PHYS_Falling)
	{
		Sleep(1.0);
	}
	HandleLanding();
}		

//This carcass should never have been spawned in the first place so remove its blood decal.
function CleanBlood()
{
	pool.Destroy();
	pool2.Destroy();
}

defaultproperties
{
     BloodOffset=-20.000000
     bInWorld=True
     Health=20.000000
     drowntime=2.000000
     burnTime=60.000000
     bEmitCarcass=True
     bBloodPool=True
     bSeen=false;
}
