//=============================================================================
// tdpPawn.
//=============================================================================
class tdpPawn extends tnmPawn
	abstract;

Var() bool BWhiteblood;

function CatchFire()
{
	Spawn(class'TNMFire', self);
}

function SpurtBlood()
{
	local vector WbloodVector;

	If(BWhiteblood)
	{
		WbloodVector = vect(0,0,1)*CollisionHeight*0.5;  // so folks don't bleed from the crotch
		spawn(Class'WBloodDrop',,,WbloodVector+Location);
	}
	Else
	{
		Super.SpurtBlood();
	}
}

function Carcass SpawnCarcass()
{
	local TDPCarcass carc;
	local vector loc;
	local Inventory item, nextItem;
	local WFleshFragment chunk;
	local FleshFragment chunk2;
	local int i;
	local float size;
	local TNMFire f;
	local Flame f2;

	if(carc==None) //gibbed
		DropItems();

	// transfer our fire to our carcass
	if ( carc != None )
	{
		foreach BasedActors(class'TNMFire', f)
		{
			if (carc.bDontTransferFlame)
				f.Destroy();
			else
			{
				f.SetOwner(carc);
				f.SetBase(carc);
				f.Mesh = carc.Mesh;
			}
		}

		//prevent some accesssed nones
		foreach AllActors(class'Flame', f2)
			if(f2.Owner==Self)
				if ( carc.bDontTransferFlame )
					f2.Destroy();
				else
					f2.SetOwner(carc);

		carc.bImportant = bImportant;
		carc.bEmitCarcass=bEmitCarcass;
	}

	// if we really got blown up good, gib us and don't display a carcass
	if ((Health < -100) && !IsA('Robot'))
	{
		size = (CollisionRadius + CollisionHeight) / 2;
		if (size > 10.0)
		{
			for (i=0; i<size/4.0; i++)
			{
				loc.X = (1-2*FRand()) * CollisionRadius;
				loc.Y = (1-2*FRand()) * CollisionRadius;
				loc.Z = (1-2*FRand()) * CollisionHeight;
				loc += Location;
				If(BWhiteblood)
				{
					chunk = spawn(class'WFleshFragment', None,, loc);
					if (chunk != None)
					{
						chunk.DrawScale = size / 25;
						chunk.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
						chunk.bFixedRotationDir = True;
						chunk.RotationRate = RotRand(False);
					}
				}
				Else
				{
					chunk2 = spawn(class'FleshFragment', None,, loc);
					if (chunk2 != None)
					{
						chunk2.DrawScale = size / 25;
						chunk2.SetCollisionSize(chunk.CollisionRadius / chunk.DrawScale, chunk.CollisionHeight / chunk.DrawScale);
						chunk2.bFixedRotationDir = True;
						chunk2.RotationRate = RotRand(False);
					}
				}
			}
		}

		return None;
	}

	// spawn the carcass
	carc = TDPCarcass(Spawn(CarcassType)); //its assumed that the carcass will be a tdpcarcass

	if ( carc != None )
	{
		if (bStunned)
			carc.bNotDead = True;
		if (BWhiteblood)
			carc.BWhiteblood = True;

		carc.Initfor(self);

		// move it down to the floor
		loc = Location;
		loc.z -= Default.CollisionHeight;
		loc.z += carc.Default.CollisionHeight;
		carc.SetLocation(loc);
		carc.Velocity = Velocity;
		carc.Acceleration = Acceleration;

		// give the carcass the pawn's inventory if we aren't an animal or robot
		if (!IsA('Animal') && !IsA('Robot'))
		{
			if (Inventory != None)
			{
				do
				{
					item = Inventory;
					nextItem = item.Inventory;
					DeleteInventory(item);
					if ((DeusExWeapon(item) != None) && (DeusExWeapon(item).bNativeAttack))
						item.Destroy();
					else
						carc.AddInventory(item);
					item = nextItem;
				}
				until (item == None);
			}
		}
	}

	return carc;
}

defaultproperties
{
    bEmitCarcass=True
    bRestoreOrders=True
    originalOrders='
    AugHealthLimit=-999999.00
    Energy=500.00
    stealthmodifier=1.00
    breathtime=2.00
    BaseAccuracy=0.20
    maxRange=1000.00
    MinHealth=20.00
    bPlayIdle=True
    bCanCrouch=True
    bSprint=True
    CrouchRate=1.00
    SprintRate=1.00
    bHateCarcass=True
    bReactFutz=True
    bReactLoudNoise=True
    bReactAlarm=True
    bReactShot=True
    bReactCarcass=True
    bReactDistress=True
    EnemyTimeout=5.00
    bCanTurnHead=True
    WaterSpeed=80.00
    AirSpeed=160.00
    AccelRate=500.00
    BaseEyeHeight=40.00
    UnderWaterTime=20.00
    AttitudeToPlayer=4
    HitSound1=Sound'DeusExSounds.Player.MalePainSmall'
    HitSound2=Sound'DeusExSounds.Player.MalePainMedium'
    Die=Sound'DeusExSounds.Player.MaleDeath'
    VisibilityThreshold=0.01
    DrawType=2
    Mass=150.00
    Buoyancy=155.00
    BindName="HumanMilitary"
    BWhiteblood=false
}