//=============================================================================
// FleshFragment, but this is super awesome because it's a gib that can be
// gibbed! 
//=============================================================================
class ChocoFrag expands DeusExFragment;

var bool bSpray;

//ALL THIS NEEDS TO BE HERE! If it's not this will throw up terribly!
auto state Flying
{
	simulated function timer()
	{
	 bSpray = False;
	}

	simulated function BeginState()
	{
		Super.BeginState();
		Velocity = VRand() * 300;
		bSpray = True;						
	}
}

simulated function HitWall (vector HitNormal, actor HitWall)
{
	local Sound sound;
	local float volume, radius;

	// if we are stuck, stop moving
	if (lastHitLoc == Location)
		Velocity = vect(0,0,0);
	else
		Velocity = Elasticity*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	speed = VSize(Velocity);	
	if (bFirstHit && speed<400) 
	{
		bFirstHit=False;
		bRotatetoDesired=True;
		bFixedRotationDir=False;
		DesiredRotation.Pitch=0;	
		DesiredRotation.Yaw=FRand()*65536;
		DesiredRotation.roll=0;
	}
	RotationRate.Yaw = RotationRate.Yaw*0.75;
	RotationRate.Roll = RotationRate.Roll*0.75;
	RotationRate.Pitch = RotationRate.Pitch*0.75;
	if ( ( (speed < 60) && (HitNormal.Z > 0.7) ) || (speed == 0) )
	{
		SetPhysics(PHYS_none, HitWall);
		if (Physics == PHYS_None)
		{
			bBounce = false;
			bSpray = false;
		}
	}

	volume = 0.5+FRand()*0.5;
	radius = 768;
	if (FRand()<0.5)
		sound = ImpactSound;
	else
		sound = MiscSound;
	PlaySound(sound, SLOT_None, volume,, radius, 0.85+FRand()*0.3);
	if (sound != None)
		AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius * 0.5);		// lower AI sound radius for gameplay balancing

	lastHitLoc = Location;
}

function GibTheGibs(float GibOfGibScale, int NumSubGibs, vector GibLoc)
{
 local int i;
 local chocofrag f;
 
 //numerical iterators are awesome on how flexible they are!
 if (DrawScale > 0.25)
 {
 for(i=NumSubGibs;i>0;i--)
 {
  f = Spawn(class'ChocoFrag',,,GibLoc + VRand(),RotRand(True));
  if (f != none) f.DrawScale = GibOfGibScale;
 }
 }
 else if (DrawScale <= 0.25) i = 0;
 if (i == 0) Destroy();
}

function TakeDamage(int OwFactor, pawn Jerk, vector boobooLoc, vector Knockback, name boobootype)
{
 if (DrawScale <= 0.25)
  Destroy();
 if (DrawScale > 0.25)
 {
  GibTheGibs(Drawscale / 2, OwFactor / 4, boobooLoc);
 }
}

function Tick(float deltaTime)
{
	Super.Tick(deltaTime);
	
	if (bSpray)
		if (FRand() < 0.35)
			Spawn(class'ChocoDrop',,, Location);
}

defaultproperties
{
     numFragmentTypes=4
     Fragments(0)=LODMesh'ChocoFrag1'
     Fragments(1)=LODMesh'ChocoFrag2'
     Fragments(2)=LODMesh'ChocoFrag3'
     Fragments(3)=LODMesh'ChocoFrag4'
     bSpray=True
     elasticity=0.400000
     ImpactSound=Sound'DeusExSounds.Generic.FleshHit1'
     MiscSound=Sound'DeusExSounds.Generic.FleshHit2'
     Mesh=LodMesh'ChocoFrag1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     Mass=5.000000
     Buoyancy=5.500000
     DrawType=DT_Mesh
     DrawScale=1.000000
     bBlockActors=True
     bBlockPlayers=True
     bCollideActors=True
     bProjTarget=True
     bVisionImportant=True
     LifeSpan=999.000000
}
