//=============================================================================
// PoisonLaser.  (Made by RedGreasel for The Darma Project)
//=============================================================================
class PoisonLaser expands TDPBeams;

static function doLaserEffects(TDPBeams beam, Actor ac)
{
	local ScriptedPawn c;
	local DeusExPlayer d;
	if(ac.IsA('ScriptedPawn')){
		c = ScriptedPawn(ac);
		if(c.poisonDamage >= 20 && c.poisonCounter > 0)
			return;
		c.startPoison(1,none);
		c.poisonTimer = 2;
		c.poisonCounter = 17;
		c.poisonDamage = 20;
	}
	else if(ac.IsA('DeusExPlayer')){
		d = DeusExPlayer(ac);
		if(d.poisonDamage >= 20 && d.poisonCounter > 0)
			return;
		d.startPoison(none,1);
		d.poisonTimer = 2;
		d.poisonCounter = 17;
		d.drugEffectTimer = 16;
		d.poisonDamage = 20;
	}
}

defaultproperties
{
    laserTexture=FireTexture'TDP_Effects.Laser.PLaser'
    laserSpotTexture=FireTexture'TDP_Effects.spot.PSpot'
    Mesh=LodMesh'hdtpBeamTrigger'
    MultiSkins(0)=Texture'TDPDeco.Laser.PBeamTriggerTex1'
    MultiSkins(1)=FireTexture'TDP_Effects.spot.PSpot'
    enabledTextures(0)=Texture'TDPDeco.Laser.PBeamTriggerTex1'
    enabledTextures(1)=FireTexture'TDP_Effects.spot.PSpot'
}
