//=============================================================================
// stunLaser.  (Made by Darma for The Darma Project)
//=============================================================================
class StunLaser expands TDPBeams;

static function doLaserEffects(TDPBeams beam, Actor ac)
{
	local Autoturret AT;
	local SecurityCamera SC;
	local ScriptedPawn P;
	local DeusexPlayer H;
	local Robot R;

	if(ac.IsA('Autoturret'))
	{
		AT = Autoturret(ac);
		AT.bConfused=true;
		AT.confusionTimer=1;
		AT.confusionDuration=1;
	}
	else if(ac.IsA('SecurityCamera'))
	{
		SC = SecurityCamera(ac);
		SC.bConfused=true;
		SC.confusionDuration=1;
		SC.confusionTimer=1;
	}
	else if(ac.IsA('ScriptedPawn'))
	{
		P = ScriptedPawn(ac);
		P.GotoState('Stunned');
	}
	else if(ac.IsA('DeusexPlayer'))
	{
		H = DeusexPlayer(ac); // H for Human
		H.EnergyDrain += 5;
		H.EnergyDrainTotal += 5;
		H.TakeDamage(5, P, P.Location, vect(0,0,0), 'EMP');
		H.DropDecoration();
	}
	else if(ac.IsA('Robot'))
	{
		R = Robot(ac);

		R.AmbientSound = None;
		if (R.GetStateName() != 'Disabled')
			R.GotoState('Disabled');
	}
}

defaultproperties
{
    laserTexture=FireTexture'TDP_Effects.Laser.PLaser'
    laserSpotTexture=FireTexture'TDP_Effects.spot.PSpot'
    Mesh=LodMesh'hdtpBeamTrigger'
    MultiSkins(0)=Texture'TDPDeco.Laser.PBeamTriggerTex1'
    MultiSkins(1)=FireTexture'TDP_Effects.spot.PSpot'
    enabledTextures(0)=Texture'TDPDeco.Laser.PBeamTriggerTex1'
    enabledTextures(1)=FireTexture'TDP_Effects.spot.PSpot'
}
